/*********************************************************************************
*
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*
*                        EmuZ-2000  Extend Board DLL
*
*                               << MZ-1R12 >>
*
*                          Main Module [MZ1R12.C]
*
*               Programmed & Porting by 2003 EmuZ-2000 (M.Y)
*		Bug fix and TF-Edition state save support by T.Fukui (2010)
*               28 Feb. 2013 New FileName support*
*		- When I/O base address is changed, the state load is ignored.
*
*********************************************************************************/
//
//
#include <windows.h>
#include "resource.h"
#include "..\interface\emuz2000ioBoard.h"
//Support Debugger
//#include "..\interface\emuz2000debug.h"
#include "..\interface\plugin_ex.h"

////////////////////////////////////
// Prototype 
////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	) ;

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	) ;

////////////////////////////////////
// Global Variable 
////////////////////////////////////
HINSTANCE		h_instdll = NULL ;

EMUZ2000EBIH	mz1r12EBIH = {
	"31DD2499-F757-481b-9BCA-F0C60733368B",
	"MZ-1R12 by SHARP",
	"32KByte S-RAM Extend Board",
	"Copyright 2003 by EmuZ-2000, 2010 by T.Fukui",
	"http://www5d.biglobe.ne.jp/~object",
	"emuz2000@excite.co.jp",
	0x00000000,//Reserved
	InportFunction,
	OutportFunction,
	0xF8,
	0x3,
	USE_INFODIALOG
} ;

USHORT	address = 0 ;
UCHAR	mz1r12Buf[32768] ;
DWORD	gId = 0 ;
DWORD	dwBase = 0 ;

////////////////////////////////////
// Extern
////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// Logic Start
//
///////////////////////////////////////////////////////
// System interface
///////////////////////////////////////////////////////
BOOL WINAPI
DllMain(
	HINSTANCE	inst,
	DWORD		q_mode,
	LPVOID		vp_res_c )
{
	switch (q_mode) {
	case DLL_PROCESS_ATTACH :
		h_instdll = inst;
		break;
	case DLL_THREAD_ATTACH :
		break;
	case DLL_THREAD_DETACH :
		break;
	case DLL_PROCESS_DETACH :
		h_instdll = NULL;
		break;
	}
	return TRUE;
}

///////////////////////////////////////////////////////
// window Proc.
BOOL
WINAPI
InfomationDlgProc(
	HWND hDlg,
	UINT msg,
	WPARAM wPrm,
	LPARAM lPrm
	)
{
	switch( msg ){
		case	WM_INITDIALOG:
			switch( dwBase )
			{
			case	0x04:
				SendDlgItemMessage( hDlg, IDC_RADIO1, BM_SETCHECK, TRUE, 0L ) ;
				break ;
			case	0xf8:
				SendDlgItemMessage( hDlg, IDC_RADIO2, BM_SETCHECK, TRUE, 0L ) ;
				break ;
			}

			return	TRUE ;

		case	WM_COMMAND:
			switch( wPrm ){
				case	IDOK:
					if( TRUE == SendDlgItemMessage( hDlg, IDC_RADIO1, BM_GETCHECK, 0L, 0L ))
						dwBase = 0x04 ;
					else
						dwBase = 0xf8 ;
					EndDialog( hDlg, TRUE ) ;
					return	TRUE ;

				case	IDCANCEL:
					EndDialog( hDlg, FALSE ) ;
					return	TRUE ;

			}
			break ;
	}
	return	FALSE ;
}

/////////////////////////////////////////////////////////////////////
// I/O Function Interface
/////////////////////////////////////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	)
{
	UCHAR	data = 0 ;

	switch( port )
	{
	case	0x04:
	case	0xf8:
		address = 0 ;
		break ;
	case	0x05:
	case	0xf9:
		data = mz1r12Buf[address] ;
		address++ ;
		address &= 0x7fff ;
		break ;
	case	0x06:
	case	0xfa:
		break ;
	}
	return	data ;
}

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	)
{
	switch( port )
	{
	case	0x04:
	case	0xf8:
		address &= 0xff ;
		address |= (USHORT)(data<<8) ;
		address &= 0x7fff ;
		break ;
	case	0x05:
	case	0xf9:
		address &= 0xff00 ;
		address |= (USHORT)data ;
		address &= 0x7fff ;
		break ;
	case	0x06:
	case	0xfa:
		mz1r12Buf[address] = data ;
		address++ ;
		address &= 0x7fff ;
		break ;
	}
	return	0 ;
}

/////////////////////////////////////////////////////////////////////
// EmuZ-2000 Interface
/////////////////////////////////////////////////////////////////////
BOOL
WINAPI
IntializeBoard( 
	VOID
	)
{
	HANDLE h_File ;
	DWORD dwReadSize ;

	h_File = CreateFile ( "mz_1r12.mem",
		GENERIC_READ,FILE_SHARE_READ,
		NULL,OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,NULL ) ;
	if( h_File != INVALID_HANDLE_VALUE )
	{
		ReadFile( h_File, mz1r12Buf, 32768, &dwReadSize, NULL );
		CloseHandle( h_File ) ;
	}

	dwBase = emuz2000_readProfileDword( gId, "BaseAddress" ) ;
	switch( dwBase )
	{
	case	0xf8:
	case	0x04:
		break ;
	default:
		dwBase = 0xf8 ;
		break ;
	}
	mz1r12EBIH.ioMapper.ucStartPort = (UCHAR)dwBase ;

	address = 0 ;
	return	TRUE ;
}

BOOL
WINAPI
ReIntializeBoard( 
	VOID
	)
{
	address = 0 ;
	return	TRUE ;
}


VOID
WINAPI
FinalizeBoard( 
	VOID 
	)
{
	HANDLE h_File ;
	DWORD dwWriteSize ;

	h_File = CreateFile ( "mz_1r12.mem",
		GENERIC_WRITE ,FILE_SHARE_WRITE,
		NULL,CREATE_ALWAYS,
		FILE_ATTRIBUTE_NORMAL,NULL ) ;
	if( h_File != INVALID_HANDLE_VALUE )
	{
		WriteFile( h_File, mz1r12Buf, 32768, &dwWriteSize, NULL );
		CloseHandle( h_File ) ;
	}

	emuz2000_writeProfileDword( gId, "BaseAddress", dwBase ) ;
	return ;
}

VOID
WINAPI
ReportCpuClock( 
	int clk
	)
{
	return ;
}

VOID
WINAPI
InfomationDialog( 
	HWND	hWnd 
	)
{
	DialogBox( h_instdll, MAKEINTATOM(IDD_DIALOG_BASEADDRESS), 
		hWnd, InfomationDlgProc);

	return ;
}

BOOL
WINAPI
BoardInfomationService( 
	PEMUZ2000EBIH *info,
	DWORD id
	)
{

	*info = &mz1r12EBIH ;
	gId = id ;
	return	TRUE ;
}

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx( int *ver, DWORD *size, PUCHAR *buf )
{
	static unsigned int data[2];

	data[0] = address;
	data[1] = dwBase;

	*size = sizeof(data);
	*buf = (void *)data;
	*ver = 1;				/* Data Format Ver.1 */
	return TRUE;
}

BOOL WINAPI StateSaveInputDataEx( int ver, DWORD size, PUCHAR buf )
{
	unsigned int *data = (void *)buf;
	unsigned int tdata[2] = { 0, 0 };	/* for automatic size calculation */

	if (ver > 1)				/* Newer Data Format Ver. */
		return FALSE;
	if (size != sizeof(tdata))
		return FALSE;
	if (dwBase != (DWORD)data[1])		/* I/O port changed */
		return FALSE;
	address    = (USHORT)data[0];
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveOutputData( 
	DWORD *size,
	PUCHAR buf
	)
{
	*size = 0 ;
	buf = NULL ;
	return	TRUE ;
}

BOOL
WINAPI
StateSaveInputData( 
	DWORD size,
	PUCHAR buf
	)
{
	return	TRUE ;
}
#endif