/*********************************************************************************
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*                        EmuZ-2000  Extend Board DLL
*                               << PIO-3034 >>
*                          320KB Extension RAM Board
*                          Main Module [PIO-3034.C]
*
*                             Programmed by Suga
*		   TF-Edition state save supported by T.Fukui
*********************************************************************************/
//
// yύXz
// 2006N0403 Ver.0.1
//	ƎҁFSuga
//	@eFmz_1r12 x[Xɏō쐬
//
// 2006N0412 Ver.1.0
//	ƎҁFSuga
//	@eF{[hS܂ŃT|[g
//@@@@@q`lf[^ۑEON/OFFAx[XAhXA
//  @@@@{[hݒ_CAO{bNXǉ
//
// 2010N0420 Ver.1.1
//	ƎҁFT.Fukui
//	@eFTF-EditionXe[gZ[uΉA
//		bord_max -> BOARD_MAX
//
// 2013N0228 Ver.1.2
//	ƎҁFT.Fukui
//	@eFt@CύX
//		PIO-3034EMM*.MEM  pio_3034_emm*.mem
//
#include <windows.h>
#include <stdio.h>
#include "resource.h"
#include "..\interface\emuz2000ioBoard.h"
#include "..\interface\plugin_ex.h"

////////////////////////////////////
// Prototype 
////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	) ;

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	) ;

////////////////////////////////////
// Global Variable 
////////////////////////////////////
HINSTANCE		h_instdll = NULL ;

#define	RamFileNamefmt	"pio_3034_emm%1.1d.mem"
#define	IniBaseAddress	"PIO-3034BaseAddress"
#define IniMaisuu		"PIO-3034Maisuu"
#define	IniRamSave		"PIO-3034RamSave"
#define	ram_size		0x50000
#define BOARD_MAX		4

EMUZ2000EBIH	pio3034EBIH = {
	"F69F0E1A-DB72-45e2-B698-77BEC81843E8",
	"PIO-3034 by I-O DATA",
	"320KB Extension RAM Board",
	"Copyright 2006 by Suga, 2010 by T.Fukui",
	"http://www.ne.jp/asahi/suga/junkyard/",
	"suga@mar.email.ne.jp",
	0x00000000,	//Reserved
	InportFunction,
	OutportFunction,
	0,
	0,
	USE_INFODIALOG
} ;

ULONG	address[BOARD_MAX];
UCHAR	ram_data[BOARD_MAX][ram_size];
DWORD	gId = 0;
UINT	IOBASE = 0;
UINT	MAISUU = 0;
UINT	RAM_SAVE = 0;

////////////////////////////////////
// Extern
////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// Logic Start
//
///////////////////////////////////////////////////////
// System interface
///////////////////////////////////////////////////////
BOOL WINAPI
DllMain(
	HINSTANCE	inst,
	DWORD		q_mode,
	LPVOID		vp_res_c )
{
	switch (q_mode)
	{
		case DLL_PROCESS_ATTACH :
			h_instdll = inst;
			break;
		case DLL_THREAD_ATTACH :
			break;
		case DLL_THREAD_DETACH :
			break;
		case DLL_PROCESS_DETACH :
			h_instdll = NULL;
			break;
	}
	return TRUE;
}

///////////////////////////////////////////////////////
// window Proc.
BOOL
WINAPI
InfomationDlgProc(
	HWND hDlg,
	UINT msg,
	WPARAM wPrm,
	LPARAM lPrm
	)
{
	UINT	IoBaseU, IoBaseD;
	char	baseUC[][16] = {"0","1","2","3","4","5","6","7",
							"8","9","A","B","C","D","E","F"};
	char	baseDC[][4]  = {"0","4","8","C"};
	char	maisuuC[][4] = {"1","2","3","4"};
	int		i;

	switch( msg )
	{
		case	WM_INITDIALOG:
			for(i=0; i<16; i++)
				SendDlgItemMessage( hDlg, IDC_IOBU, CB_INSERTSTRING, (WPARAM)i,(LPARAM)baseUC[i]);

			for(i=0; i<4; i++)
				SendDlgItemMessage( hDlg, IDC_IOBD, CB_INSERTSTRING, (WPARAM)i,(LPARAM)baseDC[i]);

			for(i=0; i<4; i++)
				SendDlgItemMessage( hDlg, IDC_MAISUU, CB_INSERTSTRING, (WPARAM)i,(LPARAM)maisuuC[i]);

			IoBaseU = (UINT)(IOBASE / 16);
			IoBaseD = (UINT)((IOBASE % 16) / 4);
			SendDlgItemMessage( hDlg, IDC_IOBU, CB_SETCURSEL, IoBaseU, 0L);
			SendDlgItemMessage( hDlg, IDC_IOBD, CB_SETCURSEL, IoBaseD, 0L);
			SendDlgItemMessage( hDlg, IDC_MAISUU, CB_SETCURSEL, (MAISUU - 1), 0L);

			if(RAM_SAVE == 2) 	// 1 ( 2 ȊO):s 2:sȂ
				SendDlgItemMessage( hDlg, IDC_RAM_NOSAVE, BM_SETCHECK, TRUE, 0L);
			else
				SendDlgItemMessage( hDlg, IDC_RAM_SAVE, BM_SETCHECK, TRUE, 0L);

			return	TRUE;
			break;
		case	WM_COMMAND:
			switch( wPrm )
			{
				case	IDOK:
					IOBASE = (
						SendDlgItemMessage( hDlg, IDC_IOBU, CB_GETCURSEL, 0L, 0L) * 16 +
						SendDlgItemMessage( hDlg, IDC_IOBD, CB_GETCURSEL, 0L, 0L) * 4 ) & 0xfc ;
					MAISUU = SendDlgItemMessage( hDlg, IDC_MAISUU, CB_GETCURSEL, 0L, 0L) + 1;
					if(SendDlgItemMessage( hDlg, IDC_RAM_NOSAVE, BM_GETCHECK, 0L, 0L) )
						RAM_SAVE = 2;	// sȂ
					else
						RAM_SAVE = 1;	// s
					EndDialog( hDlg, FALSE ) ;
					return	TRUE;
				case	IDCANCEL:
					EndDialog( hDlg, FALSE ) ;
					return	TRUE;
					break;
			}
	}
	return	FALSE ;
}

/////////////////////////////////////////////////////////////////////
// I/O Function Interface
/////////////////////////////////////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	)
{
	UCHAR	data;
	UINT	ioport, bordno;

	bordno = (UINT)((port - IOBASE ) / 4);
	if(bordno >= MAISUU) return	0 ;
	ioport = (UINT)((port - IOBASE ) % 4);
	data = 0xff ;

	switch( ioport )
	{
	case	0x03:
		if (address[bordno] < ram_size)
			data = ram_data[bordno][ address[bordno] ] ;
		address[bordno]++ ;
		address[bordno] &= 0x7ffff ;
		break ;
	}
	return	data ;
}

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	)
{
	UINT	ioport, bordno;

	bordno = (UINT)((port - IOBASE ) / 4);
	if(bordno >= MAISUU) return	0 ;
	ioport = (UINT)((port - IOBASE ) % 4);

	switch( ioport )
	{
	case	0x00:
		address[bordno] &= 0x7ff00 ;
		address[bordno] |= (ULONG)data ;
		break ;
	case	0x01:
		address[bordno] &= 0x700ff ;
		address[bordno] |= (ULONG)(data<<8) ;
		break ;
	case	0x02:
		address[bordno] &= 0x0ffff ;
		address[bordno] |= (ULONG)(data<<16) ;
		address[bordno] &= 0x7ffff ;
		break ;
	case	0x03:
		if (address[bordno] < ram_size)
			ram_data[bordno][ address[bordno] ] = data;

		address[bordno]++ ;
		address[bordno] &= 0x7ffff ;
		break ;
	}
	return	0 ;
}

/////////////////////////////////////////////////////////////////////
// EmuZ-2000 Interface
/////////////////////////////////////////////////////////////////////
BOOL
WINAPI
IntializeBoard( 
	VOID
	)
{
	HANDLE	h_File;
	DWORD	dwReadSize;
	UINT	i;
	UINT	SKIP = FALSE;
	char	RamFileName[1024];

//	*--- ini RAMf[^ۑEǂݏo
	RAM_SAVE = emuz2000_readProfileDword( gId, IniRamSave );
	switch( RAM_SAVE)
	{
	case	1:	// s
		break;
	case	2:	// sȂ
		break;
	default :	//	ݒ or ͈͊Oi߂Ė{DLLgꂽƔfj
		RAM_SAVE = 1;
		IOBASE = 0xa0;
		MAISUU = 4;
		SKIP = TRUE;
	}

//	*--- ini I/OAhXAgp{[hǂݏo
	if(!SKIP)
	{
		IOBASE = emuz2000_readProfileDword( gId, IniBaseAddress ) & 0xfc;
		MAISUU = emuz2000_readProfileDword( gId, IniMaisuu );
		if (MAISUU < 1) MAISUU = 1;
		if (MAISUU > BOARD_MAX) MAISUU = BOARD_MAX;
	}

//	*--- EmuZ2000 {̂֎gpI/O AhXA|[gʒm
	pio3034EBIH.ioMapper.ucStartPort = (UCHAR)IOBASE ;
	pio3034EBIH.ioMapper.nCount = (UCHAR)((MAISUU) * 4);

//	*--- {[h̃AhXJE^
	for(i=0; i<BOARD_MAX; i++) address[i] = 0 ;

//	*--- {[h̃Z[uf[^𕜌
	for(i=0; i<MAISUU; i++)
	{
		sprintf(RamFileName, RamFileNamefmt, i);
		h_File = CreateFile ( RamFileName,
				GENERIC_READ,FILE_SHARE_READ,
				NULL,OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL,NULL ) ;
		if( h_File != INVALID_HANDLE_VALUE )
		{
			ReadFile( h_File, ram_data[i], ram_size, &dwReadSize, NULL );
			CloseHandle( h_File );
		}
	}

	return	TRUE;
}

BOOL
WINAPI
ReIntializeBoard( 
	VOID
	)
{
	UINT	i;

	for(i=0; i< BOARD_MAX; i++) address[i] = 0 ;
	return	TRUE ;
}


VOID
WINAPI
FinalizeBoard( 
	VOID 
	)
{
	HANDLE h_File ;
	DWORD dwWriteSize ;
	UINT	i;
	char	RamFileName[1024];

//	*--- |[h̃f[^Z[u
	if(RAM_SAVE == 1)
	{
		for(i=0; i<MAISUU; i++) {
			sprintf(RamFileName, RamFileNamefmt, i);
			h_File = CreateFile ( RamFileName,
				GENERIC_WRITE ,FILE_SHARE_WRITE,
				NULL,CREATE_ALWAYS,
				FILE_ATTRIBUTE_NORMAL,NULL ) ;
			if( h_File != INVALID_HANDLE_VALUE )
			{
				WriteFile( h_File, ram_data[i], ram_size, &dwWriteSize, NULL );
				CloseHandle( h_File ) ;
			}
		}
	}

//	*--- ini փ{[hRAMۑEAI/OAhXAgp{[hۑ
	emuz2000_writeProfileDword( gId, IniRamSave, RAM_SAVE );
	emuz2000_writeProfileDword( gId, IniBaseAddress, IOBASE ) ;
	emuz2000_writeProfileDword( gId, IniMaisuu, MAISUU ) ;

	return ;
}

VOID
WINAPI
ReportCpuClock( 
	int clk
	)
{
	return ;
}

VOID
WINAPI
InfomationDialog( 
	HWND	hWnd 
	)
{
	DialogBox( h_instdll, MAKEINTATOM(IDD_PIO3034_DIALOG), 
		hWnd, InfomationDlgProc);

	return ;
}

BOOL
WINAPI
BoardInfomationService( 
	PEMUZ2000EBIH *info,
	DWORD id
	)
{

	*info = &pio3034EBIH ;
	gId = id ;
	return	TRUE ;
}

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx( int *ver, DWORD *size, PUCHAR *buf )
{
	int i;
	static unsigned int data[BOARD_MAX];

	for (i = 0; i < BOARD_MAX; i++)
		data[i] = 0;
	*size = sizeof(data);
	*buf = (void *)data;
	*ver = 1;				/* Data Format Ver.1 */
	return TRUE;
}

BOOL WINAPI StateSaveInputDataEx( int ver, DWORD size, PUCHAR buf )
{
	int i;
	unsigned int *data = (void *)buf;
	unsigned int tdata[BOARD_MAX];		/* for automatic size calculation */

	for (i = 0; i < BOARD_MAX; i++)
		tdata[i] = 0;			/* for Compiler Warning */
	if (ver > 1)				/* Newer Data Format Ver. */
		return FALSE;
	if (size != sizeof(tdata))
		return FALSE;
	for (i = 0; i < BOARD_MAX; i++)
		address[i] = (ULONG)data[i];
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveOutputData( 
	DWORD *size,
	PUCHAR buf
	)
{
	*size = 0 ;
	buf = NULL ;
	return	TRUE ;
}

BOOL
WINAPI
StateSaveInputData( 
	DWORD size,
	PUCHAR buf
	)
{
	return	TRUE ;
}
#endif
