/* File: plugin_ex.c

	MZ-2000/2200/80B/B2 Emulator "EmuZ-2000" (PluginEx)

	Combine the emz2000 Board_SDK / emuz2000ioBoard.h, emuz2000Debug.h,
		and extend by Toshio Fukui and Shinji Tsuneoka.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#include <windows.h>
#include <stdio.h>

#include "emuz2000ioBoard.h"
#include "plugin_ex.h"

static PEMUZ2000SERVICES _services = NULL;

BOOL WINAPI InitializeBoardEx(PEMUZ2000SERVICES services)
{
	_services = services;
	return IntializeBoard();
}

int WINAPI emuz2000_ex_getVersion(DWORD id)	/* TF-EDITION only service */
{
	if(_services == NULL){
		return 0;
	}
	return _services->emuz2000_ex_getVersion(id);
}

VOID WINAPI emuz2000_ex_setIoEntries(DWORD id, PMAPIOSTRUCT pIoMapper)	/* TF-EDITION only service */
{
	if(_services == NULL){
		return;
	}
	_services->emuz2000_ex_setIoEntries(id, pIoMapper);
}

short WINAPI emuz2000_getCpuMode(DWORD id)
{
	if(_services == NULL){
		return 0;
	}
	return _services->emuz2000_getCpuMode(id);
}

int WINAPI emuz2000_getCpuClock(DWORD id)
{
	if(_services == NULL){
		return 0;
	}
	return _services->emuz2000_getCpuClock(id);
}

PVOID WINAPI emuz2000_getMainMemoryPointer(DWORD id)
{
	if(_services == NULL){
		return NULL;
	}
	return _services->emuz2000_getMainMemoryPointer(id);
}

PVOID WINAPI emuz2000_getTextVramPointer(DWORD id)
{
	if(_services == NULL){
		return NULL;
	}
	return _services->emuz2000_getTextVramPointer(id);
}

VOID WINAPI emuz2000_getGraphicRamPointers(DWORD id, PVOID g1, PVOID g2, PVOID g3)
{
	if(_services == NULL){
		return;
	}
	_services->emuz2000_getGraphicRamPointers(id, g1, g2, g3);
}

VOID WINAPI emuz2000_setViewChange(DWORD id)
{
	if(_services == NULL){
		return;
	}
	_services->emuz2000_setViewChange(id);
}

VOID WINAPI emuz2000_sendKeyMessage(DWORD id, UCHAR keyCode, UCHAR flg)
{
	if(_services == NULL){
		return;
	}
	_services->emuz2000_sendKeyMessage(id, keyCode, flg);
}

VOID WINAPI emuz2000_signalInterrupt(DWORD id, UCHAR code)
{
	if(_services == NULL){
		return;
	}
	_services->emuz2000_signalInterrupt(id, code);
}

UCHAR WINAPI emuz2000_inputPort(DWORD id, USHORT port)
{
	if(_services == NULL){
		return 0;
	}
	return _services->emuz2000_inputPort(id, port);
}

VOID WINAPI emuz2000_outputPort(DWORD id, USHORT port, UCHAR data)
{
	if(_services == NULL){
		return;
	}
	_services->emuz2000_outputPort(id, port, data);
}

DWORD WINAPI emuz2000_readProfileDword(DWORD id, LPCTSTR lpKey)
{
	if(_services == NULL){
		return 0;
	}
	return _services->emuz2000_readProfileDword(id, lpKey);
}

DWORD WINAPI emuz2000_readProgileString(DWORD id, LPCTSTR lpKey, LPTSTR lpGetBuf, DWORD nGetMaxSize)
{
	if(_services == NULL){
		return 0;
	}
	return _services->emuz2000_readProfileString(id, lpKey, lpGetBuf, nGetMaxSize);
}

BOOL WINAPI emuz2000_writeProfileDword(DWORD id, LPCTSTR lpKey, DWORD value)
{
	if(_services == NULL){
		return FALSE;
	}
	return _services->emuz2000_writeProfileDword(id, lpKey, value);
}

BOOL WINAPI emuz2000_writeProgileString(DWORD id, LPCTSTR lpKey, LPCTSTR lpString)
{
	if(_services == NULL){
		return FALSE;
	}
	return _services->emuz2000_writeProfileString(id, lpKey, lpString);
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
