/* File: plugin_ex.h

	MZ-2000/2200/80B/B2 Emulator "EmuZ-2000" (Plugin Ex)

	Combine the emz2000 emuz2000ioBoard.h, emuz2000Debug.h,
		and extend by Toshio Fukui and Shinji Tsuneoka.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __PLUGIN_EX_H__
#define __PLUGIN_EX_H__

#include "emuz2000plugin.h"

#define PLUGIN_DEVICE_VERB_GETINTERFACE		1
#define PLUGIN_DEVICE_VERB_GETFNPTR			2
#define PLUGIN_DEVICE_VERB_GETEXIST			3
#define PLUGIN_DEVICE_VERB_GETWRITABLE		4
#define PLUGIN_DEVICE_VERB_GETACCESS		5
#define PLUGIN_DEVICE_VERB_GETMODIFIED		6
#define PLUGIN_DEVICE_VERB_GETRUNNINGSTATUS	7
#define PLUGIN_DEVICE_VERB_WRITEBACK		8
#define PLUGIN_DEVICE_VERB_EJECT			9
#define PLUGIN_DEVICE_VERB_CHANGE			10
#define PLUGIN_DEVICE_VERB_EXEC				11

#define PLUGIN_DEVICE_TYPE_NONE				-1
#define PLUGIN_DEVICE_TYPE_TAPE				0
#define PLUGIN_DEVICE_TYPE_FD				1
#define PLUGIN_DEVICE_TYPE_QD				2

/* emuz2000 service api */

/* Basic Service */
typedef short (WINAPI *EMUZ2000GETCPUMODEFUNC)(DWORD id);
typedef int   (WINAPI *EMUZ2000GETCPUCLOCKFUNC)(DWORD id);
typedef PVOID (WINAPI *EMUZ2000GETMAINMEMORYPOINTERFUNC)(DWORD id);
typedef PVOID (WINAPI *EMUZ2000GETTEXTVRAMPOINTERFUNC)(DWORD id);
typedef VOID  (WINAPI *EMUZ2000GETGRAPHICRAMPOINTERSFUNC)(DWORD id, PVOID g1, PVOID g2, PVOID g3);
typedef VOID  (WINAPI *EMUZ2000SETVIEWCHANGEFUNC)(DWORD id);
typedef VOID  (WINAPI *EMUZ2000SENDKEYMESSAGEFUNC)(DWORD id, UCHAR keyCode, UCHAR flg);
typedef VOID  (WINAPI *EMUZ2000SIGNALINTERRUPTFUNC)(DWORD id, UCHAR code);
typedef UCHAR (WINAPI *EMUZ2000INPUTPORTFUNC)(DWORD id, USHORT port);
typedef VOID  (WINAPI *EMUZ2000OUTPUTPORTFUNC)(DWORD id, USHORT port, UCHAR data);

/* Profile Service */
typedef DWORD (WINAPI *EMUZ2000READPROFILEDWORDFUNC)(DWORD id, LPCTSTR lpKey);
typedef DWORD (WINAPI *EMUZ2000READPROFILESTRINGFUNC)(DWORD id, LPCTSTR lpKey, LPTSTR	lpGetBuf, DWORD nGetMaxSize);
typedef BOOL  (WINAPI *EMUZ2000WRITEPROFILEDWORDFUNC)(DWORD id, LPCTSTR lpKey, DWORD value);
typedef BOOL  (WINAPI *EMUZ2000WRITEPROFILESTRINGFUNC)(DWORD id, LPCTSTR lpKey, LPCTSTR lpString);

/* Memory Segment Collection */
typedef BOOL  (WINAPI *EMUZ2000GETMEMORYSEGMENTINFO)(DWORD id, PMAPMEMORYSTRUCT pmms);
typedef BOOL  (WINAPI *EMUZ2000SETMEMORYSEGMENTINFO)(DWORD id, PMAPMEMORYSTRUCT pmms);

/* Sound Service */
typedef BOOL  (WINAPI *EMUZ2000EXTSOUNDCREATE)(DWORD id, DWORD no);
typedef BOOL  (WINAPI *EMUZ2000EXTSOUNDPLAY)(DWORD id, DWORD no);
typedef BOOL  (WINAPI *EMUZ2000EXTSOUNDSTOP)(DWORD id, DWORD no);

/* Extended Service */
typedef int   (WINAPI *EMUZ2000EXGETVERSIONFUNC)(DWORD id);
typedef VOID  (WINAPI *EMUZ2000EXSETIOENTRIES)(DWORD id, PMAPIOSTRUCT pIoMapper);

typedef struct _emuz2000servicesstruct{
	/* Basic Service */
	EMUZ2000GETCPUMODEFUNC emuz2000_getCpuMode;
	EMUZ2000GETCPUCLOCKFUNC emuz2000_getCpuClock;
	EMUZ2000GETMAINMEMORYPOINTERFUNC emuz2000_getMainMemoryPointer;
	EMUZ2000GETTEXTVRAMPOINTERFUNC emuz2000_getTextVramPointer;
	EMUZ2000GETGRAPHICRAMPOINTERSFUNC emuz2000_getGraphicRamPointers;
	EMUZ2000SETVIEWCHANGEFUNC emuz2000_setViewChange;
	EMUZ2000SENDKEYMESSAGEFUNC emuz2000_sendKeyMessage;
	EMUZ2000SIGNALINTERRUPTFUNC emuz2000_signalInterrupt;
	EMUZ2000INPUTPORTFUNC emuz2000_inputPort;
	EMUZ2000OUTPUTPORTFUNC emuz2000_outputPort;
	/* Profile Service */
	EMUZ2000READPROFILEDWORDFUNC emuz2000_readProfileDword;
	EMUZ2000READPROFILESTRINGFUNC emuz2000_readProfileString;
	EMUZ2000WRITEPROFILEDWORDFUNC emuz2000_writeProfileDword;
	EMUZ2000WRITEPROFILESTRINGFUNC emuz2000_writeProfileString;
	/* Memory Segment Collection */
	EMUZ2000GETMEMORYSEGMENTINFO emuz2000_getMemorySegmentInfo;
	EMUZ2000SETMEMORYSEGMENTINFO emuz2000_setMemorySegmentInfo;
	/* Sound Service */
	EMUZ2000EXTSOUNDCREATE emuz2000_ext_Sound_Create;
	EMUZ2000EXTSOUNDPLAY emuz2000_ext_Sound_Play;
	EMUZ2000EXTSOUNDSTOP emuz2000_ext_Sound_Stop;
	/* Extended Service */
	EMUZ2000EXGETVERSIONFUNC emuz2000_ex_getVersion;
	EMUZ2000EXSETIOENTRIES emuz2000_ex_setIoEntries;
} EMUZ2000SERVICES, *PEMUZ2000SERVICES;

/* extended api */
BOOL WINAPI InitializeBoardEx(PEMUZ2000SERVICES services); 
BOOL WINAPI StateSaveOutputDataEx(int *ver, DWORD *size, PUCHAR *buf);
BOOL WINAPI StateSaveInputDataEx(int ver, DWORD size, PUCHAR buf);
BOOL WINAPI StrageDeviceCallback(int type, int drive, int verb, int mode, DWORD dwParam1, DWORD dwParam2, LPVOID lpParam);

/* Plugin DLL APIs */
typedef BOOL (WINAPI *PLUGININITIALIZEBOARDEX)(PEMUZ2000SERVICES services);
typedef BOOL (WINAPI *PSTATESAVEOUTPUTDATAEX)(int *ver, DWORD *size, PUCHAR *buf);
typedef BOOL (WINAPI *PSTATESAVEINPUTDATAEX)(int ver, DWORD size, PUCHAR buf);
typedef BOOL (WINAPI *PSTRAGEDEVICECALLBACK)(int type, int drive, int verb, int mode, DWORD dwParam1, DWORD dwParam2, LPVOID lpParam);

/* extended services */
int  WINAPI emuz2000_ex_getVersion(DWORD id);
VOID WINAPI emuz2000_ex_setIoEntries(DWORD id, PMAPIOSTRUCT pIoMapper);

#endif	/* __PLUGIN_EX_H__ */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
