//============================================================================
//  cmu800core.c uCMU-800v
//----------------------------------------------------------------------------
//													Programmed by 
//============================================================================
#include <process.h>
#include "generic.h"
#include "cmu800core.h"
#include "midi.h"
#include "timer.h"
#include "debug.h"

unsigned int Cmu800Tempo = 120;
unsigned int Cmu800Interval = 0;
unsigned int Cmu800StartClock = 0;
// IC
unsigned char Cmu800PortData[ 13 ];
unsigned short Cmu800_8253Counter[ 6 ];
unsigned int Cmu800_8253CounterSwitch[ 6 ];
// MIDI
BOOL Cmu800MidiFlag = FALSE;	// MIDI gpł邩ǂ
Cmu800KeyOnFlag[ 8 ];
unsigned char Cmu800ToneTbl[ 8 ] = {
	0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char Cmu800RythmTbl[ 7 ] = {
	42, 46, 52, 50, 45, 38, 35
};
// PLAY
unsigned char Cmu800CvKey[ 8 ];
unsigned char Cmu800Cv;
BOOL Cmu800KeyOn;
BOOL Cmu800KeyOnEnableFlag[ 8 ] = {
	TRUE, TRUE, TRUE, TRUE,
	TRUE, TRUE, TRUE, TRUE
};
BOOL Cmu800KeyOffEnableFlag[ 8 ] = {
	TRUE, TRUE, TRUE, TRUE,
	TRUE, TRUE, TRUE, TRUE
};
unsigned char Cmu800RythmStatus = 255;
unsigned char Cmu800ToneStatus = 0;

// vCx[g֐
BOOL Cmu800CheckCpu( void );
int Cmu800GetCpuSpeed( void );
void CALLBACK playloop( UINT timer_id, UINT msg, DWORD user, DWORD dw1, DWORD dw2 );

//============================================================================
//	CMU-800 
//============================================================================
BOOL Cmu800Init( void )
{
	int i;
	memset( Cmu800PortData, 0, sizeof( Cmu800PortData ) );
	memset( Cmu800_8253Counter, 0, sizeof( Cmu800_8253Counter ) );
	memset( Cmu800_8253CounterSwitch, 0, sizeof( Cmu800_8253CounterSwitch ) );
	memset( Cmu800KeyOnFlag, 0, sizeof( Cmu800KeyOnFlag ) );
	// ^C}
	if ( FALSE == TimerInit() ) {
		return FALSE;
	}
	// e|ݒ
	Cmu800Set( CMU800_SET_TEMPO, 120 );
	// MIDI 
	Cmu800MidiFlag = MidiOpen( MIDI_MAPPER );
	if ( FALSE == Cmu800MidiFlag ) {
		return FALSE;
	}
	MidiReset();
	for ( i=0; i<8; i++ ) {
		Cmu800Set( CMU800_SET_CH1TONE + i, 0 );
	}
	return TRUE;
}

//============================================================================
//	CMU-800 I
//============================================================================
void Cmu800End( void )
{
	// ^C}I
	TimerStop();
	// MIDI J
	if ( Cmu800MidiFlag ) {
		MidiClose() ;
	}
}

//============================================================================
//	CMU-800 ݒ肷
//============================================================================
void Cmu800Set( int type, int data )
{
	switch( type ) {
		case CMU800_SET_TEMPO:
			Cmu800Tempo = data;
			Cmu800Interval = 60 * 1000 / Cmu800Tempo / 24 / 2;
			TimerStop();
			TimerStart( Cmu800Interval, playloop, 0 );
			break;
		case CMU800_SET_CH1TONE:
		case CMU800_SET_CH2TONE:
		case CMU800_SET_CH3TONE:
		case CMU800_SET_CH4TONE:
		case CMU800_SET_CH5TONE:
		case CMU800_SET_CH6TONE:
		case CMU800_SET_CH7TONE:
		case CMU800_SET_CH8TONE:
			Cmu800ToneTbl[ type - CMU800_SET_CH1TONE ] = (unsigned char)data;
			MidiOut( (unsigned char)( 0xC0 + type - CMU800_SET_CH1TONE ), (unsigned char)( data ), 0x00 );
			break;
		case CMU800_SET_DRUM1TONE:
		case CMU800_SET_DRUM2TONE:
		case CMU800_SET_DRUM3TONE:
		case CMU800_SET_DRUM4TONE:
		case CMU800_SET_DRUM5TONE:
		case CMU800_SET_DRUM6TONE:
		case CMU800_SET_DRUM7TONE:
			Cmu800RythmTbl[ type - CMU800_SET_DRUM1TONE ] = (unsigned char)data;
			break;
	}
}

//============================================================================
//	CMU-800 ɃR}h𑗂
//============================================================================
void Cmu800Send( int port, unsigned char data )
{
	switch( port ) {
		// 8253-1 JE^ݒ (vOł͂̃f[^͎gpĂȂ)
		case 0x0:
		case 0x1:
		case 0x2:
			Cmu800_8253Counter[ port ] = data * 256 * Cmu800_8253CounterSwitch[ port ];
			Cmu800_8253CounterSwitch[ port ]++;
			Cmu800_8253CounterSwitch[ port ] &= 1;
			break;
		// 8253-1 [hݒ (ȗ)
		case 0x3:
			break;
		// 8253-2 JE^ݒ (vOł͂̃f[^͎gpĂȂ)
		case 0x4:
		case 0x5:
		case 0x6:
			Cmu800_8253Counter[ port - 6 ] = data * 256 * Cmu800_8253CounterSwitch[ port - 6 ];
			Cmu800_8253CounterSwitch[ port - 6 ]++;
			Cmu800_8253CounterSwitch[ port - 6 ] &= 1;
			break;
		// 8253-2 [hݒ (ȗ)
		case 0x7:
			break;
		// b0-5 CV-OUT f[^ ({͓Ɋ֌WȂ)
		// b6 TUNE-GATE (ꂪ H  CHORD ̉oȂȂ邩 ?)
		// b7 GATE-DATA (0 = A1 = )
		case 0x8:
			Cmu800Cv = data & 0x3F;
			Cmu800KeyOn = ( 0 == ( data & 0x80 ) );
			break;
		// YA10 = 
		// b7 BD (oXh)
		// b6 SD (XlAh)
		// b5 LT ([^)
		// b4 HT (nC^)
		// b3 CY (Vo)
		// b2 OH (I[vnCnbg)
		// b1 CH (N[YnCnbg)
		// b0 Reserve (gp)
		case 0x9:
			Cmu800RythmStatus = data;
			break;
		// b0 (10 = ݒ芮A܂͏)
		// b1-3 = `l (0-7)
		case 0xA:
			if ( ( Cmu800PortData[ port ] & 1 ) && ( 0 == ( data & 1 ) ) ) {
				int channel;
				channel = ( data >> 1 ) & 0x7;
				if ( ( Cmu800KeyOn ) && ( FALSE == Cmu800KeyOnFlag[ channel ] ) ) {
					Cmu800ToneStatus |= ( 1 << channel );
					Cmu800KeyOnFlag[ channel ] = TRUE;
					Cmu800CvKey[ channel ] = Cmu800Cv + 24;
					Cmu800KeyOnEnableFlag[ channel ] = TRUE;
				} else if ( ( FALSE == Cmu800KeyOn ) && ( TRUE == Cmu800KeyOnFlag[ channel ] ) ) {
					Cmu800ToneStatus &= ~( 1 << channel );
					Cmu800KeyOnFlag[ channel ] = FALSE;
					Cmu800KeyOffEnableFlag[ channel ] = TRUE;
				}
			}
			break;
		// 8255 ݒ (ȗ)
		case 0xB:
			break;
		// _~[|[g (Ȃ)
		case 0xC:
			break;
	}
	Cmu800PortData[ port ] = data;
}

//============================================================================
//	CMU-800 f[^󂯎
//============================================================================
U8 Cmu800Receive( int port )
{
	return Cmu800PortData[ port ];
}

//============================================================================
//	t
//============================================================================
void CALLBACK playloop( UINT timer_id, UINT msg, DWORD user, DWORD dw1, DWORD dw2 )
{
	if ( 0 == Cmu800Interval ) {
		return;
	}
	// 0xA |[g̃NbN
	if ( Cmu800PortData[ 0x0A ] & 0xF0 ) {
		Cmu800PortData[ 0x0A ] &= 0x0F;
	} else {
		unsigned char bit;
		int i;
		Cmu800PortData[ 0x0A ] |= 0xF0;
		// Y
		bit = 2;
		for ( i=0; i<7; i++ ) {
			if ( 0 == ( Cmu800RythmStatus & bit ) ) {
				MidiOut( 0x99, Cmu800RythmTbl[ i ], 0x7F );
			}
			bit <<= 1;
		}
		// K
		bit = 1;
		for ( i=0; i<8; i++ ) {
			if ( Cmu800ToneStatus & bit ) {
				if ( Cmu800KeyOnEnableFlag[ i ] ) {
					MidiOut( (unsigned char)( 0x90 + i ), (unsigned char)( Cmu800CvKey[ i ] ), 0x7F );
					Cmu800KeyOnEnableFlag[ i ] = FALSE;
				}
			} else {
				if ( Cmu800KeyOffEnableFlag[ i ] ) {
					MidiOut( (unsigned char)( 0x80 + i ), (unsigned char)( Cmu800CvKey[ i ] ), 0x7F );
					Cmu800KeyOffEnableFlag[ i ] = FALSE;
				}
			}
			bit <<= 1;
		}
	}
}
