/*********************************************************************************
*
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*
*                        EmuZ-2000  Extend Board DLL
*
*                               << CMU-800 >>
*
*                          Main Module [cmu_800.c]
*
*               Programmed & Porting by 2003 EmuZ-2000 (M.Y) & TAGO
*		TF-Edition support by T.Fukui (2017)
*
*********************************************************************************/
//
//
#include <windows.h>
#include "resource.h"
#include "../interface/emuz2000ioBoard.h"
//Support Debugger
//#include "../interface/emuz2000debug.h"
#include "../interface/plugin_ex.h"
#include <mmsystem.h>
#include <stdio.h>
#include "cmu800core.h"
#include "debug.h"

// NCu̎w
#pragma comment( lib, "Winmm.lib" )

////////////////////////////////////
// Prototype 
////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	) ;

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	) ;

////////////////////////////////////
// Global Variable 
////////////////////////////////////
HINSTANCE		h_instdll = NULL ;

EMUZ2000EBIH	cmu800EBIH = {
	"31DD2499-F757-481B-9BCA-434D55383030",
	"COMPU-MUSIC CMU-800 by AMDEK,Roland/DG",
	"GM MIDI Version " CMU800_VERSION,
	"Copyright 2003 by EmuZ-2000 & TAGO, 2017 by T.Fukui",
	"http://www.geocities.co.jp/SiliconValley-Sunnyvale/2521/",
	"mz-2500@erato.dricas.com",
	0x00000000,	//Reserved
	InportFunction,
	OutportFunction,
	0x90,
	0x0D,		// 13
	USE_INFODIALOG
} ;

DWORD	gId = 0 ;
DWORD	dwBase = 0x90 ;
BOOL	bCmu800Init = FALSE;
int		nTempo = 120 ;

////////////////////////////////////
// Extern
////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// Logic Start
//
///////////////////////////////////////////////////////
// System interface
///////////////////////////////////////////////////////
BOOL WINAPI
DllMain(
	HINSTANCE	inst,
	DWORD		q_mode,
	LPVOID		vp_res_c )
{
	switch (q_mode) {
	case DLL_PROCESS_ATTACH :
		h_instdll = inst;
		break;
	case DLL_THREAD_ATTACH :
		break;
	case DLL_THREAD_DETACH :
		break;
	case DLL_PROCESS_DETACH :
		h_instdll = NULL;
		break;
	}
	return TRUE;
}

///////////////////////////////////////////////////////
// window Proc.
BOOL
WINAPI
InfomationDlgProc(
	HWND hDlg,
	UINT msg,
	WPARAM wPrm,
	LPARAM lPrm
	)
{
	switch( msg ){
		case	WM_INITDIALOG:
			SetDlgItemInt( hDlg, IDC_TEMPO, nTempo, TRUE ) ;
			return	TRUE ;

		case	WM_COMMAND:
			switch( wPrm ){
				case	IDOK:
					nTempo = GetDlgItemInt( hDlg, IDC_TEMPO, NULL, TRUE ) ;
					Cmu800Set( CMU800_SET_TEMPO, nTempo ) ;
					EndDialog( hDlg, TRUE ) ;
					return	TRUE ;

				case	IDCANCEL:
					EndDialog( hDlg, FALSE ) ;
					return	TRUE ;

			}
			break ;
	}
	return	FALSE ;
}

/////////////////////////////////////////////////////////////////////
// I/O Function Interface
/////////////////////////////////////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	)
{
	UCHAR	data = 0 ;

	switch( port )
	{
	case	0x9A:
		data = Cmu800Receive( port & 0xF ) ;
		break ;
	}
	// fobO
/*
	DEBUGOUT( "In : Port = " ) ;
	DEBUGOUTVALUEHEX2( port ) ;
	DEBUGOUT( " Data = " ) ;
	DEBUGOUTVALUEHEX2( data ) ;
	DEBUGOUT( "\n" ) ;
//*/

	return	data ;
}

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	)
{
/*
	// fobO
	DEBUGOUT( "Out : Port = " ) ;
	DEBUGOUTVALUEHEX2( port ) ;
	DEBUGOUT( " Data = " ) ;
	DEBUGOUTVALUEHEX2( data ) ;
	DEBUGOUT( "\n" ) ;
//*/
	switch( port )
	{
	case	0x90:
	case	0x91:
	case	0x92:
	case	0x93:
	case	0x94:
	case	0x95:
	case	0x96:
	case	0x97:
	case	0x98:
	case	0x99:
	case	0x9A:
	case	0x9B:
	case	0x9C:
		Cmu800Send( port & 0xF, data ) ;
		break ;
	}

	return	0 ;
}

/////////////////////////////////////////////////////////////////////
// EmuZ-2000 Interface
/////////////////////////////////////////////////////////////////////
BOOL
WINAPI
IntializeBoard( 
	VOID
	)
{
	// CMU-800 
	bCmu800Init = Cmu800Init() ;
	Cmu800Set( CMU800_SET_TEMPO, nTempo ) ;
	// |[gԍݒ
	dwBase = emuz2000_readProfileDword( gId, "BaseAddress" ) ;
	switch( dwBase )
	{
	case	0x90:
		break ;
	default:
		dwBase = 0x90 ;
		break ;
	}
	// I/O |[gAhX擾
	cmu800EBIH.ioMapper.ucStartPort = (UCHAR)dwBase ;

	return	TRUE ;
}

BOOL
WINAPI
ReIntializeBoard( 
	VOID
	)
{
	return	TRUE ;
}


VOID
WINAPI
FinalizeBoard( 
	VOID 
	)
{
	Cmu800End() ;
	emuz2000_writeProfileDword( gId, "BaseAddress", dwBase ) ;
	return ;
}

VOID
WINAPI
ReportCpuClock( 
	int clk
	)
{
	return ;
}

VOID
WINAPI
InfomationDialog( 
	HWND	hWnd 
	)
{
	DialogBox( h_instdll, MAKEINTATOM(IDD_DIALOG_BASEADDRESS), 
		hWnd, InfomationDlgProc) ;

	return ;
}

BOOL
WINAPI
BoardInfomationService( 
	PEMUZ2000EBIH *info,
	DWORD id
	)
{

	*info = &cmu800EBIH ;
	gId = id ;
	return	TRUE ;
}

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx( int *ver, LPDWORD lpdwSize, LPBYTE *lpbBuff )
{
	*lpdwSize = 0;
	*lpbBuff = NULL;
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveOutputData( 
	DWORD *size,
	PUCHAR buf
	)
{
	*size = 0 ;
	buf = NULL ;
	return	TRUE ;
}
#endif

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveInputDataEx( int ver, DWORD dwSize, PBYTE lpbBuff )
{
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveInputData( 
	DWORD size,
	PUCHAR buf
	)
{
	return	TRUE ;
}
#endif
