/*********************************************************************************
*
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*
*                        EmuZ-2000  Extend Board DLL
*
*                               << EmuZ-1M03 >>
*
*                          Main Module [emuz_1m03.c]
*
*               Programmed & Porting by 2003-4 EmuZ-2000 (M.Y) & TAGO
*
*********************************************************************************/
//
//
#include <windows.h>
#include "resource.h"
#include "..\interface\emuz2000ioBoard.h"
//Support Debugger
//#include "..\interface\emuz2000debug.h"
#include "..\interface\plugin_ex.h"
#include <mmsystem.h>
#include <stdio.h>
#include "emuz_1m03.h"
#include "debug.h"

////////////////////////////////////
// Prototype 
////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	) ;

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	) ;

////////////////////////////////////
// Global Variable 
////////////////////////////////////
HINSTANCE		h_instdll = NULL ;

EMUZ2000EBIH	emuz_1m03EBIH = {
	"5A854F70-272E-40af-A79A-C977AA490CB8",
	"EmuZ-1M03 BasicManager",
	"EmuZ-1M03 Version " EmuZ1M03_VERSION,
	"Copyright 2003-4 by EmuZ-2000 & TAGO & Suga, 2010 T.Fukui",
	"http://www.geocities.co.jp/SiliconValley-Sunnyvale/2521/",
	"mz-2500@erato.dricas.com",
	0x00000000,	//Reserved
	InportFunction,
	OutportFunction,
	0x80,
	0x00,
	USE_INFODIALOG | USE_MAINMEMORY
} ;

DWORD	gId = 0 ;
DWORD	dwBase = 0x80 ;
static int SaveType = 0;
static char MzFileName[ 17 ];
static int MzFileType = 1;
static int MzFileStartAddress = 0;
static int MzFileRunAddress = 0;
static int MzFileSize = 0;
static int CustomStartAddress = 0;
static int CustomRunAddress = 0;
static int CustomSize = 0;
static char Filename[ MAX_PATH ];
// t@CI
static OPENFILENAME ofn;
static TCHAR strFile[ MAX_PATH ];
static TCHAR strCustom[ 256 ];
// eƂ̃t@C
typedef struct _EnvData
{
	char *EnvName;
	unsigned char Mode;
	unsigned short LoadAdr;
	unsigned short PointerList;
} ENVDATA;

#define ENVDATA_MAX 8
ENVDATA EnvDataList[ ENVDATA_MAX ] =
{
	"BINARY",               1, 0x0000, 0x0000,
	"SB-5520",              2, 0x515C, 0x4F4E,
	"MZ-1Z001",             2, 0x545C, 0x524E,
	"MZ-1Z002",             2, 0x655C, 0x634E,
	"MZ-1Z003",             2, 0x5DDD, 0x5B4E,
	"SuperColorBASIC",      2, 0x74AF, 0x524E,
	"HIMEJI BASIC 1.0",     2, 0x6300, 0x524E,
	"KANJI BASIC SB-2000T", 2, 0x815C, 0x7F4E,
};

////////////////////////////////////
// Extern
////////////////////////////////////


////////////////////////////////////
// Private function
////////////////////////////////////
int SaveBasic( char *path, char *buffer, int address ) ;
int LoadBasic( char *path, char *buffer, int address, int type ) ;
int LoadBinary( char *path, char *buffer, int address, int size ) ;
int SaveBinary( char *path, char *buffer, int address, int size ) ;

////////////////////////////////////
// Tape header struct
////////////////////////////////////
typedef struct tagMZTHEAD
{
	unsigned char Mode;
	char Filename[ 17 ];
	unsigned short Size;
	unsigned short LoadAdr;
	unsigned short RunAdr;
	unsigned char Reserve[ 104 ];
} MZTHEAD;

//////////////////////////////////////////////////////////////////////////////////////
// Logic Start
//
///////////////////////////////////////////////////////
// System interface
///////////////////////////////////////////////////////
BOOL WINAPI
DllMain(
	HINSTANCE	inst,
	DWORD		q_mode,
	LPVOID		vp_res_c )
{
	switch (q_mode) {
	case DLL_PROCESS_ATTACH :
		h_instdll = inst;
		break;
	case DLL_THREAD_ATTACH :
		break;
	case DLL_THREAD_DETACH :
		break;
	case DLL_PROCESS_DETACH :
		h_instdll = NULL;
		break;
	}
	return TRUE;
}

///////////////////////////////////////////////////////
// window Proc.
BOOL
WINAPI
InfomationDlgProc(
	HWND hDlg,
	UINT msg,
	WPARAM wPrm,
	LPARAM lPrm
	)
{
	HWND combo;
	int i;
	combo = GetDlgItem( hDlg, IDC_COMBO1 ) ;
	switch( msg ){
		case	WM_INITDIALOG:
			for( i = 0; i < ENVDATA_MAX; i ++ )
			{
				SendMessage( combo, CB_ADDSTRING, 0, (LPARAM)EnvDataList[ i ].EnvName ) ;
			}
			SendMessage( combo, CB_SETCURSEL, (WPARAM)SaveType, 0 ) ;
			SetDlgItemInt( hDlg, IDC_TYPE, MzFileType, TRUE ) ;
			SetDlgItemInt( hDlg, IDC_ADDRESS, MzFileStartAddress, TRUE ) ;
			SetDlgItemInt( hDlg, IDC_RUN, MzFileRunAddress, TRUE ) ;
			SetDlgItemInt( hDlg, IDC_FILESIZE, MzFileSize, TRUE ) ;
			SetDlgItemText( hDlg, IDC_FILENAME, MzFileName ) ;
			SetDlgItemText( hDlg, IDC_PATH, Filename ) ;
			return	TRUE ;

		case	WM_COMMAND:
			if( IDC_COMBO1 == LOWORD( wPrm ) )
			{
				if( CBN_SELCHANGE == HIWORD( wPrm ) )
				{
					SaveType = SendMessage( combo, CB_GETCURSEL, 0, 0 ) ;
					MzFileType = EnvDataList[ SaveType ].Mode ;
					MzFileStartAddress = EnvDataList[ SaveType ].LoadAdr ;
					MzFileRunAddress = 0 ;
					if ( 1 == MzFileType )
					{
							MzFileStartAddress = CustomStartAddress ;
							MzFileRunAddress = CustomRunAddress ;
					}
					SetDlgItemInt( hDlg, IDC_TYPE, MzFileType, TRUE ) ;
					SetDlgItemInt( hDlg, IDC_ADDRESS, MzFileStartAddress, TRUE ) ;
					SetDlgItemInt( hDlg, IDC_RUN, MzFileRunAddress, TRUE ) ;
					SetDlgItemInt( hDlg, IDC_FILESIZE, MzFileSize, TRUE ) ;
				}
			}
			switch( wPrm ){
				case	IDOK:
					GetDlgItemText( hDlg, IDC_PATH, Filename, MAX_PATH ) ;
					MzFileType = GetDlgItemInt( hDlg, IDC_TYPE, NULL, TRUE ) ;
					MzFileStartAddress = GetDlgItemInt( hDlg, IDC_ADDRESS, NULL, TRUE ) ;
					MzFileRunAddress = GetDlgItemInt( hDlg, IDC_RUN, NULL, TRUE ) ;
					MzFileSize = GetDlgItemInt( hDlg, IDC_FILESIZE, NULL, TRUE ) ;
					EndDialog( hDlg, TRUE ) ;
					return	TRUE ;

				case	IDCANCEL:
					EndDialog( hDlg, FALSE ) ;
					return	TRUE ;

				case	IDC_BUTTON1:	// SAVE
				{
					char *buffer ;
					char filename[ 17 ] ;
					char path[ MAX_PATH ] ;
					int i ;
					int zero = 0 ;
					int result;
					char msg[ MAX_PATH + 100 ];
					GetDlgItemText( hDlg, IDC_PATH, path, MAX_PATH ) ;
					if ( '\0' == path[ 0 ] )
					{
						MessageBox( hDlg, "pX͂Ă", "BasicManager error", MB_OK ) ;
						return TRUE ;
					}
					sprintf( msg, "{ %s ۑ܂ ?", path ) ;
					if ( IDNO == MessageBox( hDlg, msg, "mF", MB_YESNO ) )
					{
						return TRUE;
					}
					buffer = emuz2000_getMainMemoryPointer( gId ) ;
					MzFileType = GetDlgItemInt( hDlg, IDC_TYPE, NULL, TRUE ) ;
					MzFileStartAddress = GetDlgItemInt( hDlg, IDC_ADDRESS, NULL, TRUE ) ;
					MzFileRunAddress = GetDlgItemInt( hDlg, IDC_RUN, NULL, TRUE ) ;
					MzFileSize = GetDlgItemInt( hDlg, IDC_FILESIZE, NULL, TRUE ) ;
					GetDlgItemText( hDlg, IDC_FILENAME, filename, 17 ) ;
					for( i = 0; i < 17; i ++ )
					{
						if( 1 == zero )
						{
							filename[ i ] = '\0' ;
						}
						else
						{
							if( '\0' == filename[ i ] )
							{
								zero = 1 ;
							}
						}
					}
					strncpy( MzFileName, filename, 17 ) ;
					if( 2 == MzFileType )
					{
						result = SaveBasic( path, buffer, MzFileStartAddress ) ;
					}
					else
					{
						result = SaveBinary( path, buffer, MzFileStartAddress, MzFileSize ) ;
					}
					if( 0 == result )
					{
						sprintf( msg, "%s ۑ܂.", path ) ;
						MessageBox( hDlg, msg, "mF", MB_OK ) ;
					}
					else
					{
						sprintf( msg, "%s ̕ۑɎs܂.", path ) ;
						MessageBox( hDlg, msg, "mF", MB_OK ) ;
					}
					return	TRUE ;
				}

				case	IDC_BUTTON2:	// LOAD
				{
					char *buffer ;
					char filename[ 17 ] ;
					char path[ MAX_PATH ] ;
					char msg[ MAX_PATH + 100 ];
					int i ;
					int zero = 0 ;
					buffer = emuz2000_getMainMemoryPointer( gId ) ;
					MzFileType = GetDlgItemInt( hDlg, IDC_TYPE, NULL, TRUE ) ;
					MzFileStartAddress = GetDlgItemInt( hDlg, IDC_ADDRESS, NULL, TRUE ) ;
					MzFileRunAddress = GetDlgItemInt( hDlg, IDC_RUN, NULL, TRUE ) ;
					MzFileSize = GetDlgItemInt( hDlg, IDC_FILESIZE, NULL, TRUE ) ;
					GetDlgItemText( hDlg, IDC_PATH, path, MAX_PATH ) ;
					if ( '\0' == path[ 0 ] )
					{
						MessageBox( hDlg, "pX͂Ă", "BasicManager error", MB_OK ) ;
						return TRUE;
					}
					for( i = 0; i < 17; i ++ )
					{
						if( 1 == zero )
						{
							filename[ i ] = '\0' ;
						}
						else
						{
							if( '\0' == filename[ i ] )
							{
								zero = 1 ;
							}
						}
					}
					strncpy( MzFileName, filename, 17 ) ;
					if ( 0 == LoadBasic( path, buffer, MzFileStartAddress, SaveType ) )
					{
						sprintf( msg, "%s ǂݍ݂܂.", path ) ;
						MessageBox( hDlg, msg, "mF", MB_OK ) ;
					}
					else
					{
						sprintf( msg, "%s ̓ǂݍ݂Ɏs܂.", path ) ;
						MessageBox( hDlg, msg, "mF", MB_OK ) ;
					}
					return	TRUE ;
				}

				case	IDC_BUTTON3:	// Q
				{
					BOOL result;
					memset( &ofn, 0, sizeof( OPENFILENAME ) ) ;
					ofn.lStructSize = sizeof( OPENFILENAME ) ;
					ofn.hwndOwner = hDlg;
					ofn.lpstrFilter = TEXT("MZT files\0*.mzt\0") ;
					ofn.lpstrCustomFilter = strCustom;
					ofn.nMaxCustFilter = 256;
					ofn.nFilterIndex = 0;
					ofn.lpstrFile = strFile;
					ofn.nMaxFile = MAX_PATH;
					ofn.Flags = OFN_FILEMUSTEXIST;
					ofn.lpstrFileTitle = "";
					ofn.nMaxFileTitle = 0;
					result = GetOpenFileName( &ofn ) ;
					if ( result ) {
						MZTHEAD head;
						FILE *file;
						int i ;
						int zero = 0 ;
						char filename[ 17 ] ;
						strcpy( Filename, ofn.lpstrFile ) ;
						SetDlgItemText( hDlg, IDC_PATH, Filename ) ;
						// t@Cǂݍ
						file = fopen( Filename, "rb" ) ;
						if( NULL == file )
						{
							return TRUE;
						}
						fread( &head, 1, sizeof( head ), file ) ;
						MzFileType = head.Mode ;
						MzFileSize = head.Size ;
						if ( 0 == SaveType )
						{
							MzFileStartAddress = head.LoadAdr ;
							MzFileRunAddress = head.RunAdr ;
						}
						SetDlgItemInt( hDlg, IDC_TYPE, MzFileType, TRUE ) ;
						SetDlgItemInt( hDlg, IDC_ADDRESS, MzFileStartAddress, TRUE ) ;
						SetDlgItemInt( hDlg, IDC_RUN, MzFileRunAddress, TRUE ) ;
						SetDlgItemInt( hDlg, IDC_FILESIZE, MzFileSize, TRUE ) ;
						strncpy( filename, head.Filename, 17 ) ;
						for( i = 0; i < 17; i ++ )
						{
							if( 1 == zero )
							{
								filename[ i ] = '\0' ;
							}
							else
							{
								if( 0xD == filename[ i ] )
								{
									filename[ i ] = 0 ;
									zero = 1 ;
								}
							}
						}
						strncpy( MzFileName, filename, 17 ) ;
						SetDlgItemText( hDlg, IDC_FILENAME, MzFileName ) ;
						fclose( file ) ;
					}
					return	TRUE ;
				}

			}
			break ;

	}
	return	FALSE ;
}

/////////////////////////////////////////////////////////////////////
// I/O Function Interface
/////////////////////////////////////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	)
{
	UCHAR	data = 0 ;

	switch( port )
	{
	case	0x80:
		break ;
	}
	return	data ;
}

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	)
{
	switch( port )
	{
	case	0x80:
		break ;
	}

	return	0 ;
}

/////////////////////////////////////////////////////////////////////
// EmuZ-2000 Interface
/////////////////////////////////////////////////////////////////////
BOOL
WINAPI
IntializeBoard( 
	VOID
	)
{
	// |[gԍݒ
/*
	dwBase = emuz2000_readProfileDword( gId, "BaseAddress" ) ;
	switch( dwBase )
	{
	case	0x80:
		break ;
	default:
		dwBase = 0x80 ;
		break ;
	}
	// I/O |[gAhX擾
	emuz_1m03EBIH.ioMapper.ucStartPort = (UCHAR)dwBase ;
*/
	emuz2000_getMainMemoryPointer( gId ) ;
//	DEBUGOUT( "EmuZ-1M03 BasicManager start.\n" ) ;

	return	TRUE ;
}

BOOL
WINAPI
ReIntializeBoard( 
	VOID
	)
{
	return	TRUE ;
}


VOID
WINAPI
FinalizeBoard( 
	VOID 
	)
{
/*
	emuz2000_writeProfileDword( gId, "BaseAddress", dwBase ) ;
*/
	return ;
}

VOID
WINAPI
ReportCpuClock( 
	int clk
	)
{
	return ;
}

VOID
WINAPI
InfomationDialog( 
	HWND	hWnd 
	)
{
	DialogBox( h_instdll, MAKEINTATOM(IDD_DIALOG_BASEADDRESS), 
		hWnd, InfomationDlgProc) ;

	return ;
}

BOOL
WINAPI
BoardInfomationService( 
	PEMUZ2000EBIH *info,
	DWORD id
	)
{

	*info = &emuz_1m03EBIH ;
	gId = id ;
	return	TRUE ;
}

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx( int *ver, DWORD *size, PUCHAR *buf )
{
	*size = 0;
	*buf = NULL;
	*ver = 1;				/* Data Format Ver.1 */
	return TRUE;
}

BOOL WINAPI StateSaveInputDataEx( int ver, DWORD size, PUCHAR buf )
{
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveOutputData( 
	DWORD *size,
	PUCHAR buf
	)
{
	*size = 0 ;
	buf = NULL ;
	return	TRUE ;
}

BOOL
WINAPI
StateSaveInputData( 
	DWORD size,
	PUCHAR buf
	)
{
	return	TRUE ;
}
#endif

/////////////////////////////////////////////////////////////////////
// Save BASIC program
/////////////////////////////////////////////////////////////////////
int SaveBasic( char *path, char *buffer, int address )
{
	char *analyze ;
	MZTHEAD head ;
	char data[ 65536 ] ;
	unsigned short next_address ;
	unsigned short line_size ;
	char *basic_data ;
	FILE *file ;
	int i ;
	int data_size = 0 ;
	// 
	memset( &head, 0, sizeof( head ) ) ;
	memset( &data, 0, sizeof( data ) ) ;
	memset( head.Filename, 0x0D, sizeof( head.Filename ) ) ;
	// wb_쐬
	head.Mode = MzFileType ;
	strncpy( head.Filename, MzFileName, 17 ) ;
	for( i = 0; i < 17; i ++ )
	{
		if ( '\0' == head.Filename[ i ] )
		{
			head.Filename[ i ] = 0xD ;
		}
	}
	head.Size = MzFileSize ;
	head.LoadAdr = MzFileStartAddress ;
	head.RunAdr = MzFileRunAddress ;
	// f[^쐬
	basic_data = data ;
	analyze = &buffer[ address ] ;
	while( 1 )
	{
		next_address = *(unsigned short *)analyze;
		if ( 0 == next_address )
		{
			*(unsigned short *)basic_data = 0;
			data_size += 2;
			break;
		}
		line_size = 0 ;
		while( analyze[ 4 + line_size ] != 0x0D )
		{
			line_size ++;
		}
		line_size += 3;
		*(unsigned short *)basic_data = line_size + 2;
		basic_data += 2;
		memcpy( basic_data, &analyze[ 2 ], line_size ) ;
		analyze = &buffer[ next_address ];
		basic_data += line_size;
		data_size += ( line_size + 2 ) ;
	}
	head.Size = data_size;
	if ( 0 == data_size )
	{
		return 1 ;
	}
	// t@C쐬
	file = fopen( path, "wb" ) ;
	if( NULL == file )
	{
		return 1 ;
	}
	fwrite( &head, 1, sizeof( head ), file ) ;
	fwrite( data, 1, data_size, file ) ;
	fclose( file ) ;
	return 0 ;
}

/////////////////////////////////////////////////////////////////////
// Load BASIC program
/////////////////////////////////////////////////////////////////////
int LoadBasic( char *path, char *buffer, int address, int type )
{
	MZTHEAD head ;
	FILE *file ;
	unsigned char data[ 65536 ] ;
	char *data_buffer ;
	int source_address ;
	int dest_address ;
	int ret_code = 0 ;
	// --> BASIC MZ-1Z001 bΉieXgŁjby Suga 2004y 02m 07d
	int loop_cnt01 ;
	unsigned short pointer_address ;
	int pointer_length ;
	unsigned char pointer_data[ 128 ] ;
	int destination ;
	int comp_work01 ;
	// <-- BASIC MZ-1Z001 bΉieXgŁjby Suga 2004y 02m 07d
	data_buffer = data ;
	// t@Cǂݍ
	file = fopen( path, "rb" ) ;
	if( NULL == file )
	{
		return 1;
	}
	fread( &head, 1, sizeof( head ), file ) ;
	fread( &data, 1, head.Size, file ) ;
	fclose( file ) ;
	if( 0 == type )
	{
		// ǂݍރt@C BASIC ł͖
		LoadBinary( path, buffer, address, MzFileSize ) ;
		return 1;
	}
	else if( type < ENVDATA_MAX )
	{
		// --> BASIC MZ-1Z001 bΉieXgŁjby Suga 2004y 02m 07d
		// $524E n܂X^bN|C^iHjւ
		// $524E : \[X̏IAhX
		// $5250`$5296($5294) 36̕ϐ̈X^bN|C^iHj
		// \[X̏IAhX{QԒnQԒnɐݒ
		// ȏe BASIC ɑΉ 
		pointer_length = 0 ;
		pointer_address = (unsigned short)address + head.Size;
		for( loop_cnt01 = 0 ; loop_cnt01 < 37 ; loop_cnt01++ )
		{
			pointer_data[ pointer_length++ ] = (char)( pointer_address & 0x00ff );
			pointer_data[ pointer_length++ ] = (char)( pointer_address >> 8 );
			pointer_address += 2;
		}
		//
		// BASIC\[X̎̍sւ̑΃AhX΃AhXɒu
		destination	= address ; // 21596 ; // $545C
		dest_address = destination ;
		source_address = 0;
		while( 1 )
		{
			// G[
			if( source_address > 65535 )
			{
				ret_code = 1;
				break;
			}
			// BASIC\[X̏I
			if( ( data[ source_address ] == 0 ) && ( data[ source_address + 1 ] == 0 ) )
			{
				// EmuZ2000 ̃CBASIC\[X]
				memcpy( &buffer[ destination ], data, ( head.Size + 72 ) ) ;
				// EmuZ2000 ̃Cփ|C^[iHjf[^]
				memcpy( &buffer[ EnvDataList[ SaveType ].PointerList ], pointer_data, pointer_length ) ;
				// ϐX^bN|C^[iHjNA
				memset( &buffer[ dest_address ] , 0 , 72 ) ;
				break;
			}
			// s̑΃AhXo
			comp_work01 = (int)( data[ source_address ] )  +
							(int)( data[ source_address + 1 ] ) * 256 ;
			// s̐΃AhXvZAւ
			dest_address += comp_work01 ;
			data[ source_address ] = (char)( dest_address & 0x00ff ) ;
			data[ source_address + 1 ] = (char)( dest_address / 256 ) ;
			// sidata̎sjAhXvZ
			source_address += comp_work01 ;
		}
		// <-- BASIC MZ-1Z001 bΉieXgŁjby Suga 2004y 02m 07d
	}
	else // s
	{
		MessageBox( NULL, "̃t@C̓ǂݍݖΉł.", "x", MB_OK );
		return 1;
	}

	return ret_code;
}

/////////////////////////////////////////////////////////////////////
// Load BINARY program
/////////////////////////////////////////////////////////////////////
int LoadBinary( char *path, char *buffer, int address, int size )
{
	MZTHEAD head;
	FILE *file;
	// t@Cǂݍ
	file = fopen( path, "rb" ) ;
	if( NULL == file )
	{
		return 1;
	}
	fread( &head, 1, sizeof( head ), file ) ;
	fread( &buffer[ address ], 1, head.Size, file ) ;
	fclose( file ) ;
	return 0;
}

/////////////////////////////////////////////////////////////////////
// Save BINARY program
/////////////////////////////////////////////////////////////////////
int SaveBinary( char *path, char *buffer, int address, int size )
{
	MZTHEAD head;
	FILE *file;
	int i;
	// wb_쐬
	memset( &head, 0, sizeof( head ) ) ;
	// wb_쐬
	head.Mode = MzFileType;
	strncpy( head.Filename, MzFileName, 17 ) ;
	for( i = 0; i < 17; i ++ )
	{
		if ( '\0' == head.Filename[ i ] )
		{
			head.Filename[ i ] = 0xD;
		}
	}
	if ( MzFileSize > 65535 )
	{
		head.Size = 0;
	}
	else
	{
		head.Size = (unsigned short)MzFileSize;
	}
	head.LoadAdr = MzFileStartAddress;
	head.RunAdr = MzFileRunAddress;
	// t@C쐬
	file = fopen( path, "wb" ) ;
	if( NULL == file )
	{
		return 1;
	}
	fwrite( &head, 1, sizeof( head ), file ) ;
	fwrite( &buffer[ address ], 1, size, file ) ;
	fclose( file ) ;
	return 0;
}
