/******************************************************************************
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*                        EmuZ-2000  Extend Board DLL
*                               << MZ-1E08 >>
*                          Main Module [MZ1E08.C]
*               12 Mar. 2003  version 0.01  - Create
*               20 Mar. 2003  version 0.03  - Bmp font support
*               10 Apl. 2010  version 0.10  - EmuZ-2000 TF-Edition Font Rom support
*                1 Mar. 2013  version 0.11  - Rename Rom FileName, Change Windows Font
*                6 Mar. 2013  version 0.12  - Add Windows Font Pattern File
*                        Programmed by S.Tsuneoka
******************************************************************************/
#include <windows.h>
#include <stdio.h>
#include "mz1e08.h"
#include "resource.h"
#include "..\interface\emuz2000ioBoard.h"
#include "..\interface\plugin_ex.h"

/*-----------------------------------------------------------------------------
	Board Infomation
-----------------------------------------------------------------------------*/

	EMUZ2000EBIH _Mz1e08EBIH = {
		"1E76BABA-8547-49B6-9FA9-870619E0900F",
		"MZ-1E08 by SHARP",
		"Printer I/F Board for TF-Edition",
		"Copyright 2003-2010 by S.Tsuneoka",
		"http://www7a.biglobe.ne.jp/~tsuneoka/",
		"tsuneoka@kxa.biglobe.ne.jp",
		0x00000000,
		InportFunction,
		OutportFunction,
		BASEIOPORT,
		USINGPORTS,
		USE_INFODIALOG
	};

/*-----------------------------------------------------------------------------
	Static Data
-----------------------------------------------------------------------------*/
	static HINSTANCE	_hInst    = NULL;			/* CX^X */
	static DWORD		_dwId     = 0;				/* ݒ񎯕ʎq */
	static FILE 		*_fpDebug = NULL;			/* fobOOp */
	static char			_szCurrentDir[MAX_PATH];	/* JgfBNg */
	/* I/F */
	static WORD 		_wControl = 0;				/* |[g */
	static WORD 		_wData    = 0;				/* f[^|[g */
	static BOOL 		_fIsError = FALSE;			/* G[tO */
	/* ݒ */
	static DWORD		_dwMode = PRINTMODE_COOKED | PRINTMODE_BMPFONT
								| PRINTMODE_RASTERVIEW;	/* o̓[h */
	static char 		_szDevice[MAX_PATH] = {'\0'};	/* foCX */
	static char 		_szFile[MAX_PATH]   = {'\0'};	/* o̓t@C */

/*-----------------------------------------------------------------------------
	DLL̏
-----------------------------------------------------------------------------*/
BOOL APIENTRY DllMain(HANDLE hInstance, DWORD dwReasonBeingCalled, LPVOID lpReserved)
{
	UNREFERENCED_PARAMETER(lpReserved);
	switch(dwReasonBeingCalled){
		case DLL_PROCESS_ATTACH:
			_hInst = hInstance;
			break;
		case DLL_PROCESS_DETACH:
			_hInst = NULL;
			break;
	}
	return TRUE;
}

/*-----------------------------------------------------------------------------
	JgfBNg擾
-----------------------------------------------------------------------------*/
LPCSTR GetEmuZDirectory(VOID)
{
	DbgPrintf("EmuZDir = %s", _szCurrentDir);
	return _szCurrentDir;
}

/*-----------------------------------------------------------------------------
	fobOOo
-----------------------------------------------------------------------------*/
VOID DbgPrintf(LPCSTR lpszFmt, ...)
{
	LPSTR		*lppParam;
	SYSTEMTIME	st;
	char		szBuff[BUFFSIZE];

	if(_fpDebug == NULL){
		return;
	}

	lppParam = ((LPSTR*)&lpszFmt) + 1;
	wvsprintfA(szBuff, lpszFmt, (LPSTR)lppParam);

	GetLocalTime(&st);
	fprintf(_fpDebug, "%04d/%02d/%02d %02d:%02d:%02d ",
			st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond);
	fputs(szBuff, _fpDebug);
	fputc('\n', _fpDebug);
	fflush(_fpDebug);
}

/*-----------------------------------------------------------------------------
	InPort
-----------------------------------------------------------------------------*/
BYTE InportFunction(WORD wPort)
{
	WORD wData = 0x00;

	if(_fIsError){
		ReIntializeBoard();
		return 0xff;
	}

	switch(wPort){
		case CONTROLPORT:
			switch(_wControl){
				case 0x00:
					wData = 0x02;
					break;
				case 0x80:
					wData = 0x01;
					break;
				default:
					wData = _wControl;
					break;
			}
			break;
		case DATAPORT:
			wData = _wData;
			break;
	}

	DbgPrintf("IN  $%02X, $%02X", wPort, wData);
	return (BYTE)wData;
}

/*-----------------------------------------------------------------------------
	OutPort
-----------------------------------------------------------------------------*/
int OutportFunction(WORD wPort, BYTE bData)
{
	LRESULT lResult = ERROR_SUCCESS;

	DbgPrintf("OUT $%02X, $%02X", wPort, bData);
	_fIsError = FALSE;

	switch(wPort){
		case CONTROLPORT:
			_wControl = (WORD)bData;
			switch(_wControl){
				case 0x00:
					break;
				case 0x80:
					lResult = InitiarizeSpooler(_dwMode, _szDevice, _szFile);
					if(lResult != ERROR_SUCCESS){
						break;
					}
					lResult = PrintSpooler(_wData);
					break;
				case 0xff:	/* EmuZ-2000ŗL */
					ReIntializeBoard();
					break;
				default:
					break;
			}
			break;
		case DATAPORT:
			_wData = (WORD)bData;
			break;
	}

	if(lResult != ERROR_SUCCESS){
		_fIsError = TRUE;
		DbgPrintf("Print Failed code = %d", lResult);
	}

	return 0;
}

/*-----------------------------------------------------------------------------
	{[h
-----------------------------------------------------------------------------*/
BOOL APIENTRY IntializeBoard(VOID)
{
	DWORD	dwMode = 0;
	/* fobOOo(Read̂) */
	if(emuz2000_readProfileDword(_dwId, "Debug") != 0L){
		_fpDebug = fopen(DEBUGLOGFILENAME, "a");
	}
	DbgPrintf("IntializeBoard");

	/* [h */
	dwMode = emuz2000_readProfileDword(_dwId, "Mode");
	DbgPrintf("Mode = %d", _dwMode);
	if(dwMode > 0){
		_dwMode = dwMode;
	}

	/* v^ */
	emuz2000_readProgileString(_dwId,"Device", _szDevice, sizeof(_szDevice));
	if(*_szDevice == '\0'){
		GetDefaultPrintDevice(_szDevice, sizeof(_szDevice));
	}
	DbgPrintf("Device = %s", _szDevice);

	/* o̓t@C(Read̂) */
	emuz2000_readProgileString(_dwId, "File", _szFile, sizeof(_szFile));
	DbgPrintf("File = %s", _szFile);

	/* JgfBNgۑ */
	GetCurrentDirectory(MAX_PATH, _szCurrentDir);

	if(ReadPatternFile(PATTERNFILENAME) == FALSE){
		return  FALSE;
	}

	return TRUE;
}

/*-----------------------------------------------------------------------------
	{[hď
-----------------------------------------------------------------------------*/
BOOL APIENTRY ReIntializeBoard(VOID)
{
	DbgPrintf("ReIntializeBoard");

	TerminateSpooler();
	_wData    = 0x00;
	_wControl = 0x00;
	_fIsError = FALSE;

	return TRUE;
}

/*-----------------------------------------------------------------------------
	{[hpI
-----------------------------------------------------------------------------*/
VOID APIENTRY FinalizeBoard(VOID)
{
	DbgPrintf("FinalizeBoard");

	TerminateSpooler();

	/* ݒۑ */
	emuz2000_writeProfileDword(_dwId, "Mode", _dwMode);
	emuz2000_writeProgileString(_dwId, "Device", _szDevice);

	if(_fpDebug != NULL){
		fclose(_fpDebug);
		_fpDebug = NULL;
	}
}

/*-----------------------------------------------------------------------------
	{[hʒm
-----------------------------------------------------------------------------*/
BOOL APIENTRY BoardInfomationService(PEMUZ2000EBIH *info, DWORD dwId)
{
	*info = &_Mz1e08EBIH;
	_dwId = dwId;
	return TRUE;
}

/*-----------------------------------------------------------------------------
	CPUNbN擾
-----------------------------------------------------------------------------*/
VOID APIENTRY ReportCpuClock(int iClock)
{
}

/*-----------------------------------------------------------------------------
	Xe[gZ[uo̓f[^ݒ
-----------------------------------------------------------------------------*/
#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx( int *ver, LPDWORD lpdwSize, LPBYTE *lpbBuff )
{
	*lpdwSize = 0;
	*lpbBuff = NULL;
	return TRUE;
}
#else
BOOL APIENTRY StateSaveOutputData(LPDWORD lpdwSize, LPBYTE lpbBuff)
{
	lpdwSize = 0;
	lpbBuff  = NULL;
	return TRUE;
}
#endif

/*-----------------------------------------------------------------------------
	Xe[gZ[u̓f[^ݒ
-----------------------------------------------------------------------------*/
#ifdef EMUZ2000EX
BOOL WINAPI StateSaveInputDataEx( int ver, DWORD dwSize, PBYTE lpbBuff )
{
	return TRUE;
}
#else
BOOL APIENTRY StateSaveInputData(DWORD dwSize, PBYTE lpbBuff)
{
	return TRUE;
}
#endif

/*----------------------------------------------------------------------------
	ݒ_CAOWM_INITDIALOG̏
----------------------------------------------------------------------------*/
BOOL InfomationDlgInitDialog(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	char	szBuff[1024];
	LPSTR	lpszKey;
	int		iCt    = 0;
	int		iIndex = 0;

	switch(_dwMode & PRINTMODE_COOKED){
		case PRINTMODE_ROW:
			SendDlgItemMessage(hWnd, IDC_ROW, BM_SETCHECK, TRUE, 0L);
			break;
		case PRINTMODE_COOKED:
			SendDlgItemMessage(hWnd, IDC_COOKED, BM_SETCHECK, TRUE, 0L);
			break;
	}
	if(_dwMode & PRINTMODE_WINDOWSFONT){
		SendDlgItemMessage(hWnd, IDC_WINDOWSFONT, BM_SETCHECK, TRUE, 0L);
	}
	else if(_dwMode & PRINTMODE_BMPFONT){
		SendDlgItemMessage(hWnd, IDC_BMPFONT, BM_SETCHECK, TRUE, 0L);
	}
	else if(_dwMode & PRINTMODE_FONTROM_JP){
		SendDlgItemMessage(hWnd, IDC_ROMFONT_JP, BM_SETCHECK, TRUE, 0L);
	}
	else{
		SendDlgItemMessage(hWnd, IDC_ROMFONT_EN, BM_SETCHECK, TRUE, 0L);
	}
	if(_dwMode & PRINTMODE_RASTERVIEW){
		SendDlgItemMessage(hWnd, IDC_RASTERCHECK, BM_SETCHECK, TRUE, 0L);
	}

	GetPrintDeviceList(szBuff, sizeof(szBuff));
	for(lpszKey = szBuff; *lpszKey != '\0'; lpszKey += (lstrlen(lpszKey) + 1)){
		SendDlgItemMessage(hWnd, IDC_PRINTERLIST,
				CB_ADDSTRING, 0, (LONG)((LPSTR)lpszKey));
		if(lstrcmp(lpszKey, _szDevice) == 0){
			iIndex = iCt;
			DbgPrintf("CurrentPrinter= %d %s", iIndex, lpszKey);
		}
		iCt++;
	}
	SendDlgItemMessage(hWnd, IDC_PRINTERLIST, CB_SETCURSEL, iIndex, 0L);

	return TRUE;
}

/*----------------------------------------------------------------------------
	ݒ_CAOWM_COMMAND̏
----------------------------------------------------------------------------*/
BOOL InfomationDlgCommand(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	int 	iIndex;
	DWORD	dwMode = 0L;

	switch(wParam){
		case IDOK:
			if(SendDlgItemMessage(hWnd, IDC_ROW, BM_GETCHECK, 0L, 0L) == TRUE){
				dwMode = PRINTMODE_ROW;
			}
			else{
				dwMode = PRINTMODE_COOKED;
			}
			if(SendDlgItemMessage(hWnd, IDC_WINDOWSFONT ,BM_GETCHECK, 0L, 0L) == TRUE){
				dwMode |= PRINTMODE_WINDOWSFONT;
			}
			else if(SendDlgItemMessage(hWnd, IDC_BMPFONT ,BM_GETCHECK, 0L, 0L) == TRUE){
				dwMode |= PRINTMODE_BMPFONT;
			}
			else if(SendDlgItemMessage(hWnd, IDC_ROMFONT_JP ,BM_GETCHECK, 0L, 0L) == TRUE){
				dwMode |= PRINTMODE_FONTROM_JP;
			}
			else if(SendDlgItemMessage(hWnd, IDC_ROMFONT_EN ,BM_GETCHECK, 0L, 0L) == TRUE){
				dwMode |= PRINTMODE_FONTROM_EN;
			}
			if(SendDlgItemMessage(hWnd, IDC_RASTERCHECK ,BM_GETCHECK, 0L, 0L) == TRUE){
				dwMode |= PRINTMODE_RASTERVIEW;
			}
			_dwMode = dwMode;
			iIndex = SendDlgItemMessage(hWnd, IDC_PRINTERLIST, CB_GETCURSEL, 0, 0L);
			if(iIndex != CB_ERR){
				SendDlgItemMessage(hWnd, IDC_PRINTERLIST, CB_GETLBTEXT, (WPARAM)iIndex, (LPARAM)_szDevice);
			}
			EndDialog(hWnd, TRUE);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWnd, TRUE);
			return TRUE;
		case IDC_PRINT:
			if(IsInitiarizeSpooler() == TRUE){
				ReIntializeBoard();
				EndDialog(hWnd, TRUE);
			}
			else{
				MessageBox(hWnd, "Print is Already Ended.", "MZ-1E08", MB_ICONEXCLAMATION | MB_OK);
			}
			return TRUE;
		default:
			break;
	}
	return FALSE;
}

/*-----------------------------------------------------------------------------
	ݒ_CAO{bNXR[obN֐
-----------------------------------------------------------------------------*/
BOOL APIENTRY InfomationDlgProc(
HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg){
		MSGDISPATCH(WM_COMMAND,    InfomationDlgCommand);
		MSGDISPATCH(WM_INITDIALOG, InfomationDlgInitDialog);
	}
	return FALSE;
}

/*-----------------------------------------------------------------------------
	ݒ_CAO{bNX\
-----------------------------------------------------------------------------*/
VOID APIENTRY InfomationDialog(HWND hWnd)
{
	DialogBox(_hInst, MAKEINTATOM(IDD_INFODLG), hWnd, InfomationDlgProc);
}
