/******************************************************************************
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*                        EmuZ-2000  Extend Board DLL
*                               << MZ-1E08 >>
*                          PrintOut Module [SPOOL.C]
*               12 Mar. 2003  version 0.01  - Create
*               19 Mar. 2003  version 0.02  - bug fix Kana Print on TextOut
*               20 Mar. 2003  version 0.03  - Bmp font support
*               10 Apl. 2010  version 0.10  - EmuZ-2000 TF-Edition Font Rom support
*                1 Mar. 2013  version 0.11  - Rename Rom FileName, Change Windows Font
*                6 Mar. 2013  version 0.12  - Add Windows Font Pattern File
*                         Programmed by S.Tsuneoka
******************************************************************************/
#include <windows.h>
#include <stdio.h>
#include "mz1e08.h"

/*-----------------------------------------------------------------------------
	Static Data
-----------------------------------------------------------------------------*/
	static char			_szReadedAsciiCodeAnk[PATTERNBUFFSIZE];
	static char			_szPrintBuffer[PRINTBUFFSIZE];
	static DWORD		_dwDataCounter = 0L;
	static HANDLE		_hPrinter      = NULL;
	static HDC			_hDC           = NULL;
	static DWORD		_dwMode        = 0;
	static int 			_iX            = 0;
	static int 			_iY            = 0;

	static LPBITMAPINFO _lpBmpInfo     = NULL;
	static LPBYTE		_lpbFont       = NULL;

/*-----------------------------------------------------------------------------
	BITMAPINFO쐬
-----------------------------------------------------------------------------*/
LPBITMAPINFO CreateBitmapInfo(VOID)
{
	LPBITMAPINFO	lpBmpInfo = NULL;
	DWORD			dwSize = sizeof(BITMAPINFOHEADER) + (sizeof(RGBQUAD) * 2);

	if((lpBmpInfo = LocalAlloc(LPTR, dwSize)) == NULL){
		DbgPrintf("CreateBitmapInfo failed code=%d", GetLastError());
		return NULL;
	}

	/* BITMAPINFOHEADER */
	lpBmpInfo->bmiHeader.biSize         = sizeof(BITMAPINFOHEADER);
	lpBmpInfo->bmiHeader.biPlanes       = 1;
	lpBmpInfo->bmiHeader.biBitCount     = 1;
	lpBmpInfo->bmiHeader.biCompression  = BI_RGB;
	lpBmpInfo->bmiHeader.biSizeImage    = 0;
	lpBmpInfo->bmiHeader.biClrUsed      = 1;
	lpBmpInfo->bmiHeader.biClrImportant = 0;
	lpBmpInfo->bmiHeader.biWidth        = 8;
	lpBmpInfo->bmiHeader.biHeight       = 16;
	/* RGBQUAD */
	/* wipbg */
	lpBmpInfo->bmiColors[0].rgbBlue     = 0xff;
	lpBmpInfo->bmiColors[0].rgbGreen    = 0xff;
	lpBmpInfo->bmiColors[0].rgbRed      = 0xff;
	lpBmpInfo->bmiColors[0].rgbReserved = 0x00;
	/* pbg */
	lpBmpInfo->bmiColors[1].rgbBlue     = 0x00;
	lpBmpInfo->bmiColors[1].rgbGreen    = 0x00;
	lpBmpInfo->bmiColors[1].rgbRed      = 0x00;
	lpBmpInfo->bmiColors[1].rgbReserved = 0x00;

	return lpBmpInfo;
}

/*-----------------------------------------------------------------------------
	tHgǂݏo
-----------------------------------------------------------------------------*/
LPBYTE ReadFont(LPCSTR lpcszFontFile, BOOL isRom, BOOL isRaster)
{
	HANDLE	hFile    = NULL;
	LPBYTE	lpbFont  = NULL;
	LPBYTE	lpbBuff  = NULL;
	LPBYTE	lpbData  = NULL;
	DWORD	dwReaded   = 0;
	LRESULT lResult = ERROR_SUCCESS;

	if((lpbFont = LocalAlloc(LPTR, FONTBUFFSIZE)) == NULL){
		return NULL;
	}
	__try{
		if((lpbBuff = LocalAlloc(LPTR, FONTFILEBUFFSIZE)) == NULL){
			lResult = GetLastError();
			__leave;
		}
		hFile = CreateFile(lpcszFontFile,
			GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile == INVALID_HANDLE_VALUE){
			lResult = GetLastError();
			__leave;
		}
		ReadFile(hFile, lpbBuff, FONTFILEBUFFSIZE, &dwReaded, NULL);
		CloseHandle(hFile);

		DbgPrintf("FontFile Readed : %s", lpcszFontFile);

		if(isRom == TRUE){
			/* @̃tHgROM0x00`0xff̏ɔzu */
			DWORD	dwCode, dwCount;
			lpbData = lpbBuff;
			for(dwCode = 0; dwCode < 256; dwCode++){
				if(isRaster == TRUE){
					for(dwCount = 0; dwCount < 8; dwCount++){
						LPBYTE lpb = lpbFont + ((dwCode * 64) + ((7 - dwCount) * 8));
						*lpb = *lpbData++;
					}
				}
				else{
					for(dwCount = 0; dwCount < 16; dwCount++){
						LPBYTE lpb = lpbFont + ((dwCode * 64) + ((15 - dwCount) * 4));
						*lpb = *lpbData;
						if(dwCount % 2 != 0){
							lpbData++;
						}
					}
				}
			}
		}
		else{
			DWORD	dwX, dwY, dwCount;
			/* PƂDIBɕ0x00`0xff̏ɔzu */
			lpbData = lpbBuff + 62;	/* f[^Jnʒu */
			for(dwY = 0; dwY < 16; dwY++){
				for(dwCount = 0; dwCount < 16; dwCount++){
					for(dwX = 0; dwX < 16; dwX++){
						LPBYTE lpb = lpbFont + ((15 - dwY) + dwX * 16) * 64 + (dwCount * 4);
						*lpb = ~*lpbData++;
					}
				}
			}
		}
	}
	__finally{
		if(lpbBuff != NULL){
			LocalFree(lpbBuff);
		}
		if(lResult != ERROR_SUCCESS){
			DbgPrintf("ReadFont(%s) failed code=%d", lpcszFontFile, lResult);
			if(lpbFont != NULL){
				LocalFree(lpbFont);
				lpbFont = NULL;
			}
			SetLastError(lResult);
		}
	}
	return lpbFont;
}

/*-----------------------------------------------------------------------------
	ς݂H
-----------------------------------------------------------------------------*/
BOOL IsInitiarizeSpooler(VOID)
{
	if((_hPrinter == NULL) && (_hDC == NULL)){
		return FALSE;
	}
	return TRUE;
}

/*-----------------------------------------------------------------------------
	WindowstHg̕R[hp^[ǂݍ
-----------------------------------------------------------------------------*/
BOOL ReadPatternFile(LPCSTR lpcszFileName)
{
	LPCSTR lpcszDispCode = NULL;
	FILE *fp = NULL;

	DbgPrintf("Pattern File = %s", lpcszFileName);
	if((fp = fopen(lpcszFileName, "r")) != NULL){
		int iCount;
		char szBuff[PATTERNBUFFSIZE];

		*_szReadedAsciiCodeAnk = '\0';
		for(iCount = 0; iCount <= 16; iCount++){
			if(fgets(szBuff, PATTERNBUFFSIZE-3, fp) != NULL){
				*(szBuff + 32) = '\0';
				strcat(_szReadedAsciiCodeAnk, szBuff);
			}
		}
		fclose(fp);
		DbgPrintf("->%s", _szReadedAsciiCodeAnk);
		return TRUE;
	}

	return FALSE;
}

/*-----------------------------------------------------------------------------
	Xv[
-----------------------------------------------------------------------------*/
LRESULT InitiarizeSpooler(DWORD dwMode, LPSTR lpszDevice, LPSTR lpszFile)
{
	BOOL	isRaster = (dwMode & PRINTMODE_RASTERVIEW) ? TRUE : FALSE;
	LRESULT	lResult = ERROR_SUCCESS;

	if(IsInitiarizeSpooler() == TRUE){
		return ERROR_SUCCESS;
	}

	DbgPrintf("InitiarizeSpooler(%d, %s, %s)", dwMode, lpszDevice, lpszFile);

	if(!(dwMode & PRINTMODE_COOKED)){
		DOC_INFO_1 docinfo1;
		if(OpenPrinter(lpszDevice, &_hPrinter, NULL) != TRUE){
			return GetLastError();
		}
		docinfo1.pDocName    = DOCNAME;
		docinfo1.pOutputFile = NULL;
		if((lpszFile != NULL) && (lstrlen(lpszFile) > 0)){
			docinfo1.pOutputFile = lpszFile;
		}
		docinfo1.pDatatype   = NULL;
		if(StartDocPrinter(_hPrinter, 1, (LPBYTE)&docinfo1) == 0){
			return GetLastError();
		}
		StartPagePrinter(_hPrinter);
	}
	else if(dwMode & PRINTMODE_COOKED){
		DOCINFO docinfo;
		if(dwMode & PRINTMODE_BMPFONT){
			char szFontPath[MAX_PATH];
			wsprintf(szFontPath, "%s\\%s", GetEmuZDirectory(), FONTFILENAME);
			if((_lpBmpInfo = CreateBitmapInfo()) == NULL){
				return GetLastError();
			}
			if((_lpbFont = ReadFont(szFontPath, FALSE, isRaster)) == NULL){
				return GetLastError();
			}
		}
		else{
			char	szFontPath[MAX_PATH];
			LPCSTR	lpszFontFile = NULL;
			if(dwMode & PRINTMODE_FONTROM_JP){
				lpszFontFile = FONTROM_JP_FILENAME;
			}
			else{
				lpszFontFile = FONTROM_EN_FILENAME;
			}
			wsprintf(szFontPath, "%s\\%s", GetEmuZDirectory(), lpszFontFile);
			if((_lpBmpInfo = CreateBitmapInfo()) == NULL){
				return GetLastError();
			}
			if((_lpbFont = ReadFont(szFontPath, TRUE, isRaster)) == NULL){
				return GetLastError();
			}
		}
		if((_hDC = CreateDC("WINSPOOL", lpszDevice, NULL, NULL)) == NULL){
			return GetLastError();
		}

		docinfo.cbSize      = lstrlen(DOCNAME);
		docinfo.lpszDocName = DOCNAME;
		docinfo.lpszOutput  = NULL;
		if((lpszFile != NULL) && (lstrlen(lpszFile) > 0)){
			docinfo.lpszOutput = lpszFile;
		}
		if(StartDoc(_hDC, &docinfo) <= 0){
			return GetLastError();
		}
		StartPage(_hDC);
	}
	else{
		return  ERROR_INVALID_PARAMETER;
	}

	_dwMode = dwMode;
	_iX = 0;
	_iY = 0;
	_dwDataCounter = 0;

	return ERROR_SUCCESS;
}

/*-----------------------------------------------------------------------------
	
-----------------------------------------------------------------------------*/
LRESULT PrintChar(
HDC hDC, DWORD dwMode, int iX, int iY, LPSIZE lpMetric, BYTE bCode)
{
	LRESULT lResult = ERROR_SUCCESS;

	if(dwMode & (PRINTMODE_BMPFONT | PRINTMODE_FONTROM_JP | PRINTMODE_FONTROM_EN)){
		int iRet;
		GetTextExtentPoint32(_hDC, "A", 1, lpMetric);	/* Œ */
		iRet = StretchDIBits(hDC, iX, iY, lpMetric->cx, lpMetric->cy,
				0, 0, 8, 16, (_lpbFont + (bCode * 64)), _lpBmpInfo,
				DIB_RGB_COLORS, SRCCOPY);
		if(iRet == GDI_ERROR){
			lResult = GetLastError();
		}
	}
	else{
		LPCSTR lpcszDispCode = _szReadedAsciiCodeAnk + (bCode * 2);
		GetTextExtentPoint32(_hDC, lpcszDispCode, 2, lpMetric);
		if(TextOut(hDC, iX, iY, lpcszDispCode, 2) == FALSE){
			lResult = GetLastError();
		}
	}

	return lResult;
}

/*-----------------------------------------------------------------------------
	Xv[ɋo
-----------------------------------------------------------------------------*/
LRESULT FlushSpooler(VOID)
{
	DWORD	dwWritten = 0;
	DWORD	dwCt;
	LRESULT lResult  = ERROR_SUCCESS;

	DbgPrintf("FlushSpooler");

	if(_hPrinter != NULL){
		DWORD dwWritten = 0;
		if(!WritePrinter(_hPrinter,_szPrintBuffer,_dwDataCounter,&dwWritten)){
			lResult = GetLastError();
		}
	}
	else if(_hDC != NULL){
		SIZE metric;
		LPSTR lpszChar = _szPrintBuffer;
		for(dwCt = 0; dwCt < _dwDataCounter; dwCt++, lpszChar++){
			int iHeight = GetDeviceCaps(_hDC, VERTRES);	/* 󎚉\ */
			int iWidth  = GetDeviceCaps(_hDC, HORZRES);	/* 󎚉\ */
			GetTextExtentPoint32(_hDC, lpszChar, 1, &metric);
			if(*lpszChar == LF){	/* s */
				_iX = 0;
				_iY += metric.cy;
				if(_iY > (iHeight - metric.cy)){	/* Y󎚉\͈͊O */
					EndPage(_hDC);
					StartPage(_hDC);
					_iY = 0;
				}
				continue;
			}
			/* R[h͈󎚑ΏۂɂȂ */
			if(((BYTE)(*lpszChar) >= 0x01) && ((BYTE)(*lpszChar) <= 0x06)){
				if((BYTE)(*(lpszChar-1)) == ESC){
					continue;
				}
			}
			else if((BYTE)(*lpszChar) < 0x1e){
				continue;
			}
			PrintChar(_hDC, _dwMode, _iX, _iY, &metric, (BYTE)*lpszChar);
			_iX += metric.cx;
			if(_iX > (iWidth - metric.cx)){	/* X󎚉\͈͊O */
				_iX = 0;
				_iY += metric.cy;
				if(_iY > (iHeight - metric.cy)){	/* Y󎚉\͈͊O */
					EndPage(_hDC);
					StartPage(_hDC);
					_iY = 0;
				}
			}
		}
	}
	else{
		lResult = ERROR_INVALID_DATA;
	}

	_dwDataCounter = 0;
	return lResult;
}

/*-----------------------------------------------------------------------------
	vgobt@Ƀf[^ݒ肷
-----------------------------------------------------------------------------*/
LRESULT PrintSpooler(WORD wData)
{
	*(_szPrintBuffer+_dwDataCounter) = (BYTE)wData;
	_dwDataCounter++;

	if(_dwDataCounter >= sizeof(_szPrintBuffer)){
		return FlushSpooler();
	}
	return ERROR_SUCCESS;
}

/*-----------------------------------------------------------------------------
	I
-----------------------------------------------------------------------------*/
VOID TerminateSpooler(VOID)
{
	DbgPrintf("TerminateSpooler");

	FlushSpooler();

	if(_hPrinter != NULL){
		EndPagePrinter(_hPrinter);
		EndDocPrinter(_hPrinter);
		ClosePrinter(_hPrinter);
		_hPrinter = NULL;
	}
	else if(_hDC != NULL){
		EndPage(_hDC);
		EndDoc(_hDC);
		DeleteDC(_hDC);
		_hDC = NULL;
		if(_lpBmpInfo != NULL){
			LocalFree(_lpBmpInfo);
			_lpBmpInfo = NULL;
		}
		if(_lpbFont != NULL){
			LocalFree(_lpbFont);
			_lpbFont = NULL;
		}
	}
}

/*-----------------------------------------------------------------------------
	uʏgv^v𓾂
-----------------------------------------------------------------------------*/
LPSTR GetDefaultPrintDevice(LPSTR lpszDevice, DWORD dwSize)
{
	DWORD	dwNeeded   = 0;
	DWORD	dwReturned = 0;
	DWORD	dwFlags = PRINTER_ENUM_LOCAL | PRINTER_ENUM_CONNECTIONS;

	EnumPrinters(dwFlags, NULL, 2, NULL, 0, &dwNeeded, &dwReturned);
	if(dwNeeded <= 0){
		*lpszDevice = '\0';
		return NULL;
	}

	GetProfileString("windows", "device", ",,,", lpszDevice, dwSize - 1);
	strtok(lpszDevice, ",");

	return lpszDevice;
}

/*-----------------------------------------------------------------------------
	p\ȃv^̈ꗗ𓾂
-----------------------------------------------------------------------------*/
LPSTR GetPrintDeviceList(LPSTR lpszDeviceList, DWORD dwSize)
{
	GetProfileString("devices", NULL, "", lpszDeviceList, dwSize);
	if(*lpszDeviceList == '\0'){
		return NULL;
	}

	return lpszDeviceList;
}
