/* File: PrinterFileDlg.c

	MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		( MZ-1E08 DLL - Printer Setting Dialog )

	Copyright (C) 2017 Toshio Fukui
	This file is part of the EmuZ-2000 plugins software.
	See copyright notice in the COPYING file.
*/

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "PrinterFileDlg.h"
#include "resource.h"

#define LNMAX	1024

static BOOL DlgCenterWindow( HWND hDlg, HWND hWndParent )
{
	RECT rect;
	int tx, ty, dx, dy, sx, sy;

	/* Get the target center position */
	if (!hWndParent)
		hWndParent = GetWindow( hDlg, GW_OWNER );
	if (!hWndParent)
		return FALSE;
	GetWindowRect( hWndParent, &rect );
	tx = (rect.left + rect.right) / 2;
	ty = (rect.top + rect.bottom) / 2;

	/* Move to center position */
	GetWindowRect( hDlg, &rect );
	dx = tx - (rect.left + rect.right) / 2;
	dy = ty - (rect.top + rect.bottom) / 2;
	rect.left   += dx;
	rect.right  += dx;
	rect.top    += dy;
	rect.bottom += dy;

	/* Move to inside of screen */
	sx = GetSystemMetrics( SM_CXSCREEN );
	sy = GetSystemMetrics( SM_CYSCREEN );
	if (rect.right >= sx) {
		int dd = sx - rect.right;
		rect.left  += dd;
		rect.right += dd;
	}
	if (rect.bottom >= sy) {
		int dd = sy - rect.bottom;
		rect.top    += dd;
		rect.bottom += dd;
	}
	if (rect.left < 0) {
		rect.right += -rect.left;
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.bottom += -rect.top;
		rect.top = 0;
	}

	/* Update the real window position */
	SetWindowPos( hDlg, NULL,
		rect.left, rect.top, 0, 0,
		SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	return TRUE;
}

static void DlgSetWindowState( HWND hDlg )
{
	/* END items */
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_END ), output_fp ? TRUE : FALSE );

	/* START items */
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_START ), !output_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_EDIT_FILE ), !output_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_FILE ), !output_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), !output_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_CHECK_ERASESHARPCODE ), !output_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_CHECK_CONVCRLF ), !output_fp ? TRUE : FALSE );
	return;
}

BOOL WINAPI DlgProcPrinterSettings( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch (msg) {
	case WM_INITDIALOG :
		/* set the window attributes */
		DlgCenterWindow( hDlg, NULL );

		/* set dialog items */
		SendDlgItemMessage( hDlg, IDC_EDIT_FILE, WM_SETTEXT, 0, (LPARAM)output_fn );
		SendMessage( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), BM_SETCHECK, enable_nocodeconv, 0 );
		SendMessage( GetDlgItem( hDlg, IDC_CHECK_ERASESHARPCODE ), BM_SETCHECK, enable_erasesharpcode, 0 );
		SendMessage( GetDlgItem( hDlg, IDC_CHECK_CONVCRLF ), BM_SETCHECK, enable_convcrlf, 0 );

		/* set dialog items - II */ 
		DlgSetWindowState( hDlg );
		return TRUE;
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
		case IDCLOSE :
			SendDlgItemMessage( hDlg, IDC_EDIT_FILE, WM_GETTEXT, MAX_PATH, (LPARAM)output_fn );
			output_fn[MAX_PATH - 1] = '\0';
			enable_nocodeconv = SendMessage( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_erasesharpcode = SendMessage( GetDlgItem( hDlg, IDC_CHECK_ERASESHARPCODE ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_convcrlf = SendMessage( GetDlgItem( hDlg, IDC_CHECK_CONVCRLF ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			EndDialog( hDlg, TRUE );
			return TRUE;
		case IDCANCEL :
			EndDialog( hDlg, FALSE );
			return TRUE;
		case IDC_BUTTON_FILE :
			SendDlgItemMessage( hDlg, IDC_EDIT_FILE, WM_GETTEXT, MAX_PATH, (LPARAM)output_fn );
			output_fn[MAX_PATH - 1] = '\0';
			{
				OPENFILENAME ofn;
				char *cp, szFileName[MAX_PATH] = "";
				char szFileTitle[MAX_PATH] = "";

				strncpy( szFileName, (char *)output_fn, MAX_PATH );
				szFileName[MAX_PATH - 1] = '\0';
				if (szFileName[strlen(szFileName) - 1] == '\\') {
					strncat( szFileName, "*.txt", MAX_PATH - strlen(szFileName) - 1 );
					szFileName[MAX_PATH - 1] = '\0';
				}
				memset( &ofn, 0, sizeof(OPENFILENAME) );
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hDlg;
				ofn.lpstrFilter = 
					"Generic Text (*.txt)\0*.txt\0"
					"All Files (*.*)\0*.*\0\0";
				ofn.lpstrFile = szFileName;
				ofn.lpstrFileTitle = szFileTitle;
				ofn.nMaxFile = MAX_PATH;
				ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
				cp = strrchr( szFileName, '.' );
				if (cp) {
					cp++;
					if (!stricmp( cp, "txt" )) {
						ofn.nFilterIndex = 1; 
						ofn.lpstrDefExt = "txt";
					} else {
						ofn.nFilterIndex = 2; 
						ofn.lpstrDefExt = "";
					}
				} else {
					ofn.nFilterIndex = 1; 
					ofn.lpstrDefExt = "txt";
				}
				ofn.lpstrTitle = "Select MZ State File";
				if (!GetSaveFileName(&ofn)) {
					/* cancel */
					return TRUE;
				}
				strncpy( (void *)output_fn, szFileName, MAX_PATH );
				output_fn[MAX_PATH - 1] = '\0';

				SendDlgItemMessage( hDlg, IDC_EDIT_FILE, WM_SETTEXT, 0, (LPARAM)output_fn );
				return TRUE;
			}
		case IDC_BUTTON_START :
			SendDlgItemMessage( hDlg, IDC_EDIT_FILE, WM_GETTEXT, MAX_PATH, (LPARAM)output_fn );
			output_fn[MAX_PATH - 1] = '\0';
			if (strlen( output_fn ) < 1 ) {
				MessageBox( hDlg, "Please input output file name.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
				return TRUE;
			}
			output_fp = fopen( output_fn, "wb" );
			if (!output_fp) {
				MessageBox( hDlg, "Can't create the file for write.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
				return TRUE;
			}
			enable_nocodeconv = SendMessage( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_erasesharpcode = SendMessage( GetDlgItem( hDlg, IDC_CHECK_ERASESHARPCODE ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_convcrlf = SendMessage( GetDlgItem( hDlg, IDC_CHECK_CONVCRLF ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			DlgSetWindowState( hDlg );
			return TRUE;
		case IDC_BUTTON_END :
			if (output_fp) {
				fclose( output_fp );
				output_fp = NULL;
			} else
				MessageBox( hDlg, "Print out file is closed already.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
			DlgSetWindowState( hDlg );
			return TRUE;
		default :
			break;
		}
		break;
	}
	return FALSE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
