/******************************************************************************
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*                        EmuZ-2000  Extend Board DLL
*                               << MZ-1E18 >>
*                          Main Module [MZ1E18.C]
*               10 Apl. 2010  version 0.01  - Create
*               26 Feb. 2013  version 0.02  - Play Sound
*                        Programmed by S.Tsuneoka
******************************************************************************/
#include <windows.h>
#include <stdio.h>
#include "mz1e18.h"
#include "resource.h"
#include "..\interface\emuz2000ioBoard.h"
#include "..\interface\plugin_ex.h"

/*-----------------------------------------------------------------------------
	Board Infomation
-----------------------------------------------------------------------------*/

	EMUZ2000EBIH _Mz1e18EBIH = {
		"ADD40C64-535F-49a3-9DA8-4BFE5F640449",
		"MZ-1E18 by SHARP",
		"Quick Disk I/F Board",
		"Copyright 2010 by S.Tsuneoka",
		"http://www7a.biglobe.ne.jp/~tsuneoka/",
		"tsuneoka@kxa.biglobe.ne.jp",
		0x00000000,
		InportQDFunction,
		OutportQDFunction,
		QDIF_BASEIOPORT,
		QDIF_USINGPORTS,
		USE_INFODIALOG
	};

	/* QD IPL-Rom Ports */
	MAPIOSTRUCT _extendIo = {
		InportIplRomFunction,
		OutportIplRomFunction,
		IPL_BASEIOPORT,
		IPL_USINGPORTS
	};

/*-----------------------------------------------------------------------------
	Static Data
-----------------------------------------------------------------------------*/
	static HINSTANCE	_hInst    = NULL;					/* CX^X */
	static DWORD		_dwId     = 0;						/* ݒ񎯕ʎq */
	static FILE 		*_fpDebug = NULL;					/* fobOOp */
	static DWORD		_dwSound  = DEFAULT_ENABLESOUND;	/* ĐtO */

	static USHORT		_usAddress = 0;
	static BYTE			_bRomImage[ROMBUFFSIZE];

	static char			_qdFileName[MAX_PATH];

	static IOSTATEMENTS	_statements[MAX_STATEMENTS];
	static DWORD		_dwStatements = 0;
	static IOSTATEMENTS	_inData;

	static MZTAPE		_tapeImage;
	static MZQD			_qdImage;
	static LPBYTE		_pImage = NULL;
	static LPBYTE		_pBlockList[2048];
	static int			_iBlockId = 0;
	static int			_iReaded = 0;

	static BOOL			_isLoadRom = FALSE;
	static BOOL			_isLoadQd  = FALSE;

	static BOOL			_QDRDY  = FALSE;
	static BOOL			_MTON   = FALSE;
	static BOOL			_NRCH   = FALSE;

/*-----------------------------------------------------------------------------
	DLL̏
-----------------------------------------------------------------------------*/
BOOL APIENTRY DllMain(HANDLE hInstance, DWORD dwReasonBeingCalled, LPVOID lpReserved)
{
	UNREFERENCED_PARAMETER(lpReserved);
	switch(dwReasonBeingCalled){
		case DLL_PROCESS_ATTACH:
			_hInst = hInstance;
			break;
		case DLL_PROCESS_DETACH:
			_hInst = NULL;
			break;
	}
	return TRUE;
}

/*-----------------------------------------------------------------------------
	fobOOo
-----------------------------------------------------------------------------*/
VOID DbgPrintf(LPCSTR lpszFmt, ...)
{
	LPSTR		*lppParam;
	SYSTEMTIME	st;
	char		szBuff[BUFFSIZE];

	if(_fpDebug == NULL){
		return;
	}

	lppParam = ((LPSTR*)&lpszFmt) + 1;
	wvsprintfA(szBuff, lpszFmt, (LPSTR)lppParam);

	GetLocalTime(&st);
	fprintf(_fpDebug, "%04d/%02d/%02d %02d:%02d:%02d ",
			st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond);
	fputs(szBuff, _fpDebug);
	fputc('\n', _fpDebug);
	fflush(_fpDebug);
}

/*-----------------------------------------------------------------------------
	t@Cǂݍ
-----------------------------------------------------------------------------*/
DWORD ReadImageFile(LPSTR pFileName, LPVOID *pBuff, DWORD dwSize)
{
	HANDLE	hFile = NULL;
	DWORD	dwReaded = 0L;

	hFile = CreateFile(pFileName, GENERIC_READ,FILE_SHARE_READ,
		NULL,OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile == INVALID_HANDLE_VALUE){
		return 0;
	}
	ReadFile(hFile, pBuff, dwSize, &dwReaded, NULL);
	CloseHandle(hFile);

	return dwReaded;
}

/*-----------------------------------------------------------------------------
	IPL-ROM ǂݍ
-----------------------------------------------------------------------------*/
BOOL LoadRomImage(LPSTR lpszFileName)
{
	ZeroMemory(&_bRomImage, sizeof(_bRomImage));
	return (ReadImageFile(lpszFileName, (LPVOID)&_bRomImage, sizeof(_bRomImage)) > 0);
}

/*-----------------------------------------------------------------------------
	e[vQDɕϊ
-----------------------------------------------------------------------------*/
LPBYTE TapeToQd(PMZQD pQd, PMZTAPE pTape, LPBYTE list[])
{
	/*InformationBlock*/
	pQd->header.bBlockFlag    = 0x00;
	pQd->header.wBlockSize    = sizeof(MZQDHEADER) - MZQDBLOCKHEADERLEN;
	pQd->header.bAttr         = pTape->header.bAttr;
	CopyMemory(pQd->header.szFileName, pTape->header.szFileName, MZFILENAMELEN);
	pQd->header.wSize         = pTape->header.wSize;
	pQd->header.wStartAddress = pTape->header.wStartAddress;
	pQd->header.wJumpAddress  = pTape->header.wJumpAddress;

	/*DataBlock*/
	if((pTape->header.bAttr == 0x01) || (pTape->header.bAttr == 0x02)){
		pQd->body.bBlockFlag = 0x05;
	}
	else{
		pQd->body.bBlockFlag = 0x07;	/*or 0x03*/
	}
	pQd->body.wBlockSize = pQd->header.wSize;
	CopyMemory(pQd->body.bBody, pTape->body.bBody, pQd->header.wSize);

	DbgPrintf("File=%s (Size=%04x,StartAdr=%04x,JumpAdr=%04x)",
		pQd->header.szFileName,
		pQd->header.wSize, pQd->header.wStartAddress, pQd->header.wJumpAddress);

	/*SetBlockList*/
	*list       = (LPBYTE)&(pQd->header);
	*(list + 1) = (LPBYTE)&(pQd->body);
	*(list + 2) = NULL;

	return ((LPBYTE)&(pQd->body.bBody)) + pQd->body.wBlockSize + 3;
}

/*-----------------------------------------------------------------------------
	QDhCȗ쉹Đ܂B
-----------------------------------------------------------------------------*/
BOOL PlayQddSound(LPCSTR lpcszSoundFile)
{
	DWORD dwFlags = SND_FILENAME | SND_ASYNC | SND_NOSTOP | SND_NODEFAULT;

	if(_dwSound == 0){
		return FALSE;
	}
	return PlaySound(lpcszSoundFile, NULL, dwFlags);
}

/*-----------------------------------------------------------------------------
	QDt@CC[Wǂݍ
-----------------------------------------------------------------------------*/
BOOL LoadQdImage(LPSTR lpszFileName)
{
	DWORD dwFileSize     = 0L;
	LPBYTE lpbTape       = (LPBYTE)&_tapeImage;
	LPBYTE lpbTapeBottom = lpbTape;
	LPBYTE lpbQd         = (LPBYTE)&_qdImage;
	LPBYTE lpbQdBottom   = lpbQd + sizeof(MZQD) - 1;
	LPBYTE *lplpList     = (LPBYTE*)&_pBlockList;

	ZeroMemory(lpbTape, sizeof(_tapeImage));
	ZeroMemory(lpbQd, sizeof(_qdImage));
	ZeroMemory(lplpList, sizeof(_pBlockList));

	_isLoadQd = FALSE;
	((PMZQD)lpbQd)->bMediaCheckFlag = 0x08;
	*lplpList = lpbQd;
	lplpList++;

	if((dwFileSize = ReadImageFile(lpszFileName, (LPVOID)lpbTape, sizeof(MZTAPE))) == 0){
		return _isLoadQd;
	}
	if(dwFileSize > DISKBUFFSIZE){
		return _isLoadQd;
	}

	_isLoadQd = TRUE;
	lpbTapeBottom = lpbTape + dwFileSize - 1;
	while(lpbQd < lpbQdBottom){
		lpbQd = TapeToQd((PMZQD)lpbQd, (PMZTAPE)lpbTape, lplpList);
		lpbTape += (sizeof(MZTAPEHEADER) + ((PMZTAPEHEADER)lpbTape)->wSize);
		if(lpbTape > lpbTapeBottom){
			break;
		}
		lplpList += 2;
	}

	return _isLoadQd;
}

/*-----------------------------------------------------------------------------
	SIOXe[ggNA
-----------------------------------------------------------------------------*/
VOID ClearStatements()
{
	_dwStatements = 0;
	ZeroMemory(&_statements, sizeof(_statements));
}

/*-----------------------------------------------------------------------------
	SIOXe[ggݒ
-----------------------------------------------------------------------------*/
VOID SetStatements(WORD wPort, BYTE bData)
{
	if(_dwStatements > MAX_STATEMENTS)
	{
		ClearStatements();
		return;
	}
	_statements[_dwStatements].wPort = wPort;
	_statements[_dwStatements].bData = bData;
	_dwStatements++;
}

/*-----------------------------------------------------------------------------
	SIOXe[gg擾
-----------------------------------------------------------------------------*/
PIOSTATEMENTS GetStatements(DWORD num)
{
	return &_statements[num];
}

/*-----------------------------------------------------------------------------
	SIOXe[gg擾
-----------------------------------------------------------------------------*/
DWORD GetCurrentStatementNumber()
{
	return _dwStatements;
}

/*-----------------------------------------------------------------------------
	o̓|[gf[^ݒ
-----------------------------------------------------------------------------*/
VOID SetPortData(WORD wPort, BYTE bData)
{
	_inData.wPort = wPort;
	_inData.bData = bData;
}

/*-----------------------------------------------------------------------------
	o̓|[gf[^擾
-----------------------------------------------------------------------------*/
PIOSTATEMENTS GetPortData()
{
	return &_inData;
}

/*-----------------------------------------------------------------------------
	IPL Rom Inport
-----------------------------------------------------------------------------*/
BYTE InportIplRomFunction(WORD wPort)
{
	BYTE	bData = 0;

	switch(wPort){
		case PORT_ROM_H:
			_usAddress = 0;
			break;
		case PORT_ROM_L:
			bData = _bRomImage[_usAddress];
			_usAddress++;
			_usAddress &= 0x7fff;
			break;
	}
	return (BYTE)bData;
}

/*-----------------------------------------------------------------------------
	IPL Rom Outport
-----------------------------------------------------------------------------*/
int OutportIplRomFunction(WORD wPort, BYTE bData)
{
	switch(wPort){
		case PORT_ROM_H:
			_usAddress &= 0xff;
			_usAddress |= (USHORT)(bData << 8);
			_usAddress &= 0x7fff;
			break ;
		case PORT_ROM_L:
			_usAddress &= 0xff00;
			_usAddress |= (USHORT)bData;
			_usAddress &= 0x7fff;
			break ;
	}
	return 0;
}

/*-----------------------------------------------------------------------------
	QD I/F Inport
-----------------------------------------------------------------------------*/
BYTE InportQDFunction(WORD wPort)
{
	PIOSTATEMENTS pInData = GetPortData();
	BYTE	bData = 0;

	switch(wPort){
		case PORT_SIOAD:
			if(_iReaded == 0){
				bData = 0x08;
				_iReaded++;
				break;
			}
			bData = *_pImage++;
			DbgPrintf("  $%02X - %04X", bData, _iReaded++);
			break;
		default:
			if(pInData->wPort == wPort){
				bData = pInData->bData;
				if(_NRCH == TRUE){
					SetPortData(PORT_SIOAC, 0x01);
				}
			}
			break;
	}

	//DbgPrintf("IN $%02X -> $%02X", wPort, bData);
	return bData;
}

/*-----------------------------------------------------------------------------
	QD I/F Outport
-----------------------------------------------------------------------------*/
int OutportQDFunction(WORD wPort, BYTE bData)
{
	PIOSTATEMENTS ps0 = GetStatements(0);
	PIOSTATEMENTS ps1 = GetStatements(1);
	PIOSTATEMENTS ps2 = GetStatements(2);
	PIOSTATEMENTS ps3 = GetStatements(3);
	PIOSTATEMENTS ps4 = GetStatements(4);
	PIOSTATEMENTS ps5 = GetStatements(5);

	//DbgPrintf("OUT $%02X <- $%02X", wPort, bData);
	SetStatements(wPort, bData);

	switch(wPort){
		case PORT_SIOAC:
			switch(bData){
				case 0x01:
					ClearStatements();
					SetPortData(PORT_SIOAC, 0x08);
					break;
				case 0x10:
					if(_QDRDY == TRUE){
						/*WRITEPROTECT*/
						if(_isLoadQd == FALSE){
							SetPortData(PORT_SIOAC, 0x00);
						}
						else{
							SetPortData(PORT_SIOAC, 0x08 + WRITEPROTECT);
						}
						_QDRDY = FALSE;
						ClearStatements();
						_iBlockId = 0;
						_pImage = _pBlockList[_iBlockId];
						break;
					}
					if((ps0->wPort == PORT_SIOBC) && (ps0->bData == 0x05)
					 &&(ps1->wPort == PORT_SIOBC) && (ps1->bData == 0x82)
					 &&(ps2->wPort == PORT_SIOAC) && (ps2->bData == 0x03)
					 &&(ps3->wPort == PORT_SIOAC) && (ps3->bData == 0xd3)){
						SetPortData(PORT_SIOAC, 0x08);
						ClearStatements();
						DbgPrintf("SYNCL1");
						break;
					}
					if((ps0->wPort == PORT_SIOAC) && (ps0->bData == 0x03)
					 &&(ps1->wPort == PORT_SIOAC) && (ps1->bData == 0xc3)){
						SetPortData(PORT_SIOAC, 0x01);
						ClearStatements();
						DbgPrintf("SYNCL2");
						_NRCH = FALSE;
						break;
					}
					if((ps0->wPort == PORT_SIOAC) && (ps0->bData == 0x03)
					 &&(ps1->wPort == PORT_SIOAC) && (ps1->bData == 0xc9)){
						SetPortData(PORT_SIOAC, 0x08);
						DbgPrintf("SYNCL3");
						ClearStatements();
						_NRCH = TRUE;
						break;
					}
					if((ps0->wPort == PORT_SIOBC) && (ps0->bData == 0x05)
					 &&(ps1->wPort == PORT_SIOBC) && (ps1->bData == 0x80)){
						SetPortData(PORT_SIOAC, 0x08);
						ClearStatements();
						PlayQddSound(SOUNDFILE_SEEK);
						DbgPrintf("MTON");
						_MTON = TRUE;
						break;
					}
					if(_NRCH == TRUE){
						SetPortData(PORT_SIOAC, 0x08);
						ClearStatements();
					}
					break;
				case 0xd0:
					if((ps0->wPort == PORT_SIOAC) && (ps0->bData == 0x58)
					 &&(ps1->wPort == PORT_SIOAC) && (ps1->bData == 0x04)
					 &&(ps2->wPort == PORT_SIOAC) && (ps2->bData == 0x10)
					 &&(ps3->wPort == PORT_SIOAC) && (ps3->bData == 0x05)
					 &&(ps4->wPort == PORT_SIOAC) && (ps4->bData == 0x04)
					 &&(ps5->wPort == PORT_SIOAC) && (ps5->bData == 0x03)){
						ClearStatements();
						DbgPrintf("SIOLD");
					}
					break;
				case 0x16:
					if((ps0->wPort == PORT_SIOAC) && (ps0->bData == 0x06)
					 &&(ps1->wPort == PORT_SIOAC) && (ps1->bData == 0x16)
					 &&(ps2->wPort == PORT_SIOAC) && (ps2->bData == 0x07)){
						ClearStatements();
						DbgPrintf("Rx8Bit");
						_iReaded = 0;
						if((_pImage = (LPBYTE)_pBlockList[_iBlockId++]) == NULL){
							/*EOF*/
							_NRCH = FALSE;
							_iBlockId = 0;
							_pImage = (LPBYTE)_pBlockList[_iBlockId++];
						}
					}
					break;
				default:
					_NRCH = FALSE;
					break;
			}
			break;
		case PORT_SIOBC:
			switch(bData){
				case 0x00:
					ClearStatements();
					break;
				case 0x02:
					if((ps0->wPort == PORT_SIOBC) && (ps0->bData == 0x02)
					 &&(ps1->wPort == PORT_SIOBC) && (ps1->bData == 0x81)){
						SetPortData(PORT_SIOBC, 0x80);
						_QDRDY = TRUE;
						DbgPrintf("QDRDY");
						ClearStatements();
					}
					break;
				case 0x05:
					if((ps0->wPort == PORT_SIOAC) && (ps0->bData == 0x05)
					 &&(ps1->wPort == PORT_SIOAC) && (ps1->bData == 0x60)){
						_MTON = FALSE;
						DbgPrintf("MTOFF");
						ClearStatements();
					}
					break;
				case 0x10:
					SetPortData(PORT_SIOBC, 0x08);
					DbgPrintf("RDCRC");
					ClearStatements();
					break;
				case 0x80:
					if((ps0->wPort == PORT_SIOAC) && (ps0->bData == 0x58)
					 &&(ps1->wPort == PORT_SIOBC) && (ps1->bData == 0x05)){
						DbgPrintf("LSINT");
						ClearStatements();
					}
					break;
				default:
					break;
			}
	}

	return 0;
}

/*-----------------------------------------------------------------------------
	{[h
-----------------------------------------------------------------------------*/
BOOL APIENTRY IntializeBoard(VOID)
{
	char buff[MAX_PATH];

	if(emuz2000_readProfileDword(_dwId, KEYNAME_DEBUG) != 0L){
		_fpDebug = fopen(DEBUGLOGFILE, "a");
	}
	DbgPrintf("IntializeBoard");

	emuz2000_readProgileString(_dwId, KEYNAME_QDFILEPATH, _qdFileName, sizeof(_qdFileName));
	ZeroMemory(buff, sizeof(buff));
	emuz2000_readProgileString(_dwId, KEYNAME_ENABLESOUND, buff, sizeof(buff));
	if(strlen(buff) > 0){
		_dwSound = emuz2000_readProfileDword(_dwId, KEYNAME_ENABLESOUND);
	}

	_isLoadRom = LoadRomImage(ROMFILENAME);

	return TRUE;
}

/*-----------------------------------------------------------------------------
	{[hď
-----------------------------------------------------------------------------*/
BOOL APIENTRY ReIntializeBoard(VOID)
{
	DbgPrintf("ReIntializeBoard");
#ifdef EMUZ2000EX
	if(_isLoadRom == TRUE){
		DbgPrintf("Enable IPL Rom Ports");
		emuz2000_ex_setIoEntries(_dwId, &_extendIo);
	}
#endif
	ClearStatements();
	return TRUE;
}

/*-----------------------------------------------------------------------------
	{[hpI
-----------------------------------------------------------------------------*/
VOID APIENTRY FinalizeBoard(VOID)
{
	DbgPrintf("FinalizeBoard");

	//emuz2000_writeProfileDword(_dwId, KEYNAME_DEBUG, _fpDebug ? 1 : 0);
	emuz2000_writeProfileDword(_dwId, KEYNAME_ENABLESOUND, _dwSound);
	emuz2000_writeProgileString(_dwId, KEYNAME_QDFILEPATH, _qdFileName);

	if(_fpDebug != NULL){
		fclose(_fpDebug);
		_fpDebug = NULL;
	}
}

/*-----------------------------------------------------------------------------
	{[hʒm
-----------------------------------------------------------------------------*/
BOOL APIENTRY BoardInfomationService(PEMUZ2000EBIH *info, DWORD dwId)
{
#ifdef EMUZ2000EX
	_Mz1e18EBIH.flgs.val = 0L;
#endif
	*info   = &_Mz1e18EBIH;
	_dwId = dwId;
	return TRUE;
}

/*-----------------------------------------------------------------------------
	CPUNbN擾
-----------------------------------------------------------------------------*/
VOID APIENTRY ReportCpuClock(int iClock)
{
}

/*-----------------------------------------------------------------------------
	Xe[gZ[uo̓f[^ݒ
-----------------------------------------------------------------------------*/
#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx(int *ver, LPDWORD lpdwSize, LPBYTE *lpbBuff )
{
	*lpdwSize = 0;
	*lpbBuff  = NULL;
	return TRUE;
}
#else
BOOL APIENTRY StateSaveOutputData(LPDWORD lpdwSize, LPBYTE lpbBuff)
{
	lpdwSize = 0;
	lpbBuff  = NULL;
	return TRUE;
}
#endif

/*-----------------------------------------------------------------------------
	Xe[gZ[u̓f[^ݒ
-----------------------------------------------------------------------------*/
#ifdef EMUZ2000EX
BOOL WINAPI StateSaveInputDataEx(int ver, DWORD dwSize, PBYTE lpbBuff )
{
	return TRUE;
}
#else
BOOL APIENTRY StateSaveInputData(DWORD dwSize, PBYTE lpbBuff)
{
	return TRUE;
}
#endif

/*----------------------------------------------------------------------------
	ݒ_CAOWM_INITDIALOG̏
----------------------------------------------------------------------------*/
BOOL InfomationDlgInitDialog(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return TRUE;
}

/*----------------------------------------------------------------------------
	ݒ_CAOWM_COMMAND̏
----------------------------------------------------------------------------*/
BOOL InfomationDlgCommand(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	OPENFILENAME ofn;

	switch(wParam){
		case IDC_OPENBUTTON:
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hWnd;
			ofn.lpstrFilter = 
				"MZ QD (*.q20)\0*.q20\0"
				"MZ Tape (*.mzt)\0*.mzt\0"
				"All Files (*.*)\0*.*\0\0";
			ofn.lpstrFile = _qdFileName;
			ofn.lpstrFileTitle = "";
			ofn.nMaxFile = MAX_PATH;
			ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
			ofn.lpstrTitle = "Select QD File";
			if(GetOpenFileName(&ofn) == FALSE) {
				return TRUE;
			}
			LoadQdImage(_qdFileName);
			return TRUE;
		case IDC_EJECTBUTTON:
			_isLoadQd = FALSE;
			MessageBox(hWnd, "Eject QD File.", "MZ-1E18", MB_OK);
			return TRUE;
		case IDOK:
			EndDialog(hWnd, TRUE);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWnd, TRUE);
			return TRUE;
		default:
			break;
	}
	return FALSE;
}

/*-----------------------------------------------------------------------------
	ݒ_CAO{bNXR[obN֐
-----------------------------------------------------------------------------*/
BOOL APIENTRY InfomationDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg){
		MSGDISPATCH(WM_COMMAND,    InfomationDlgCommand);
		MSGDISPATCH(WM_INITDIALOG, InfomationDlgInitDialog);
	}
	return FALSE;
}

/*-----------------------------------------------------------------------------
	ݒ_CAO{bNX\
-----------------------------------------------------------------------------*/
VOID APIENTRY InfomationDialog(HWND hWnd)
{
	DialogBox(_hInst, MAKEINTATOM(IDD_INFODLG), hWnd, InfomationDlgProc);
}

#ifdef EMUZ2000EX
/*-----------------------------------------------------------------------------
	ȈIPLN
-----------------------------------------------------------------------------*/
BOOL ExecQdImage()
{
	PMZQDHEADER pHeader = (PMZQDHEADER)_pBlockList[1];
	PMZQDBODY   pBody   = (PMZQDBODY)_pBlockList[2];
	LPVOID      pMem    = emuz2000_getMainMemoryPointer(_dwId);

	DbgPrintf("ExecQdImage");

	if(pMem == NULL){
		return FALSE;
	}

	if((pHeader->bAttr == 0x01)
	 && (pHeader->wStartAddress == 0) && (pHeader->wJumpAddress == 0)){
		DbgPrintf("CopyToMainMemory %s", pHeader->szFileName);
		memcpy(pMem, (LPVOID)&(pBody->bBody), pHeader->wSize);
		return TRUE;
	}

	return FALSE;
}

/*-----------------------------------------------------------------------------
	Xg[WfoCXR[obN
-----------------------------------------------------------------------------*/
BOOL APIENTRY StrageDeviceCallback(int type, int drive, int verb, int mode, DWORD dwParam1, DWORD dwParam2, LPVOID lpParam)
{
	if(type != PLUGIN_DEVICE_TYPE_QD){
		return FALSE;
	}

	switch(verb){
		case PLUGIN_DEVICE_VERB_GETINTERFACE:
			*((LPBOOL)lpParam) = TRUE;
			return TRUE;
		case PLUGIN_DEVICE_VERB_GETACCESS:
		case PLUGIN_DEVICE_VERB_GETRUNNINGSTATUS:
			*((LPBOOL)lpParam) = _MTON;
			return TRUE;
		case PLUGIN_DEVICE_VERB_GETEXIST:
			*((LPBOOL)lpParam) = _isLoadQd;
			return TRUE;
		case PLUGIN_DEVICE_VERB_GETWRITABLE:
			*((LPBOOL)lpParam) = FALSE;
			return TRUE;
		case PLUGIN_DEVICE_VERB_CHANGE:
			strcpy(_qdFileName, (LPSTR)lpParam);
			LoadQdImage(_qdFileName);
			PlayQddSound(SOUNDFILE_SET);
			return TRUE;
		case PLUGIN_DEVICE_VERB_EXEC:
			if(_isLoadQd == FALSE){
				return FALSE;
			}
			return ExecQdImage();
		case PLUGIN_DEVICE_VERB_EJECT:
			if(_isLoadQd == TRUE){
				PlayQddSound(SOUNDFILE_EJECT);
			}
			_isLoadQd = FALSE;
			return TRUE;
	}
	return FALSE;
}
#endif
