/******************************************************************************
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*                        EmuZ-2000  Extend Board DLL
*                               << MZ-1E18 >>
*                          Header File [MZ1E18.H]
*               10 Apl. 2010  version 0.01  - Create
*               26 Feb. 2013  version 0.02  - Play Sound
*               28 Feb. 2013  version 0.03  - New FileName support
*                      Programmed by 2010 S.Tsuneoka
******************************************************************************/
#ifndef __MZ1E18_H__
#define __MZ1E18_H__

#define MSGDISPATCH(msg, fn)	case msg: return fn(hWnd, wParam, lParam)

#define PORT_ROM_H				0xf8
#define PORT_ROM_L				0xf9
#define PORT_SIOAD				0xd0
#define PORT_SIOBD				0xd1
#define PORT_SIOAC				0xd2
#define PORT_SIOBC				0xd3

#define IPL_BASEIOPORT			PORT_ROM_H
#define IPL_USINGPORTS			2
#define QDIF_BASEIOPORT			PORT_SIOAD
#define QDIF_USINGPORTS			4

#define ROMFILENAME				"mz_1e18.rom"
#define DEBUGLOGFILE			"mz_1e18.log"
#define SOUNDFILE_SET			"qdset.wav"
#define SOUNDFILE_EJECT			"qdeject.wav"
#define SOUNDFILE_SEEK			"qdseek.wav"

#define KEYNAME_DEBUG			"Debug"
#define KEYNAME_QDFILEPATH		"FileName"
#define KEYNAME_ENABLESOUND		"EnableSound"

#define DEFAULT_ENABLESOUND		1L

#define ROMBUFFSIZE				32768
#define BUFFSIZE				1024
#define MAX_STATEMENTS			16
#define DISKBUFFSIZE			65536

#define MZBODYDATALEN			DISKBUFFSIZE
#define MZFILENAMELEN			17
#define MZTAPEHEADRESLEN		104
#define MZQDHEADRESLEN			38
#define MZQDBLOCKHEADERLEN		3

#define WRITEPROTECT_ON			0x00
#define WRITEPROTECT_OFF		0x20
#define WRITEPROTECT			WRITEPROTECT_ON

typedef struct _tagIoStatements{
	WORD		wPort;
	BYTE		bData;
} IOSTATEMENTS, *PIOSTATEMENTS, *LPIOSTATEMENTS;

#pragma pack(1)

/* MZ Tape Header */
typedef struct tagMZTAPEHEADER {
	BYTE		bAttr;						/* 0x01:Machine 0x02:BASIC */
	char		szFileName[MZFILENAMELEN];	/* FileName */
	WORD		wSize;						/* DataSize */
	WORD		wStartAddress;				/* StartAddress */
	WORD		wJumpAddress;				/* ExecuteAddress */
	BYTE		bReserverd[MZTAPEHEADRESLEN];/* Reserved */
} MZTAPEHEADER, *PMZTAPEHEADER, *LPMZTAPEHEADER;

/* MZ Tape Data */
typedef struct tagMZTAPEBODY {
	BYTE		bBody[MZBODYDATALEN];		/* DataFMax64KB */
} MZTAPEBODY, *PMZTAPEBODY, *LPMZTAPEBODY;

/* MZ Tape */
typedef struct tagMZTAPE {
	MZTAPEHEADER	header;					/* Header */
	MZTAPEBODY		body;					/* Data */
} MZTAPE, *PMZTAPE, *LPMZTAPE;

/* MZ QD Header */
typedef struct tagMZQDHEADER {
	BYTE		bBlockFlag;					/* BlockFlag */
	WORD		wBlockSize;					/* BlockSize */
	BYTE		bAttr;						/* 0x01:Machine 0x02:BASIC */
	char		szFileName[MZFILENAMELEN];	/* FileName */
	BYTE		bLock;						/* Reserved */
	BYTE		bSecret;					/* Reserved */
	WORD		wSize;						/* DataSize */
	WORD		wStartAddress;				/* StartAddress */
	WORD		wJumpAddress;				/* ExecuteAddress */
	BYTE		bReserverd[MZQDHEADRESLEN];	/* Reserved */
} MZQDHEADER, *PMZQDHEADER, *LPMZQDHEADER;

/* MZ QD Body */
typedef struct tagMZQDBODY {
	BYTE		bBlockFlag;					/* BlockFlag */
	WORD		wBlockSize;					/* BlockSize */
	BYTE		bBody[MZBODYDATALEN];		/* DataFMax64KB */
} MZQDBODY, *PMZQDBODY, *LPMZQDBODY;

/* MZ QD */
typedef struct tagMZQD {
	BYTE		bMediaCheckFlag;			/* MediaCheckFlag */
	MZQDHEADER	header;						/* Header */
	MZQDBODY	body;						/* Data */
} MZQD, *PMZQD, *LPMZQD;

#pragma pack()

/* prototypes */
#ifdef __cplusplus
extern "C" {
#endif

/* mz1e08.c */
LPCSTR GetEmuZDirectory(VOID);
VOID   DbgPrintf(LPCSTR, ...);

BYTE   InportIplRomFunction(WORD wPort);
int    OutportIplRomFunction(WORD wPort, BYTE bData);
BYTE   InportQDFunction(WORD wPort);
int    OutportQDFunction(WORD wPort, BYTE bData);

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif	/* __MZ1E18_H__ */
