/*********************************************************************************
*
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*
*                                  EmuZ-2000
*
*           EmuZ-2000 Extend Debugger Board Header [EmuZ2000Debug.h]
*
*             Programmed & Porting by 2002-2003 EmuZ-2000 (M.Y)
*
*********************************************************************************/
//   emuz2000Debug.h
//
//
//

#ifndef	_emuz2000Debug_h_
#define	_emuz2000Debug_h_

///////////////////////////////
// Define

///////////////////////////////
// Typedefs

///////////////////////////////
// Structures & unions
typedef	struct	_cpuinfo{
	UCHAR	a,b,c,d,e,f,h,l;
	UCHAR	a2,b2,c2,d2,e2,f2,h2,l2;
	USHORT	ix,iy,sp,pc;
	UCHAR	r,i,iff1,iff2,im;
}CPUINFO, *PCPUINFO ;

typedef	struct	_brkinfo{
	DWORD	prev ;
	DWORD	enable ;
	USHORT	port ;
	USHORT	adr ;
	DWORD	next ;
}BRKINFO, *PBRKINFO ;

//////////////////////////////////
// Call by DLLs Prototype
//////////////////////////////////////////////////////////////////////////////////////////////
//Debbuger Service
BOOL
WINAPI
emuz2000_dbg_setPcBreadPoint(
	DWORD	id,
	USHORT	adr
	) ;

BOOL
WINAPI
emuz2000_dbg_setMemoryWriteBreak(
	DWORD	id,
	USHORT	adr
	) ;

BOOL
WINAPI
emuz2000_dbg_setMemoryReadBreak(
	DWORD	id,
	USHORT	adr
	) ;

BOOL
WINAPI
emuz2000_dbg_setIoWriteBreak(
	DWORD	id,
	USHORT	port
	) ;

BOOL
WINAPI
emuz2000_dbg_setIoReadBreak(
	DWORD	id,
	USHORT	port
	) ;

BOOL
WINAPI
emuz2000_dbg_emunBreadPoints(
	DWORD		id,
	DWORD		mode, //(PC Bread, MemWrite, MemRead, IOWrite, IORead)
	PBRKINFO	info
	) ;

BOOL
WINAPI
emuz2000_dbg_clearBreakPoint(
	DWORD	id,
	DWORD	mode,	//ǂBreakPoint̂(OnePoint or All :: PC Bread, MemWrite, MemRead, IOWrite, IORead)
	USHORT	adr
	) ;

BOOL
WINAPI
emuz2000_dbg_getCpuInfomation(
	DWORD		id,
	PCPUINFO	info
	) ;

BOOL
WINAPI
emuz2000_dbg_setInternalBreak( //(Use Step Execute : Break on Clear)
	DWORD	id,
	USHORT	adr
	) ;

BOOL
WINAPI
emuz2000_dbg_playControl(
	DWORD	id,
	DWORD	control
	) ;


#ifndef	_NO_BOARD_API_
BOOL
WINAPI
OnBreakPoint( 
	DWORD flg
	) ;
#endif //_NO_BOARD_API_

#endif	//_emuz2000Debug_h_
