/* File: emuz2000.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Windows GUI and Initialize, etc.

	Extend the EmuZ-2000 emuz2000.c by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.

	Caution !!
	This file is including the old EmuZ-2000 program code.
	These are released open source code without copyright information.
*/

#include "config.h"

#include <windows.h>
#include <commctrl.h>
#include <ddraw.h>
#include <stdio.h>
#include <string.h>
#include <locale.h>

#include "common.h"
#include "resource.h"
#include "mz2000.h"
#include "pasteDlg.h"
#include "tapeDlg.h"
#include "clockDlg.h"
#include "deviceDlg.h"
#include "versionDlg.h"
#include "../Plugin/plugin.h"
#include "../Plugin/pluginDlg.h"

#ifdef ENABLE_D3D
HWND	ghWndChild = NULL;
// RPI
#include "now\rpimenu.h"
#endif

/* for Emulator */
MZ2000 *mz2000_global = NULL;
WOV_TYPE os_runmode = WOV_2000;
volatile BOOL bFullScreenMenu = TRUE;
volatile int playDestroy = FALSE;
int g_statusbar_height = 0;
volatile char g_statusbar_msg[LNMAX] = "";
HANDLE g_hFSStatusBarFont;
/* MZ font */
int mzfont8_have, mzfont16_have;
BYTE mzfont[256*2][16];
BYTE mzfont8[256*2][16];
BYTE mzfont16[256*2][16];

static MZ2000 *mz2000 = NULL;
static char szClassName[] = APPNAME;
static volatile BOOL bFullScreen = FALSE;
static HMENU hFullscreenMenu;
static volatile int playDestroy_view = FALSE;
static int winpos_x = 0, winpos_y = 0;
static int winsize_x = 0, winsize_y = 0;
static HANDLE hViewMutex = NULL;

/* for Timer */
#define MZ_DIRECTDRAW_REDRAWCT_DEFAULT	5	/* unit = MZ2000_REFRESHRATE = 10ms */
#define MZ_DIRECTDRAW_REDRAWCT_DEFAULT2	80	/* unit = MZ2000_REFRESHRATE = 10ms */
static int g_setwinsize_ct = 0;		/* for delayed restore window position (WinXP) */
static int g_directredraw_ct = 0;	/* for delayed rewrite fullscreen */
static MMRESULT timerid;

DWORD WINAPI mainloop_thread( LPVOID arg )
{
	MZ2000 *mz = (MZ2000 *)arg;

	mainloop_mz2000( mz );
	ExitThread( 0 );
	return 1;
}

void playview_add_redrawct( void )
{
	if (bFullScreen)
		g_directredraw_ct = MZ_DIRECTDRAW_REDRAWCT_DEFAULT;
	return;
}

DWORD WINAPI playview_thread( LPVOID arg )
{
	MZ2000 *mz = (MZ2000 *)arg;

	mz -> dwDebugPrintDrawCount = 0;
	while (!playDestroy) {
		if (mz -> playStop && bFullScreen) {
			Sleep( 100 );
			continue;
		}
		if (mz -> dwDebugPrint) {
			mz -> dwDebugPrintDrawCount++;
			if (mz -> dwDebugPrintDrawCount >= 100) {
				mz -> viewMsg = TRUE;
				mz -> mzChgGraphMode = TRUE;
				mz -> dwDebugPrintDrawCount = 0;
				playview_add_redrawct();
			}
		}
#ifdef VIEWCHG
		if (mz -> viewMsg || g_directredraw_ct > 0) {
			WaitForSingleObject( hViewMutex, INFINITE );
			if (g_directredraw_ct > 0)
				--g_directredraw_ct;
			mz -> viewMsg = FALSE;
			if (mz -> mzChgGraphMode) {
				mz -> mzChgGraphMode = FALSE;
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				ReleaseMutex( hViewMutex );
				Sleep( MZ2000_REFRESHRATE/2 );
			} else {
				if (!bFullScreen)
					ShowMyText2( mz->ghWnd, mz );
				else
					DDrawUpdateScreen( mz->ghWnd, mz, FALSE );
				ReleaseMutex( hViewMutex );
				Sleep( MZ2000_REFRESHRATE/2 );
			}
		} else
			Sleep( MZ2000_REFRESHRATE );
#else
		PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
		Sleep( 50 );
#endif // VIEWCHG
	}
	playDestroy_view = TRUE;
	ExitThread( 0 );
	return 1;
}

void CALLBACK playTimer( UINT uid, UINT cc, DWORD user, DWORD aa, DWORD bb )
{
	int i, tape_runmode, tapeend;
	unsigned long pos, total, offset, tfreq, dfreq;
	char c, c2, c3, c4, c5, c6;
	char buf[LNMAX], buf2[LNMAX], buf3[LNMAX];
	static char obuf[LNMAX] = "";
	MZ2000 *mz = (MZ2000 *)user;

	sound_tickprogress( mz );
	if (g_setwinsize_ct > 0) {
		--g_setwinsize_ct;
		if (!g_setwinsize_ct) {
			SetWindowPos( mz -> ghWnd, HWND_NOTOPMOST, winpos_x, winpos_y,
#ifdef ENABLE_RESIZE
				screen_window_width + GetSystemMetrics(SM_CXSIZEFRAME)*2 +
					GetSystemMetrics(SM_CXEDGE)*2,
				screen_window_height + GetSystemMetrics(SM_CYCAPTION) +
					GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
					GetSystemMetrics(SM_CYSIZEFRAME)*2 +
					GetSystemMetrics(SM_CYEDGE)*2,
#else
				MZ2000_DISPLAY_WIDTH + GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
					GetSystemMetrics(SM_CXEDGE)*2,
				MZ2000_DISPLAY_HEIGHT + GetSystemMetrics(SM_CYCAPTION) +
					GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
					GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
					GetSystemMetrics(SM_CYEDGE)*2,
#endif
				SWP_SHOWWINDOW );
#ifdef ENABLE_STATUSBAR_MW
			MoveWindow( mz2000 -> ghStatusBar, 0, MZ2000_DISPLAY_HEIGHT,
				MZ2000_DISPLAY_WIDTH, GetSystemMetrics(SM_CYMENU), TRUE );
#endif

		}
	}
	if (!(mz -> playStop) && !(mz -> pause)) {
		z80_timer();
		mz2tape_updatetimer();
		disk_updatetimer();
		copypaste_pastetimer();
	}
	if (!(mz2000 -> ghStatusBar))
		return;
	if (bFullScreen && !bFullScreenMenu)
		return;
	if (!(mz2000 -> mzmode))
		_snprintf( buf, LNMAX, "MZ-2000/2200 " );
	else
		_snprintf( buf, LNMAX, "MZ-80B/B2 " );
	if (!(mz2000 -> pause)) {
		if (!getspeed_z80())
			_snprintf( buf2, LNMAX, "NO WAIT        " );
		else
			_snprintf( buf2, LNMAX, "%dMHz        ", getspeed_z80() / 1000 );
	} else
		_snprintf( buf2, LNMAX, "PAUSE        " );
	strncat( buf, buf2, LNMAX - strlen(buf) - 1 );
	for (i = 0; i < MZ_DISK_DRIVE_MAX; i++) {
		if (disk_getwritable( mz2000, i ))
			c2 = ' ';
		else
			c2 = 'r';
		switch (disk_getexist( mz2000, i )) {
		case DISK_STATUS_INSERT :
			c = '+';
			if (disk_getaccess( mz2000, i ))
				c = '*';
			break;
		case DISK_STATUS_WCHANGED :
			c = 'W';
			if (disk_getaccess( mz2000, i ))
				c = '*';
			break;
		default :
			c  = '-';
			c2 = ' ';
			if (disk_getaccess( mz2000, i ))
				c = '*';
			break;
		}
		_snprintf( buf2, LNMAX, "FD%d:%c%c ", i+1, c, c2 );
		strncat( buf, buf2, LNMAX - strlen(buf) - 1 );
	}
	if (mz2tape_getwritable())
		c2 = ' ';
	else
		c2 = 'r';
	tape_runmode = mz2tape_getstatus( &pos, &total, &offset, &tapeend,
		&tfreq, &dfreq );
	switch (tape_runmode) {
	case MZ2TAPE_RUNMODE_STOP :
		c = '+';
		break;
	case MZ2TAPE_RUNMODE_PLAY :
		c = '*';
		break;
	case MZ2TAPE_RUNMODE_RECORD :
		c = 'W';
		break;
	case MZ2TAPE_RUNMODE_FF :
		c = '>';
		break;
	case MZ2TAPE_RUNMODE_REW :
		c = '<';
		break;
	default :
		c = '-';
		c2 = ' ';
		break;
	}
	if (tape_runmode >= 0) {
		switch (mz2000 -> tapecounter) {
		case TAPE_COUNTERMODE_MZ2080 :
			pos = (unsigned long)(((ULONGLONG)(pos - offset))
				* (ULONGLONG)dfreq * 10 / (ULONGLONG)tfreq);
			total = (unsigned long)(((ULONGLONG)(total - offset))
				* (ULONGLONG)dfreq * 10  / (ULONGLONG)tfreq);
			if (!(mz2000 -> mzmode)) {
				pos   = pos / mz2000 -> tapectspeed_2000;
				total = total / mz2000 -> tapectspeed_2000;
			} else {
				pos   = pos / mz2000 -> tapectspeed_80B;
				total = total / mz2000 -> tapectspeed_80B;
			}
			break;
		case TAPE_COUNTERMODE_MZ2500 :
			pos = (unsigned long)(((ULONGLONG)(pos - offset))
				* (ULONGLONG)dfreq * 10 / (ULONGLONG)tfreq);
			total = (unsigned long)(((ULONGLONG)(total - offset))
				* (ULONGLONG)dfreq * 10  / (ULONGLONG)tfreq);
			pos   = pos   / mz2000 -> tapectspeed_2500;
			total = total / mz2000 -> tapectspeed_2500;
			break;
		case TAPE_COUNTERMODE_KBYTES :
			pos   = (pos   + 500) / 1000;
			total = (total + 500) / 1000;
			break;
		default : /* TAPE_COUNTERMODE_BYTES */
			break;
		}
		switch (mz2000 -> tapecounter) {
		case TAPE_COUNTERMODE_MZ2080 :
		case TAPE_COUNTERMODE_MZ2500 :
			if (tapeend)
				_snprintf( buf3, LNMAX, "(%03lu.%01lu-END/%03lu.%01lu) ",
					pos / 10, pos % 10, total / 10, total % 10 );
			else
				_snprintf( buf3, LNMAX, "(%03lu.%01lu/%03lu.%01lu) ",
					pos / 10, pos % 10, total / 10, total % 10 );
			break;
		default :
			if (tapeend)
				_snprintf( buf3, LNMAX, "(%03lu-END/%03lu) ", pos, total );
			else
				_snprintf( buf3, LNMAX, "(%03lu/%03lu) ", pos, total );
		}
	} else {
		_snprintf( buf3, LNMAX, "(-/-) " );
	}
	if (c2 != ' ')
		_snprintf( buf2, LNMAX, "CAS:%c%c", c, c2 );
	else
		_snprintf( buf2, LNMAX, "CAS:%c", c );
	strncat( buf, buf2, LNMAX - strlen(buf) - 1 );
	strncat( buf, buf3, LNMAX - strlen(buf) - 1 );

	if (plugin_device_getinterface( PLUGIN_DEVICETYPE_QD )) {
		if (plugin_device_getwritable( PLUGIN_DEVICETYPE_QD, 0 ))
			c2 = ' ';
		else
			c2 = 'r';
		switch (plugin_device_getexist( PLUGIN_DEVICETYPE_QD, 0 )) {
		case DISK_STATUS_INSERT :
		case DISK_STATUS_WCHANGED :
			c = '+';
			if (plugin_device_getaccess( PLUGIN_DEVICETYPE_QD, 0 ))
				c = '*';
			break;
		default :
			c = '-';
			c2 = ' ';
			break;
		}
		_snprintf( buf2, LNMAX, " QD:%c%c ", c, c2 );
		buf2[LNMAX - 1] = '\0';
		strncat( buf, buf2, LNMAX - strlen(buf) - 1 );
	}
	if (mz2000 -> mzmode) {
		if (mz2000->ioinfo->port_e0 & 0x20U)
			c = 'S';
		else
			c = '-';
		if (mz2000->ioinfo->port_e0 & 0x40U)
			c2 = 'G';
		else
			c2 = '-';
		if (mz2000->ioinfo->port_e0 & 0x80U)
			c3 = 'K';
		else
			c3 = '-';
		_snprintf( buf2, LNMAX, " LED:%c%c%c ", c, c2, c3 );
		buf2[LNMAX - 1] = '\0';
		strncat( buf, buf2, LNMAX - strlen(buf) - 1 );
	}

	if (mz2000 -> keyboard_mode) {
		if (mz2000 -> keyboard_mode & 0x01U)
			c = '1';
		else
			c = '-';
		if (mz2000 -> keyboard_mode & 0x02U)
			c2 = '2';
		else
			c2 = '-';
		if (mz2000 -> keyboard_mode & 0x04U)
			c3 = '3';
		else
			c3 = '-';
		if (mz2000 -> keyboard_mode & 0x08U)
			c4 = '4';
		else
			c4 = '-';
		if (mz2000 -> keyboard_mode & 0x10U)
			c5 = '5';
		else
			c5 = '-';
		if (mz2000 -> keyboard_mode & 0x20U)
			c6 = '6';
		else
			c6 = '-';
		_snprintf( buf2, LNMAX, " KBD:%c%c%c%c%c%c ", c, c2, c3, c4, c5, c6 );
		buf2[LNMAX - 1] = '\0';
		strncat( buf, buf2, LNMAX - strlen(buf) - 1 );
	}
#ifdef _DEBUG
#if 0
	_snprintf( buf2, LNMAX, "(%d < %d < %d)",
		sound_stat_value2, sound_stat_value1, sound_stat_value3 );
	buf2[LNMAX - 1] = '\0';
	strncat( buf, buf2, LNMAX - strlen(buf) - 1 );
#endif
#endif
	if (strcmp( obuf, buf )) {
		SetWindowText( mz2000 -> ghStatusBar, buf );
#if 0
		if (bFullScreen)
			RedrawWindow( mz2000 -> ghStatusBar, NULL, NULL, RDW_INVALIDATE | RDW_ERASE );
#else
		mz -> viewMsg = TRUE;
		mz -> mzChgGraphMode = TRUE;
		mz -> dwDebugPrintDrawCount = 0;
		playview_add_redrawct();
#endif
		WaitForSingleObject( hViewMutex, INFINITE );
		strncpy( (char *)g_statusbar_msg, buf, LNMAX - 1 );
		g_statusbar_msg[LNMAX - 1] = '\0';
		ReleaseMutex( hViewMutex );
	}

	strncpy( obuf, buf, LNMAX - 1 );
	obuf[LNMAX - 1] = '\0';
	return;
}

void change_fullscreen( MZ2000 *mz )
{
	HWND ime;
	RECT rect;

	setplaystop( mz, TRUE );
	bFullScreen = !bFullScreen;
	WaitForSingleObject( hViewMutex, INFINITE );
	if (bFullScreen) {	/* full screen */
		GetWindowRect( mz->ghStatusBar, &rect );
		g_statusbar_height = rect.bottom - rect.top;
		GetWindowRect( mz->ghWnd, &rect );
		winpos_x = rect.left;
		winpos_y = rect.top;
		winsize_x = screen_window_width;
		winsize_y = screen_window_height;
		SetWindowPos( mz->ghWnd, HWND_NOTOPMOST, winpos_x, winpos_y,
			MZ2000_DISPLAY_WIDTH + GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
				GetSystemMetrics(SM_CXEDGE)*2,
			MZ2000_DISPLAY_HEIGHT + 80
					- GetSystemMetrics(SM_CYFIXEDFRAME)
					- GetSystemMetrics(SM_CYEDGE)*2
					+ GetSystemMetrics(SM_CYCAPTION) +
				GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
				GetSystemMetrics(SM_CYEDGE)*2 +
				GetSystemMetrics(SM_CYFIXEDFRAME)*2 -
				(GetSystemMetrics(SM_CYMENU) + g_statusbar_height),
			SWP_SHOWWINDOW );
		//Sleep( 100 );
		if (!DDrawCreate( mz->ghWnd )) {
			SetWindowLong( mz->ghWnd, GWL_EXSTYLE, WS_EX_OVERLAPPEDWINDOW );
			SetWindowLong( mz->ghWnd, GWL_STYLE,
#ifdef ENABLE_RESIZE
				WS_OVERLAPPEDWINDOW
#else
				WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX | WS_VISIBLE
#endif
			);
			screen_window_width  = winsize_x;
			screen_window_height = winsize_y;
			SetWindowPos( mz->ghWnd, HWND_NOTOPMOST, winpos_x, winpos_y,
#ifdef ENABLE_RESIZE
				screen_window_width + GetSystemMetrics(SM_CXSIZEFRAME)*2 +
					GetSystemMetrics(SM_CXEDGE)*2,
				screen_window_height + GetSystemMetrics(SM_CYCAPTION) +
					GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
					GetSystemMetrics(SM_CXSIZEFRAME)*2 +
					GetSystemMetrics(SM_CYEDGE)*2,
#else
				MZ2000_DISPLAY_WIDTH + GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
					GetSystemMetrics(SM_CXEDGE)*2,
				MZ2000_DISPLAY_HEIGHT + GetSystemMetrics(SM_CYCAPTION) +
					GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
					GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
					GetSystemMetrics(SM_CYEDGE)*2,
#endif
				SWP_SHOWWINDOW );
			ShowWindow( mz2000 -> ghStatusBar, SW_SHOW );
			bFullScreen = FALSE;
			ReleaseMutex( hViewMutex );
			setplaystop( mz, FALSE );
			PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
			return;
		}
		SetWindowLong( mz->ghWnd, GWL_EXSTYLE, 0 );
		SetWindowLong( mz->ghWnd, GWL_STYLE, WS_VISIBLE );
		hFullscreenMenu = GetMenu( mz->ghWnd );
		SetMenu( mz->ghWnd, NULL );
		SetMenu( mz->ghWnd, hFullscreenMenu );
		//Sleep( 100 );
#ifdef ENABLE_STATUSBAR_MW
		MoveWindow( mz2000 -> ghStatusBar, 0, MZ2000_DISPLAY_HEIGHT + 80,
			MZ2000_DISPLAY_WIDTH, GetSystemMetrics(SM_CYMENU), TRUE );
#endif
		ShowWindow( mz2000 -> ghStatusBar, SW_HIDE );
		//Sleep( 100 );
		ime = ImmGetDefaultIMEWnd( mz->ghWnd );
		SendMessage( ime, WM_IME_CONTROL, IMC_CLOSESTATUSWINDOW, 0 );
		mz -> mzChgGraphMode = TRUE;
		mz -> viewMsg = TRUE;
		bFullScreenMenu = TRUE;
		screen_region_add_all( mz );
		DDrawUpdateScreen( mz->ghWnd, mz, TRUE );
		//Sleep( 100 );
		PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
		g_directredraw_ct = MZ_DIRECTDRAW_REDRAWCT_DEFAULT;
		setplaystop( mz, FALSE );
	} else {	/* window */
		DDrawRelease( mz->ghWnd );
		if (!bFullScreenMenu) {
			SetMenu( mz->ghWnd, hFullscreenMenu );
			ShowCursor( TRUE );
			bFullScreenMenu = TRUE;
		}
		SetWindowLong( mz->ghWnd, GWL_EXSTYLE, WS_EX_OVERLAPPEDWINDOW );
		SetWindowLong( mz->ghWnd, GWL_STYLE,
#ifdef ENABLE_RESIZE
			WS_OVERLAPPEDWINDOW
#else
			WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX | WS_VISIBLE
#endif
		);
		screen_window_width = winsize_x;
		screen_window_height = winsize_y;
		//Sleep( 100 );
		GetWindowRect( mz->ghStatusBar, &rect );
		g_statusbar_height = rect.bottom - rect.top;
		SetWindowPos( mz->ghWnd, HWND_NOTOPMOST, winpos_x, winpos_y,
#ifdef ENABLE_RESIZE
			screen_window_width + GetSystemMetrics(SM_CXSIZEFRAME)*2 +
				GetSystemMetrics(SM_CXEDGE)*2,
			screen_window_height + GetSystemMetrics(SM_CYCAPTION) +
				GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
				GetSystemMetrics(SM_CXSIZEFRAME)*2 +
				GetSystemMetrics(SM_CYEDGE)*2,
#else
			MZ2000_DISPLAY_WIDTH + GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
				GetSystemMetrics(SM_CXEDGE)*2,
			MZ2000_DISPLAY_HEIGHT + GetSystemMetrics(SM_CYCAPTION) +
				GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
				GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
				GetSystemMetrics(SM_CYEDGE)*2,
#endif
			SWP_SHOWWINDOW );
#ifdef ENABLE_STATUSBAR_MW
		MoveWindow( mz2000 -> ghStatusBar, 0, MZ2000_DISPLAY_HEIGHT,
			MZ2000_DISPLAY_WIDTH, GetSystemMetrics(SM_CYMENU), TRUE );
#endif
		ShowWindow( mz2000 -> ghStatusBar, SW_SHOW );
		ime = ImmGetDefaultIMEWnd( mz->ghWnd );
		SendMessage( ime, WM_IME_CONTROL, IMC_OPENSTATUSWINDOW, 0 );
		//Sleep( 100 );
		setplaystop( mz, FALSE );
		if (os_runmode == WOV_2000) {
			/* Windows 2000/XP mode only special code */
			g_setwinsize_ct = 1500 / MZ2000_REFRESHRATE;
		}
		PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
		PostMessage( mz->ghStatusBar, WM_PAINT, 0, 0 );
		DragAcceptFiles( mz->ghWnd, TRUE );

#ifdef ENABLE_D3D
		gbRedraw = TRUE;
		InvalidRect( NULL, NULL, FALSE );
#endif
	}
	ReleaseMutex( hViewMutex );
	setplaystop( mz, FALSE );
	return;
}

void open_tapefile( HWND hWnd, MZ2000 *mz )
{
	int r, roflag;
	char *cp;
	char szFileName[MAX_PATH] = "";
	char szFileTitle[MAX_PATH] = "";
	OPENFILENAME ofn;

	setplaystop( mz, TRUE );
	strncpy( szFileName, (char *)mz -> tfilename, MAX_PATH );
	szFileName[MAX_PATH - 1] = '\0';
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFilter =
		"MZ Tape (*.mzt)\0*.mzt\0"
		"MZ tape for Foreign emulators (*.mzf)\0*.mzf\0"
		"MZ tape with Waves (*.mtw)\0*.mtw\0"
		"MZ tape wave Images (*.mti)\0*.mti\0"
		"MZ memory DATa (*.dat)\0*.dat\0"
		"Windows WAV (*.wav)\0*.wav\0"
		"Intel Hex (*.hex)\0*.hex\0"
		"All Files (*.*)\0*.*\0\0";
	ofn.lpstrFile = szFileName;
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST /* | OFN_HIDEREADONLY */;
	cp = strrchr( szFileName, '.' );
	if (cp) {
		cp++;
		if (!stricmp( cp, "mzt" )) {
			ofn.nFilterIndex = 1;
			ofn.lpstrDefExt = "mzt";
		} else if (!stricmp( cp, "mzf" )) {
			ofn.nFilterIndex = 2;
			ofn.lpstrDefExt = "mzf";
		} else if (!stricmp( cp, "mtw" )) {
			ofn.nFilterIndex = 3;
			ofn.lpstrDefExt = "mtw";
		} else if (!stricmp( cp, "mti" )) {
			ofn.nFilterIndex = 4;
			ofn.lpstrDefExt = "mti";
		} else if (!stricmp( cp, "dat" )) {
			ofn.nFilterIndex = 5;
			ofn.lpstrDefExt = "dat";
		} else if (!stricmp( cp, "wav" )) {
			ofn.nFilterIndex = 6;
			ofn.lpstrDefExt = "wav";
		} else if (!stricmp( cp, "hex" )) {
			ofn.nFilterIndex = 7;
			ofn.lpstrDefExt = "hex";
		} else {
			ofn.nFilterIndex = 8;
			ofn.lpstrDefExt = "";
		}
	} else {
		ofn.nFilterIndex = 1;
		ofn.lpstrDefExt = "mzt";
	}
	ofn.lpstrTitle = "Select a tape image file";
	if (!GetOpenFileName(&ofn)) {
		setplaystop( mz, FALSE );
		return;
	}
	strncpy( (char *)mz -> tfilename, szFileName, MAX_PATH );
	mz -> tfilename[MAX_PATH - 1] = '\0';
	roflag = mz -> forcereadonly ? TRUE : (ofn.Flags & OFN_READONLY ? TRUE : FALSE);
	r = mz2tape_exec( mz, szFileName, roflag );
	if (r <= MZ2TAPE_FILEMODE_ERRNDLG) {
		MessageBox( mz -> ghWnd, "A unknown type extentions filename found", DLGTITLE,
			MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
	}
	setplaystop( mz, FALSE );
	return;
}

BOOL checkShortcutKeys( MZ2000 *mz, WPARAM wp, BOOL onoff )
{
	switch (wp) {
	case VK_RETURN : /* toggle the display modes (fullscreen/window) */
		if (!onoff)
			return TRUE;
		if (g_setwinsize_ct <= 0)
			change_fullscreen( mz );
		return TRUE;
	case 'P' :
	case VK_F1 :	/* PAUSE */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_PAUSE, 0 );
		return TRUE;
	case VK_F2 :	/* display the debugging information */
		if (!onoff)
			return TRUE;
		mz -> dwDebugPrint = !mz->dwDebugPrint;
		mz -> mzChgGraphMode = TRUE;
		mz -> viewMsg = TRUE;
		playview_add_redrawct();
		return TRUE;
	case VK_F3 :	/* change the sound modes for enable/disable */
	case 'S' :
		if (!onoff)
			return TRUE;
		mz -> soundmode = !mz -> soundmode;
		sound_reset( mz );
		return TRUE;
	case VK_F4 :	/* toggle the disply colors modes (color/green) */
		if (!onoff)
			return TRUE;
		if (mz->displayMode == GREEN_DISPLAY)
			PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_COLOR, 0 );
		else
			PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_GREEN, 0 );
		return TRUE;
	case 'G' :	/* set the display colors to green */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_GREEN, 0 );
		return TRUE;
	case 'C' :	/* set the display colors to color */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_COLOR, 0 );
		return TRUE;
	case 'N' :	/* set the display resolutions to 15KHz */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_15KHz, 0 );
		return TRUE;
	case 'B' :	/* set the display resolutions to 24KHz */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_24KHz, 0 );
		return TRUE;
	case VK_F5 :
	case VK_F6 :
	case VK_F7 :
		if (!onoff)
			return TRUE;
		return TRUE;
	case VK_F8 :	/* Alt+F8 ... states save */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_FILESAVE, 0 );
		return TRUE;
	case VK_F9 :	/* Alt+F9 ... clock down */
		if (!onoff)
			return TRUE;
		mz -> nowZ80Clock = max( 1000, mz->nowZ80Clock - 1000 );
		setspeed_z80( mz2000->nowZ80Clock );
		return TRUE;
	case ';' :	/* clock down */
		if (onoff)
			return TRUE;
		mz -> nowZ80Clock = max( 1000, mz->nowZ80Clock - 1000 );
		setspeed_z80( mz2000->nowZ80Clock );
		return TRUE;
	case VK_F10 :	/* Alt+F10 ... clock up */
		if (!onoff)
			return TRUE;
		mz -> nowZ80Clock = min( mz->z80MaxClock, mz->nowZ80Clock + 1000 );
		setspeed_z80( mz2000->nowZ80Clock );
		return TRUE;
	case ':' :	/* clock up */
		if (onoff)
			return TRUE;
		mz -> nowZ80Clock = min( mz->z80MaxClock, mz->nowZ80Clock + 1000 );
		setspeed_z80( mz2000->nowZ80Clock );
		return TRUE;
	case ']' :	/* set the default to clock */
		if (onoff)
			return TRUE;
		mz -> nowZ80Clock = DEFAULT_SPEED_KHZ;
		setspeed_z80( mz2000->nowZ80Clock );
		return TRUE;
	case VK_F11 :	/* Alt+F11 ... reset */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_RESET, 0 );
		return TRUE;
	case VK_F12 :	/* Alt+F12 ... IPL reset */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_IPLRESET, 0 );
		return TRUE;
#if 0
	case 'X' :	/* Alt+X ... exit */
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_EXIT, 0 );
		return TRUE;
#endif
	case '1' :
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_KEY_EX1, 0 );
		return TRUE;
	case '2' :
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_KEY_EX2, 0 );
		return TRUE;
	case '3' :
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_KEY_EX3, 0 );
		return TRUE;
	case '4' :
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_KEY_EX4, 0 );
		return TRUE;
	case '5' :
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_KEY_EX5, 0 );
		return TRUE;
	case '6' :
		if (!onoff)
			return TRUE;
		PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_KEY_EX6, 0 );
		return TRUE;
	case ',' :
		if (onoff)
			return TRUE;
		if (mz2tape_ready() && !mz2tape_getkinh())
			PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_TAPE_REW, 0 );
		return TRUE;
	case '.' :
		if (onoff)
			return TRUE;
		if (mz2tape_ready() && !mz2tape_getkinh())
			PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_TAPE_FF, 0 );
		return TRUE;
	case '/' :
		if (onoff)
			return TRUE;
		if (mz2tape_ready() && !mz2tape_getkinh())
			PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_TAPE_STOP, 0 );
		return TRUE;
	case '\\' :
		if (onoff)
			return TRUE;
		if (!mz2tape_getkinh())
			PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_TAPE_EJECT, 0 );
		return TRUE;
	default :
		break;
	}
	return FALSE;
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	LRESULT result = 0L;
	MZ2000 *mz = mz2000;

	switch (msg) {
	case WM_INITMENUPOPUP :
		setplaystop( mz, TRUE );
		switch (lParam) {
		case 0 :	/* File */
			/* pause */
			CheckMenuItem( GetMenu(hWnd),ID_MENU_PAUSE,
				mz2000 -> pause ? MF_CHECKED : MF_UNCHECKED );
			/* mz modes */
			if (!(mz2000 -> mzmode)) {
				CheckMenuItem( GetMenu(hWnd), ID_MENU_80B, MF_UNCHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_2000, MF_CHECKED );
			} else {
				CheckMenuItem( GetMenu(hWnd), ID_MENU_80B, MF_CHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_2000, MF_UNCHECKED );
			}
			EnableMenuItem( GetMenu(hWnd), ID_MENU_FILESAVE,
				mz2000 -> howipl > 0 ? MF_GRAYED : MF_ENABLED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_FILESAVEAS,
				mz2000 -> howipl > 0 ? MF_GRAYED : MF_ENABLED );
			EnableMenuItem( GetMenu(hWnd), ID_EDIT_PASTE,
				!copypaste_havepaste( mz2000 -> ghWnd )
				|| copypaste_runningpaste() ? MF_GRAYED : MF_ENABLED );
			EnableMenuItem( GetMenu(hWnd), ID_EDIT_PASTE_STOP,
				!copypaste_runningpaste() ? MF_GRAYED : MF_ENABLED );
			/* languages */
			switch (mz2000 -> language) {
			case UILANG_ENGLISH :
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_AUTO,     MF_UNCHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_ENGLISH,  MF_CHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_JAPANESE, MF_UNCHECKED );
				break;
			case UILANG_JAPANESE :
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_AUTO,     MF_UNCHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_ENGLISH,  MF_UNCHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_JAPANESE, MF_CHECKED );
				break;
			default :
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_AUTO,     MF_CHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_ENGLISH,  MF_UNCHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_LANGUAGE_JAPANESE, MF_UNCHECKED );
				break;
			}
			break;
		case 1 :	/* A cassette tape deck */
			EnableMenuItem( GetMenu(hWnd), ID_MENU_TAPE_EJECT,
				!mz2tape_getkinh() ? MF_ENABLED : MF_GRAYED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_TAPE_STOP,
				mz2tape_ready() && !mz2tape_getkinh() ? MF_ENABLED : MF_GRAYED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_TAPE_REW,
				mz2tape_ready() && !mz2tape_getkinh() ? MF_ENABLED : MF_GRAYED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_TAPE_FF,
				mz2tape_ready() && !mz2tape_getkinh() ? MF_ENABLED : MF_GRAYED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_TAPE_REWIND,
				mz2tape_ready() && !mz2tape_getkinh() ? MF_ENABLED : MF_GRAYED );
			/* tape speaker */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_TAPESPEAKER,
				mz2000 -> tapespeaker ? MF_CHECKED : MF_UNCHECKED );
			/* counter types */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_TAPECOUNTER_2080,
				mz2000 -> tapecounter == TAPE_COUNTERMODE_MZ2080 ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_TAPECOUNTER_2500,
				mz2000 -> tapecounter == TAPE_COUNTERMODE_MZ2500 ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_TAPECOUNTER_KB,
				mz2000 -> tapecounter == TAPE_COUNTERMODE_KBYTES ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_TAPECOUNTER_BYTES,
				mz2000 -> tapecounter == TAPE_COUNTERMODE_BYTES ? MF_CHECKED : MF_UNCHECKED );
			/* drop auto IPL mode (tape) */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_DROPAUTOIPLTAPE,
				mz2000 -> dropautoipltape ? MF_CHECKED : MF_UNCHECKED );
			/* enable sounds mode (tape) */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_TAPESOUND,
				mz2000 -> enable_soundtape ? MF_CHECKED : MF_UNCHECKED );
			break;
		case 2 :	/* Floppy Diskette Drives */
			{
				int i;
				const int update_menu_id[] = {
					ID_MENU_DISK1_UPDATE,
					ID_MENU_DISK2_UPDATE,
					ID_MENU_DISK3_UPDATE,
					ID_MENU_DISK4_UPDATE
				};
				const int eject_menu_id[] = {
					ID_MENU_DISK1_EJECT,
					ID_MENU_DISK2_EJECT,
					ID_MENU_DISK3_EJECT,
					ID_MENU_DISK4_EJECT
				};

				for (i = 0; i < MZ_DISK_DRIVE_MAX; i++) {
					EnableMenuItem( GetMenu(hWnd), update_menu_id[i],
						disk_getmodified( mz2000, i ) ? MF_ENABLED : MF_GRAYED );
					EnableMenuItem( GetMenu(hWnd), eject_menu_id[i],
						disk_getexist( mz2000, i ) ? MF_ENABLED : MF_GRAYED );
				}
			}
			/* enable FDD interface */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_FDDIF,
				mz2000 -> enable_fddif ? MF_CHECKED : MF_UNCHECKED );
			/* the three disk module system modes */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_DISKFAST,
				mz2000 -> fd_exec_fast ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_DISKIGNORECRC,
				mz2000 -> fd_ignore_crc ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_DISKERASESCT17,
				mz2000 -> fd_erase_sct17crc ? MF_CHECKED : MF_UNCHECKED );
			/* drop to fd2 mode (fdd) */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_DROPTOFD2,
				mz2000 -> droptofd2 ? MF_CHECKED : MF_UNCHECKED );
			/* drop auto IPL mode (fdd) */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_DROPAUTOIPL,
				mz2000 -> dropautoipl ? MF_CHECKED : MF_UNCHECKED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_DROPAUTOIPL,
				mz2000 -> droptofd2 ? MF_GRAYED : MF_ENABLED );
			/* enable sounds mode (fdd) */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_FDDSOUND,
				mz2000 -> enable_soundfdd ? MF_CHECKED : MF_UNCHECKED );
			break;
		case 3 :	/* Quick Disks */
			if (!plugin_device_getinterface( PLUGIN_DEVICETYPE_QD )) {
				EnableMenuItem( GetMenu(hWnd), ID_MENU_QDCHANGE, MF_GRAYED );
				EnableMenuItem( GetMenu(hWnd), ID_MENU_QDEJECT, MF_GRAYED );
			} else {
				EnableMenuItem( GetMenu(hWnd), ID_MENU_QDCHANGE, MF_ENABLED );
				EnableMenuItem( GetMenu(hWnd), ID_MENU_QDEJECT,
					plugin_device_getexist( PLUGIN_DEVICETYPE_QD, 0 ) ? MF_ENABLED : MF_GRAYED );
			}
			break;
		case 4 :	/* Tools */
			/* key definitins modes */
			if (mz2000->keyboard_mode & 0x01U)
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX1, MF_CHECKED );
			else
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX1, MF_UNCHECKED );
			if (mz2000->keyboard_mode & 0x02U)
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX2, MF_CHECKED );
			else
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX2, MF_UNCHECKED );
			if (mz2000->keyboard_mode & 0x04U)
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX3, MF_CHECKED );
			else
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX3, MF_UNCHECKED );
			if (mz2000->keyboard_mode & 0x08U)
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX4, MF_CHECKED );
			else
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX4, MF_UNCHECKED );
			if (mz2000->keyboard_mode & 0x10U)
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX5, MF_CHECKED );
			else
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX5, MF_UNCHECKED );
			if (mz2000->keyboard_mode & 0x20U)
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX6, MF_CHECKED );
			else
				CheckMenuItem( GetMenu(hWnd), ID_MENU_KEY_EX6, MF_UNCHECKED );
			/* display colors */
			if (!mz2000 -> displayMode) {
				CheckMenuItem( GetMenu(hWnd), ID_MENU_GREEN, MF_CHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_COLOR, MF_UNCHECKED );
			} else {
				CheckMenuItem( GetMenu(hWnd), ID_MENU_GREEN, MF_UNCHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_COLOR, MF_CHECKED );
			}
			/* display resolutions */
			if (!mz2000 -> screen_highreso) {
				CheckMenuItem( GetMenu(hWnd), ID_MENU_15KHz, MF_CHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_24KHz, MF_UNCHECKED );
			} else {
				CheckMenuItem( GetMenu(hWnd), ID_MENU_15KHz, MF_UNCHECKED );
				CheckMenuItem( GetMenu(hWnd), ID_MENU_24KHz, MF_CHECKED );
			}
			/* A font selects */
			/* select a Japanese 8x16 24KHz font ROM */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_FONTH16,
				mz2000 -> font_select == TEXTFONT_400LINE ? MF_CHECKED : MF_UNCHECKED );
			/* select a English font ROM */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_FONTENGLISH,
				mz2000 -> font_english ? MF_CHECKED : MF_UNCHECKED );
			/* change to system clock values */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_CLOCK_4MHz,
				mz2000 -> nowZ80Clock == 4000 ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_CLOCK_6MHz,
				mz2000 -> nowZ80Clock == 6000 ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_CLOCK_8MHz,
				mz2000 -> nowZ80Clock == 8000 ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem( GetMenu(hWnd), ID_MENU_CLOCK_400MHz,
				mz2000 -> nowZ80Clock == 400000 ? MF_CHECKED : MF_UNCHECKED );
			if (mz2000 -> nowZ80Clock != 4000
					&& mz2000 -> nowZ80Clock != 6000
					&& mz2000 -> nowZ80Clock != 8000
					&& mz2000 -> nowZ80Clock != 400000)
				CheckMenuItem( GetMenu(hWnd), ID_MENU_CLOCK, MF_CHECKED );
			else
				CheckMenuItem( GetMenu(hWnd), ID_MENU_CLOCK, MF_UNCHECKED );
			/* Others */
			/* console rev. blank on color display */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_CONSOLERCBLANK,
				mz2000 -> consoler_cblank ? MF_CHECKED : MF_UNCHECKED );
			/* V-blank special mode */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_VBLANKSPECIAL,
				mz2000 -> vblankspecial ? MF_CHECKED : MF_UNCHECKED );
			/* force read only mode */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_FORCEREADONLY,
				mz2000 -> forcereadonly ? MF_CHECKED : MF_UNCHECKED );
			/* auto initialize I/O on reset */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_ENINITRESET,
				mz2000 -> enable_initreset ? MF_CHECKED : MF_UNCHECKED );
			/* IPL memory clear */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_IPLMEMCLR,
				mz2000 -> iplmemclr ? MF_CHECKED : MF_UNCHECKED );
			/* memory clear is zero clear */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_IPLMEMZCLR,
				mz2000 -> iplmemzclr ? MF_CHECKED : MF_UNCHECKED );
			/* enable sonuds to this application */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_SOUNDMODE,
				mz2000 -> soundmode ? MF_CHECKED : MF_UNCHECKED );
			/* enable the sound time interpolations */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_SOUNDITPOLATIONS,
				mz2000 -> enable_soundtminterpolations ? MF_CHECKED : MF_UNCHECKED );
			break;
		case 5 :	/* Window */
			/* window size x 1 */
#ifdef ENABLE_RESIZE
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE100,
				bFullScreen ? MF_GRAYED : MF_ENABLED );
#else
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE100, MF_GRAYED );
#endif
			CheckMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE100,
				screen_window_width  == MZ2000_DISPLAY_WIDTH &&
				screen_window_height == MZ2000_DISPLAY_HEIGHT
					? MF_CHECKED : MF_UNCHECKED );
			/* window size x 1.5 */
#ifdef ENABLE_RESIZE
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE150,
				bFullScreen ? MF_GRAYED : MF_ENABLED );
#else
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE150, MF_GRAYED );
#endif
			CheckMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE150,
				screen_window_width  == MZ2000_DISPLAY_WIDTH * 15 / 10 &&
				screen_window_height == MZ2000_DISPLAY_HEIGHT * 15 / 10
					? MF_CHECKED : MF_UNCHECKED );
			/* window size x 2 */
#ifdef ENABLE_RESIZE
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE200,
				bFullScreen ? MF_GRAYED : MF_ENABLED );
#else
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE200, MF_GRAYED );
#endif
			CheckMenuItem( GetMenu(hWnd), ID_MENU_WINSIZE200,
				screen_window_width  == MZ2000_DISPLAY_WIDTH * 20 / 10 &&
				screen_window_height == MZ2000_DISPLAY_HEIGHT * 20 / 10
					? MF_CHECKED : MF_UNCHECKED );
#ifndef ENABLE_D3D
			/* full screen mode */
			CheckMenuItem( GetMenu(hWnd), ID_MENU_FULLSCREEN,
				bFullScreen ? MF_CHECKED : MF_UNCHECKED );
#else
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINDOW_GDI,
				bFullScreen ? MF_GRAYED : MF_ENABLED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINDOW_D3D,
				bFullScreen ? MF_GRAYED : MF_ENABLED );
			EnableMenuItem( GetMenu(hWnd), ID_MENU_WINDOW_D3DF,
				bFullScreen ? MF_GRAYED : MF_ENABLED );

			CheckMenuItem ( GetMenu(hWnd), ID_MENU_WINDOW_GDI,
				!gbD3D ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem ( GetMenu(hWnd), ID_MENU_WINDOW_D3D,
				(gbD3D && !gbD3DF) ? MF_CHECKED : MF_UNCHECKED );
			CheckMenuItem ( GetMenu(hWnd), ID_MENU_WINDOW_D3DF,
				(gbD3D && gbD3DF) ? MF_CHECKED : MF_UNCHECKED );
#endif /* ENABLE_D3D */
			break;
		default :
			break;
		}
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case ID_MENU_PAUSE :
			setplaystop( mz, TRUE );
			mz2000 -> pause = !(mz2000 -> pause);
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_RESET :
			mz2000 -> needReset = TRUE;
			stop_z80();
			break;
		case ID_MENU_IPLRESET :
			if (!(mz -> mzmode))
				PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_2000, 0 );
			else
				PostMessage( mz->ghWnd, WM_COMMAND, ID_MENU_80B, 0 );
			break;
		case ID_MENU_2000 :	/* IPL 2000 */
		case ID_MENU_80B :	/* IPL 80B */
			if (LOWORD(wParam) == ID_MENU_2000)
				mz2000 -> mzmode = FALSE;
			else
				mz2000 -> mzmode = TRUE;
			mz2000 -> needIpl = TRUE;
			stop_z80();
			break;
		case ID_MENU_FILELOAD :
			load_state( mz->ghWnd, mz, FALSE );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				playview_add_redrawct();
			}
			break;
		case ID_MENU_FILESAVE :
			save_state( mz->ghWnd, mz, FALSE );
			playview_add_redrawct();
			break;
		case ID_MENU_FILESAVEAS :
			save_state( mz->ghWnd, mz, TRUE );
			playview_add_redrawct();
			break;
		case ID_EDIT_COPY :
			setplaystop( mz, TRUE );
			copypaste_copy( mz->ghWnd );
			setplaystop( mz, FALSE );
			break;
		case ID_EDIT_PASTE :
			setplaystop( mz, TRUE );
			copypaste_pastestart( mz->ghWnd );
			setplaystop( mz, FALSE );
			break;
		case ID_EDIT_PASTE_STOP :
			setplaystop( mz, TRUE );
			copypaste_pasteend( FALSE );
			setplaystop( mz, FALSE );
			break;
		case ID_EDIT_PASTE_SETTING :
			setplaystop( mz, TRUE );
			keyboard_hookend( hWnd, mz2000 );
			if (mz2000 -> currentlanguage == UILANG_JAPANESE)
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_PASTE_DIALOG_JP), hWnd, DlgProcPasteSettings );
			else
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_PASTE_DIALOG), hWnd, DlgProcPasteSettings );
			keyboard_hookstart( hWnd, mz2000 );
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_LANGUAGE_AUTO :
			mz -> language = UILANG_AUTOMATIC;
			MessageBox( hWnd, "Please restart this application after change this", DLGTITLE,
				MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
			break;
		case ID_MENU_LANGUAGE_ENGLISH :
			mz -> language = UILANG_ENGLISH;
			MessageBox( hWnd, "Please restart this application after change this", DLGTITLE,
				MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
			break;
		case ID_MENU_LANGUAGE_JAPANESE :
			mz -> language = UILANG_JAPANESE;
			MessageBox( hWnd, "Please restart this application after change this", DLGTITLE,
				MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
			break;
		case ID_MENU_EXIT :
			PostMessage( hWnd, WM_CLOSE, 0, 0L );
			break;
		case ID_MENU_TAPE :
			open_tapefile( hWnd, mz2000 );
			playview_add_redrawct();
			break;
		case ID_MENU_TAPE_EJECT :
			setplaystop( mz, TRUE );
			mz2tape_eject( mz2000, TRUE );
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_TAPE_STOP :
			setplaystop( mz, TRUE );
			mz2tape_stop( mz2000 );
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_TAPE_REW :
			setplaystop( mz, TRUE );
			mz2tape_rew( mz2000 );
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_TAPE_FF :
			setplaystop( mz, TRUE );
			mz2tape_ff( mz2000 );
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_TAPE_REWIND :
			setplaystop( mz, TRUE );
			mz2tape_head( mz2000 );
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_TAPE_SETTING :
			setplaystop( mz, TRUE );
			keyboard_hookend( hWnd, mz2000 );
			if (mz2000 -> currentlanguage == UILANG_JAPANESE)
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_TAPE_DIALOG_JP), hWnd, DlgProcTape );
			else
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_TAPE_DIALOG), hWnd, DlgProcTape );
			keyboard_hookstart( hWnd, mz2000 );
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_TAPESPEAKER :
			mz2000 -> tapespeaker = !mz2000 -> tapespeaker;
			break;
		case ID_MENU_TAPECOUNTER_2080 :
			mz2000 -> tapecounter = TAPE_COUNTERMODE_MZ2080;
			break;
		case ID_MENU_TAPECOUNTER_2500 :
			mz2000 -> tapecounter = TAPE_COUNTERMODE_MZ2500;
			break;
		case ID_MENU_TAPECOUNTER_KB :
			mz2000 -> tapecounter = TAPE_COUNTERMODE_KBYTES;
			break;
		case ID_MENU_TAPECOUNTER_BYTES :
			mz2000 -> tapecounter = TAPE_COUNTERMODE_BYTES;
			break;
		case ID_MENU_DROPAUTOIPLTAPE :
			mz2000 -> dropautoipltape = !mz2000 -> dropautoipltape;
			break;
		case ID_MENU_TAPESOUND :
			mz2000 -> enable_soundtape = !mz2000 -> enable_soundtape;
			sound_reset( mz2000 );
			break;
		case ID_MENU_DISK1 :
		case ID_MENU_DISK2 :
		case ID_MENU_DISK3 :
		case ID_MENU_DISK4 :
			{
				int d88flag, roflag, driveno;
				OPENFILENAME ofn;
				char *cp, szFileName[MAX_PATH];
				char tbuf[LNMAX];

				setplaystop( mz, TRUE );
				switch (LOWORD(wParam)) {
				case ID_MENU_DISK2 :
					driveno = 1;
					break;
				case ID_MENU_DISK3 :
					driveno = 2;
					break;
				case ID_MENU_DISK4 :
					driveno = 3;
					break;
				default : /* ID_MENU_DISK1 */
					driveno = 0;
					break;
				}
				if (!disk_eject( mz2000, driveno, DISK_EJECT_CHECKONLY )) {
					setplaystop( mz, FALSE );
					break;
				}
				strncpy( szFileName, disk_getdefpath( mz2000, driveno ), MAX_PATH );
				szFileName[MAX_PATH - 1] = '\0';
				memset( &ofn, 0, sizeof(OPENFILENAME) );
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hWnd;
				ofn.lpstrFilter =
					"Disk images D88 (*.d88 *.d20 *.d77)\0*.d88;*.d20;*.d77\0"
					"Disk images 2D (*.2d)\0*.2d\0"
					"Disk images DSK (*.dsk)\0*.dsk\0"
					"All Files (*.*)\0*.*\0\0";
				ofn.lpstrFile = szFileName;
				ofn.lpstrFileTitle = NULL;
				ofn.nMaxFile = MAX_PATH;
				ofn.Flags = OFN_FILEMUSTEXIST /* | OFN_HIDEREADONLY */;
				cp = strrchr( szFileName, '.' );
				if (cp) {
					cp++;
					if (!stricmp( cp, "d88" )) {
						ofn.nFilterIndex = 1;
						ofn.lpstrDefExt = "d88";
					} else if (!stricmp( cp, "d20" )) {
						ofn.nFilterIndex = 1;
						ofn.lpstrDefExt = "d20";
					} else if (!stricmp( cp, "d77" )) {
						ofn.nFilterIndex = 1;
						ofn.lpstrDefExt = "d77";
					} else if (!stricmp( cp, "2d" )) {
						ofn.nFilterIndex = 2;
						ofn.lpstrDefExt = "2d";
					} else if (!stricmp( cp, "dsk" )) {
						ofn.nFilterIndex = 3;
						ofn.lpstrDefExt = "dsk";
					} else {
						ofn.nFilterIndex = 4;
						ofn.lpstrDefExt = "";
					}
				} else {
					ofn.nFilterIndex = 1;
					ofn.lpstrDefExt = "d88";
				}
				_snprintf( tbuf, LNMAX, "Select a disk image file for drives %d", driveno + 1 );
				tbuf[LNMAX-1] = '\0';	/* VC6 is not C99 */
				ofn.lpstrTitle = tbuf;
				if (GetOpenFileName(&ofn)) {
					char *p;

					if (!disk_eject( mz2000, driveno, DISK_EJECT_FORCE ))
						break;
					d88flag = FALSE;
					p = strrchr( szFileName, '.' );
					if (!p) {
						MessageBox( mz2000->ghWnd, "A no extentions filename specified", DLGTITLE,
							MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
						setplaystop( mz, FALSE );
						break;
					}
					p++;
					if (!stricmp( p, "d88" ))
						d88flag = TRUE;
					else if (!stricmp( p, "d77" ))
						d88flag = TRUE;
					else if (!stricmp( p, "d20" ))
						d88flag = TRUE;
					else if (!stricmp( p, "dsk" ))
						d88flag = TRUE;
					else if (!stricmp( p, "2d" ))
						;
					else {
						MessageBox( mz2000->ghWnd, "A unknown extention filename found", DLGTITLE,
							MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
						setplaystop( mz, FALSE );
						break;
					}
					roflag = mz -> forcereadonly ? TRUE : (ofn.Flags & OFN_READONLY ? TRUE : FALSE);
					disk_change( mz2000, driveno, szFileName, d88flag, FALSE, roflag );
				}
				playview_add_redrawct();
				setplaystop( mz, FALSE );
			}
			break;
		case ID_MENU_DISK1_UPDATE :
		case ID_MENU_DISK2_UPDATE :
		case ID_MENU_DISK3_UPDATE :
		case ID_MENU_DISK4_UPDATE :
			{
				int driveno;

				setplaystop( mz, TRUE );
				switch (LOWORD(wParam)) {
				case ID_MENU_DISK2_UPDATE :
					driveno = 1;
					break;
				case ID_MENU_DISK3_UPDATE :
					driveno = 2;
					break;
				case ID_MENU_DISK4_UPDATE :
					driveno = 3;
					break;
				default : /* ID_MENU_DISK1_UPDATE */
					driveno = 0;
					break;
				}
				disk_writeback( mz2000, driveno );
				playview_add_redrawct();
				setplaystop( mz, FALSE );
			}
			break;
		case ID_MENU_DISK1_EJECT :
		case ID_MENU_DISK2_EJECT :
		case ID_MENU_DISK3_EJECT :
		case ID_MENU_DISK4_EJECT :
			{
				int driveno;

				setplaystop( mz, TRUE );
				switch (LOWORD(wParam)) {
				case ID_MENU_DISK2_EJECT :
					driveno = 1;
					break;
				case ID_MENU_DISK3_EJECT :
					driveno = 2;
					break;
				case ID_MENU_DISK4_EJECT :
					driveno = 3;
					break;
				default : /* ID_MENU_DISK1_EJECT */
					driveno = 0;
					break;
				}
				disk_eject( mz2000, driveno, DISK_EJECT_NORMAL );
				playview_add_redrawct();
				setplaystop( mz, FALSE );
			}
			break;
		case ID_MENU_FDDIF :
			mz2000 -> enable_fddif = !mz2000 -> enable_fddif;
			break;
		case ID_MENU_DISKFAST :
			mz2000 -> fd_exec_fast = !mz2000 -> fd_exec_fast;
			disk_setparam( mz2000 -> fd_exec_fast, -1, -1 );
			break;
		case ID_MENU_DISKIGNORECRC :
			mz2000 -> fd_ignore_crc = !mz2000 -> fd_ignore_crc;
			disk_setparam( -1, mz2000 -> fd_ignore_crc, -1 );
			break;
		case ID_MENU_DISKERASESCT17 :
			mz2000 -> fd_erase_sct17crc = !mz2000 -> fd_erase_sct17crc;
			disk_setparam( -1, -1, mz2000 -> fd_erase_sct17crc );
			break;
		case ID_MENU_DROPTOFD2 :
			mz2000 -> droptofd2 = !mz2000 -> droptofd2;
			break;
		case ID_MENU_DROPAUTOIPL :
			mz2000 -> dropautoipl = !mz2000 -> dropautoipl;
			break;
		case ID_MENU_FDDSOUND :
			mz2000 -> enable_soundfdd = !mz2000 -> enable_soundfdd;
			sound_reset( mz2000 );
			break;
		case ID_MENU_QDCHANGE :
			{
				int ftype, roflag;
				OPENFILENAME ofn;
				char *cp, szFileName[MAX_PATH];
				char tbuf[LNMAX];

				setplaystop( mz, TRUE );
				if (!plugin_device_eject( PLUGIN_DEVICETYPE_QD, 0, PLUGIN_DEVICEEJECT_CHECKONLY )) {
					setplaystop( mz, FALSE );
					break;
				}
				strncpy( szFileName, (char *)mz->qfilename, MAX_PATH );
				szFileName[MAX_PATH - 1] = '\0';
				memset( &ofn, 0, sizeof(OPENFILENAME) );
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hWnd;
				ofn.lpstrFilter =
					"MZ quick disk images (*.q20)\0*.q20\0"
					"MZ Tape (*.mzt)\0*.mzt\0"
					"All Files (*.*)\0*.*\0\0";
				ofn.lpstrFile = szFileName;
				ofn.lpstrFileTitle = NULL;
				ofn.nMaxFile = MAX_PATH;
				ofn.Flags = OFN_FILEMUSTEXIST /* | OFN_HIDEREADONLY */;
				cp = strrchr( szFileName, '.' );
				if (cp) {
					cp++;
					if (!stricmp( cp, "q20" )) {
						ofn.nFilterIndex = 0;
						ofn.lpstrDefExt = "q20";
					} else if (!stricmp( cp, "mzt" )) {
						ofn.nFilterIndex = 1;
						ofn.lpstrDefExt = "mzt";
					} else {
						ofn.nFilterIndex = 2;
						ofn.lpstrDefExt = "";
					}
				} else {
					ofn.nFilterIndex = 0;
					ofn.lpstrDefExt = "q20";
				}
				_snprintf( tbuf, LNMAX, "Select a quick disk image file" );
				tbuf[LNMAX-1] = '\0';	/* VC6 is not C99 */
				ofn.lpstrTitle = tbuf;
				if (GetOpenFileName(&ofn)) {
					char *p;

					if (!plugin_device_eject( PLUGIN_DEVICETYPE_QD, 0, PLUGIN_DEVICEEJECT_FORCE ))
						break;
					ftype = -1;
					p = strrchr( szFileName, '.' );
					if (!p) {
						MessageBox( mz2000->ghWnd, "A no extentions filename found", DLGTITLE,
							MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
						setplaystop( mz, FALSE );
						break;
					}
					p++;
					if (!stricmp( p, "q20" ))
						ftype = 0;
					else if (!stricmp( p, "mzt" ))
						ftype = 1;
					else {
						MessageBox( mz2000->ghWnd, "A unknown type filename extentions found.", DLGTITLE,
							MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
						setplaystop( mz, FALSE );
						break;
					}
					strncpy( (char *)mz -> qfilename, szFileName, MAX_PATH );
					mz -> qfilename[MAX_PATH - 1] = '\0';
					roflag = mz -> forcereadonly ? TRUE : (ofn.Flags & OFN_READONLY ? TRUE : FALSE);
					plugin_device_change( PLUGIN_DEVICETYPE_QD, 0, szFileName, ftype, FALSE, roflag );
				}
				playview_add_redrawct();
				setplaystop( mz, FALSE );
			}
			break;
		case ID_MENU_QDEJECT :
			setplaystop( mz, TRUE );
			plugin_device_eject( PLUGIN_DEVICETYPE_QD, 0, DISK_EJECT_NORMAL );
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_PLUGIN :
			setplaystop( mz, TRUE );
			keyboard_hookend( hWnd, mz2000 );
			if (mz2000 -> currentlanguage == UILANG_JAPANESE)
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_PLUGIN_DIALOG_JP), hWnd, DlgProcPlugin );
			else
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_PLUGIN_DIALOG), hWnd, DlgProcPlugin );
			keyboard_hookstart( hWnd, mz2000 );
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_KEY_EX1 :
			if (!(mz2000->keyboard_mode & 0x01U)) {
				mz2000->keyboard_mode &= ~0x03U;
				mz2000->keyboard_mode |= 0x01U;
			} else
				mz2000->keyboard_mode &= ~0x03U;
			keyboard_setkeymode( mz2000->keyboard_mode );
			break;
		case ID_MENU_KEY_EX2 :
			if (!(mz2000->keyboard_mode & 0x02U)) {
				mz2000->keyboard_mode &= ~0x03U;
				mz2000->keyboard_mode |= 0x02U;
			} else
				mz2000->keyboard_mode &= ~0x03U;
			keyboard_setkeymode( mz2000->keyboard_mode );
			break;
		case ID_MENU_KEY_EX3 :
			if (!(mz2000->keyboard_mode & 0x04U))
				mz2000->keyboard_mode |= 0x04U;
			else
				mz2000->keyboard_mode &= ~0x04U;
			keyboard_setkeymode( mz2000->keyboard_mode );
			break;
		case ID_MENU_KEY_EX4 :
			if (!(mz2000->keyboard_mode & 0x08U)) {
				mz2000->keyboard_mode &= ~0x10U;
				mz2000->keyboard_mode |= 0x08U;
			} else
				mz2000->keyboard_mode &= ~0x08U;
			keyboard_setkeymode( mz2000->keyboard_mode );
			break;
		case ID_MENU_KEY_EX5 :
			if (!(mz2000->keyboard_mode & 0x10U)) {
				mz2000->keyboard_mode &= ~0x08U;
				mz2000->keyboard_mode |= 0x10U;
			} else
				mz2000->keyboard_mode &= ~0x10U;
			keyboard_setkeymode( mz2000->keyboard_mode );
			break;
		case ID_MENU_KEY_EX6 :
			if (!(mz2000->keyboard_mode & 0x20U)) {
				mz2000->keyboard_mode |= 0x20U;
			} else
				mz2000->keyboard_mode &= ~0x20U;
			keyboard_setkeymode( mz2000->keyboard_mode );
			break;
		case ID_MENU_GREEN :
			screen_setmonitor( mz2000, FALSE );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				playview_add_redrawct();
			}
			break;
		case ID_MENU_COLOR :
			screen_setmonitor( mz2000, TRUE );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				playview_add_redrawct();
			}
			break;
		case ID_MENU_15KHz :
			if (mz2000 -> font_select == TEXTFONT_400LINE) {
				if (mzfont8_have)
					mz2000 -> font_select = TEXTFONT_200LINE;
				fontSel( mz2000 -> font_select );
			}
			screen_sethighreso( mz2000, FALSE );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				playview_add_redrawct();
			}
			break;
		case ID_MENU_24KHz :
			screen_sethighreso( mz2000, TRUE );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				playview_add_redrawct();
			}
			break;
		case ID_MENU_FONTH16 :
			if (mz2000 -> font_select == TEXTFONT_400LINE) {
				if (mzfont8_have)
					mz2000 -> font_select = TEXTFONT_200LINE;
				fontSel( mz2000 -> font_select );
			} else {
				if (mzfont16_have) {
					screen_sethighreso( mz2000, TRUE );
					mz2000 -> font_select = TEXTFONT_400LINE;
					fontSel( mz2000 -> font_select );
				}
			}
			screen_sethighreso( mz2000, mz2000 -> screen_highreso );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				playview_add_redrawct();
			}
			break;
		case ID_MENU_FONTENGLISH :
			mz2000 -> font_english = !mz2000 -> font_english;
			screen_setfontlang( mz2000, mz2000 -> font_english );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				playview_add_redrawct();
			}
			break;
		case ID_MENU_CLOCK_4MHz :
			mz2000->nowZ80Clock = 4000;
			setspeed_z80( mz2000->nowZ80Clock );
			break;
		case ID_MENU_CLOCK_6MHz :
			mz2000->nowZ80Clock = 6000;
			setspeed_z80( mz2000->nowZ80Clock );
			break;
		case ID_MENU_CLOCK_8MHz :
			mz2000->nowZ80Clock = 8000;
			setspeed_z80( mz2000->nowZ80Clock );
			break;
		case ID_MENU_CLOCK_400MHz :
			mz2000->nowZ80Clock = 400000;
			setspeed_z80( mz2000->nowZ80Clock );
			break;
		case ID_MENU_CLOCK :
			setplaystop( mz, TRUE );
			keyboard_hookend( hWnd, mz2000 );
			{
				BOOL r;

				if (mz2000 -> currentlanguage == UILANG_JAPANESE)
					r = DialogBox( mz2000->ghInstance,
						MAKEINTRESOURCE(IDD_CLOCK_DIALOG_JP), hWnd, DlgProcClock );
				else
					r = DialogBox( mz2000->ghInstance,
						MAKEINTRESOURCE(IDD_CLOCK_DIALOG), hWnd, DlgProcClock );
				if (r)
					setspeed_z80( mz2000->nowZ80Clock );
			}
			keyboard_hookstart( hWnd, mz2000 );
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_CONSOLERCBLANK :
			mz2000 -> consoler_cblank = !mz2000 -> consoler_cblank;
			screen_setreverse( mz2000, -1 );
			break;
		case ID_MENU_VBLANKSPECIAL :
			mz2000 -> vblankspecial = !mz2000 -> vblankspecial;
			break;
		case ID_MENU_FORCEREADONLY :
			mz2000 -> forcereadonly = !mz2000 -> forcereadonly;
			break;
		case ID_MENU_ENINITRESET :
			mz2000 -> enable_initreset = !mz2000 -> enable_initreset;
			break;
		case ID_MENU_IPLMEMCLR :
			mz2000 -> iplmemclr = !mz2000 -> iplmemclr;
			break;
		case ID_MENU_IPLMEMZCLR :
			mz2000 -> iplmemzclr = !mz2000 -> iplmemzclr;
			break;
		case ID_MENU_DEVICECONFIG :
			setplaystop( mz, TRUE );
			keyboard_hookend( hWnd, mz2000 );
			{
				BOOL r;

				if (mz2000 -> currentlanguage == UILANG_JAPANESE)
					r = DialogBox( mz2000->ghInstance,
						MAKEINTRESOURCE(IDD_DEVICE_DIALOG_JP), hWnd, DlgProcDeviceConfig );
				else
					r = DialogBox( mz2000->ghInstance,
						MAKEINTRESOURCE(IDD_DEVICE_DIALOG), hWnd, DlgProcDeviceConfig );
				if (r) {
#ifdef ENABLE_RESTART_SOUNDSETTINGS
					if (os_runmode != WOV_WIN8_10) {
#endif
						WaitForSingleObject( hViewMutex, INFINITE );
						sound_updateparams( hWnd, mz );
						ReleaseMutex( hViewMutex );
#ifdef ENABLE_RESTART_SOUNDSETTINGS
					} else {
						MessageBox( hWnd, "Please restart this application after change sound parameters on Windows 8/8.1/10 and higher", DLGTITLE,
							MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
					}
#endif
				}
			}
			keyboard_hookstart( hWnd, mz2000 );
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		case ID_MENU_SOUNDMODE :
			mz2000 -> soundmode = !mz2000 -> soundmode;
			sound_reset( mz2000 );
			break;
		case ID_MENU_SOUNDITPOLATIONS :
			{
				int r;
				r = getspeed_z80();
				mz2000 -> enable_soundtminterpolations = !mz2000 -> enable_soundtminterpolations;
				if (r > 0)
					setspeed_z80( r );
			}
			sound_reset( mz2000 );
			break;
		case ID_MENU_WINSIZE100 :
		case ID_MENU_WINSIZE150 :
		case ID_MENU_WINSIZE200 :
			{
				int n;
				RECT rect;

				switch (LOWORD(wParam)) {
				case ID_MENU_WINSIZE150 :
					n = 15;
					break;
				case ID_MENU_WINSIZE200 :
					n = 20;
					break;
				default : /* ID_MENU_WINSIZE100 */
					n = 10;
					break;
				}
				screen_window_width = MZ2000_DISPLAY_WIDTH * n / 10;
				screen_window_height = MZ2000_DISPLAY_HEIGHT * n / 10;
				GetWindowRect( mz -> ghWnd, &rect );
				winpos_x = rect.left;
				winpos_y = rect.top;
				SetWindowPos( mz -> ghWnd, HWND_NOTOPMOST, winpos_x, winpos_y,
#ifdef ENABLE_RESIZE
					screen_window_width + GetSystemMetrics(SM_CXSIZEFRAME)*2 +
						GetSystemMetrics(SM_CXEDGE)*2,
					screen_window_height + GetSystemMetrics(SM_CYCAPTION) +
						GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
						GetSystemMetrics(SM_CYSIZEFRAME)*2 +
						GetSystemMetrics(SM_CYEDGE)*2,
#else
					MZ2000_DISPLAY_WIDTH + GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
						GetSystemMetrics(SM_CXEDGE)*2,
					MZ2000_DISPLAY_HEIGHT + GetSystemMetrics(SM_CYCAPTION) +
						GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
						GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
						GetSystemMetrics(SM_CYEDGE)*2,
#endif
					SWP_SHOWWINDOW );
#ifdef ENABLE_STATUSBAR_MW
				MoveWindow( mz -> ghStatusBar, 0, MZ2000_DISPLAY_HEIGHT,
						MZ2000_DISPLAY_WIDTH, GetSystemMetrics(SM_CYMENU), TRUE );
#endif
			}
			break;
		case ID_MENU_FULLSCREEN :
			if (g_setwinsize_ct <= 0)
				change_fullscreen( mz2000 );
			break;
#ifdef ENABLE_D3D
		case ID_MENU_WINDOW_GDI:
		case ID_MENU_WINDOW_D3D:
		case ID_MENU_WINDOW_D3DF:
			gbD3D = ( LOWORD(wParam) == ID_MENU_WINDOW_GDI ) ? FALSE : TRUE;
			gbD3DF = (gbD3D && (LOWORD(wParam) == ID_MENU_WINDOW_D3D )) ? FALSE : TRUE;
			gbRedraw = TRUE;
			InvalidateRect(hWnd, NULL, FALSE);
			break;
		default:
			{
				UINT	tmp;
				tmp = RPICheck(LOWORD(wParam));
				if (tmp != 0xffffffff) {
					if (gdwRPI != tmp) {
						CheckMenuItem(GetMenu(hWnd), 44000 + gdwRPI, MF_UNCHECKED);
						gdwRPI = tmp;
						CheckMenuItem(GetMenu(hWnd), 44000 + gdwRPI, MF_CHECKED);
						gbRedraw = TRUE;
//						if (IsWindow(ghWndChild))
//							InvalidateRect( ghWndChild, NULL, FALSE);
					}
				}
				break;
			}
#endif
		case ID_MENU_ABOUT :
			setplaystop( mz, TRUE );
			keyboard_hookend( hWnd, mz2000 );
			if (mz2000 -> currentlanguage == UILANG_JAPANESE)
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_VERSION_DIALOG_JP), hWnd, DlgProcVersion );
			else
				DialogBox( mz2000->ghInstance,
					MAKEINTRESOURCE(IDD_VERSION_DIALOG), hWnd, DlgProcVersion );
			keyboard_hookstart( hWnd, mz2000 );
			playview_add_redrawct();
			setplaystop( mz, FALSE );
			break;
		}
		break;
	case WM_EXITMENULOOP :
		setplaystop( mz, FALSE );
		if (bFullScreen) {
			PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
			playview_add_redrawct();
		}
		break;
	case WM_ACTIVATEAPP :
		//_TRACE( "ACTIVATEAPP: %08lx %08lx\n", wParam, lParam );
		if (wParam) {
			keyboard_hookstart( hWnd, mz2000 );
			if (bFullScreen) {
				PostMessage( mz->ghWnd, WM_PAINT, 0, 0 );
				g_directredraw_ct = MZ_DIRECTDRAW_REDRAWCT_DEFAULT2;
			}
		} else
			keyboard_hookend( hWnd, mz2000 );
		break;
	case WM_CREATE :
		/* Window and GDI */
		mz2000 -> ghWnd = hWnd;
		mz2000 -> ghStatusBar = CreateWindowEx( 0,
			"msctls_statusbar32", "", WS_CHILD | WS_VISIBLE,
			CW_USEDEFAULT, CW_USEDEFAULT,
			CW_USEDEFAULT, CW_USEDEFAULT,
			hWnd, NULL, mz2000 -> ghInstance, NULL );
		{
			RECT rect;

			GetWindowRect( mz -> ghStatusBar, &rect );
			g_statusbar_height = rect.bottom - rect.top;
			GetWindowRect( mz -> ghWnd, &rect );
			winpos_x = rect.left;
			winpos_y = rect.top;
			SetWindowPos( mz -> ghWnd, HWND_NOTOPMOST, winpos_x, winpos_y,
#ifdef ENABLE_RESIZE
				screen_window_width + GetSystemMetrics(SM_CXSIZEFRAME)*2 +
					GetSystemMetrics(SM_CXEDGE)*2,
				screen_window_height + GetSystemMetrics(SM_CYCAPTION) +
					GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
					GetSystemMetrics(SM_CYSIZEFRAME)*2 +
					GetSystemMetrics(SM_CYEDGE)*2,
#else
				MZ2000_DISPLAY_WIDTH + GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
					GetSystemMetrics(SM_CXEDGE)*2,
				MZ2000_DISPLAY_HEIGHT + GetSystemMetrics(SM_CYCAPTION) +
					GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
					GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
					GetSystemMetrics(SM_CYEDGE)*2,
#endif
				SWP_SHOWWINDOW );
#ifdef ENABLE_STATUSBAR_MW
			MoveWindow( mz -> ghStatusBar, 0, MZ2000_DISPLAY_HEIGHT,
					MZ2000_DISPLAY_WIDTH, GetSystemMetrics(SM_CYMENU), TRUE );
#endif
		}
		mz2000->gdimem = CreateOffScreen( mz2000 );
		viewarea.hmutex = CreateMutex( NULL, FALSE, "EmuZ_2000_VIEW_Mutex" );
		g_hFSStatusBarFont = CreateFont( 15, 0, 0, 0, FW_NORMAL, FALSE, FALSE, 0,
			ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, DEFAULT_PITCH, "Arial" );
		/* sound modules */
		sound_init( hWnd, mz2000 );
		/* the extend boards plugins supports */
		plugin_initialize_board();
		/* copy/paste */
		copypaste_init();
		/* system timers */
		timeBeginPeriod( 1 );
		timerid = timeSetEvent( MZ2000_REFRESHRATE, 0,
			playTimer, (DWORD)mz2000, TIME_PERIODIC );
		/* key hooks */
		keyboard_setkeymode( mz2000->keyboard_mode );
		keyboard_hookstart( hWnd, mz2000 );
		/* set the resolutions */
		screen_sethighreso( mz2000, mz2000 -> screen_highreso );
		/* Set the colors (green/color) */
		screen_setgreencolor( mz2000,
			mz2000 -> greencolor_nfr, mz2000 -> greencolor_nfg, mz2000 -> greencolor_nfb,
			mz2000 -> greencolor_nbr, mz2000 -> greencolor_nbg, mz2000 -> greencolor_nbb,
			mz2000 -> greencolor_rfr, mz2000 -> greencolor_rfg, mz2000 -> greencolor_rfb,
			mz2000 -> greencolor_rbr, mz2000 -> greencolor_rbg, mz2000 -> greencolor_rbb );
		/* IME OFF */
		{
			HIMC hIMC = ImmAssociateContext( hWnd, (HIMC)NULL );
			if (hIMC)
				ImmDestroyContext( hIMC );
		}
		/* etc. */
		DragAcceptFiles( hWnd, TRUE );
		break;
	case WM_SIZE :
#ifdef ENABLE_RESIZE
		if (!bFullScreen) {
			int sx = LOWORD(lParam);
			int sy = HIWORD(lParam);

			sy -= g_statusbar_height;
#ifdef ENABLE_STATUSBAR_MW
			MoveWindow( mz -> ghStatusBar, 0, sy,
					sx, GetSystemMetrics(SM_CYMENU), TRUE );
#endif
			PostMessage( mz -> ghStatusBar, WM_SIZE, wParam, lParam );
			screen_window_width = sx;
			screen_window_height = sy;
			_TRACE("%d %d\n", sx, sy);
#ifdef ENABLE_D3D
			if (IsWindow(ghWndChild))
				MoveWindow( ghWndChild, 0, 0, LOWORD(lParam), HIWORD(lParam) - g_statusbar_height, TRUE);
#endif
		}
#endif /* ENABLE_RESIZE */
		break;
	case WM_CLOSE :
		{
			int i, r, qflag = FALSE;
			char buf[LNMAX];

			setplaystop( mz, TRUE );
			r = mz2tape_getstatus( NULL, NULL, NULL, NULL, NULL, NULL );
			if (r != MZ2TAPE_RUNMODE_STOP && r != MZ2TAPE_RUNMODE_EJECT) {
				_snprintf( buf, LNMAX, "Now a cassette tape deck is running. Stop it ?" );
				r = MessageBox( mz->ghWnd, buf, DLGTITLE, MB_YESNOCANCEL | MB_DEFBUTTON3 | MB_ICONQUESTION | MB_APPLMODAL );
				if (r == IDCANCEL || r == IDNO) {
					setplaystop( mz, FALSE );
					break;
				}
			}
			mz2tape_stop( mz );
			for (i = 0; i < MZ_DISK_DRIVE_MAX; i++) {
				if (!disk_getmodified( mz, i ))
					continue;
				_snprintf( buf, LNMAX, "A drives %d image was modified. Writeback to \"%s\" ?",
					i + 1, disk_getfnptr( mz, i ) );
				buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
				r = MessageBox( mz->ghWnd, buf, DLGTITLE, MB_YESNOCANCEL | MB_DEFBUTTON3 | MB_ICONQUESTION | MB_APPLMODAL );
				if (r == IDCANCEL) {
					qflag = TRUE;
					break;
				}
				if (r == IDYES)
					disk_writeback( mz, i );
			}
			if (qflag) {
				setplaystop( mz, FALSE );
				break;
			}
			if (plugin_device_getinterface( PLUGIN_DEVICETYPE_QD )) {
				r = plugin_device_getrunningstatus( PLUGIN_DEVICETYPE_QD, 0 );
				if (r) {
					_snprintf( buf, LNMAX, "Now a quick disk drive is running. Quit OK ?" );
					r = MessageBox( mz->ghWnd, buf, DLGTITLE, MB_YESNOCANCEL | MB_DEFBUTTON3 | MB_ICONQUESTION | MB_APPLMODAL );
					if (r == IDCANCEL || r == IDNO) {
						setplaystop( mz, FALSE );
						break;
					}
				}
			}
		}
		return DefWindowProc( hWnd, msg, wParam, lParam );
	case WM_DESTROY :
		if (app_currentpath[0])
			SetCurrentDirectory( app_currentpath );
		copypaste_pasteend( TRUE );
		save_configuration( mz2000 );
		playDestroy = TRUE;
		setplaystop( mz, TRUE );
		if (mz2000 -> mainloop_thread_handle) {
			WaitForSingleObject( mz2000 -> mainloop_thread_handle, MZ2000_REFRESHRATE * 5 /* ms */ );
			CloseHandle( mz2000 -> mainloop_thread_handle );
			mz2000 -> mainloop_thread_handle = NULL;
		}
		if (mz2000 -> playview_thread_handle) {
			WaitForSingleObject( mz2000 -> playview_thread_handle, MZ2000_REFRESHRATE * 5 /* ms */ );
			CloseHandle( mz2000 -> playview_thread_handle );
			mz2000 -> playview_thread_handle = NULL;
		}
		//if (os_runmode == WOV_WIN9X)
		//	Sleep( 200 );
		plugin_finalize_board();	/* the extend boards plugins supports */
		stop_z80();
		if (mz2000->ghStatusBar) {
			DestroyWindow( mz2000 -> ghStatusBar );
			mz2000 -> ghStatusBar = NULL;
		}
		if (bFullScreen) {
			DDrawRelease( mz2000->ghWnd );
			ShowCursor( TRUE );
			Sleep( 200 );
		}
		timeKillEvent( timerid );
		timeEndPeriod( MZ2000_REFRESHRATE );
		copypaste_exit();
		if (g_hFSStatusBarFont) {
			DeleteObject( g_hFSStatusBarFont );
			g_hFSStatusBarFont = NULL;
		}
		sound_exit( mz2000 );
		{
			int ct;

			for (ct = 30; !playDestroy_view && ct > 0; --ct)
				Sleep( 100 );
			if (ct >= 20)
				Sleep( (ct - 20) * 100);
		}
		keyboard_hookend( hWnd, mz2000 );
		FreeOffScreen( mz2000 );
		z80_exit();
		memory_exit( mz2000 );
		keyboard_exit( mz2000 );
		disk_exit( mz2000 );
		tape_exit( mz2000 );
		io_exit( mz2000 );
		screen_exit( mz2000 );
		if (mz2000 -> iplrom2000) {
			FREE( mz2000 -> iplrom2000 );
			mz2000 -> iplrom2000 = NULL;
		}
		if (mz2000 -> iplrom80b) {
			FREE( mz2000 -> iplrom80b );
			mz2000 -> iplrom80b = NULL;
		}
		if (mz2000 -> iplmon) {
			FREE( mz2000 -> iplmon );
			mz2000 -> iplmon = NULL;
		}
		if (hViewMutex) {
			CloseHandle( hViewMutex );
			hViewMutex = NULL;
		}
		if (viewarea.hmutex) {
			CloseHandle(viewarea.hmutex);
			viewarea.hmutex = NULL;
		}
#ifdef ENABLE_D3D
		DestroyWindow( ghWndChild );
#endif
		PostQuitMessage(0);
		break;
	case WM_PAINT :
		if (*commandline_param != '\0') {
			/* read the drag and drops */
			if (!(z80.external_signal & RESET_SIGNAL)) {	/* Wait RESET */
				strncpy( (char *)mz -> sfilename, commandline_param, MAX_PATH );
				mz -> sfilename[MAX_PATH - 1] = '\0';
				*commandline_param = '\0';
				load_state( mz->ghWnd, mz, TRUE );
			}
		}
		if (!(mz2000 -> playStop)) {
#if 0
			RECT rect;

			GetUpdateRect( hWnd, &rect, FALSE );
			if ((!rect.left && !rect.top && !rect.right && !rect.bottom)
				|| (!rect.left && !rect.top
					&& rect.right == MZ2000_DISPLAY_WIDTH
					&& rect.bottom == MZ2000_DISPLAY_HEIGHT)) {
#endif
				mz2000 -> viewChg = TRUE;
				PaletteChange( mz2000 );
#if 0
			} else
				screen_region_add_all( mz2000 );
#endif
			WaitForSingleObject( hViewMutex, INFINITE );
			if (!bFullScreen)
				ShowMyText( hWnd, mz2000 );
			else
				DDrawUpdateScreen( hWnd, mz2000, TRUE );
			ReleaseMutex( hViewMutex );
		}
		return DefWindowProc( hWnd, msg, wParam, lParam );
	case WM_DROPFILES :
		{
			int r;
			HDROP hDrop;
			UINT uFileNo;
			char *p, szFileName[MAX_PATH];

			setplaystop( mz, TRUE );
			hDrop = (HDROP)wParam;
			uFileNo = DragQueryFile( (HDROP)hDrop, 0xFFFFFFFF, NULL, 0 );
			DragQueryFile( hDrop, 0, szFileName, MAX_PATH );
			p = strrchr( szFileName, '.' );
			if (!p) {
				MessageBox( mz2000->ghWnd, "A no extentions filename found", DLGTITLE,
					MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
			} else {
				p++;
				if (!stricmp( p, "d88" ) || !stricmp( p, "d20" ) || !stricmp( p, "d77" ) || !stricmp( p, "dsk" )) {
					disk_change( mz2000, mz2000 -> droptofd2 ? 1 : 0, szFileName, TRUE, FALSE, mz2000 -> forcereadonly );
					if (mz2000 -> dropautoipl && !(mz2000 -> droptofd2)) {
						mz2000 -> needIpl = TRUE;
						stop_z80();
					}
				} else if (!stricmp( p, "2d" )) {
					disk_change( mz2000, mz2000 -> droptofd2 ? 1 : 0, szFileName, FALSE, FALSE, mz2000 -> forcereadonly );
					if (mz2000 -> dropautoipl && !(mz2000 -> droptofd2)) {
						mz2000 -> needIpl = TRUE;
						stop_z80();
					}
				} else if (!stricmp( p, "q20" )) {
					strncpy( (char *)mz -> qfilename, szFileName, MAX_PATH );
					mz -> qfilename[MAX_PATH - 1] = '\0';
					plugin_device_change( PLUGIN_DEVICETYPE_QD, 0, szFileName, 0, FALSE, mz2000 -> forcereadonly );
				} else if (!stricmp( p, "mze" ) || !stricmp( p, "emuz" )) {
					strncpy( (char *)mz2000 -> sfilename, szFileName, MAX_PATH );
					mz2000 -> sfilename[MAX_PATH - 1] = '\0';
					load_state( mz->ghWnd, mz, TRUE );
				} else {
					strncpy( (char *)mz2000 -> tfilename, szFileName, MAX_PATH );
					mz2000 -> tfilename[MAX_PATH - 1] = '\0';
					r = mz2tape_exec( mz2000, szFileName, mz2000 -> forcereadonly );
					if (r <= MZ2TAPE_FILEMODE_ERRNDLG) {
						MessageBox( mz2000->ghWnd, "A unknown type extentions filename found", DLGTITLE,
							MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
					}
					if (r == MZ2TAPE_FILEMODE_MTI || r == MZ2TAPE_FILEMODE_WAV) {
						if (mz2000 -> dropautoipltape && (!(mz2000 -> enable_fddif) || !(mz2000 -> howipl))) {
							mz2000 -> needIpl = TRUE;
							stop_z80();
						}
					}
				}
			}
			DragFinish(hDrop);
			playview_add_redrawct();
			setplaystop( mz, FALSE );
		}
		break;
	case WM_SYSKEYDOWN :
		if ((lParam & 0xff00ffff) == 0x20000001) {	/* Alt + No repeat */
			if (!checkShortcutKeys( mz2000, wParam, TRUE ))
				return DefWindowProc( hWnd, msg, wParam, lParam );
		}
		result = TRUE;
		break;
	case WM_SYSKEYUP :
#if 0
		if (wParam == VK_MENU)	/* enable to select menu modes */
			return DefWindowProc( hWnd, msg, wParam, lParam );
#endif
		if ((lParam & 0xff000000) == 0x20000000) {	/* Alt */
			if (!checkShortcutKeys( mz2000, wParam, FALSE ))
				return DefWindowProc( hWnd, msg, wParam, lParam );
		}
		result = TRUE;
		break;
	case WM_KEYDOWN :
	case WM_KEYUP :
		keyboard_keyevent( wParam, lParam );
		break;
	case WM_LBUTTONDOWN :
		if (!bFullScreen || bFullScreenMenu)
			return DefWindowProc( hWnd, msg, wParam, lParam );
	case WM_RBUTTONDOWN :
		if (bFullScreen) {
			bFullScreenMenu = !bFullScreenMenu;
			ShowCursor( bFullScreenMenu );
			if (bFullScreenMenu) {
				SetMenu( hWnd, hFullscreenMenu );
				//skipActivateDXreinit += 1;
			} else
				SetMenu( hWnd, NULL );
			//Sleep( 100 );
			RedrawWindow( mz2000 -> ghWnd, NULL, NULL, RDW_INVALIDATE );
			mz2000 -> mzChgGraphMode = TRUE;
			mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
			playview_add_redrawct();
		} else
			return DefWindowProc( hWnd, msg, wParam, lParam );
		break;
	case WM_SYSCOMMAND :
		if (wParam == 0xf100) {
			if (checkShortcutKeys( mz2000, toupper(lParam), FALSE ))
				break;
		}
		return DefWindowProc( hWnd, msg, wParam, lParam );
	default:
		return DefWindowProc( hWnd, msg, wParam, lParam );
	}
	return result;
}

#ifdef ENABLE_D3D
+LRESULT CALLBACK WndProcChild( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch (msg) {
	case WM_CREATE :
//		gbRedraw = TRUE;
		break;
	case WM_DESTROY :
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc( hWnd, msg, wParam, lParam );
	}
	return 0;
}
#endif

BOOL FontReadROM( MZ2000 *mz )
{
	int i, j;
	FILE *fp, *fp2;

	fp  = fopen( FONTROMFILE, "rb" );
	fp2 = fopen( FONTEROMFILE, "rb" );
	if (!fp && !fp2) {
		if (fp)
			fclose( fp );
		if (fp2)
			fclose( fp2 );
		return FALSE;
	}
	for (i = 0; i < 256; i++) {
		for (j = 0; j < 8; j++) {
			int c1, c2;

			if (!fp && !fp2)
				return FALSE;
			if (fp) {
				c1 = getc(fp);
				if (c1 == EOF) {
					if (fp)
						fclose( fp );
					fp = NULL;
				}
				if (fp2)
					c2 = getc( fp2 );
				else
					c2 = c1;
			} else {
				c2 = getc( fp2 );
				if (c2 == EOF) {
					if (fp2)
						fclose( fp2 );
					fp2 = NULL;
				}
				if (fp)
					c1 = getc( fp );
				else
					c1 = c2;
			}
			if (c1 == EOF) {
				if (fp)
					fclose( fp );
				if (fp2)
					fclose( fp2 );
				return FALSE;
			}
			mzfont8[i    ][j] = c1;
			mzfont8[i+256][j] = c2;
		}
	}
	if (fp)
		fclose( fp );
	if (fp2)
		fclose( fp2 );
	mzfont8_have = TRUE;
	return TRUE;
}

BOOL FontRead200( MZ2000 *mz )
{
	int i, x, y, cnt;
	HANDLE hFile;
	DWORD dwReadSize;
	BYTE fontBuf[FONT_BUFFER];

	memset( fontBuf, 0, FONT_BUFFER );
	hFile = CreateFile( FONT200FILE,
		GENERIC_READ, FILE_SHARE_READ,
		NULL, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL, NULL );
	if (hFile == INVALID_HANDLE_VALUE)
		return FALSE;
	ReadFile( hFile, fontBuf, FONT_BUFFER, &dwReadSize, NULL );
	CloseHandle( hFile );
	i = 62;
	for (y = 0;y < 16; y++) {
		for (cnt = 0; cnt < 8; cnt++) {
			for (x = 0; x < 16; x++) {
				mzfont8[(15-y)+x*16    ][7-cnt] = ~fontBuf[i];
				mzfont8[(15-y)+x*16+256][7-cnt] = ~fontBuf[i];
				i++;
			}
		}
	}
	mzfont8_have = TRUE;
	return TRUE;
}

BOOL FontRead400( MZ2000 *mz )
{
	int i, x, y, cnt;
	HANDLE hFile;
	DWORD dwReadSize;
	BYTE fontBuf[FONT_BUFFER];

	memset( fontBuf, 0, FONT_BUFFER );
	hFile = CreateFile( FONT400FILE,
		GENERIC_READ, FILE_SHARE_READ,
		NULL, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL, NULL );
	if (hFile == INVALID_HANDLE_VALUE)
		return FALSE;
	ReadFile( hFile, fontBuf, FONT_BUFFER, &dwReadSize, NULL );
	CloseHandle( hFile );
	i = 62;
	for (y = 0;y < 16; y++) {
		for (cnt = 0; cnt < 16; cnt++) {
			for (x = 0; x < 16; x++) {
				mzfont16[(15-y)+x*16    ][15-cnt] = ~fontBuf[i];
				mzfont16[(15-y)+x*16+256][15-cnt] = ~fontBuf[i];
				i++;
			}
		}
	}
	mzfont16_have = TRUE;
	return TRUE;
}

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPreInst,
	LPSTR lpszCmdLine, int nCmdShow )
{
	HWND hWnd;
	MSG msg;
	WNDCLASS wndclass;
	OSVERSIONINFO os_info;
	char *cp;

	/* Get the Window versions */
	os_info.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );
	GetVersionEx( &os_info );
	if (os_info.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
		os_runmode = WOV_WIN9X;			/* 95/98/ME */
	else if (os_info.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		if (os_info.dwMajorVersion >= 5) {
			unsigned int buildnum = LOWORD(os_info.dwBuildNumber);

			_TRACE("Windows Ver.%u.%u(%u)\n", os_info.dwMajorVersion, os_info.dwMinorVersion, buildnum );
			if (os_info.dwMajorVersion == 5)
				os_runmode = WOV_2000;	/* 2000/XP */
			else
				os_runmode = WOV_VISTA;	/* Vista/7 */
			if (os_info.dwMajorVersion >= 10 || buildnum >= 9000)
				os_runmode = WOV_WIN8_10; /* 8/8.1/10/2012 */
		} else {
			if (os_info.dwMajorVersion < 4) {
				MessageBox( NULL, "NT Ver.3.x is not supported", DLGINITTITLE, MB_OK | MB_ICONSTOP | MB_APPLMODAL );
				return FALSE;
			}
			os_runmode = WOV_NT;		/* NT 4.0 */
		}
	} else if (os_info.dwPlatformId == VER_PLATFORM_WIN32s) {
		MessageBox( NULL, "WIN32s is not supported", DLGINITTITLE, MB_OK | MB_ICONSTOP | MB_APPLMODAL );
		return FALSE;
	} else
		os_runmode = WOV_UNKNOWN;
	if (os_runmode == WOV_UNKNOWN) {
		MessageBox( NULL, "Unknown OS... Use Windows Vista mode", DLGINITTITLE, MB_OK | MB_ICONINFORMATION | MB_APPLMODAL );
		os_runmode = WOV_VISTA;
	}

	/* initializing the MZ-2000 */
	mz2000 = init_mz2000();
	if (!mz2000) {
		MessageBox( NULL, "Initializing Failed (init_mz2000())", DLGINITTITLE, MB_OK | MB_ICONSTOP | MB_APPLMODAL );
		return FALSE;
	}
	mz2000_global = mz2000;
	setspeed_z80( (int)mz2000 -> nowZ80Clock );
	mz2000 -> displayAttr = FALSE;
	mz2000 -> playStop = TRUE;
	mz2000 -> ghInstance = hInstance;
	screen_window_width  = MZ2000_DISPLAY_WIDTH;
	screen_window_height = MZ2000_DISPLAY_HEIGHT;

	mz2000 -> currentlanguage = mz2000 -> language;
	if (mz2000 -> currentlanguage < 0) {
#if 1
		int	len;
		LCID	lcid = GetUserDefaultLCID();
		len = GetLocaleInfo( lcid, LOCALE_SENGLANGUAGE, NULL, 0);
		cp = (char*) GlobalAlloc(GPTR, len + 1);
		if (cp) {
			GetLocaleInfo( lcid, LOCALE_SENGLANGUAGE, cp, len + 1);
			if (!strncmp( cp, "Japanese", 8 ))
				mz2000 -> currentlanguage = UILANG_JAPANESE;
			else
				mz2000 -> currentlanguage = UILANG_ENGLISH;
			GlobalFree(cp);
		}
#else
		cp = setlocale( LC_ALL, ".OCP" );
		_TRACE("setlocale return: %s\n", cp );
		if (!strncmp( cp, "Japanese", 8 ))
			mz2000 -> currentlanguage = UILANG_JAPANESE;
		else
			mz2000 -> currentlanguage = UILANG_ENGLISH;
#endif
	}

	/* initialize a font ROM */
	mz2000 -> use_fontrom = FALSE;
	if (!FontReadROM( mz2000 ))
		FontRead200( mz2000 );
	else
		mz2000 -> use_fontrom = TRUE;
	FontRead400( mz2000 );
	if (!mzfont8_have && !mzfont16_have) {
		MessageBox( NULL, "No all fonts data found, skipping it.", DLGINITTITLE, MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
		memset( mzfont, 0xff, sizeof(mzfont) );
		memset( mzfont, 0, 8*8/8*32 );
		memcpy( mzfont8, mzfont, sizeof(mzfont8) );
		memcpy( mzfont16, mzfont, sizeof(mzfont16) );
		mzfont8_have = TRUE;
	}
	if (!mz2000 -> screen_highreso)
		mz2000 -> font_select = TEXTFONT_200LINE;
	if (mz2000 -> font_select == TEXTFONT_400LINE)
		mz2000 -> screen_highreso = TRUE;
	if (!mzfont8_have && mz2000 -> font_select == TEXTFONT_200LINE) {
		mz2000 -> font_select = TEXTFONT_400LINE;
		mz2000 -> screen_highreso = TRUE;
	}
	if (!mzfont16_have && mz2000 -> font_select == TEXTFONT_400LINE) {
		mz2000 -> font_select = TEXTFONT_200LINE;
		mz2000 -> screen_highreso = FALSE;
	}
	fontSel( mz2000 -> font_select );

	/* create the Windows Application */
	if (!hPreInst) {
		wndclass.style		= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= WndProc;
		wndclass.cbClsExtra	= 0;
		wndclass.cbWndExtra	= 0;
		wndclass.hInstance	= hInstance;
		wndclass.hIcon		= LoadIcon( hInstance, MAKEINTRESOURCE(IDR_MAINFRAME) );
		wndclass.hCursor	= LoadCursor( NULL, IDC_ARROW );
		wndclass.hbrBackground	= GetStockObject( BLACK_BRUSH );
		if (mz2000 -> currentlanguage == UILANG_JAPANESE)
			wndclass.lpszMenuName	= MAKEINTRESOURCE( IDR_MAINFRAME_JP );
		else
			wndclass.lpszMenuName	= MAKEINTRESOURCE( IDR_MAINFRAME );
		wndclass.lpszClassName	= szClassName;
		if (!RegisterClass( &wndclass )) {
			MessageBox( NULL, "Initializing Failed (RegisterClass())", DLGINITTITLE, MB_OK | MB_ICONSTOP | MB_APPLMODAL );
			return FALSE;
		}
	}
	hWnd = CreateWindowEx(
		WS_EX_OVERLAPPEDWINDOW,
		szClassName,
		WINDOWTITLE,
#ifdef ENABLE_RESIZE
		WS_OVERLAPPEDWINDOW,
#else
		WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
#endif
		CW_USEDEFAULT,
		CW_USEDEFAULT,
#ifdef ENABLE_RESIZE
		screen_window_width + GetSystemMetrics(SM_CXSIZEFRAME)*2 +
			GetSystemMetrics(SM_CXEDGE)*2,
		screen_window_height + GetSystemMetrics(SM_CYCAPTION) +
			GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
			GetSystemMetrics(SM_CYSIZEFRAME)*2 +
			GetSystemMetrics(SM_CYEDGE)*2,
#else
		MZ2000_DISPLAY_WIDTH + GetSystemMetrics(SM_CXFIXEDFRAME)*2 +
			GetSystemMetrics(SM_CXEDGE)*2,
		MZ2000_DISPLAY_HEIGHT + GetSystemMetrics(SM_CYCAPTION) +
			GetSystemMetrics(SM_CYMENU) + g_statusbar_height +
			GetSystemMetrics(SM_CYFIXEDFRAME)*2 +
			GetSystemMetrics(SM_CYEDGE)*2,
#endif
		NULL, NULL, hInstance, NULL );
	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );

#ifdef ENABLE_D3D
	wndclass.lpszClassName = "Draw";
	wndclass.lpfnWndProc = WndProcChild;
	wndclass.hIcon = NULL;
	wndclass.hCursor = NULL;
	wndclass.hbrBackground = (HBRUSH) GetStockObject(NULL_BRUSH);
	wndclass.lpszMenuName = NULL;
	if (RegisterClass(&wndclass)) {
		ghWndChild = CreateWindowEx(
			0,
			"Draw",
			"Draw",
			WS_CHILD|WS_VISIBLE,
			0,	//CW_USEDEFAULT,	// x
			0,	//CW_USEDEFAULT,	// y
			MZ2000_DISPLAY_WIDTH,	//640,	// w
			MZ2000_DISPLAY_HEIGHT,	//400,	// h
			hWnd,
			NULL,
			hInstance,
			NULL
		);
	}
#endif

	/* get the screen informations */
	screen_info = NULL;
	if (GetScreenResolutions( hWnd ) < 0) {
		if (screen_info)
			FREE( screen_info );
		MessageBox( NULL, "Initializing Failed (GetScreenResolutions())", DLGINITTITLE, MB_OK | MB_ICONSTOP | MB_APPLMODAL );
		return FALSE;
	}
	if (mz2000 -> fullscreen_device >= screeninfo_maxnum)
		mz2000 -> fullscreen_device = screeninfo_maxnum - 1;
	if (mz2000 -> fullscreen_resolution >= screen_info[mz2000 -> fullscreen_device] . res_maxnum + 1)
		mz2000 -> fullscreen_resolution = screen_info[mz2000 -> fullscreen_device] . res_maxnum;

	/* create the mutexs */
	hViewMutex = CreateMutex( NULL, FALSE, "EmuZ_2000_View_Mutex" );
	if (!hViewMutex) {
		MessageBox( NULL, "Initializing Failed (CreateMutex/EmuZ_2000_View_Mutex)", DLGINITTITLE, MB_OK | MB_ICONSTOP | MB_APPLMODAL );
		return FALSE;
	}

	/* create the threads and the message pumps */
	mz2000 -> mainloop_thread_handle = CreateThread( NULL, 0, mainloop_thread,
		(void *)mz2000, 0, (DWORD *)&mz2000->mainloop_thread_id );
	mz2000 -> playview_thread_handle = CreateThread( NULL, 0, playview_thread,
		(void *)mz2000, 0, (DWORD *)&mz2000->playview_thread_id );

#ifdef ENABLE_D3D
	{
		char moduleFile[MAX_PATH] = "";
		char filename[MAX_PATH] = "";

		GetModuleFileName( NULL, moduleFile, sizeof(moduleFile) );
		_splitpath( moduleFile, NULL, NULL, filename, NULL ) ;
		lstrcat( filename, ".ini" );
		RPICreateMenu( GetMenu(hWnd), IDM_RPI, 44000, &gdwRPI, filename, INISECTIONNAME_BASIC, NULL );
		CheckMenuItem( GetMenu(hWnd), 44000 + gdwRPI, MF_CHECKED );
	}
#endif

	mz2000 -> playStop = FALSE;
	while (GetMessage( &msg, NULL, 0, 0 )) {
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	FREE( (void *)mz2000 );
	if (screen_info)
		FREE( screen_info );

	return msg.wParam;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
