/* File: mz2000.h

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		System Definitions Headders

	Combine the emz2000 mz2000.h, EmuZ-2000 emuz2000.h,
		and extend by FUKUI, Toshio and TSUNEOKA, Shinji.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.

	Caution !!
	This file is including the old EmuZ-2000 program code.
	These are no copyright information and released open source code.
*/

#ifndef __MZ2000_H_INCLUDED
#define __MZ2000_H_INCLUDED

#include "../z80/z80.h"

#define MZ2000_REFRESHRATE		10	/* ms (16 is bad) */
#define MZ2000_DISPLAY_WIDTH		640
#define MZ2000_DISPLAY_HEIGHT		(200 * 2)

#define TIMER8253_USE_INTERNALTIME
#define TIMER8253_COUNTER_MAXNUM	3

typedef unsigned int u32;

typedef	volatile struct _exchangevram {
	HANDLE	hmutex;
	DWORD	max;
	DWORD	min;
	DWORD	minx;
	DWORD	maxx;
} EXCHANGEVRAM, *PEXCHANGEVRAM;

typedef	struct	_bitpattern {
	BYTE	b:1;
	BYTE	r:1;
	BYTE	g:1;
	BYTE	text:1;
	BYTE	dbg:1;
	BYTE	ext:1;
	BYTE	dmy:2;
} BITPATTERN, PBITPATTERN;

typedef	union	_vramimg {
	BYTE		dat;
	BITPATTERN	bit;
} VRAMIMG, *PVRAMIMG;

typedef struct pal {
	WORD	Version;
	WORD	NumberOfEntries;
	PALETTEENTRY aEntries[256];
} pal;

typedef struct header {
	BITMAPINFOHEADER  Header;
	RGBQUAD           aColors[256];
} header;

typedef volatile struct mzioinfo {
	u8 port_d8;
	u8 port_d9;
	u8 port_da;
	u8 port_db;
	u8 port_dc;
	u8 port_dd;

	u8 port_e0;
	u8 port_e1;
	u8 port_e2;
	u8 port_e3;
	u8 port_e4;
	u8 port_e5;
	u8 port_e6;
	u8 port_e7;
	u8 port_e8;
	u8 port_e9;
	u8 port_ea;
	u8 port_eb;
	u8 port_f4;
	u8 port_f5;
	u8 port_f6;
	u8 port_f7;
	int strobe_low;
} MZIOInfo;

typedef volatile struct mz2000 {
	u8 *ipl;
	u8 *memory;
	u8 *vram;
	u8 *gram1, *gram2, *gram3;
	u8 *iplrom2000, *iplrom80b;
	MZIOInfo *ioinfo;
	int inipl, vramon, selchr, gramno, blank;
	int z80MaxClock;
	int nowZ80Clock;
	int howipl;		/* 0: no need, 1: internal function, 2: z80 program, etc. */
	volatile int needReset;	/* Reset switch */
	volatile int needIpl;	/* IPL switch */
	volatile int playStop;	/* temporary stop flag */

	volatile int cpu_peripherals_start; /* Peripherals Initialize Info. */
		/* bit 0 ... 8255 */
		/* bit 1 ... 8253 */
		/* bit 2 ... Z80 PIO A (Keyboard, Memory Mapping, CRTC) */
		/* bit 3 ... Z80 PIO B (Keyboard) */
		/* bit 4 ... Reserved for Z80 PIO A (16bit board) */
		/* bit 5 ... Reserved for Z80 PIO B (16bit board) */

	/* 8253 (timer) */
	int timer8253_start;
	z80clk timer8253_starttime[TIMER8253_COUNTER_MAXNUM];
	z80clk timer8253_currenttime[TIMER8253_COUNTER_MAXNUM];
	int timer8253_rwmode[TIMER8253_COUNTER_MAXNUM];
	u16 timer8253_count[TIMER8253_COUNTER_MAXNUM];
	u16 timer8253_fast_mode;

	/* Z80 PIO (keyboard) */
	int z80pio_modecontrol_state;
	u8 intVect;
	u8 bitMask;
	volatile unsigned char keyint_select;
	void (*keyint_func)( u8 KeyBitMask );

	int cpu_peripherals_end;

	/* Architecture and Pause Mode */
	volatile int mzmode;	/* FALSE=2000 / TRUE=80B */
	volatile int pause;	/* Pause On/Off */

	/* Sound */
	char soundmode;		/* Sound On/Off */
	char enable_soundtape;
	char enable_soundfdd;
	char sound_bit;
	int sound_freq;
	int sound_playbuffer_ms;
	int sound_delaytime_ms;

	/* Other Hardware */
	u8 *iplmon;
	char screen_highreso;	/* Screen High Resolution Mode */
	unsigned char sound_volume1;	/* Sound Volume MZ Pulse Sound */
	unsigned char sound_volume2;	/* Sound Volume Effect Waves */
	char enable_soundtminterpolations; /* Sound Time Interpolations */
	int font_select;	/* Font 24KHz 8x16 */
	int font_english;	/* Font English Mode */
	int vblankspecial;	/* V-Blank Special Mode */
	int dropautoipl;	/* Drop Auto IPL On/Off (FD) */
	int forcereadonly;	/* Force Read Only On/Off */
	char enable_initreset;	/* Auto Initialize I/O on Reset */
	char iplmemclr;		/* IPL reset clear init On/Off */
	char iplmemzclr;	/* Init memory is zero clear */
	char fullscreen_bpp;	/* Display BPP */
	int language_info;	/* Laguage mode, 0 ... Auto (Reserved) */
	int aeroglass_obsolete;	/* Windows Aero Glass BG, obsoleted (Reserved) */
	int dropautoipltape;	/* Drop Auto IPL On/Off (TAPE) */
	char droptofd2;		/* Drop to FD2 */
	char fd_exec_fast;	/* In FD, fast running mode */
	char fd_ignore_crc;	/* In FD, ignore read crc error */
	char fd_erase_sct17crc;	/* In FD, erase sector 17 crc to 16 sectors */
	int consoler_cblank;	/* Console Rev. Blank on Color Display */
	char fullscreen_device;	/* Display Device */
	char fullscreen_resolution; /* Display Resolution */
	char language;		/* Language Mode */
	char currentlanguage;	/* Current Language */
	u8 keyboard_mode;	/* Keyboard Mode */

	/* Green Display Color */
	unsigned char greencolor_nfr;
	unsigned char greencolor_nfg;
	unsigned char greencolor_nfb;
	unsigned char greencolor_nbr;
	unsigned char greencolor_nbg;
	unsigned char greencolor_nbb;
	unsigned char greencolor_rfr;
	unsigned char greencolor_rfg;
	unsigned char greencolor_rfb;
	unsigned char greencolor_rbr;
	unsigned char greencolor_rbg;
	unsigned char greencolor_rbb;

	/* Memory Wait and Frame Clock Adjust */
	int frameclock_alpha;
	int memory_waittvramclock_r;
	int memory_waittvramclock_w;
	int memory_waitgramclock_r;
	int memory_waitgramclock_w;
	int memory_waitgram80bclock_r;
	int memory_waitgram80bclock_w;

	/* Machine State (.mze) */
	BOOL sfilename_havewrite;
	char sfilename[MAX_PATH];

	/* Cassette Tape Deck */
	char tfilename[MAX_PATH];
	int tapemode_reverse;	/* Reverse */
	char tapeff_ignore;	/* Ignore FF */
	char tapewrite_interpolation;	/* Write Interpolation On/Off */
	char tape_reserved1;
	char tape_reserved2;
	int tapecounter;	/* Counter Mode */
	int tapectspeed_2000;	/* Counter Speed 2000 */
	int tapectspeed_80B;	/* Counter Speed 80B */
	int tapectspeed_2500;	/* Counter Speed 2500 */
	int tapespeaker;	/* Speaker On/Off */
	unsigned int tapePitch;
	unsigned int tapeThreshold;
	unsigned int writeThreshold;
	unsigned int amplitudeRange;
	int tapeLoad;
	int tapeFF;
	int tapeEnd;

	/* Floppy Disk Drive */
	int enable_fddif;	/* Enable I/F (MZ-1E05/MZ-8FBI) */

	/* Quick Disk Drive MZ-1E18+MZ-1F11 */
	char qfilename[MAX_PATH];

	/* Main Window */
	HWND ghWnd;
	HWND ghStatusBar;
	HINSTANCE ghInstance;
	/* Thread Handle & etc */
	HANDLE mainloop_thread_handle, playview_thread_handle;
	DWORD mainloop_thread_id, playview_thread_id;

	/* Screen */
	u8 *dvram, *dgram;
	volatile int vramChg, gram1Chg, gram2Chg, gram3Chg;
	volatile int viewChg, viewMsg, mzChgGraphMode;
	int displayMode;	// 0:green 1:color
	int greenGraphOn;	// 0:GreenMode Graph off 1:GreenMode Graph on
	int greenTextOn;	// 0:GreenMode Text off  1:Green Mode Text on
	int displayAttr;	// 0:t-Front..   1:G-Front (displayMode+dispAttr)=... 
	int textColor;		// Text Color Number
	int backColor;		// Back Color Number
	u8 graphMask[3 + 1];
	int _screen_reserved[5];
	int screen_dummy;
	/* GDI */
	void *gdimem;
	HDC Buffer;		// WinGBitmap device context
	HBITMAP gbmOldMonoBitmap;
	HPALETTE hpalApp;
	volatile DWORD viewMessageVal;
	/* Font */
	int use_fontrom;
	RGBQUAD	paletteTableTemp[6][16];
	/* Keyboard */
	HHOOK hKeyHook;

	/* 16bit Board MZ-1M01/MZ-1R08(Kanji-ROM) */
	/* (not implemented currently) */
	int enable_16bit;	/* Enable 16bit Board (reserved) */

	/* Output Information */
	volatile BOOL dwDebugPrint;
	volatile BOOL dwDebugPrint_state;
	volatile DWORD _reserved_viewDebug;
	volatile BYTE dwDebugPrintDrawCount;
} MZ2000;

/* emuz2000.c */
typedef enum {
	WOV_UNKNOWN = -1,
	WOV_WIN9X = 0,	/* 95/98/98SE/ME */
	WOV_NT,		/* NT 4.0 */
	WOV_2000,	/* 2000/XP */
	WOV_VISTA,	/* Vista/7 */
	WOV_WIN8_10,	/* 8/8.1/10/2012 */
	WOV_MAXNUM
} WOV_TYPE;
typedef enum {
	UILANG_AUTOMATIC = -1,
	UILANG_ENGLISH = 0,
	UILANG_JAPANESE,
	UILANG_MAXNUM
} UILANG_TYPE;
typedef enum {
	TAPE_COUNTERMODE_MZ2080 = 0,
	TAPE_COUNTERMODE_MZ2500,
	TAPE_COUNTERMODE_KBYTES,
	TAPE_COUNTERMODE_BYTES,
	TAPE_COUNTERMODE_MAXNUM
} TAPE_COUNTERMODE_TYPE;
#define TAPE_COUNTERMODE_DEFAULT TAPE_COUNTERMODE_MZ2080
extern MZ2000 *mz2000_global;
extern WOV_TYPE os_runmode;
extern volatile BOOL bFullScreenMenu;
extern volatile int playDestroy;
extern int g_statusbar_height;
extern volatile char g_statusbar_msg[LNMAX];
extern HANDLE g_hFSStatusBarFont;

extern int mzfont8_have, mzfont16_have;
extern BYTE mzfont[256*2][16];
extern BYTE mzfont8[256*2][16];
extern BYTE mzfont16[256*2][16];
extern void playview_add_redrawct( void );

/* main.c */
extern char commandline_param[];
extern char app_currentpath[];
extern char app_defaultinifile[];
extern void setplaystop( MZ2000 *mz, int flag );
extern int reset_mz2000_sub( MZ2000 *mz2000 );
extern int reset_mz2000( MZ2000 *mz2000 );
extern int iplreset_mz( MZ2000 *mz2000 );
extern int iplreset_mz2000( MZ2000 *mz2000 );
extern int iplreset_mz80b( MZ2000 *mz2000 );
extern int mainloop_mz2000( MZ2000 *mz2000 );
extern void save_configuration( MZ2000 *mz );
extern MZ2000 *init_mz2000( void );

/* mz2io.c */
#define CPUPERIPHERALS_RESET		0x00U
#define CPUPERIPHERALS_INIT		0x0fU
#define CPUPERIPHERALS_INIT_8255	0x01U
#define CPUPERIPHERALS_INIT_8253	0x02U
#define CPUPERIPHERALS_INIT_Z80PIOA	0x04U
#define CPUPERIPHERALS_INIT_Z80PIOB	0x08U
#define CPUPERIPHERALS_INIT_Z80PIO16A	0x10U
#define CPUPERIPHERALS_INIT_Z80PIO16B	0x20U
extern void mz2io_keyintfunc( u8 KeyBitMask );
extern void reinit_io( MZ2000 *mz );
extern void refresh_io( MZ2000 *mz );
extern void io_exit( MZ2000 *mz );
extern int io_init( MZ2000 *mz );

/* mz2mem.c */
#define MZ_IPLROM_SIZE		( 2 * 1024)	/* IPL Main memory size */
#define MZ_MAINMEMORY_SIZE	(64 * 1024)	/* Main memory size */
#define MZ_TEXTVRAM_SIZE	( 4 * 1024)	/* Text V-RAM size */
#define MZ_GRAMPAGE_SIZE	(16 * 1024)	/* G-RAM page size */
#define	GRAM_MAX		0x3fff		/* Graphic area memory size */
#define	GRAM_CLIP		0x3e80		/* Graphic area scan clip */
#define	TEXT_MAX		0xfff		/* Text area memory size */
#define	TEXT_CLIP		0x800		/* Text area scan clip */
#define	GRAM_MAX_80B		0x1fff		/* Graphic area memory size */
#define	GRAM_CLIP_80B		0x1f40		/* Graphic area scan clip */
extern int vram_on( MZ2000 *mz );
extern int gram_on( MZ2000 *mz );
extern int v_gram_off( MZ2000 *mz );
extern int v_gram_on80B_D0( MZ2000 *mz );
extern int v_gram_on80B_50( MZ2000 *mz );
extern int v_gram_off80B( MZ2000 *mz );
extern int memory_clear( MZ2000 *mz, int mode ); /* 0 = all / 1 = main / 2 = T/G-RAM */
extern int memory_ipl( MZ2000 *mz );
extern int memory_normal( MZ2000 *mz );
extern void memory_exit( MZ2000 *arg );
extern int memory_init( MZ2000 *arg );

/* screen.c */
extern BOOL screen_clear( MZ2000 *mz2000 );
extern BOOL screen_putmsg( MZ2000 *mz2000, int adr, const char *s );
extern BOOL screen_putmsgn( MZ2000 *mz2000, int adr, const char *s, int n );
extern BOOL screen_region_add_textvram( MZ2000 *mz, int addr );
extern BOOL screen_region_add_gram2000( MZ2000 *mz, int page, int addr );
extern BOOL screen_region_add_gram80B( MZ2000 *mz, int page, int addr );
extern BOOL screen_region_add_all( MZ2000 *mz );
extern BOOL screen_portF4( MZ2000 *mz2000, unsigned char val );
extern BOOL screen_portF5( MZ2000 *mz2000, unsigned char val );
extern BOOL screen_portF6( MZ2000 *mz2000, unsigned char val );
extern BOOL screen_setreverse( MZ2000 *mz2000, BOOL flag );
extern BOOL screen_setblank( MZ2000 *mz2000, BOOL flag );
extern BOOL screen_setchrsize( MZ2000 *mz2000, BOOL chr80_flag );
extern BOOL screen_setmonitor( MZ2000 *mz2000, BOOL color_flag );
extern BOOL screen_sethighreso( MZ2000 *mz2000, BOOL highreso_flag );
extern BOOL screen_setfontlang( MZ2000 *mz2000, BOOL english_flag );
extern BOOL screen_setgreencolor( MZ2000 *mz,
	unsigned char nfr, unsigned char nfg, unsigned char nfb,
	unsigned char nbr, unsigned char nbg, unsigned char nbb,
	unsigned char rfr, unsigned char rfg, unsigned char rfb,
	unsigned char rbr, unsigned char rbg, unsigned char rbb );
extern BOOL screen_initattr2( MZ2000 *mz );
extern BOOL screen_initattr( MZ2000 *mz );
extern BOOL screen_initarch( MZ2000 *mz );
extern void screen_exit( MZ2000 *mz2000 );
extern BOOL screen_init( MZ2000 *mz2000 );
/* screen_crtc.c (DirectX Window) */
#define	GREEN_DISPLAY		FALSE		// Green Display
#define	COLOR_DISPLAY		TRUE		// Color Display
#define	CONSOLE_N		FALSE		// Console N
#define	CONSOLE_R		TRUE		// Console R
#define	TEXT_FRONT		FALSE		// Text Front
#define	TEXT_BACK		TRUE		// Text Front
#define	TEXTFONT_200LINE	FALSE		// Used TEXT Font 200 Line
#define	TEXTFONT_400LINE	TRUE		// Used TEXT Font 400 Line
#ifdef ENABLE_D3D
extern BOOL gbD3D;
extern BOOL gbD3DF;
extern BOOL gbRedraw;
extern DWORD gdwRPI;
#endif /* ENABLE_D3D */
/* -- */
#define	FONT_BUFFER		(5*1024)	// Font Buffer Size
#define	TEXT_ALL_REDRAW		0xffff		// Text Draw Function Param Flag
#define	PADBYTE_INDEX		128
extern int screen_window_width;
extern int screen_window_height;
extern int screen_full_autoflag;
extern int screen_full_width;
extern int screen_full_height;
extern int screen_full_bpp;
extern DWORD vchg;
extern EXCHANGEVRAM viewarea;
extern RGBQUAD paletteTable[6][16];
/* -- */
extern void screen_crtc_setgreencolor( MZ2000 *mz,
	unsigned char nfr, unsigned char nfg, unsigned char nfb,
	unsigned char nbr, unsigned char nbg, unsigned char nbb,
	unsigned char rfr, unsigned char rfg, unsigned char rfb,
	unsigned char rbr, unsigned char rbg, unsigned char rbb );
extern void ShowMyText( HWND hWnd, MZ2000 *mz );
extern void ShowMyText2( HWND hWnd, MZ2000 *mz );
extern void textDraw80( MZ2000 *mz, DWORD flg );
extern void textDraw40( MZ2000 *mz, DWORD flg );
extern void drawGraph( MZ2000 *mz );
extern void drawGraph80B( MZ2000 *mz );
extern void debugTextDraw80( MZ2000 *mz, BOOL flg );
extern void fontSel( int sel );
extern void ChangeHighresoInit( MZ2000 *mz );
extern void PaletteChange( MZ2000 *mz );
extern BYTE *CreateOffScreen( MZ2000 *mz );
extern void FreeOffScreen( MZ2000 *mz );
/* screen_crtc2.c (DirectX FullScreen) */
#define SCREENINFO_RES_MAXNUM		128
#define SCREENINFO_DRIVERNAME_MAXNUM	64
typedef struct {
	GUID guid;
	char DriverName[SCREENINFO_DRIVERNAME_MAXNUM];
	int res_maxnum;
	unsigned int sx[SCREENINFO_RES_MAXNUM], sy[SCREENINFO_RES_MAXNUM];
	unsigned int srefresh[SCREENINFO_RES_MAXNUM];
} SCREEN_INFO;
extern SCREEN_INFO *screen_info;
extern int screeninfo_maxnum;
#define	SCREEN_DEVICE_DEFAULT	0
#define	SCREEN_RESOLUTION_AUTO	0
#define SCREEN_BPP_16	16
#define SCREEN_BPP_32	32
#define SCREEN_BPP_DEFAULT SCREEN_BPP_16
extern int GetScreenResolutions( HWND hWnd );
extern BOOL DDrawCreate( HWND hWnd );
extern BOOL DDrawRelease( HWND hWnd );
extern void DDrawUpdateScreen( HWND hWnd, MZ2000 *mz, BOOL force_flag );

/* keyboard.c */
extern void keyboard_keyevent( WPARAM wParam, LPARAM lParam );
extern void keyboard_setinterrupt( unsigned char select, void *intfunc );
extern void keyboard_setdirect( BOOL press_flag, int strobe, int bit );
extern int keyboard_getbitdata( MZ2000 *mz2000, int strobe );
extern int keyboard_getallbitdata( MZ2000 *mz2000 );
extern BOOL keyboard_breakkey_released( MZ2000 *mz2000 );
extern BOOL keyboard_releaseall( MZ2000 *mz2000 );
extern BOOL keyboard_setkeymode( unsigned char keymode );
extern BOOL keyboard_hookstart( HWND hWnd, MZ2000 *mz );
extern BOOL keyboard_hookend( HWND hWnd, MZ2000 *mz );
extern void keyboard_exit( MZ2000 *mz2000 );
extern BOOL keyboard_init( MZ2000 *mz2000 );

/* mz2tape.c */
#define TAPE_IPLMSG_MAXNUM	16
typedef enum {
	MZ2TAPE_RUNMODE_EJECT = -1,
	MZ2TAPE_RUNMODE_STOP = 0,
	MZ2TAPE_RUNMODE_PLAY,
	MZ2TAPE_RUNMODE_RECORD,
	MZ2TAPE_RUNMODE_FF,
	MZ2TAPE_RUNMODE_REW,
	MZ2TAPE_RUNMODE_MAXNUM
} MZ2TAPE_RUNMODE;
typedef enum {
	MZ2TAPE_FILEMODE_ERRNDLG = -2,
	MZ2TAPE_FILEMODE_ERROR = -1,
	MZ2TAPE_FILEMODE_MZT = 0,
	MZ2TAPE_FILEMODE_MZF,
	MZ2TAPE_FILEMODE_MTW,
	MZ2TAPE_FILEMODE_MTI,
	MZ2TAPE_FILEMODE_WAV,
	MZ2TAPE_FILEMODE_DAT,
	MZ2TAPE_FILEMODE_HEX,
	MZ2TAPE_FILEMODE_MAXNUM
} MZ2TAPE_FILEMODE;
extern int mz2tape_ready( void );
extern int mz2tape_getstatus( unsigned long *pos, unsigned long *total,
	unsigned long *offset, int *tapeend,
	unsigned long *tapefreq, unsigned long *deffreq );
extern int mz2tape_getwritable( void );
extern int mz2tape_setwritable( int enable );
extern int mz2tape_getkinh( void );
extern int mz2tape_setkinh( int enable );
extern int mz2tape_getrev( void );
extern int mz2tape_setrev( int enable );
extern int mz2tape_eject( MZ2000 *mz, int sound_flag );
extern int mz2tape_stop2( MZ2000 *mz );
extern int mz2tape_stop( MZ2000 *mz );
extern int mz2tape_rew( MZ2000 *mz );
extern int mz2tape_ff( MZ2000 *mz );
extern int mz2tape_play( MZ2000 *mz );
extern int mz2tape_record( MZ2000 *mz );
extern int mz2tape_head( MZ2000 *mz );
extern int mz2tape_updatestatus( MZ2000 *mz, unsigned char *port );
extern int mz2tape_updatewrite( MZ2000 *mz, int flag );
extern int mz2tape_updatetimer( void );
extern int mz2tape_exec( MZ2000 *mz, const char *filename, int readonly );
extern void tape_exit( MZ2000 *mz );
extern int tape_init( MZ2000 *mz );

/* disk.c */
#define	MZ_DISK_DRIVE_MAX	4
#define DISK_IPLMSG_MAXNUM	10
typedef enum {
	DISK_STATUS_NONE = 0,
	DISK_STATUS_INSERT,
	DISK_STATUS_WCHANGED,
	DISK_STATUS_MAXNUM
} DISK_STATUS_TYPE;
typedef enum {
	DISK_EJECT_NORMAL = 0,
	DISK_EJECT_CHECKONLY,
	DISK_EJECT_FORCE,
	DISK_EJECT_MAXNUM,
} DISK_EJECT_TYPE;
extern char disk_iplmsg[DISK_IPLMSG_MAXNUM + 1];
extern int disk_updatetimer( void );
extern const char *disk_getdefpath( MZ2000 *mz, int drive );
extern int disk_getexist( MZ2000 *mz, int drive );
extern int disk_getwritable( MZ2000 *mz, int drive );
extern int disk_getaccess( MZ2000 *mz, int drive );
extern int disk_getmodified( MZ2000 *mz, int drive );
extern char *disk_getfnptr( MZ2000 *mz, int drive );
extern int disk_writeback( MZ2000 *mz, int drive );
extern int disk_eject( MZ2000 *mz, int drive, DISK_EJECT_TYPE mode );
extern int disk_change( MZ2000 *mz, int drive, const char *filename, int d88flag, int nomsg, int readonly );
extern int disk_exec( MZ2000 *mz, int drive, const char *filename, int d88flag, int readonly );
extern int disk_setparam( int exec_fast, int ignore_crc, int erase_sct17crc );
extern void disk_reset( MZ2000 *mz );
extern void disk_exit( MZ2000 *mz );
extern int disk_init( MZ2000 *mz );
/* I/O */
extern u8 disk_port_in_d8( u16 port );
extern int disk_port_out_d8( u16 port, u8 value );
extern u8 disk_port_in_d9( u16 port );
extern int disk_port_out_d9( u16 port, u8 value );
extern u8 disk_port_in_da( u16 port );
extern int disk_port_out_da( u16 port, u8 value );
extern u8 disk_port_in_db( u16 port );
extern int disk_port_out_db( u16 port, u8 value );
extern u8 disk_port_in_dc( u16 port );
extern int disk_port_out_dc( u16 port, u8 value );
extern u8 disk_port_in_dd( u16 port );
extern int disk_port_out_dd( u16 port, u8 value );

/* sound.cpp */
typedef enum {
	SOUND_WAV_FDMOTOR = 0,
	SOUND_WAV_FDMOTOR_ST,
	SOUND_WAV_FDEJECT,
	SOUND_WAV_FDSEEK,
	SOUND_WAV_FDSEEK1,
	SOUND_WAV_2000EJECT,
	SOUND_WAV_2000PLAY,
	SOUND_WAV_2000STOP,
	SOUND_WAV_2000FF,
	SOUND_WAV_2000REW,
	SOUND_WAV_2000FFST,
	SOUND_WAV_2000APSS,
	SOUND_WAV_80BEJECT,
	SOUND_WAV_80BPLAY,
	SOUND_WAV_80BSTOP,
	SOUND_WAV_80BFF,
	SOUND_WAV_80BREW,
	SOUND_WAV_MAXNUM
} SOUND_WAVLIST;
extern int sound_stat_value1;
extern int sound_stat_value2;
extern int sound_stat_value3;
extern void sound_reset( MZ2000 *mz );
extern void sound_setstate( MZ2000 *mz, BOOL onoff );
extern void sound_tickprogress( MZ2000 *mz );
extern BOOL sound_playwav_file( MZ2000 *mz, SOUND_WAVLIST no );
extern BOOL sound_enablechk( void );
extern BOOL sound_updateparams( HWND hwnd, MZ2000 *mz );
extern void sound_exit( MZ2000 *mz );
extern BOOL sound_init( HWND hwnd,  MZ2000 *mz );

/* state.c */
extern int load_state( HWND hWnd, MZ2000 *mz, int no_fileopendlg );
extern int save_state( HWND hWnd, MZ2000 *mz, int force_newname );

/* copypaste.c */
typedef enum {
	PASTE_MONITOR_NORMAL = 0,
	PASTE_MONITOR_PUPMON,
	PASTE_MONITOR_TS,
	PASTE_MONITOR_HUBASIC,
	PASTE_MONITOR_DBBASIC,
	PASTE_MONITOR_MAXNUM
} PASTE_MONITOR_MODE;
extern int paste_mode;
extern int paste_wait;
extern int paste_waitcr;
extern BOOL copypaste_havepaste( HWND hWnd );
extern int copypaste_pastestart( HWND hWnd );
extern int copypaste_pasteend( BOOL force_flag );
extern void copypaste_pastetimer( void );
extern int copypaste_runningpaste( void );
extern int copypaste_copy( HWND hWnd );
extern void copypaste_exit( void );
extern int copypaste_init( void );

#endif /* __MZ2000_H_INCLUDED */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
