/* File: pasteDlg.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Paste Settings Dialog

	Copyright (C) 2014-2019 FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#include "config.h"

#include <windows.h>
#include <string.h>

#include "common.h"
#include "mz2000.h"
#include "pasteDlg.h"
#include "resource.h"

static BOOL DlgCenterWindow( HWND hDlg, HWND hWndParent )
{
	RECT rect;
	int tx, ty, dx, dy, sx, sy;

	/* get the target center positions */
	if (!hWndParent)
		hWndParent = GetWindow( hDlg, GW_OWNER );
	if (!hWndParent)
		return FALSE;
	GetWindowRect( hWndParent, &rect );
	tx = (rect.left + rect.right) / 2;
	ty = (rect.top + rect.bottom) / 2;

	/* move to center positions */
	GetWindowRect( hDlg, &rect );
	dx = tx - (rect.left + rect.right) / 2;
	dy = ty - (rect.top + rect.bottom) / 2;
	rect.left   += dx;
	rect.right  += dx;
	rect.top    += dy;
	rect.bottom += dy;

	/* move to inside of screen */
	sx = GetSystemMetrics( SM_CXSCREEN );
	sy = GetSystemMetrics( SM_CYSCREEN );
	if (rect.right >= sx) {
		int dd = sx - rect.right;
		rect.left  += dd;
		rect.right += dd;
	}
	if (rect.bottom >= sy) {
		int dd = sy - rect.bottom;
		rect.top    += dd;
		rect.bottom += dd;
	}
	if (rect.left < 0) {
		rect.right += -rect.left;
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.bottom += -rect.top;
		rect.top = 0;
	}

	/* update the real window positions */
	SetWindowPos( hDlg, NULL,
		rect.left, rect.top, 0, 0,
		SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	return TRUE;
}

BOOL WINAPI DlgProcPasteSettings( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	DWORD r;
	int t;
	char buf[LNMAX];

	switch (msg) {
	case WM_INITDIALOG :
		/* set the window attributes */
		DlgCenterWindow( hDlg, NULL );

		/* init. to environments */
		SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT,
			CB_ADDSTRING, 0, (LPARAM)"Normal" );
		SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT,
			CB_ADDSTRING, 0, (LPARAM)"Power Up Monitor" );
		SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT,
			CB_ADDSTRING, 0, (LPARAM)"TS-1000/TS-2000/TF-2000" );
		SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT,
			CB_ADDSTRING, 0, (LPARAM)"Hu-BASIC/Hu-Monitor" );
		SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT,
			CB_ADDSTRING, 0, (LPARAM)"dB-BASIC/Mask Monitor" );
		SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT,
			CB_SETCURSEL, paste_mode, 0 );
		/* set to Wait Time */
		_snprintf( buf, LNMAX, "%d", paste_wait );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAIT, WM_SETTEXT, 0, (LPARAM)buf );
		/* set to Wait Time for CR */
		_snprintf( buf, LNMAX, "%d", paste_waitcr );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAITCR, WM_SETTEXT, 0, (LPARAM)buf );
		return TRUE;
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
			/* the environments */
			r = SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT, CB_GETCURSEL, 0, 0 );
			if (r == CB_ERR || r < 0 || r >= PASTE_MONITOR_MAXNUM) {
				MessageBox( NULL, "Environement selecting error",
					"Paste Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			paste_mode = r;
			/* Wait Time */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAIT, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 100) {
				MessageBox( NULL, "Wait time value range error",
					"Paste Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			paste_wait = t;
			/* Wait Time for CR */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITCR, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 100) {
				MessageBox( NULL, "Wait time for CR value range error",
					"Paste Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			paste_waitcr = t;
			EndDialog( hDlg, TRUE );
			return TRUE;
		case IDCANCEL :
			EndDialog( hDlg, FALSE );
			return TRUE;
		case IDC_BUTTON_DEFAULT :
			/* set to the environments */
			SendDlgItemMessage( hDlg, IDC_COMBO_ENVIRONMENT,
				CB_SETCURSEL, PASTE_MONITOR_DEFAULT, 0 );
			/* set to Wait Time */
			_snprintf( buf, LNMAX, "%d", PASTE_WAIT_DEFAULT );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAIT, WM_SETTEXT, 0, (LPARAM)buf );
			/* set to Wait Time */
			_snprintf( buf, LNMAX, "%d", PASTE_WAITCR_DEFAULT );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITCR, WM_SETTEXT, 0, (LPARAM)buf );
			break;
		}
		break;
	}
	return FALSE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
