/* File: screen_crtc.cpp

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		CRTC Window / DIB Screens

	Extend the EmuZ-2000 mz2000CRTC.c by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.

	Caution !!
	This file is including the old EmuZ-2000 program code.
	These are no copyright information and released open source code.
*/

#include "config.h"

#include <windows.h>
#include <string.h>

#ifdef ENABLE_D3D
#include "now\now3d.h"
#include "now\now3d.cpp"
#include "now\NowRpi.h"
#include "now\NowRpi.cpp"
#include "now\Rpi.cpp"
#include "now\rpimenu.h"
#include "now\rpimenu.cpp"
#endif

extern "C" {

#include "common.h"
#include "mz2000.h"
#include "../plugin/plugin.h"

#define SCREEN_STRETCHBLT_MODE	COLORONCOLOR
//#define SCREEN_STRETCHBLT_MODE	HALFTONE

static pal LogicalPalette = {
	0x300,
	256
};

RGBQUAD paletteTable[6][16] = {	/* Value order BGR */
{
	/* Green Display Console N */
	{   1,  1,  2,  0 },		/* 0:BLACK */
	{   1,253,  1,  0 },		/* 1:GREEN */
	{   1,253,  1,  0 },		/* 2:GREEN */
	{   1,253,  1,  0 },		/* 3:GREEN */
	{   1,253,  1,  0 },		/* 4:GREEN */
	{   1,253,  1,  0 },		/* 5:GREEN */
	{   1,253,  1,  0 },		/* 6:GREEN */
	{   1,253,  1,  0 },		/* 7:GREEN */
	{   1,253,  1,  0 },		/* 8:GREEN */
	{   1,253,  1,  0 },		/* 9:GREEN */
	{   1,253,  1,  0 },		/* 10:GREEN */
	{   1,253,  1,  0 },		/* 11:GREEN */
	{   1,253,  1,  0 },		/* 12:GREEN */
	{   1,253,  1,  0 },		/* 13:GREEN */
	{   1,253,  1,  0 },		/* 14:GREEN */
	{   1,253,  1,  0 }, 		/* 15:GREEN */
}, {
	/* Green Display Console R */
	{   1,253,  2,  0 },		/* 0:BLACK */
	{   1,  1,  1,  0 },		/* 1:GREEN */
	{   1,  1,  1,  0 },		/* 2:GREEN */
	{   1,  1,  1,  0 },		/* 3:GREEN */
	{   1,  1,  1,  0 },		/* 4:GREEN */
	{   1,  1,  1,  0 },		/* 5:GREEN */
	{   1,  1,  1,  0 },		/* 6:GREEN */
	{   1,  1,  1,  0 },		/* 7:GREEN */
	{   1,  1,  1,  0 },		/* 8:GREEN */
	{   1,  1,  1,  0 },		/* 9:GREEN */
	{   1,  1,  1,  0 },		/* 10:GREEN */
	{   1,  1,  1,  0 },		/* 11:GREEN */
	{   1,  1,  1,  0 },		/* 12:GREEN */
	{   1,  1,  1,  0 },		/* 13:GREEN */
	{   1,  1,  1,  0 },		/* 14:GREEN */
	{   1,  1,  1,  0 }, 		/* 15:GREEN */
}, {
	/* Color Display Mode (Priority Text) */
	{   1,  1,  2,  0 },		/* 0:BLACK */
	{ 253,  1,  1,  0 },		/* 1:BLUE */
	{   1,  1,253,  0 },		/* 2:RED */
	{ 253,  1,253,  0 },		/* 3:PURPLE */
	{   1,253,  1,  0 },		/* 4:GREEN */
	{ 253,254,  1,  0 },		/* 5:CYAN */
	{   1,253,254,  0 },		/* 6:YELLOW */
	{ 253,253,253,  0 },		/* 7:WHITE */
	{ 253,253,253,  0 },		/* 8:TEXT Color */
	{ 253,253,253,  0 },		/* 9:TEXT Color */
	{ 253,253,253,  0 },		/* 10:TEXT Color */
	{ 253,253,253,  0 },		/* 11:TEXT Color */
	{ 253,253,253,  0 },		/* 12:TEXT Color */
	{ 253,253,253,  0 },		/* 13:TEXT Color */
	{ 253,253,253,  0 },		/* 14:TEXT Color */
	{ 253,253,253,  0 },		/* 15:TEXT Color */
}, {
	/* Color Display Mode (Priority Graphic) */
	{   1,  1,  2,  0 },		/* 0:BLACK */
	{ 253,  1,  1,  0 },		/* 1:BLUE */
	{   1,  1,253,  0 },		/* 2:RED */
	{ 253,  1,253,  0 },		/* 3:PURPLE */
	{   1,253,  1,  0 },		/* 4:GREEN */
	{ 253,254,  1,  0 },		/* 5:CYAN */
	{   1,253,254,  0 },		/* 6:YELLOW */
	{ 253,253,253,  0 },		/* 7:WHITE */
	{ 253,253,253,  0 },		/* 8:TEXT Color */
	{ 253,  1,  1,  0 },		/* 9:BLUE */
	{   1,  1,253,  0 },		/* 10:RED */
	{ 253,  1,253,  0 },		/* 11:PURPLE */
	{   1,253,  1,  0 },		/* 12:GREEN */
	{ 253,254,  1,  0 },		/* 13:CYAN */
	{   1,253,254,  0 },		/* 14:YELLOW */
	{ 253,253,253,  0 },		/* 15:WHITE */
}, {
	/* Debug Message Display Mode */
	{ 253,253,253,  0 },		/* 0:BLACK */
	{ 253,253,253,  0 },		/* 1:TEXT Color */
	{ 253,253,253,  0 },		/* 2:TEXT Color */
	{ 253,253,253,  0 },		/* 3:TEXT Color */
	{ 253,253,253,  0 },		/* 4:TEXT Color */
	{ 253,253,253,  0 },		/* 5:TEXT Color */
	{ 253,253,253,  0 },		/* 6:TEXT Color */
	{ 253,253,253,  0 },		/* 7:TEXT Color */
	{ 253,253,253,  0 },		/* 8:TEXT Color */
	{ 253,253,253,  0 },		/* 9:TEXT Color */
	{ 253,253,253,  0 },		/* 10:TEXT Color */
	{ 253,253,253,  0 },		/* 11:TEXT Color */
	{ 253,253,253,  0 },		/* 12:TEXT Color */
	{ 253,253,253,  0 },		/* 13:TEXT Color */
	{ 253,253,253,  0 },		/* 14:TEXT Color */
	{ 253,253,253,  0 },		/* 15:TEXT Color */
}, {
	/* Ext Display Mode */
	{ 255,255,255,  0 },		/* 0:BLACK */
	{ 153,153,253,  0 },		/* 1:TEXT Color */
	{ 153,153,253,  0 },		/* 2:TEXT Color */
	{ 153,153,253,  0 },		/* 3:TEXT Color */
	{ 153,153,253,  0 },		/* 4:TEXT Color */
	{ 153,153,253,  0 },		/* 5:TEXT Color */
	{ 153,153,253,  0 },		/* 6:TEXT Color */
	{ 153,153,253,  0 },		/* 7:TEXT Color */
	{ 153,153,253,  0 },		/* 8:TEXT Color */
	{ 153,153,253,  0 },		/* 9:TEXT Color */
	{ 153,153,253,  0 },		/* 10:TEXT Color */
	{ 153,153,253,  0 },		/* 11:TEXT Color */
	{ 153,153,253,  0 },		/* 12:TEXT Color */
	{ 153,153,253,  0 },		/* 13:TEXT Color */
	{ 153,153,253,  0 },		/* 14:TEXT Color */
	{ 153,153,253,  0 },		/* 15:TEXT Color */
} };

DWORD vchg = 0;
EXCHANGEVRAM viewarea;
int screen_window_width = MZ2000_DISPLAY_WIDTH;
int screen_window_height = MZ2000_DISPLAY_HEIGHT;
static HPALETTE hPal_old;

#ifdef ENABLE_D3D
/*
typedef struct {
	BITMAPINFOHEADER	bmih;
	DWORD	dwMaskR;
	DWORD	dwMaskG;
	DWORD	dwMaskB;
} BITMAPINFO2;
*/
static HBITMAP	hbm16;
static LPWORD	lpBuffer16 = NULL;
#define RGB16(r,g,b)	\
	((WORD)(((BYTE)(b&0x1f)| \
	((WORD)(g&0xfc) << 3)) | \
	(((WORD)(BYTE)(r&0xf8)) << 8) ))
static WORD	pal16[16];

BOOL	gbD3D = FALSE;
BOOL	gbD3DF = FALSE;
BOOL	gbRedraw = TRUE;

extern HWND	ghWndChild;
static CNow3D	*d3d = NULL;
static int prev_screen_window_width = -1;
static int prev_screen_window_height = -1;

static CFilter	*rpi = NULL;

DWORD	gdwRPI = 0;

static BOOL Conv8to16(MZ2000 *mz)
{
	BOOL	b = FALSE;
	
	if (!gbD3D && d3d) {
		delete d3d;
		d3d = NULL;
		if (rpi) {
			delete rpi;
			rpi = NULL;
		}
	}
	
	if ( (gbD3D && IsWindow(ghWndChild) ) &&
		( gbRedraw || (prev_screen_window_width != screen_window_width) ||
			(prev_screen_window_height != screen_window_height) ) ) {
		
		gbRedraw = FALSE;
		prev_screen_window_width = screen_window_width;
		prev_screen_window_height = screen_window_height;
		
		if (d3d)
			delete d3d;
		
		d3d = new CNow3D();
		if (d3d) {
			if (d3d->Create(ghWndChild /* mz->ghWnd */, screen_window_width, screen_window_height, TRUE, FALSE) == D3D_OK) {
				if (rpi) {
					delete rpi;
					rpi = NULL;
				}
				if (gdwRPI) {
					rpi = new CFilter();
					if ( !rpi->CreateRPI(RPIGetFilterName(gdwRPI - 1)) )
					{
						delete rpi;
						rpi = NULL;
					}
				}
				if (rpi) {
					if ( !rpi->Create(d3d, MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT) ) {
						delete rpi;
						rpi = NULL;
					} else
						b = TRUE;
				}
				if (!rpi) {
					if (d3d->CreateSurface(MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT) == D3D_OK)
						b = TRUE;
				}
			}
		}
		if (!b) {
			if (d3d) {
				delete d3d;
				d3d = NULL;
				if (rpi) {
					delete rpi;
					rpi = NULL;
				}
			}
		}
	}
	
	if (d3d) {
		LONG	dwPitch;
		LPBYTE	lpDst;
		LPWORD	lpDst_;
		LPBYTE	lpSrc;
		LPBYTE	lpSrc_;
		HRESULT	hr;
    
		if (rpi) {
			rpi->Lock((LPVOID*) &lpDst, &dwPitch);
			hr = D3D_OK;
		} else {
			hr = d3d->Lock(d3d->GetSurfaceB(),(LPVOID*) &lpDst, &dwPitch);
		}
	
		if ( hr == D3D_OK) {
			int x, y;

			lpSrc = (LPBYTE)mz->gdimem;
			for (y=0; y < MZ2000_DISPLAY_HEIGHT; y++) {
				lpSrc_ = lpSrc + y * MZ2000_DISPLAY_WIDTH;
				lpDst_ = (LPWORD) ( lpDst + y * dwPitch );
				for (x=0; x < MZ2000_DISPLAY_WIDTH; x++) {
					*lpDst_++ =
						pal16[ *lpSrc_++ ];
				}
			}
			if (rpi) {
				RECT rcSrc={0,0,MZ2000_DISPLAY_WIDTH*2, MZ2000_DISPLAY_HEIGHT*2};
				RECT rcDst={0,0,screen_window_width, screen_window_height};
				rpi->Blt(&rcSrc, &rcDst, gbD3DF ? 0 : 1);
			} else {
				d3d->Unlock( d3d->GetSurfaceB() );
				RECT rcSrc={0,0,MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT};
				RECT rcDst={0,0,screen_window_width, screen_window_height};
				d3d->Blt(&rcSrc, &rcDst, gbD3DF ? 0 : 1);
			}
			b = TRUE;
		}
	}
	return b;
}
#endif /* ENABLE_D3D */

void screen_crtc_setgreencolor( MZ2000 *mz,
	unsigned char nfr, unsigned char nfg, unsigned char nfb,
	unsigned char nbr, unsigned char nbg, unsigned char nbb,
	unsigned char rfr, unsigned char rfg, unsigned char rfb,
	unsigned char rbr, unsigned char rbg, unsigned char rbb )
{
	int i;

	/* Green Display Console N */
	paletteTable[0][0].rgbBlue  = nbb;
	paletteTable[0][0].rgbGreen = nbg;
	paletteTable[0][0].rgbRed   = nbr;
	paletteTable[0][1].rgbBlue  = nfb;
	paletteTable[0][1].rgbGreen = nfg;
	paletteTable[0][1].rgbRed   = nfr;
	for (i = 2 ; i < 16; i++)
		paletteTable[0][i] = paletteTable[0][1];
	/* Green Display Console R */
	paletteTable[1][0].rgbBlue  = rbb;
	paletteTable[1][0].rgbGreen = rbg;
	paletteTable[1][0].rgbRed   = rbr;
	paletteTable[1][1].rgbBlue  = rfb;
	paletteTable[1][1].rgbGreen = rfg;
	paletteTable[1][1].rgbRed   = rfr;
	for (i = 2 ; i < 16; i++)
		paletteTable[1][i] = paletteTable[1][1];
	return;
}

void ShowMyText( HWND hWnd, MZ2000 *mz )
{
	HDC hdc;

	if (!mz->gdimem)
		return;
	hdc = GetDC(hWnd);
	if (mz->dwDebugPrint || mz->dwDebugPrint_state) {
		if (mz->dwDebugPrint_state != mz->dwDebugPrint) {
			mz->dwDebugPrint_state = mz->dwDebugPrint;
			PaletteChange( mz );
		}
		debugTextDraw80( mz, mz->dwDebugPrint );
	}
	if (!(mz -> ioinfo -> port_e8 & 0x20))
		textDraw40( mz, TEXT_ALL_REDRAW );
	else
		textDraw80( mz, TEXT_ALL_REDRAW );
	if (mz -> mzmode)
		drawGraph80B( mz );
	else
		drawGraph( mz );
#ifdef VIEWCHG
	if (mz -> viewChg) {
#else
	{
#endif
#ifdef ENABLE_D3D
		if (!Conv8to16(mz)) {
#endif
		if (screen_window_width == MZ2000_DISPLAY_WIDTH &&
				screen_window_height == MZ2000_DISPLAY_HEIGHT) {
			BitBlt( hdc, 0, 0, MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT,
				mz->Buffer, 0, 0, SRCCOPY );
		} else {
			SetStretchBltMode( hdc, SCREEN_STRETCHBLT_MODE );
			StretchBlt( hdc, 0, 0,
				screen_window_width, screen_window_height,
				mz->Buffer, 0, 0, MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT, SRCCOPY );
		}
#ifdef ENABLE_D3D
		}
#endif
		mz->viewChg = FALSE;
	}
	ReleaseDC(hWnd,hdc);
	return;
}

void ShowMyText2( HWND hWnd, MZ2000 *mz )
{
	HDC hdc;
	DWORD sx,sy,ex,ey;

	if (!mz->gdimem)
		return;
	hdc = GetDC(hWnd);
	if (viewarea.min != 0xffffff) {
		WaitForSingleObject( viewarea.hmutex, INFINITE );
		sy = viewarea.min / MZ2000_DISPLAY_WIDTH;
		ey = viewarea.max / MZ2000_DISPLAY_WIDTH;
		sx = viewarea.minx;
		ex = viewarea.maxx;
		viewarea.maxx = 0x0;
		viewarea.minx = 0xffff;
		viewarea.max = 0x0;
		viewarea.min = 0xffffff;
		ReleaseMutex( viewarea.hmutex );
#ifdef ENABLE_D3D
		if (!Conv8to16(mz)) {
#endif
		if (screen_window_width == MZ2000_DISPLAY_WIDTH &&
				screen_window_height == MZ2000_DISPLAY_HEIGHT) {
			BitBlt( hdc, sx, sy, (ex-sx) + 8, (ey-sy) + 1,
				mz->Buffer, sx, sy, SRCCOPY );
		} else if (screen_window_width == MZ2000_DISPLAY_WIDTH * 2 &&
				screen_window_height == MZ2000_DISPLAY_HEIGHT * 2) {
			SetStretchBltMode( hdc, SCREEN_STRETCHBLT_MODE );
			StretchBlt( hdc, sx * 2, sy * 2,
				((ex-sx) + 8) * 2, ((ey-sy) + 1) * 2,
				mz->Buffer, sx, sy,
				(ex-sx) + 8, (ey-sy) + 1, SRCCOPY );
		} else {
			SetStretchBltMode( hdc, SCREEN_STRETCHBLT_MODE );
			StretchBlt( hdc, 0, 0,
				screen_window_width, screen_window_height,
				mz->Buffer, 0, 0, MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT, SRCCOPY );
		}
#ifdef ENABLE_D3D
		}
#endif
		mz->viewChg = FALSE;
	}
	ReleaseDC(hWnd,hdc);
	return;
}

void drawGraph( MZ2000 *mz )
{
	BYTE *red   = mz -> gram2;
	BYTE *green = mz -> gram3;
	BYTE *blue  = mz -> gram1;
	PVRAMIMG vimg = (PVRAMIMG)mz->gdimem;
	int gramAdr,col;
	BYTE tempRed, tempGreen, tempBlue;
	BYTE *vram = (BYTE *)mz->gdimem;
	int cnt = MZ2000_DISPLAY_WIDTH;
	
#ifdef VIEWCHG
	if (!mz->gram1Chg || !mz->gram2Chg || !mz->gram3Chg)
		return;
#endif
	if (!mz->greenGraphOn && !mz->displayMode)
		return;
	if (!mz -> screen_highreso) {
		for (gramAdr = 0; gramAdr < 16000; gramAdr++) {
			tempRed   = red[gramAdr];
			tempGreen = green[gramAdr];
			tempBlue  = blue[gramAdr];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].dat = PADBYTE_INDEX;
				vimg->bit.r = (tempRed & 0x01)   ? 1 : 0;
				vimg->bit.g = (tempGreen & 0x01) ? 1 : 0;
				vimg->bit.b = (tempBlue & 0x01)  ? 1 : 0;
				tempRed >>=1;
				tempGreen >>=1;
				tempBlue >>=1;
				vimg++;
				--cnt;
			}
			if (!cnt) {
				vimg += MZ2000_DISPLAY_WIDTH;
				cnt = MZ2000_DISPLAY_WIDTH;
			}
		}
	} else {
		for (gramAdr = 0; gramAdr < 16000; gramAdr++) {
			tempRed   = red[gramAdr];
			tempGreen = green[gramAdr];
			tempBlue  = blue[gramAdr];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].bit.r = vimg->bit.r = (tempRed & 0x01)   ? 1 : 0;
				vimg[MZ2000_DISPLAY_WIDTH].bit.g = vimg->bit.g = (tempGreen & 0x01) ? 1 : 0;
				vimg[MZ2000_DISPLAY_WIDTH].bit.b = vimg->bit.b = (tempBlue & 0x01)  ? 1 : 0;
				tempRed >>=1;
				tempGreen >>=1;
				tempBlue >>=1;
				vimg++;
				--cnt;
			}
			if (!cnt) {
				vimg += MZ2000_DISPLAY_WIDTH;
				cnt = MZ2000_DISPLAY_WIDTH;
			}
		}
	}
#ifdef VIEWCHG
	mz -> gram1Chg = mz->gram2Chg = mz->gram3Chg = FALSE;
	mz -> viewChg = TRUE;
#endif
	return;
}

void drawGraph80B( MZ2000 *mz )
{
	BYTE *red  = mz->gram2;
	BYTE *blue = mz->gram1;
	PVRAMIMG vimg = (PVRAMIMG)mz->gdimem;
	int gramAdr, col;
	BYTE tempRed, tempBlue;
	BYTE *vram = (BYTE *)mz->gdimem;
	int cnt = MZ2000_DISPLAY_WIDTH / 2;

#ifdef VIEWCHG
	if (!mz->gram1Chg || !mz->gram2Chg)
		return;
#endif
	if (!mz->greenGraphOn && !mz->displayMode)
		return;
	if (!mz -> screen_highreso) {
		for (gramAdr = 0; gramAdr < 8000; gramAdr++) {
			tempRed   = mz->graphMask[1] & red[gramAdr];
			tempBlue  = mz->graphMask[0] & blue[gramAdr];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].dat = vimg[MZ2000_DISPLAY_WIDTH + 1].dat = PADBYTE_INDEX;
				vimg[1].bit.r = vimg->bit.r = (tempRed  & 0x01) ? 1 : 0;
				vimg[1].bit.b = vimg->bit.b = (tempBlue & 0x01) ? 1 : 0;
				tempRed >>= 1;
				tempBlue >>= 1;
				vimg += 2;
				--cnt;
			}
			if (!cnt) {
				vimg += MZ2000_DISPLAY_WIDTH;
				cnt = MZ2000_DISPLAY_WIDTH / 2;
			}
		}
	} else {
		for (gramAdr = 0; gramAdr < 8000; gramAdr++) {
			tempRed   = mz->graphMask[1] & red[gramAdr];
			tempBlue  = mz->graphMask[0] & blue[gramAdr];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].bit.r = vimg[MZ2000_DISPLAY_WIDTH + 1].bit.r =
					vimg[1].bit.r = vimg->bit.r = (tempRed & 0x01) ? 1 : 0;
				vimg[MZ2000_DISPLAY_WIDTH].bit.b = vimg[MZ2000_DISPLAY_WIDTH + 1].bit.b =
					vimg[1].bit.b = vimg->bit.b = (tempBlue & 0x01) ? 1 : 0;
				tempRed >>= 1;
				tempBlue >>= 1;
				vimg += 2;
				--cnt;
			}
			if (!cnt) {
				vimg += MZ2000_DISPLAY_WIDTH;
				cnt = MZ2000_DISPLAY_WIDTH / 2;
			}
		}
	}
#ifdef VIEWCHG
	mz->gram1Chg = mz->gram2Chg = mz->gram3Chg = FALSE;
	mz->viewChg = TRUE;
#endif
	return;
}

static void drawDebug80( MZ2000 *mz, BYTE *bitpat, BYTE *vram )
{
	PVRAMIMG vimg = (PVRAMIMG)vram;
	int hight, col;
	BYTE tempbitpat;

	if (!mz -> screen_highreso) {
		for (hight = 0 ; hight < 8 ; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].dat = PADBYTE_INDEX;
				vimg->bit.dbg = (tempbitpat & 0x80U) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 1272;
		}
	} else {
		for (hight = 0 ; hight < 8 ; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].bit.dbg =
					vimg->bit.dbg = (tempbitpat & 0x80U) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 1272;
		}
	}
	return;
}

static void drawGo80( MZ2000 *mz, BYTE *bitpat, BYTE *vram )
{
	PVRAMIMG vimg = (PVRAMIMG)vram;
	int hight, col;
	BYTE tempbitpat;

	if (!mz -> screen_highreso) {
		for (hight = 0; hight < 8; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].dat = PADBYTE_INDEX;
				vimg->bit.text = (tempbitpat & 0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 1272;
		}
	} else {
		for (hight = 0; hight < 8; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].bit.text =
					vimg->bit.text = (tempbitpat & 0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 1272;
		}
	}
	return;
}

static void drawGo80_400( MZ2000 *mz, BYTE *bitpat, BYTE *vram )
{
	PVRAMIMG vimg = (PVRAMIMG)vram;
	int hight, col;
	BYTE tempbitpat;

	if (!mz -> screen_highreso) {
		for (hight = 0; hight < 16; hight += 2) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg -> bit.text = (tempbitpat & 0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 632;
			for (col = 0; col < 8; col++) {
				vimg -> dat = PADBYTE_INDEX;
				vimg++;
			}
			vimg += 632;
		}
	} else {
		for (hight = 0; hight < 16; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg -> bit.text = (tempbitpat & 0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 632;
		}
	}
	return;
}

static void drawDebug80_400( MZ2000 *mz, BYTE *bitpat, BYTE *vram )
{
	PVRAMIMG vimg = (PVRAMIMG)vram;
	int hight, col;
	BYTE tempbitpat;

	if (!mz -> screen_highreso) {
		for (hight = 0; hight < 16; hight += 2) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg -> bit.dbg = (tempbitpat&0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 632;
			for (col = 0; col < 8; col++) {
				vimg -> dat = PADBYTE_INDEX;
				vimg++;
			}
			vimg += 632;
		}
	} else {
		for (hight = 0; hight < 16; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg -> bit.dbg = (tempbitpat&0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg++;
			}
			vimg += 632;
		}
	}
	return;
}

static void drawGo40( MZ2000 *mz, BYTE *bitpat, BYTE *vram )
{
	PVRAMIMG vimg = (PVRAMIMG)vram;
	int hight, col;
	BYTE tempbitpat;

	if (!mz -> screen_highreso) {
		for (hight = 0; hight < 8; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].dat = vimg[MZ2000_DISPLAY_WIDTH + 1].dat = PADBYTE_INDEX;
				vimg->bit.text = vimg[1].bit.text = (tempbitpat&0x80U) ? 1 : 0;
				tempbitpat <<= 1;
				vimg += 2;
			}
			vimg += 1264;
		}
	} else {
		for (hight = 0; hight < 8; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg[MZ2000_DISPLAY_WIDTH].bit.text = vimg[MZ2000_DISPLAY_WIDTH + 1].bit.text =
					vimg->bit.text = vimg[1].bit.text = (tempbitpat&0x80U) ? 1 : 0;
				tempbitpat <<= 1;
				vimg += 2;
			}
			vimg += 1264;
		}
	}
	return;
}

static void drawGo40_400( MZ2000 *mz, BYTE *bitpat, BYTE *vram )
{
	PVRAMIMG vimg = (PVRAMIMG)vram;
	int hight, col;
	BYTE tempbitpat;

	if (!mz -> screen_highreso) {
		for (hight = 0; hight < 16; hight += 2) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg->bit.text = vimg[1].bit.text = (tempbitpat & 0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg += 2;
			}
			vimg += 624;
			for (col = 0; col < 8; col++) {
				vimg->dat = vimg[1].dat = PADBYTE_INDEX;
				vimg += 2;
			}
			vimg += 624;
		}
	} else {
		for (hight = 0; hight < 16; hight++) {
			tempbitpat = bitpat[hight];
			for (col = 0; col < 8; col++) {
				vimg->bit.text = vimg[1].bit.text = (tempbitpat & 0x80) ? 1 : 0;
				tempbitpat <<= 1;
				vimg += 2;
			}
			vimg += 624;
		}
	}
	return;
}

static void (*drawGoDebugFunc)( MZ2000 *mz, BYTE *bitpat, BYTE *vram );
static void (*drawGo80Func)( MZ2000 *mz, BYTE *bitpat, BYTE *vram );
static void (*drawGo40Func)( MZ2000 *mz, BYTE *bitpat, BYTE *vram );

void fontSel( int sel )
{
	switch (sel) {
	case TEXTFONT_400LINE :
		drawGo80Func = drawGo80_400;
		drawGo40Func = drawGo40_400;
		drawGoDebugFunc = drawDebug80_400;
		memcpy( mzfont, mzfont16, sizeof(mzfont) );
		break;
	default : /* TEXTFONT_200LINE */
		drawGo80Func = drawGo80;
		drawGo40Func = drawGo40;
		drawGoDebugFunc = drawDebug80;
		memcpy( mzfont, mzfont8, sizeof(mzfont) );
		break;
	}
	return;
}

static void informationCollection( MZ2000* mz )
{
	int i;

	memset( mz->dvram, 0x00, 4096 );
	sprintf( (char *)&mz->dvram[1*80], "                *****  EmuZ-2000 System Information  *****    [%s]", mz->mzmode ? "MZ-80B" : "MZ-2000/2200" );
	sprintf( (char *)&mz->dvram[2*80], "                             %s",mz -> pause ?"*****  P A U S E  *****" : " ");

	/* Cassette */
	_snprintf( (char *)&mz->dvram[3*80], 80, "CAS:%s",
		mz2tape_ready() ? mz->tfilename : "<Eject>" );
	/* FD */
	for (i = 0; i < MZ_DISK_DRIVE_MAX; i++) {
		_snprintf( (char *)&mz->dvram[(i+4)*80], 80, "FD%d:%s", i + 1,
			disk_getexist( mz, i ) ? disk_getfnptr( mz, i ) : "<Eject>" );
	}
	/* QD */
	if (plugin_device_getinterface( PLUGIN_DEVICETYPE_QD )) {
		_snprintf( (char *)&mz->dvram[8*80], 80, "QD: %s",
			plugin_device_getexist( PLUGIN_DEVICETYPE_QD, 0 ) ? mz->qfilename : "<Eject>" );
	}

	sprintf( (char *)&mz->dvram[10*80], "        Display Mode : %s Monitor",
		mz->displayMode ? "Color" : "Green" );
	sprintf( (char *)&mz->dvram[11*80], "            Green Display Graphics:%s Text:%s",
		mz->greenGraphOn ? "Enable " : "Disable",
		mz->greenTextOn  ? "Enable " : "Disable");
	if (!(mz -> mzmode)) {
		sprintf( (char *)&mz->dvram[12*80], "            Color Display Text-Color:%d BG-Color:%d Priority:%s",
			mz->textColor, mz->backColor,
			mz->displayAttr ? "Graphics" : "Text    " );
	}
	sprintf( (char *)&mz->dvram[13*80], "        Select Font : %s",
		mz->font_select ? FONT400FILE : (!mz->use_fontrom ? FONT200FILE :
		(mz->font_english ? FONTEROMFILE : FONTROMFILE)) );

	sprintf( (char *)&mz->dvram[15*80], "        Sound Mode : %s      Buffer Information : %d < %d < %d",
		mz->soundmode ? "On " : "Off",  sound_stat_value2, sound_stat_value1, sound_stat_value3 );

	sprintf( (char *)&mz->dvram[17*80], "      Z80 : AF :%02X%02X BC :%02X%02X DE :%02X%02X HL :%02X%02X IX:%04X IY:%04X PC:%04X",
		z80.a, z80.f, z80.b, z80.c, z80.d, z80.e, z80.h, z80.l, z80.ix, z80.iy, z80.pc );
	sprintf( (char *)&mz->dvram[18*80], "            AF':%02X%02X BC':%02X%02X DE':%02X%02X HL':%02X%02X R:%02X            SP:%04X",
		z80.a2, z80.f2, z80.b2, z80.c2, z80.d2, z80.e2, z80.h2, z80.l2, z80.r, z80.sp );
	sprintf( (char *)&mz->dvram[20*80], "      I/O Ports :     0xD8 0xD9 0xDA 0xDB 0xDC 0xDD 0xE0 0xE1 0xE2 0xE3");
	sprintf( (char *)&mz->dvram[21*80], "                       %02X   %02X   %02X   %02X   %02X   %02X   %02X   %02X   %02X   %02X",
		mz->ioinfo->port_d8, mz->ioinfo->port_d9, mz->ioinfo->port_da, mz->ioinfo->port_db,
		mz->ioinfo->port_dc, mz->ioinfo->port_dd,
		mz->ioinfo->port_e0, mz->ioinfo->port_e1, mz->ioinfo->port_e2, mz->ioinfo->port_e3 );
	sprintf( (char *)&mz->dvram[22*80], "       0xE4 0xE5 0xE6 0xE7 0xE8 0xE9 0xEA 0xEB 0xF0 0xF4 0xF5 0xF6 0xF7");
	if (!(mz -> mzmode)) {	/* MZ-2000/2200 */
		sprintf( (char *)&mz->dvram[23*80], "        %02X   %02X   %02X   %02X   %02X   %02X   %02X   %02X   --   %02X   %02X   %02X   %02X",
			mz->ioinfo->port_e4, mz->ioinfo->port_e5, mz->ioinfo->port_e6, mz->ioinfo->port_e7,
			mz->ioinfo->port_e8, mz->ioinfo->port_e9, mz->ioinfo->port_ea, mz->ioinfo->port_eb,
			mz->ioinfo->port_f4, mz->ioinfo->port_f5, mz->ioinfo->port_f6, mz->ioinfo->port_f7 );
	} else {		/* MZ-80B/80B2 */
		sprintf( (char *)&mz->dvram[23*80], "        %02X   %02X   %02X   %02X   %02X   %02X   %02X   %02X   --   %02X   --   --   --",
			mz->ioinfo->port_e4, mz->ioinfo->port_e5, mz->ioinfo->port_e6, mz->ioinfo->port_e7,
			mz->ioinfo->port_e8, mz->ioinfo->port_e9, mz->ioinfo->port_ea, mz->ioinfo->port_eb,
			mz->ioinfo->port_f4 );
	}
	return;
}

/* flg : FALSE=clear TRUE=print */
void debugTextDraw80( MZ2000 *mz, BOOL flg )
{
	int x, y, off;
	BYTE *textvram = mz->dvram;
	BYTE *vram = (BYTE *)mz->gdimem;

	informationCollection( mz );
	off = !mz->font_english ? 0 : 256;
	for (y = 0; y < 25; y++)
		for (x = 0; x < 80; x++)
			drawGoDebugFunc( mz, flg ? mzfont[textvram[y*80+x]+off] : mzfont[0+off],
				&vram[(y*10240)+(x<<3)] );
	return;
}

void textDraw80( MZ2000 *mz, DWORD flg )
{
	int x, y, off;
	BYTE *textvram = mz->vram;
	BYTE *vram = (BYTE *)mz->gdimem;

#ifdef VIEWCHG
	if (!mz->vramChg || !vram)
		return;
	mz->vramChg = FALSE;
	mz->viewChg = TRUE;
#endif
	if (!mz->greenTextOn && !mz->displayMode || !vram)
		return;
	off = !mz->font_english ? 0 : 256;
	if (flg == TEXT_ALL_REDRAW ) {
		for (y = 0; y < 25; y++)
			for (x = 0; x < 80; x++) {
				drawGo80Func( mz, mzfont[textvram[y*80+x]+off],
					&vram[(y*10240)+(x<<3)] );
			}
	} else {
		y = flg / 80;
		x = flg % 80;
		if (y < 25) {
			DWORD tmpStart = (y*10240)+(x<<3);
			DWORD tmpEnd   = ((y+1)*10240)+(x<<3);
			drawGo80Func( mz, mzfont[textvram[y*80+x]+off], &vram[tmpStart] );
			viewarea.minx = min( viewarea.minx, tmpStart % MZ2000_DISPLAY_WIDTH );
			viewarea.maxx = max( viewarea.maxx, (tmpEnd+7) % MZ2000_DISPLAY_WIDTH );
			viewarea.max = max( viewarea.max, tmpEnd );
			viewarea.min = min( viewarea.min, tmpStart );
		}
	}
	return;
}

void textDraw40( MZ2000 *mz, DWORD flg )
{
	int x, y, off;
	BYTE *textvram = mz->vram;
	BYTE *vram = (BYTE *)mz->gdimem;

#ifdef VIEWCHG
	if (!mz->vramChg || !vram)
		return;
	mz->vramChg = FALSE;
	mz->viewChg = TRUE;
#endif
	if (!mz->greenTextOn && !mz->displayMode || !vram)
		return;
	off = !mz->font_english ? 0 : 256;
	if (flg == TEXT_ALL_REDRAW) {
		for (y = 0; y < 25; y++)
			for (x = 0; x < 40; x++ ) {
				drawGo40Func( mz, mzfont[textvram[y*40+x]+off],
					&vram[(y*10240)+(x<<4)] );
			}
	} else {
		y = flg / 40;
		x = flg % 40;
		if (y < 25) {
			DWORD tmpStart = (y*10240)+(x<<4);
			DWORD tmpEnd   = ((y+1)*10240)+(x<<4);
			drawGo40Func( mz, mzfont[textvram[y*40+x]+off], &vram[tmpStart] ) ;
			viewarea.minx = min( viewarea.minx, tmpStart % MZ2000_DISPLAY_WIDTH );
			viewarea.maxx = max( viewarea.maxx, (tmpEnd+15) % MZ2000_DISPLAY_WIDTH );
			viewarea.max = max( viewarea.max, tmpEnd );
			viewarea.min = min( viewarea.min, tmpStart );
		}
	}
	return;
}

void ChangeHighresoInit( MZ2000 *mz )
{
	int x, y;
	PVRAMIMG vimg = (PVRAMIMG)mz->gdimem;

	if (!vimg)
		return;	
	if (!mz -> screen_highreso) {
		for (y = 0; y < MZ2000_DISPLAY_HEIGHT; y+=2)
			for (x = 0; x < MZ2000_DISPLAY_WIDTH; x++)
				vimg[(y+1) * MZ2000_DISPLAY_WIDTH + x].dat = PADBYTE_INDEX;
	} else {
		for (y = 0; y < MZ2000_DISPLAY_HEIGHT; y+=2)
			for (x = 0; x < MZ2000_DISPLAY_WIDTH; x++)
				vimg[(y+1) * MZ2000_DISPLAY_WIDTH + x].dat = vimg[y * MZ2000_DISPLAY_WIDTH + x].dat;
	}
#ifdef VIEWCHG
	mz -> gram1Chg = mz->gram2Chg = mz->gram3Chg = FALSE;
	mz -> viewChg = TRUE;
#endif
	return;
}

void PaletteChange( MZ2000 *mz )
{
	int lop, paletteNumber, disable_flag;
	BYTE r = 0;
	BYTE g = 0;
	BYTE b = 0;
	static RGBQUAD temptempPaletteTable[16];

	disable_flag = FALSE;
	if (mz->displayMode == GREEN_DISPLAY || mz->mzmode) {
		/* Green Display Mode or MZ-80B Color Display */
		if (mz->ioinfo->port_e0 & 0x10U)
			paletteNumber = CONSOLE_N;
		else
			paletteNumber = CONSOLE_R;
	} else { /* Color Display Mode */
		paletteNumber = mz->displayMode * 2 + mz->displayAttr;
		if (mz -> consoler_cblank) {
			if (!(mz->ioinfo->port_e0 & 0x10U))
				disable_flag = TRUE;
		}
	}
#if 1
	LPDWORD	tmp;
	tmp = (DWORD*) &mz->paletteTableTemp[3][8];
	*tmp = *((DWORD*) &paletteTable[3][mz->textColor]);
	tmp = (DWORD*) &mz->paletteTableTemp[3][0];
	*tmp = *((DWORD*) &paletteTable[3][0]);
	tmp = (DWORD*) &mz->paletteTableTemp[2][0];
	*tmp = *((DWORD*) &paletteTable[2][0]);
#else
	mz->paletteTableTemp[3][8] = paletteTable[3][mz->textColor];
	mz->paletteTableTemp[3][0] = paletteTable[3][0];
	mz->paletteTableTemp[2][0] = paletteTable[2][0];
#endif
	for (lop = 0; lop < 8; lop++) {
#if 1
		tmp = (DWORD*) &mz->paletteTableTemp[2][lop+8];
		*tmp = *((DWORD*) &paletteTable[3][mz->textColor]);
#else
		mz->paletteTableTemp[2][lop+8] = paletteTable[3][mz->textColor];
#endif
	}
	memcpy( temptempPaletteTable, (void *)mz->paletteTableTemp[paletteNumber], sizeof(temptempPaletteTable) );
	if ((!mz->greenGraphOn && !mz->greenTextOn) || disable_flag) {
		// Display Blank
		r = paletteTable[0][0].rgbRed;
		g = paletteTable[0][0].rgbGreen;
		b = paletteTable[0][0].rgbBlue;
		for (lop = 0; lop < 16; lop++) {
			temptempPaletteTable[lop].rgbRed = r;
			temptempPaletteTable[lop].rgbGreen = g;
			temptempPaletteTable[lop].rgbBlue = b;
		}
	} else if (mz->displayMode == GREEN_DISPLAY || mz->mzmode) {
		/* Green Display Mode or MZ-80B Color Display */
		if (!mz->greenGraphOn && !mz->greenTextOn) {
			;
		} else if (!mz->greenGraphOn && 
				mz->greenTextOn && !paletteNumber) {
			// Console N, Graphic Off, Text On
			r = paletteTable[0][0].rgbRed;   // 1
			g = paletteTable[0][0].rgbGreen; // 1
			b = paletteTable[0][0].rgbBlue;  // 1
			for (lop = 0; lop < 8; lop++) {
				temptempPaletteTable[lop].rgbRed = r;
				temptempPaletteTable[lop].rgbGreen = g;
				temptempPaletteTable[lop].rgbBlue = b;
			}
		} else if (mz->greenTextOn && paletteNumber) {
			// CONSOLE R
			BYTE tmp;
			for (lop = 1; lop < 8; lop++) {
				tmp = 0;
				if (lop & 1)
					tmp |= mz->graphMask[0];
				if (lop & 2)
					tmp |= mz->graphMask[1];
				if (lop & 4)
					tmp |= mz->graphMask[2];
				tmp &= mz->greenGraphOn ? 0xff : 0;
				temptempPaletteTable[lop].rgbGreen = ~tmp;
			}
		} else { // CONSOLE N
			r = paletteTable[0][1].rgbRed;   // 1
			b = paletteTable[0][1].rgbBlue;  // 1
			g = paletteTable[0][1].rgbGreen; // 253
			for (lop = 9; lop < 16; lop++) {
				temptempPaletteTable[lop].rgbRed = r;
				temptempPaletteTable[lop].rgbGreen = g;
				temptempPaletteTable[lop].rgbBlue = b;
			}
			if (!mz->mzmode) {	/* MZ-2000 */
				for (lop = 1; lop < 8; lop++) {
					if (lop & mz->ioinfo->port_f6) {
						r = paletteTable[0][1].rgbRed;   // 1
						b = paletteTable[0][1].rgbBlue;  // 1
						g = paletteTable[0][1].rgbGreen; // 253
					} else {
						r = paletteTable[0][0].rgbRed;   // 1
						g = paletteTable[0][0].rgbGreen; // 1
						b = paletteTable[0][0].rgbBlue;  // 1
					}
					temptempPaletteTable[lop].rgbRed = r;
					temptempPaletteTable[lop].rgbGreen = g;
					temptempPaletteTable[lop].rgbBlue = b;
				}
			} else {		/* MZ-80B */
				for (lop = 1; lop < 8; lop++) {
					if (lop & ((mz->ioinfo->port_f4 & 6) >> 1)) {
						r = paletteTable[0][1].rgbRed;   // 1
						g = paletteTable[0][1].rgbGreen; // 253
						b = paletteTable[0][1].rgbBlue;  // 1
					} else {
						r = paletteTable[0][0].rgbRed;   // 1
						g = paletteTable[0][0].rgbGreen; // 1
						b = paletteTable[0][0].rgbBlue;  // 1
					}
					temptempPaletteTable[lop].rgbRed = r;
					temptempPaletteTable[lop].rgbGreen = g;
					temptempPaletteTable[lop].rgbBlue = b;
				}
			}
		}
		if (mz->displayMode != GREEN_DISPLAY) {
			/* MZ-80B Color (B/W) mode */
			for (lop = 0; lop < 16; lop++) {
				if (temptempPaletteTable[lop].rgbGreen < 128) {
					r = paletteTable[2][0].rgbRed;
					g = paletteTable[2][0].rgbGreen;
					b = paletteTable[2][0].rgbBlue;
				} else {
					r = paletteTable[2][7].rgbRed;
					g = paletteTable[2][7].rgbGreen;
					b = paletteTable[2][7].rgbBlue;
				}
				temptempPaletteTable[lop].rgbRed   = r;
				temptempPaletteTable[lop].rgbGreen = g;
				temptempPaletteTable[lop].rgbBlue  = b;
			}
		}
	} else {	/* Color Display Mode */
		for (lop = 0; lop < 8; lop++) {
			if (mz->graphMask[1])
				temptempPaletteTable[lop].rgbRed &= mz->graphMask[1];
			else
				temptempPaletteTable[lop].rgbRed = temptempPaletteTable[0].rgbRed;
			if (mz->graphMask[2])
				temptempPaletteTable[lop].rgbGreen &= mz->graphMask[2];
			else
				temptempPaletteTable[lop].rgbGreen = temptempPaletteTable[0].rgbGreen;
			if (mz->graphMask[0])
				temptempPaletteTable[lop].rgbBlue &= mz->graphMask[0];
			else
				temptempPaletteTable[lop].rgbBlue = temptempPaletteTable[0].rgbBlue;
		}
		if (mz->displayAttr == TEXT_FRONT) {
			BOOL flag;

			temptempPaletteTable[0] = paletteTable[2][mz->backColor];
			for (lop = 1; lop <= 7; lop++) {
				flag = FALSE;
				if ((lop & 2) && mz->graphMask[1])
					flag = TRUE;
				if ((lop & 4) && mz->graphMask[2])
					flag = TRUE;
				if ((lop & 1) && mz->graphMask[0])
					flag = TRUE;
				if (!flag)
					temptempPaletteTable[lop] = paletteTable[2][mz->backColor];
			}
		} else {
			BOOL flag;

			temptempPaletteTable[0] = paletteTable[3][mz->backColor];
			for (lop = 1; lop <= 7; lop++) {
				flag = FALSE;
				if ((lop & 2) && mz->graphMask[1])
					flag = TRUE;
				if ((lop & 4) && mz->graphMask[2])
					flag = TRUE;
				if ((lop & 1) && mz->graphMask[0])
					flag = TRUE;
				if (!flag)
					temptempPaletteTable[lop] = paletteTable[3][mz->backColor];
			}
			for (lop = 8; lop < 16; lop++) {
				flag = FALSE;
				if ((lop & 2) && mz->graphMask[1]) {
					temptempPaletteTable[lop].rgbRed = temptempPaletteTable[lop-8].rgbRed;
					flag = TRUE;
				}
				if ((lop & 4) && mz->graphMask[2]) {
					temptempPaletteTable[lop].rgbGreen = temptempPaletteTable[lop-8].rgbGreen;
					flag = TRUE;
				}
				if ((lop & 1) && mz->graphMask[0]) {
					temptempPaletteTable[lop].rgbBlue = temptempPaletteTable[lop-8].rgbBlue;
					flag = TRUE;
				}
				if (!flag)
					temptempPaletteTable[lop] = paletteTable[3][mz->textColor];
			}
		}
	}
	if (mz->Buffer) {
#ifdef ENABLE_D3D
		for (lop=0; lop < 16; lop++) {
			pal16[lop] = RGB16(temptempPaletteTable[lop].rgbRed,
					temptempPaletteTable[lop].rgbGreen,
					temptempPaletteTable[lop].rgbBlue );
		}
#endif
		SetDIBColorTable( mz->Buffer, 0, 16, temptempPaletteTable );
	}

	if (mz->dwDebugPrint) {
		GetDIBColorTable( mz->Buffer, 0, 16, temptempPaletteTable );
		for (lop = 0; lop < 16; lop++) {
#if 1			/* TF-Edition color */
			temptempPaletteTable[lop].rgbRed   = mz->paletteTableTemp[paletteNumber][lop].rgbRed / 2;
			temptempPaletteTable[lop].rgbGreen = mz->paletteTableTemp[paletteNumber][lop].rgbGreen / 2;
			temptempPaletteTable[lop].rgbBlue  = mz->paletteTableTemp[paletteNumber][lop].rgbBlue / 2;
#else			/* Old EmuZ-2000 color */
			if (temptempPaletteTable[lop].rgbRed > 5)
				temptempPaletteTable[lop].rgbRed = max( 60, mz->paletteTableTemp[paletteNumber][lop].rgbRed-120 );
			else
				temptempPaletteTable[lop].rgbRed = max( 65, mz->paletteTableTemp[paletteNumber][lop].rgbRed+60 );
			if (temptempPaletteTable[lop].rgbGreen > 5)
				temptempPaletteTable[lop].rgbGreen = max( 60, mz->paletteTableTemp[paletteNumber][lop].rgbGreen-120 );
			else
				temptempPaletteTable[lop].rgbGreen = max( 65, mz->paletteTableTemp[paletteNumber][lop].rgbGreen+60 );
			if (temptempPaletteTable[lop].rgbBlue > 5)
				temptempPaletteTable[lop].rgbBlue = max( 60, mz->paletteTableTemp[paletteNumber][lop].rgbBlue-120 );
			else
				temptempPaletteTable[lop].rgbBlue = max( 65, mz->paletteTableTemp[paletteNumber][lop].rgbBlue+60 );
#endif
		}
#ifdef ENABLE_D3D
		for (lop=0; lop < 16; lop++) {
			pal16[lop] = RGB16(temptempPaletteTable[lop].rgbRed,
						temptempPaletteTable[lop].rgbGreen,
						temptempPaletteTable[lop].rgbBlue );
		}
#endif
		SetDIBColorTable( mz->Buffer, 0, 16, temptempPaletteTable );
	}
	return;
}

BYTE *CreateOffScreen( MZ2000 *mz )
{
	int Counter, lop;
	int paletteNumber;
	header BufferHeader;
	HBITMAP hbm;
	HDC Screen;

	if (mz->displayMode == GREEN_DISPLAY || mz->mzmode) {
		if (mz->ioinfo->port_e0 & 0x10)
			paletteNumber = CONSOLE_N;
		else
			paletteNumber = CONSOLE_R;
	} else
		paletteNumber = mz->displayMode*2 + mz->displayAttr;

#if 1
	LPDWORD	tmp;
	tmp = (DWORD*) &mz->paletteTableTemp[3][8];
	*tmp = *((DWORD*) &paletteTable[3][mz->textColor]);
	tmp = (DWORD*) &mz->paletteTableTemp[3][0];
	*tmp = *((DWORD*) &paletteTable[3][0]);
	tmp = (DWORD*) &mz->paletteTableTemp[2][0];
	*tmp = *((DWORD*) &paletteTable[2][0]);
#else
	mz->paletteTableTemp[3][8] = paletteTable[3][mz->textColor];
	mz->paletteTableTemp[3][0] = paletteTable[3][0];
	mz->paletteTableTemp[2][0] = paletteTable[2][0];
#endif
	for (lop = 0; lop < 8; lop++) {
#if 1
		tmp = (DWORD*) &mz->paletteTableTemp[2][lop+8];
		*tmp = *((DWORD*) &paletteTable[3][mz->textColor]);
#else
		mz->paletteTableTemp[2][lop+8] = paletteTable[3][mz->textColor];
#endif
	}
	Screen = GetDC( mz->ghWnd );
	GetSystemPaletteEntries( Screen, 0, 10,LogicalPalette.aEntries );
	GetSystemPaletteEntries( Screen, 246, 10, LogicalPalette.aEntries + 246 );
	GetSystemPaletteEntries( Screen, 10, 240, LogicalPalette.aEntries + 10 );
	ReleaseDC( mz->ghWnd, Screen );

	BufferHeader.Header.biSize = sizeof(BITMAPINFOHEADER);
	BufferHeader.Header.biPlanes = 1;
	BufferHeader.Header.biBitCount = 8;
	BufferHeader.Header.biCompression = BI_RGB;
	BufferHeader.Header.biSizeImage = 0;
	BufferHeader.Header.biClrUsed = 0;
	BufferHeader.Header.biClrImportant = 0;
	BufferHeader.Header.biWidth = screen_window_width;
	BufferHeader.Header.biHeight = -screen_window_height;
			
	for (lop = 0; lop < 16; lop++) {
		switch(lop) {
		case 0 : //Nomal Mode
		case 3 : //Nomal Mode
		case 5 : //Nomal Mode
		case 6 : //Nomal Mode
		case 7 : //Nomal Mode
		case 9 : //Nomal Mode
		case 10 : //Nomal Mode
		case 11 : //Nomal Mode
		case 12 : //Nomal Mode
		case 13 : //Nomal Mode
		case 14 : //Nomal Mode
		case 15 : //Nomal Mode
		case 4 : //Reserve
		case 8 : //Reserve
			for (Counter = 0; Counter < 16; Counter++) {
				BufferHeader.aColors[lop*16+Counter].rgbRed =
					LogicalPalette.aEntries[lop*16+Counter].peRed =
					mz->paletteTableTemp[paletteNumber][Counter].rgbRed;
				BufferHeader.aColors[lop*16+Counter].rgbGreen =
					LogicalPalette.aEntries[lop*16+Counter].peGreen =
					mz->paletteTableTemp[paletteNumber][Counter].rgbGreen;
				BufferHeader.aColors[lop*16+Counter].rgbBlue =
					LogicalPalette.aEntries[lop*16+Counter].peBlue =
					mz->paletteTableTemp[paletteNumber][Counter].rgbBlue;
				BufferHeader.aColors[lop*16+Counter].rgbReserved = 0;
				LogicalPalette.aEntries[lop*16+Counter].peFlags = PC_RESERVED;
			}
			break;
		case 1 :
			for (Counter = 0; Counter < 16; Counter++) {
				BufferHeader.aColors[lop*16+Counter].rgbRed =
					LogicalPalette.aEntries[lop*16+Counter].peRed =
					paletteTable[4][Counter].rgbRed;
				BufferHeader.aColors[lop*16+Counter].rgbGreen =
					LogicalPalette.aEntries[lop*16+Counter].peGreen =
					paletteTable[4][Counter].rgbGreen;
				BufferHeader.aColors[lop*16+Counter].rgbBlue =
					LogicalPalette.aEntries[lop*16+Counter].peBlue =
					paletteTable[4][Counter].rgbBlue;
				BufferHeader.aColors[lop*16+Counter].rgbReserved = 0;
				LogicalPalette.aEntries[lop*16+Counter].peFlags = PC_RESERVED;
			}
			break;
		case 2 :
			for (Counter = 0; Counter < 16; Counter++) {
				BufferHeader.aColors[lop*16+Counter].rgbRed =
					LogicalPalette.aEntries[lop*16+Counter].peRed =
					paletteTable[5][Counter].rgbRed;
				BufferHeader.aColors[lop*16+Counter].rgbGreen =
					LogicalPalette.aEntries[lop*16+Counter].peGreen =
					paletteTable[5][Counter].rgbGreen;
				BufferHeader.aColors[lop*16+Counter].rgbBlue =
					LogicalPalette.aEntries[lop*16+Counter].peBlue =
					paletteTable[5][Counter].rgbBlue;
				BufferHeader.aColors[lop*16+Counter].rgbReserved = 0;
				LogicalPalette.aEntries[lop*16+Counter].peFlags = PC_RESERVED;
			}
			break;
		}
	}	

	BufferHeader.aColors[PADBYTE_INDEX].rgbRed =
		LogicalPalette.aEntries[PADBYTE_INDEX].peRed = 1;
	BufferHeader.aColors[PADBYTE_INDEX].rgbGreen =
		LogicalPalette.aEntries[PADBYTE_INDEX].peGreen = 1;
	BufferHeader.aColors[PADBYTE_INDEX].rgbBlue =
		LogicalPalette.aEntries[PADBYTE_INDEX].peBlue = 2;
	BufferHeader.aColors[PADBYTE_INDEX].rgbReserved = 0;
		LogicalPalette.aEntries[PADBYTE_INDEX].peFlags = PC_RESERVED;

	mz->hpalApp = CreatePalette( (LOGPALETTE *)&LogicalPalette );

#ifdef ENABLE_D3D
	Screen = GetDC(mz->ghWnd);
	hbm = CreateDIBSection( Screen, (BITMAPINFO *)&BufferHeader,
		DIB_RGB_COLORS, (void **)&mz->gdimem, NULL, 0 );
	mz->Buffer = CreateCompatibleDC( Screen );
	mz->gbmOldMonoBitmap = (HBITMAP)SelectObject( mz->Buffer, hbm );

	{
		BITMAPINFO2 bmi;
		BITMAPINFOHEADER *bmih;
		bmih = &(bmi.bmiHeader);
		bmi.dwMaskR = 0xf800;
		bmi.dwMaskG = 0x07e0;
		bmi.dwMaskB = 0x001f;

		bmih->biSize          = sizeof(BITMAPINFOHEADER);
		bmih->biWidth         = screen_window_width;
		bmih->biHeight        = -screen_window_height;
		bmih->biPlanes        = 1;
//		bmih->biBitCount      = 32;
//		bmih->biCompression   = BI_RGB;
		bmih->biBitCount      = 16;
		bmih->biCompression   = BI_BITFIELDS;
		bmih->biSizeImage     = 0;
		bmih->biXPelsPerMeter = 0;
		bmih->biYPelsPerMeter = 0;
		bmih->biClrUsed       = 0;
		bmih->biClrImportant  = 0;
	
		hbm16 = CreateDIBSection( Screen, (BITMAPINFO*)&bmi,
			DIB_RGB_COLORS, (void **)&lpBuffer16, NULL, 0 );

//		mz->gbmOldMonoBitmap = (HBITMAP)SelectObject( mz->Buffer, hbm16 );
	}
	ReleaseDC( mz->ghWnd, Screen );
#else /* ENABLE_D3D */

#ifndef DISABLE_CompatibleDC
	mz->Buffer = CreateCompatibleDC(GetDC(mz->ghWnd));
	hbm = CreateDIBSection( (void *)mz->Buffer, (BITMAPINFO *)&BufferHeader,
		DIB_RGB_COLORS, (void *)&mz->gdimem, NULL, 0);
	mz->gbmOldMonoBitmap = (HBITMAP)SelectObject( mz->Buffer, hbm );
#else
	Screen = GetDC(mz->ghWnd);
	hbm = CreateDIBSection( Screen, (BITMAPINFO *)&BufferHeader,
		DIB_RGB_COLORS, (void **)&mz->gdimem, NULL, 0);
	mz->Buffer = CreateCompatibleDC( Screen );
	mz->gbmOldMonoBitmap = (HBITMAP)SelectObject( mz->Buffer, hbm );
	ReleaseDC( mz->ghWnd, Screen );
#endif

#endif /* ENABLE_D3D */

	hPal_old = SelectPalette( mz->Buffer, mz->hpalApp, FALSE );
	PatBlt( mz->Buffer, 0, 0, screen_window_width, screen_window_height, BLACKNESS );
	return (BYTE *)mz->gdimem;
}

void FreeOffScreen( MZ2000 *mz )
{
	HBITMAP hbm;

	if (mz->Buffer) {
		SelectPalette( mz->Buffer, hPal_old, FALSE );
		hbm = (HBITMAP)SelectObject( mz->Buffer, mz->gbmOldMonoBitmap );
		DeleteObject( hbm );
		DeleteObject( mz->hpalApp );
		DeleteDC( mz->Buffer );
		mz->Buffer = NULL;
		mz->gdimem = NULL;
#ifdef ENABLE_D3D
		DeleteObject( hbm16 );
		lpBuffer16 = NULL;
#endif
	}
#ifdef ENABLE_D3D
	if (d3d) {
		delete d3d;
		d3d = NULL;
		if (rpi) {
			delete rpi;
			rpi = NULL;
		}
	}
#endif
	return;
}

} /* extern "C" */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
