/* File: wavedata.c

	SHARP MZ-2000/2200/80B/B2 Emulator "emz2000 / EmuZ-2000"
		Wave Data Accesses

	Copyright (C) 2001-2019 FUKUI, Toshio.
	This file is part of the emz2000 / EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#if defined(HAVE_STRING_H) || defined(WIN32) || defined(_WIN32)
#include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if !(defined(WIN32) || defined(_WIN32))
#include <unistd.h>
#else
#define strcasecmp(X,Y) stricmp((X),(Y))
#endif

#include "common.h"
#include "wavedata.h"

int wavedata_initstruct( WAVEDATA_STRUCT *p )
{
	assert( p );
	memset( p, 0, sizeof(WAVEDATA_STRUCT) );
	p -> fd	= -1;
	p -> ch	= 1;		/* mono */
	p -> f	= 44100;	/* 44.1KHz */
	p -> bytes = 2;		/* 16bit */
	return 0;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
