/* File: plugin.h

  	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Plugins Supports Headers

  	Unit:	MZ-1U01 (MZ-2000)
		MZ-8BK  (MZ-80B)
		The other system has the internal slots.

	Combine the EmuZ-2000 Board_SDK / emuz2000ioBoard.h, emuz2000Debug.h,
		and extend by FUKUI, Toshio and TSUNEOKA, Shinji.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#ifndef WIN32
#define BOOL	int
#define TCHAR	char
#define UCHAR	unsigned char
#define PUCHAR	UCHAR *
#define BYTE	UCHAR
#define PBYTE	BYTE *
#define LPBYTE	PBYTE
#define USHORT	unsigned short
#define DWORD	unsigned int
#define VOID	void
#define PVOID	void *
#define LPVOID	void *
#define LPCTSTR	const char *
#define LPTSTR	char *

#define HANDLE	void *
#define HINSTANCE HANDLE
#define HWND	HANDLE
#define WINAPI
#endif

#define PLUGIN_BOARD_MAXNUM		16
#define PLUGIN_GUIDLENGTH_MAXNUM	48

#define INISECTIONNAME_PLUGIN		"Plugin"
#define MAX_KEYNAME			128

#define MAX_GUID_LENGTH			PLUGIN_GUIDLENGTH_MAXNUM
#define MAX_BOARD_NAME_LENGTH		128
#define MAX_BOARD_INFO_LENGTH		128
#define MAX_DLL_COPYRIGHT_LENGTH	128
#define MAX_DLL_MAKER_URL_LENGTH	256
#define MAX_DLL_MAKER_MAIL_LENGTH	128

#define MAKE_USE_ID(n)			(1<<(n))
#define USE_INTERRUPT			MAKE_USE_ID(0)
#define USE_MAINMEMORY			MAKE_USE_ID(1)
#define USE_TEXTVRAM			MAKE_USE_ID(2)
#define USE_GRAPHICVRAM			MAKE_USE_ID(3)
#define USE_VIEWCHGMSG			MAKE_USE_ID(4)
#define USE_OTHERIO			MAKE_USE_ID(5)
#define USE_KEYEMU			MAKE_USE_ID(6)
#define USE_CALLBACKCLKCHG		MAKE_USE_ID(7)
#define USE_STATESAVE			MAKE_USE_ID(8)
#define USE_MEMORYSEGMENT		MAKE_USE_ID(28)
#define USE_SOUNDUPLOAD			MAKE_USE_ID(29)
#define USE_DEBUGGER			MAKE_USE_ID(30)
#define USE_INFODIALOG			MAKE_USE_ID(31)

typedef UCHAR (*EMUZ2000INPORTFUNC)(USHORT port);
typedef int   (*EMUZ2000OUTPORTFUNC)(USHORT port, UCHAR data);
typedef UCHAR (*EMUZ2000READMEMORYFUNC)(USHORT addr) ;
typedef int   (*EMUZ2000WRITEMEMORYFUNC)(USHORT addr, UCHAR value);

typedef struct _mapmemorystruct{
	int			seg;
	UCHAR			*ptr;
	EMUZ2000READMEMORYFUNC	readf;
	EMUZ2000WRITEMEMORYFUNC	writef;
} MAPMEMORYSTRUCT, *PMAPMEMORYSTRUCT;

typedef struct _boarduseflg{
	DWORD	bInterrupt:1;
	DWORD	bMainMemory:1;
	DWORD	bTextVram:1;
	DWORD	bGraphicVram:1;
	DWORD	bViewChgMsg:1;
	DWORD	bOtherIo:1;
	DWORD	bKeyEmu:1;
	DWORD	bCallbackClkChg:1;
	DWORD	bStateSave:1;
	DWORD	bExt9:1;
	DWORD	bExt10:1;
	DWORD	bExt11:1;
	DWORD	bExt12:1;
	DWORD	bExt13:1;
	DWORD	bExt14:1;
	DWORD	bExt15:1;
	DWORD	bExt16:1;
	DWORD	bExt17:1;
	DWORD	bExt18:1;
	DWORD	bExt19:1;
	DWORD	bExt20:1;
	DWORD	bExt21:1;
	DWORD	bExt22:1;
	DWORD	bExt23:1;
	DWORD	bExt24:1;
	DWORD	bExt25:1;
	DWORD	bExt26:1;
	DWORD	bExt27:1;
	DWORD	bMemorySegment:1;
	DWORD	bSoundDataUpload:1;
	DWORD	bExtDbgInfo:1;
	DWORD	bMoreInfo:1; /*Board Setting Dialog*/
}BOARDUSEFLG, *PBOARDUSEFLG;

typedef union _extflg{
	DWORD	val;
	BOARDUSEFLG	flg;
}EXTFLG, *PEXTFLG;

typedef struct _mapiostruct{
	EMUZ2000INPORTFUNC	fInportFunc;
	EMUZ2000OUTPORTFUNC	fOutportFunc;
	UCHAR	ucStartPort;
	UCHAR	nCount;
}MAPIOSTRUCT, *PMAPIOSTRUCT ;

typedef struct _emuz2000extendboardinformationheader{
	TCHAR	szGuidCode[MAX_GUID_LENGTH];
	TCHAR	szBoardName[MAX_BOARD_NAME_LENGTH];
	TCHAR	szBoardInfo[MAX_BOARD_INFO_LENGTH];
	TCHAR	szDllCopyright[MAX_DLL_COPYRIGHT_LENGTH];
	TCHAR	szDllMakerUrl[MAX_DLL_MAKER_URL_LENGTH];
	TCHAR	szDllMakerMail[MAX_DLL_MAKER_MAIL_LENGTH];
	DWORD	dwIoMode;
	MAPIOSTRUCT	ioMapper;
	EXTFLG	flgs;
}EmuZ2000ExtendBoardInformationHeader, EMUZ2000EBIH, *PEmuZ2000ExtendBoardInfomationHeader, *PEMUZ2000EBIH;

typedef struct _emuZ2000plugin{
	PEMUZ2000EBIH	pebih;
	HINSTANCE	hDll;
}EMUZ2000PLUGIN, *PEMUZ2000PLUGIN;

/* for Debug */
typedef struct _cpuinfo{
	UCHAR	a,b,c,d,e,f,h,l;
	UCHAR	a2,b2,c2,d2,e2,f2,h2,l2;
	USHORT	ix,iy,sp,pc;
	UCHAR	r,i,iff1,iff2,im;
}CPUINFO, *PCPUINFO;

/* for Debug */
typedef struct _brkinfo{
	DWORD	prev ;
	DWORD	enable ;
	USHORT	port ;
	USHORT	adr ;
	DWORD	next ;
}BRKINFO, *PBRKINFO;

/* Basic Service */
int   WINAPI emuz2000_getVersion(DWORD id);
short WINAPI emuz2000_getCpuMode(DWORD id);
int   WINAPI emuz2000_getCpuClock(DWORD id);
PVOID WINAPI emuz2000_getMainMemoryPointer(DWORD id);
PVOID WINAPI emuz2000_getTextVramPointer(DWORD id);
VOID  WINAPI emuz2000_getGraphicRamPointers(DWORD id, PVOID g1, PVOID g2, PVOID g3);
VOID  WINAPI emuz2000_setViewChange(DWORD id);
VOID  WINAPI emuz2000_sendKeyMessage(DWORD id, UCHAR keyCode, UCHAR flg);
VOID  WINAPI emuz2000_signalInterrupt(DWORD id, UCHAR code);
UCHAR WINAPI emuz2000_inputPort(DWORD id, USHORT port);
VOID  WINAPI emuz2000_outputPort(DWORD id, USHORT port, UCHAR data);

/* Profile Service */
DWORD WINAPI emuz2000_readProfileDword(DWORD id, LPCTSTR lpKey);
DWORD WINAPI emuz2000_readProfileString(DWORD id, LPCTSTR lpKey, LPTSTR	lpGetBuf, DWORD nGetMaxSize);
BOOL  WINAPI emuz2000_writeProfileDword(DWORD id, LPCTSTR lpKey, DWORD value);
BOOL  WINAPI emuz2000_writeProfileString(DWORD id, LPCTSTR lpKey, LPCTSTR lpString);

/* Memory Segment Collection */
BOOL  WINAPI emuz2000_getMemorySegmentInfo(DWORD id, PMAPMEMORYSTRUCT pmms);
BOOL  WINAPI emuz2000_setMemorySegmentInfo(DWORD id, PMAPMEMORYSTRUCT pmms);

/* Sound Service */
BOOL  WINAPI emuz2000_ext_Sound_Create(DWORD id, DWORD no);
BOOL  WINAPI emuz2000_ext_Sound_Play(DWORD id, DWORD no);
BOOL  WINAPI emuz2000_ext_Sound_Stop(DWORD id, DWORD no);

/* for Debug */
BOOL WINAPI emuz2000_dbg_setPcBreadPoint(DWORD id, USHORT adr);
BOOL WINAPI emuz2000_dbg_setMemoryWriteBreak(DWORD id, USHORT adr);
BOOL WINAPI emuz2000_dbg_setMemoryReadBreak(DWORD id, USHORT adr);
BOOL WINAPI emuz2000_dbg_setIoWriteBreak(DWORD id, USHORT port);
BOOL WINAPI emuz2000_dbg_setIoReadBreak(DWORD id, USHORT port);
BOOL WINAPI emuz2000_dbg_emunBreadPoints(DWORD id, DWORD mode, PBRKINFO info);
BOOL WINAPI emuz2000_dbg_clearBreakPoint(DWORD id, DWORD mode, USHORT adr) ;
BOOL WINAPI emuz2000_dbg_getCpuInformation(DWORD id, PCPUINFO info);
BOOL WINAPI emuz2000_dbg_setInternalBreak(DWORD id, USHORT adr);
BOOL WINAPI emuz2000_dbg_playControl(DWORD id, DWORD control);

/* Plugin DLL APIs */
typedef BOOL (WINAPI *PLUGININITIALIZEBOARD)(VOID);
typedef BOOL (WINAPI *PLUGINREINITIALIZEBOARD)(VOID);
typedef VOID (WINAPI *PLUGINFINALIZEBOARD)(VOID);
typedef VOID (WINAPI *PLUGINREPORTCPUCLOCK)(int clk);
typedef VOID (WINAPI *PLUGININFORMATIONDIALOG)(HWND hWnd);
typedef BOOL (WINAPI *PLUGINBOARDINFORMATIONSERVICE)(PEMUZ2000EBIH *info, DWORD id);
typedef BOOL (WINAPI *PLUGINSOUNDDATAUPLOAD)(DWORD size, PUCHAR buf);
typedef BOOL (WINAPI *PLUGINSTATESAVEOUTPUTDATA)(DWORD *size, LPBYTE buf);
typedef BOOL (WINAPI *PLUGINSTATESAVEINPUTDATA)(DWORD size, PBYTE buf);
typedef BOOL (WINAPI *PLUGINSTATESAVEOUTPUTDATAEX)(int *ver, DWORD *size, LPBYTE *buf);
typedef BOOL (WINAPI *PLUGINSTATESAVEINPUTDATAEX)(int ver, DWORD size, PBYTE buf);

/* Internal Functions */

extern VOID plugin_initialize_board(VOID);
extern VOID plugin_reinitialize_board(VOID);
extern VOID plugin_finalize_board(VOID);
extern VOID plugin_report_cpuClock(VOID);
extern VOID plugin_show_informationDialog(HWND hWnd, DWORD id);
extern PEMUZ2000EBIH plugin_get_boardInformation(DWORD id);
extern BOOL plugin_sound_dataUpload(int id, DWORD size, PUCHAR buf);
extern BOOL plugin_get_boardstateinfo(int id, char **ident, int *ver, DWORD *size, PUCHAR *buf);
extern BOOL plugin_set_boardstateinfo(char *ident, int ver, DWORD size, PUCHAR buf);

/* Internal Functions for Quick Disk Menu */

#define PLUGIN_IPLMSG_MAXNUM	16
typedef enum {
	PLUGIN_DEVICETYPE_NONE = -1,
	PLUGIN_DEVICETYPE_TAPE = 0,	/* reserved */
	PLUGIN_DEVICETYPE_FD,		/* reserved */
	PLUGIN_DEVICETYPE_QD,
	PLUGIN_DEVICETYPE_MAXNUM
} PLUGIN_DEVICETYPE_TYPE;

typedef enum {
	PLUGIN_DEVICESTATUS_NONE = 0,
	PLUGIN_DEVICESTATUS_INSERT,
	PLUGIN_DEVICESTATUS_WCHANGED,	/* QD not use */
	PLUGIN_DEVICESTATUS_MAXNUM
} PLUGIN_DEVICESTATUS_TYPE;

typedef enum {
	PLUGIN_DEVICEEJECT_NORMAL = 0,
	PLUGIN_DEVICEEJECT_CHECKONLY,
	PLUGIN_DEVICEEJECT_FORCE,
	PLUGIN_DEVICEEJECT_MAXNUM,
} PLUGIN_DEVICEEJECT_TYPE;

extern char plugin_iplmsg[PLUGIN_IPLMSG_MAXNUM + 1];		/* for Internal */
extern BOOL plugin_device_getinterface( int type );		/* have DLL ? */
extern char *plugin_device_getfnptr( int type, int drive );
extern int plugin_device_getexist( int type, int drive );	/* return status */
extern BOOL plugin_device_getwritable( int type, int drive );	/* return no read only */
extern BOOL plugin_device_getaccess( int type, int drive );	/* for access lamp */
extern BOOL plugin_device_getmodified( int type, int drive );	/* update and writeback device only */
extern BOOL plugin_device_getrunningstatus( int type, int drive ); /* for WM_CLOSE question */
extern BOOL plugin_device_writeback( int type, int drive );	/* reserved for FD support */
extern BOOL plugin_device_eject( int type, int drive, DISK_EJECT_TYPE mode );
extern BOOL plugin_device_change( int type, int drive, const char *filename, int ftype, int nomsg, int readonly );
extern BOOL plugin_device_exec( int type, int drive, const char *filename, int ftype, int readonly ); /* for Internal IPL */

#endif	/* __PLUGIN_H__ */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
