/* File: pliginDlg.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Plugins Supports Dialog

	Created by FUKUI, Toshio and TSUNEOKA, Shinji.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#include "../MZ2000/config.h"

#include <windows.h>
#include <stdio.h>

#include "../MZ2000/common.h"
#include "../MZ2000/mz2000.h"
#include "../MZ2000/resource.h"

#include "plugin.h"
#include "pluginDlg.h"

#define MAX_BOARD	PLUGIN_BOARD_MAXNUM

static BOOL DlgCenterWindow( HWND hDlg, HWND hWndParent )
{
	RECT rect;
	int tx, ty, dx, dy, sx, sy;

	/* get the target center positions */
	if (!hWndParent)
		hWndParent = GetWindow( hDlg, GW_OWNER );
	if (!hWndParent)
		return FALSE;
	GetWindowRect( hWndParent, &rect );
	tx = (rect.left + rect.right) / 2;
	ty = (rect.top + rect.bottom) / 2;

	/* move to center positions */
	GetWindowRect( hDlg, &rect );
	dx = tx - (rect.left + rect.right) / 2;
	dy = ty - (rect.top + rect.bottom) / 2;
	rect.left   += dx;
	rect.right  += dx;
	rect.top    += dy;
	rect.bottom += dy;

	/* move to inside of screen */
	sx = GetSystemMetrics( SM_CXSCREEN );
	sy = GetSystemMetrics( SM_CYSCREEN );
	if (rect.right >= sx) {
		int dd = sx - rect.right;
		rect.left  += dd;
		rect.right += dd;
	}
	if (rect.bottom >= sy) {
		int dd = sy - rect.bottom;
		rect.top    += dd;
		rect.bottom += dd;
	}
	if (rect.left < 0) {
		rect.right += -rect.left;
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.bottom += -rect.top;
		rect.top = 0;
	}

	/* update the real window positions */
	SetWindowPos( hDlg, NULL,
		rect.left, rect.top, 0, 0,
		SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	return TRUE;
}

static VOID OnInitDialog(HWND hDlg)
{
	HWND hWndCombo       = GetDlgItem(hDlg, IDC_NUMBER_COMBO);
	HWND hWndButton      = GetDlgItem(hDlg, IDC_CUSTOMSETTING_BUTTON);
	HWND hWndInformation = GetDlgItem(hDlg, IDC_INFORMATION);
	int items = 0;
	int id = 0;

	for(id = 0; id < MAX_BOARD; id++){
		char buf[LNMAX];
		PEMUZ2000EBIH pebih = plugin_get_boardInformation(id);
		if(pebih == NULL){
			continue;
		}
		_snprintf( buf, LNMAX, "%d", id);
		buf[LNMAX - 1] = '\0';
		SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM)buf);
		items++;
	}

	if(items == 0){
		EnableWindow(hWndCombo, FALSE);
		EnableWindow(hWndButton, FALSE);
		SetWindowText(hWndInformation, "plugin is not installed.");
	}
	else{
		SendMessage(hWndCombo, CB_SETCURSEL, 0, 0);
	}
}

static char *_encode_amp( const char *cp, char *wbuf )
{
	int i = 0;

	while (*cp) {
		if (*cp == '&') {
			if (i >= LNMAX - 2)
				break;
			wbuf[i] = *cp;
			i++;
		}
		if (i >= LNMAX - 1)
			break;
		wbuf[i] = *cp;
		i++;
		cp++;
	}
	wbuf[i] = '\0';
	return wbuf;
}

static VOID OnSelectChange(HWND hDlg)
{
	HWND hWndCombo       = GetDlgItem(hDlg, IDC_NUMBER_COMBO);
	HWND hWndInformation = GetDlgItem(hDlg, IDC_INFORMATION);
	HWND hWndButton = GetDlgItem(hDlg, IDC_CUSTOMSETTING_BUTTON);
	char tbuf1[LNMAX], tbuf2[LNMAX], tbuf3[LNMAX], tbuf4[LNMAX];

	PEMUZ2000EBIH pebih  = NULL;
	int index = 0;
	char buf[LNMAX];

	if((index = SendMessage(hWndCombo, CB_GETCURSEL, 0, 0)) == CB_ERR){
		return;
	}
	if(SendMessage(hWndCombo, CB_GETLBTEXT, index, (LPARAM)buf) == CB_ERR){
		return;
	}
	if((pebih = plugin_get_boardInformation(atoi(buf))) == NULL){
		return;
	}

	if(pebih->flgs.val & USE_INFODIALOG){
		EnableWindow(hWndButton, TRUE);
	}
	else{
		EnableWindow(hWndButton, FALSE);
	}

	switch(pebih->ioMapper.nCount){
		case 0:
			_snprintf( buf, sizeof(buf), "%s\n\n%s\n\n%s\n%s\n",
				_encode_amp(pebih->szBoardName, tbuf1),
				_encode_amp(pebih->szDllCopyright, tbuf2),
				_encode_amp(pebih->szDllMakerMail, tbuf3),
				_encode_amp(pebih->szDllMakerUrl, tbuf4) );
			break;
		case 1:
			_snprintf( buf, sizeof(buf), "%s\nrequired ports : $%02X\n\n%s\n\n%s\n%s\n",
				_encode_amp(pebih->szBoardName, tbuf1),
				pebih->ioMapper.ucStartPort,
				_encode_amp(pebih->szDllCopyright, tbuf2),
				_encode_amp(pebih->szDllMakerMail, tbuf3),
				_encode_amp(pebih->szDllMakerUrl, tbuf4) );
			break;
		default:
			_snprintf( buf, sizeof(buf), "%s\nrequired ports : $%02X - $%02X\n\n%s\n\n%s\n%s\n",
				_encode_amp(pebih->szBoardName, tbuf1),
				pebih->ioMapper.ucStartPort, pebih->ioMapper.ucStartPort + pebih->ioMapper.nCount - 1,
				_encode_amp(pebih->szDllCopyright, tbuf2),
				_encode_amp(pebih->szDllMakerMail, tbuf3),
				_encode_amp(pebih->szDllMakerUrl, tbuf4) );
			break;
	}
	buf[sizeof(buf) - 1] = '\0';
	SetWindowText(hWndInformation, buf);
}

static VOID OnClickCustomButton(HWND hDlg)
{
	HWND hWndCombo = GetDlgItem(hDlg, IDC_NUMBER_COMBO);
	char buf[LNMAX];
	int index;

	if((index = SendMessage(hWndCombo, CB_GETCURSEL, 0, 0)) == CB_ERR){
		return;
	}
	if(SendMessage(hWndCombo, CB_GETLBTEXT, index, (LPARAM)buf) == CB_ERR){
		return;
	}
	buf[sizeof(buf) - 1] = '\0';
	plugin_show_informationDialog(hWndCombo, atoi(buf));
}

BOOL WINAPI DlgProcPlugin(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg){
		case WM_INITDIALOG:
			/* set the window attributes */
			DlgCenterWindow( hDlg, NULL );
			/* set the parameters */
			OnInitDialog(hDlg);
			OnSelectChange(hDlg);
			return TRUE;
		case WM_COMMAND:
			switch (wParam){
				case IDC_CUSTOMSETTING_BUTTON:
					OnClickCustomButton(hDlg);
					return TRUE;
				case IDOK:
					EndDialog(hDlg, TRUE);
					return TRUE;
				case IDCANCEL:
					EndDialog(hDlg, FALSE);
					return TRUE;
			}
			if(LOWORD(wParam) == IDC_NUMBER_COMBO){
				if(HIWORD(wParam) == CBN_SELCHANGE){
					OnSelectChange(hDlg);
				}
				return TRUE;
			}
			break;
	}
	return FALSE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
