/* File: z80.h

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Z-80 Main Routines Headers

	Combine the emz2000 z80.h, EmuZ-2000 z80.h,
		and modified by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __Z80_H_INCLUDED
#define __Z80_H_INCLUDED

#include <windows.h>

typedef unsigned char u8;
typedef signed char s8;
typedef unsigned short u16;
typedef signed short s16;
typedef LONGLONG z80clk;

struct z80mement {
	u8 *ptr;
	u8 (*readf)(u16 addr);
	int (*writef)(u16 addr, u8 value);
};

struct z80ioent {
	u8 (*readf)(u16 port);
	int (*writef)(u16 port, u8 value);
};

typedef volatile struct z80 {
	struct z80mement mem[16];
#ifdef IO16BIT
	struct z80ioent io[65536];
#else
	struct z80ioent io[256];
#endif
	u8 a,b,c,d,e,f,h,l;
	u8 a2,b2,c2,d2,e2,f2,h2,l2;
	u16 ix,iy,sp;
	volatile u16 pc;
	u8 r,i,iff1,iff2,im;
	volatile int halt_state;
	volatile int external_signal;
	volatile int onbus;
	volatile int stop;
	volatile z80clk internal_clock;
	volatile z80clk left_clock;
	volatile int speed_khz;
	LONG z80_mutex;
	volatile int timer_wait;
	HANDLE timer_cond;
	LONG timer_mutex;
#ifdef TRACE
	int trace;
#endif
	int (*(*instructs[7]))();
} Z80;

extern Z80 z80;

#define NO_SIGNAL 0
#define RESET_SIGNAL 1
#define NMI_SIGNAL 2 
#define INT_SIGNAL 4

#define DEFAULT_SPEED_KHZ	4000
#define Z80_TIMER_MSEC		MZ2000_REFRESHRATE

extern int z80_init( int speed_khz );
extern void z80_exit( void );
extern int z80_timer( void );
extern int start_z80( void );
extern int run_z80_2( int enable_halt_exit );
extern int run_z80( void );
extern int reset_z80( void );
extern int int_z80( int onbus );
extern int nmi_z80( void );
extern int stop_z80( void );
extern z80clk get_internal_clock( void );
extern int setspeed_z80( int speed_khz );
extern int getspeed_z80( void );
extern z80clk get_frameclk_z80( void );
extern int set_ioent( int port,
	u8 (*readf)(u16 port),
	int (*writef)(u16 port, u8 value) );
extern int get_ioent( int port,
	u8 (**readf)(u16 port),
	int (**writef)(u16 port, u8 value) );
extern int set_mement( int segment, u8 *ptr,
	u8 (*readf)(u16 addr),
	int (*writef)(u16 addr,u8 value) );
extern int get_mement( int segment, u8 **ptr,
	u8 ((**readf)(u16 addr)),
	int ((**writef)(u16 addr,u8 value)) );
#ifdef TRACE
extern void trace_on( void );
extern void trace_off( void );
#endif
extern void print_registers( void );

#endif /* __Z80_H_INCLUDED */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
