/* File: clockDlg.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		System Clock Settings Dialog

	Modified EmuZ-2000 clockDlg.c by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#include "config.h"

#include <windows.h>
#include <commctrl.h>
#include <string.h>

#include "common.h"
#include "mz2000.h"
#include "clockDlg.h"
#include "resource.h"

static BOOL DlgCenterWindow( HWND hDlg, HWND hWndParent )
{
	RECT rect;
	int tx, ty, dx, dy, sx, sy;

	/* get the target center positions */
	if (!hWndParent)
		hWndParent = GetWindow( hDlg, GW_OWNER );
	if (!hWndParent)
		return FALSE;
	GetWindowRect( hWndParent, &rect );
	tx = (rect.left + rect.right) / 2;
	ty = (rect.top + rect.bottom) / 2;

	/* move to center positions */
	GetWindowRect( hDlg, &rect );
	dx = tx - (rect.left + rect.right) / 2;
	dy = ty - (rect.top + rect.bottom) / 2;
	rect.left   += dx;
	rect.right  += dx;
	rect.top    += dy;
	rect.bottom += dy;

	/* move to inside of screen */
	sx = GetSystemMetrics( SM_CXSCREEN );
	sy = GetSystemMetrics( SM_CYSCREEN );
	if (rect.right >= sx) {
		int dd = sx - rect.right;
		rect.left  += dd;
		rect.right += dd;
	}
	if (rect.bottom >= sy) {
		int dd = sy - rect.bottom;
		rect.top    += dd;
		rect.bottom += dd;
	}
	if (rect.left < 0) {
		rect.right += -rect.left;
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.bottom += -rect.top;
		rect.top = 0;
	}

	/* update the real window positions */
	SetWindowPos( hDlg, NULL,
		rect.left, rect.top, 0, 0,
		SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	return TRUE;
}

BOOL WINAPI DlgProcClock( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	int t;
	char buf[LNMAX];

	switch (msg) {
	case WM_INITDIALOG :
		/* set the window attributes */
		DlgCenterWindow( hDlg, NULL );

		/* set the parameters */
		_snprintf( buf, LNMAX, "%d", mz2000_global -> nowZ80Clock / 1000 );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_SYSCLOCK, WM_SETTEXT, 0, (LPARAM)buf );
		SendDlgItemMessage( hDlg, IDC_SPIN_SYSCLOCK, UDM_SETRANGE, 0,
			MAKELONG( mz2000_global -> z80MaxClock / 1000, 1 ) );

		_snprintf( buf, LNMAX, "%d", mz2000_global -> memory_waittvramclock_r );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAITVRAMR, WM_SETTEXT, 0, (LPARAM)buf );
		_snprintf( buf, LNMAX, "%d", mz2000_global -> memory_waittvramclock_w );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAITVRAMW, WM_SETTEXT, 0, (LPARAM)buf );

		_snprintf( buf, LNMAX, "%d", mz2000_global -> memory_waitgramclock_r );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM2R, WM_SETTEXT, 0, (LPARAM)buf );
		_snprintf( buf, LNMAX, "%d", mz2000_global -> memory_waitgramclock_w );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM2W, WM_SETTEXT, 0, (LPARAM)buf );

		_snprintf( buf, LNMAX, "%d", mz2000_global -> memory_waitgram80bclock_r );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM8R, WM_SETTEXT, 0, (LPARAM)buf );
		_snprintf( buf, LNMAX, "%d", mz2000_global -> memory_waitgram80bclock_w );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM8W, WM_SETTEXT, 0, (LPARAM)buf );

		_snprintf( buf, LNMAX, "%d", mz2000_global -> frameclock_alpha );
		buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
		SendDlgItemMessage( hDlg, IDC_EDIT_FRAMEALPHA, WM_SETTEXT, 0, (LPARAM)buf );
		return TRUE;
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
			SendDlgItemMessage( hDlg, IDC_EDIT_SYSCLOCK, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > mz2000_global -> z80MaxClock / 1000) {
				MessageBox( NULL, "System clock value range error",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> nowZ80Clock = t * 1000;
			if (mz2000_global -> nowZ80Clock > mz2000_global -> z80MaxClock)
				mz2000_global -> nowZ80Clock = mz2000_global -> z80MaxClock;
			if (mz2000_global -> nowZ80Clock < 1000)
				mz2000_global -> nowZ80Clock = 1000;

			SendDlgItemMessage( hDlg, IDC_EDIT_WAITVRAMR, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 1000) {
				MessageBox( NULL, "Text V-RAM read wait value range error (1-1000)",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> memory_waittvramclock_r = t;
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITVRAMW, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 1000) {
				MessageBox( NULL, "Text V-RAM write wait value range error (1-1000)",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> memory_waittvramclock_w = t;

			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM2R, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 1000) {
				MessageBox( NULL, "MZ-2000/2200 G-RAM read wait value range error (1-1000)",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> memory_waitgramclock_r = t;
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM2W, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 1000) {
				MessageBox( NULL, "MZ-2000/2200 G-RAM write wait value range error (1-1000)",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> memory_waitgramclock_w = t;

			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM8R, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 1000) {
				MessageBox( NULL, "MZ-80B/80B2 G-RAM read wait value range error (1-1000)",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> memory_waitgram80bclock_r = t;
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM8W, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < 1 || t > 1000) {
				MessageBox( NULL, "MZ-80B/80B2 G-RAM write wait value range error (1-1000)",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> memory_waitgram80bclock_w = t;

			SendDlgItemMessage( hDlg, IDC_EDIT_FRAMEALPHA, WM_GETTEXT, 10, (LPARAM)buf );
			if (sscanf( buf, "%d", &t ) != 1 || t < -5000 || t > 5000) {
				MessageBox( NULL, "Frame additional clock value range error (-5000<=0<=5000)",
					"Hardware Speed Settings", MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
				return FALSE;
			}
			mz2000_global -> frameclock_alpha = t;
			EndDialog( hDlg, TRUE );
			return TRUE;
		case IDCANCEL :
			EndDialog( hDlg, FALSE );
			return TRUE;
		case IDC_BUTTON_DEFAULT :
			_snprintf( buf, LNMAX, "%d", DEFAULT_SPEED_KHZ / 1000 );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_SYSCLOCK, WM_SETTEXT, 0, (LPARAM)buf );

			_snprintf( buf, LNMAX, "%d", MZMEMORY_WAITTVRAMCLOCK_R );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITVRAMR, WM_SETTEXT, 0, (LPARAM)buf );
			_snprintf( buf, LNMAX, "%d", MZMEMORY_WAITTVRAMCLOCK_W );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITVRAMW, WM_SETTEXT, 0, (LPARAM)buf );

			_snprintf( buf, LNMAX, "%d", MZMEMORY_WAITGRAMCLOCK_R );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM2R, WM_SETTEXT, 0, (LPARAM)buf );
			_snprintf( buf, LNMAX, "%d", MZMEMORY_WAITGRAMCLOCK_W );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM2W, WM_SETTEXT, 0, (LPARAM)buf );

			_snprintf( buf, LNMAX, "%d", MZMEMORY_WAITGRAM80BCLOCK_R );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM8R, WM_SETTEXT, 0, (LPARAM)buf );
			_snprintf( buf, LNMAX, "%d", MZMEMORY_WAITGRAM80BCLOCK_W );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_WAITGRAM8W, WM_SETTEXT, 0, (LPARAM)buf );

			_snprintf( buf, LNMAX, "%d", MZCLOCK_ADJUSTVALUE );
			buf[LNMAX - 1] = '\0';	/* VC6 is not C99 */
			SendDlgItemMessage( hDlg, IDC_EDIT_FRAMEALPHA, WM_SETTEXT, 0, (LPARAM)buf );
			break;
		}
		break;
	}
	return FALSE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
