/* File: config2.h

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Configurations Settings - II

	Copyright (C) 2002-2019 FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __CONFIG2_H_INCLUDED
#define __CONFIG2_H_INCLUDED

/* filenames settings */
/* ROM files */
#define FONTROMFILE		"mzfont.rom"
#define FONTEROMFILE		"mzfonte.rom"
#define MZ20IPLROMFILE		"mz20_ipl.rom"
#define MZ8BIPLROMFILE		"mz80bipl.rom"
/* no ROM files */
#define FONT200FILE		"mzfont.bmp"
#define FONT400FILE		"mzfont24.bmp"
#define MZMONIPLFILE		"mzmonipl.bin"
#define CHARCODEFILE		"emuz2000_charcode.txt"

/* ini file settings */
#define INIFILEEXT		"ini"
#define INIFILENAME		"EmuZ2000TF.ini"
#define INISECTIONNAME_BASIC	"BasicSettings"

/* green monitor settings in the color definitions */
#define MZGREENCOLORN_FR_DEFAULT	1
#define MZGREENCOLORN_FG_DEFAULT	253
#define MZGREENCOLORN_FB_DEFAULT	1
#define MZGREENCOLORN_BR_DEFAULT	2
#define MZGREENCOLORN_BG_DEFAULT	1
#define MZGREENCOLORN_BB_DEFAULT	1
#define MZGREENCOLORR_FR_DEFAULT	1
#define MZGREENCOLORR_FG_DEFAULT	1
#define MZGREENCOLORR_FB_DEFAULT	1
#define MZGREENCOLORR_BR_DEFAULT	2
#define MZGREENCOLORR_BG_DEFAULT	253
#define MZGREENCOLORR_BB_DEFAULT	1

/* memory timings */
#define MZCLOCK_ADJUSTVALUE		0	/* WinXP=600 */
#define MZMEMORY_WAITTVRAMCLOCK_R	17
#define MZMEMORY_WAITTVRAMCLOCK_W	17
#define MZMEMORY_WAITGRAMCLOCK_R	34
#define MZMEMORY_WAITGRAMCLOCK_W	34
#define MZMEMORY_WAITGRAM80BCLOCK_R	34
#define MZMEMORY_WAITGRAM80BCLOCK_W	34

/* tape counter parameters */
#define TAPECOUNTER_DEFAULTSPEED_2000	58500
#define TAPECOUNTER_DEFAULTSPEED_80B	56000
#define TAPECOUNTER_DEFAULTSPEED_2500	70500

/* tape parameters */
#define	DEFAULT_TAPE_PITCH		60
#define DEFAULT_TAPE_THRESHOLD		128	/* 0x80 */
#define DEFAULT_TAPE_AMPLITUDERANGE	64	/* 0x40 */
#define DEFAULT_TAPE_WRITETHRESHOLD	128	/* 0x80 */
#define TAPE_PITCH_OFFSET		0	/* pitch = current pitch + TAPE_PITCH_OFFSET */

/* sound parameters */
#define DEFAULT_SOUND_VOLUME1		75	/* MZ pulse sound */
#define DEFAULT_SOUND_VOLUME2		95	/* wave sound effects */
#define DEFAULT_SOUND_BIT		16
#define DEFAULT_SOUND_FREQ		62000
#define DEFAULT_SOUND_PLAYBUFFER_MS	200
#define DEFAULT_SOUND_DELAYTIME_MS	500

/* text paste parameters */
#define PASTE_MONITOR_DEFAULT		PASTE_MONITOR_NORMAL
#define PASTE_WAIT_DEFAULT		(2-1)	/* press 20 ms, release 20ms */
#define PASTE_WAITCR_DEFAULT		(60-1)	/* press 600 ms, release PASTE_WAIT_DEFAULT ms */

/* configuration options */
#define	VIEWCHG			/* ENABLE_VIEWCHG differential update for draw of the screen */
#define ENABLE_RESIZE		/* freely resizable */
#undef	ENABLE_DDRAWBLT		/* enable fast draw (can't run yet) */
#undef  ENABLE_RESTART_SOUNDSETTINGS /* enable require to restart after sound configurations */
#define ENABLE_STATUSBAR_MW	/* enable StatusBar with MoveWindow */
#define	DISABLE_CompatibleDC	/* perhaps, I feel <>WIN9X/ME only */
#undef  ENABLE_D3D		/* enable the Rednow's Direct 3D code, but insufficiency source codes */
#undef	ENABLE_REGISTORIES	/* enable set registories (only .mze autostart supports) */

#endif /* __CONFIG2_H_INCLUDED */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
