/* File: tapeDlg.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Tape Settings Dialog

	Modified EmuZ-2000 tapeDlg.c by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#include "config.h"

#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "mz2000.h"
#include "resource.h"

static BOOL DlgCenterWindow( HWND hDlg, HWND hWndParent )
{
	RECT rect;
	int tx, ty, dx, dy, sx, sy;

	/* get the target center positions */
	if (!hWndParent)
		hWndParent = GetWindow( hDlg, GW_OWNER );
	if (!hWndParent)
		return FALSE;
	GetWindowRect( hWndParent, &rect );
	tx = (rect.left + rect.right) / 2;
	ty = (rect.top + rect.bottom) / 2;

	/* move to center positions */
	GetWindowRect( hDlg, &rect );
	dx = tx - (rect.left + rect.right) / 2;
	dy = ty - (rect.top + rect.bottom) / 2;
	rect.left   += dx;
	rect.right  += dx;
	rect.top    += dy;
	rect.bottom += dy;

	/* move to inside of screen */
	sx = GetSystemMetrics( SM_CXSCREEN );
	sy = GetSystemMetrics( SM_CYSCREEN );
	if (rect.right >= sx) {
		int dd = sx - rect.right;
		rect.left  += dd;
		rect.right += dd;
	}
	if (rect.bottom >= sy) {
		int dd = sy - rect.bottom;
		rect.top    += dd;
		rect.bottom += dd;
	}
	if (rect.left < 0) {
		rect.right += -rect.left;
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.bottom += -rect.top;
		rect.top = 0;
	}

	/* update the real window positions */
	SetWindowPos( hDlg, NULL,
		rect.left, rect.top, 0, 0,
		SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	return TRUE;
}

VOID OnSliderChanged( HWND hDlg )
{
	TCHAR strBuffer[10];

	/* get the handles from dialog items */
	HWND hPitchSlider       = GetDlgItem( hDlg, IDC_PITCH_SLIDER );
	HWND hThresholdSlider   = GetDlgItem( hDlg, IDC_THRESHOLD_SLIDER );
	HWND hWAmpRangeSlider   = GetDlgItem( hDlg, IDC_AMPLITUDERANGE_SLIDER );
	HWND hWriteCenterSlider = GetDlgItem( hDlg, IDC_WCENTER_SLIDER );

	/* get the positions of the sliders */
	DWORD lPitch          = SendMessage( hPitchSlider,       TBM_GETPOS, 0, 0 );
	DWORD lThreshold      = SendMessage( hThresholdSlider,   TBM_GETPOS, 0, 0 );
	DWORD lWAmpRange      = SendMessage( hWAmpRangeSlider,   TBM_GETPOS, 0, 0 );
	DWORD lWriteCenter    = SendMessage( hWriteCenterSlider, TBM_GETPOS, 0, 0 );

	/* set to the static text boxes */
	wsprintf( strBuffer, TEXT("%ld"), lPitch );
	SetWindowText( GetDlgItem( hDlg, IDC_PITCH ), strBuffer );
	wsprintf( strBuffer, TEXT("%ld"), lThreshold );
	SetWindowText( GetDlgItem( hDlg, IDC_THRESHOLD ), strBuffer );
	wsprintf( strBuffer, TEXT("%ld"), lWAmpRange );
	SetWindowText( GetDlgItem( hDlg, IDC_AMPLITUDERANGE ), strBuffer );
	wsprintf( strBuffer, TEXT("%ld"), lWriteCenter );
	SetWindowText( GetDlgItem( hDlg, IDC_WCENTER ), strBuffer );
	return;
}

VOID SetSlidersPos( HWND hDlg, DWORD lPitchSlider, DWORD lThresholdSlider,
	DWORD lWAmpRangeSlider, DWORD lWriteCenterSlider )
{
	/* get the handles from dialog items */
	HWND hPitchSlider       = GetDlgItem( hDlg, IDC_PITCH_SLIDER );
	HWND hThresholdSlider   = GetDlgItem( hDlg, IDC_THRESHOLD_SLIDER );
	HWND hAmpRangeSlider    = GetDlgItem( hDlg, IDC_AMPLITUDERANGE_SLIDER );
	HWND hWriteCenterSlider = GetDlgItem( hDlg, IDC_WCENTER_SLIDER );
	TCHAR strBuffer[10];

	PostMessage( hPitchSlider,       TBM_SETPOS, TRUE, lPitchSlider );
	PostMessage( hThresholdSlider,   TBM_SETPOS, TRUE, lThresholdSlider );
	PostMessage( hAmpRangeSlider,    TBM_SETPOS, TRUE, lWAmpRangeSlider );
	PostMessage( hWriteCenterSlider, TBM_SETPOS, TRUE, lWriteCenterSlider );

	wsprintf( strBuffer, TEXT("%ld"), lPitchSlider );
	SetWindowText( GetDlgItem( hDlg, IDC_PITCH ), strBuffer );
	wsprintf( strBuffer, TEXT("%ld"), lThresholdSlider );
	SetWindowText( GetDlgItem( hDlg, IDC_THRESHOLD ), strBuffer );
	wsprintf( strBuffer, TEXT("%ld"), lWAmpRangeSlider );
	SetWindowText( GetDlgItem( hDlg, IDC_AMPLITUDERANGE ), strBuffer );
	wsprintf( strBuffer, TEXT("%ld"), lWriteCenterSlider );
	SetWindowText( GetDlgItem( hDlg, IDC_WCENTER ), strBuffer );
	return;
}

VOID GetSlidersPos( HWND hDlg, DWORD *lPitchSlider, DWORD *lThresholdSlider,
	DWORD *lWAmpRangeSlider, DWORD *lWriteCenterSlider )
{
	/* get the handles from dialog items */
	HWND hPitchSlider       = GetDlgItem( hDlg, IDC_PITCH_SLIDER );
	HWND hThresholdSlider   = GetDlgItem( hDlg, IDC_THRESHOLD_SLIDER );
	HWND hAmpRangeSlider    = GetDlgItem( hDlg, IDC_AMPLITUDERANGE_SLIDER );
	HWND hWriteCenterSlider = GetDlgItem( hDlg, IDC_WCENTER_SLIDER );

	*lPitchSlider       = SendMessage( hPitchSlider,       TBM_GETPOS, 0, 0 );
	*lThresholdSlider   = SendMessage( hThresholdSlider,   TBM_GETPOS, 0, 0 );
	*lWAmpRangeSlider   = SendMessage( hAmpRangeSlider,    TBM_GETPOS, 0, 0 );
	*lWriteCenterSlider = SendMessage( hWriteCenterSlider, TBM_GETPOS, 0, 0 );
	return;
}

VOID SetCheckValue( HWND hDlg, DWORD lReversedata, DWORD lIgnoreff, DWORD lWriteInterpolation )
{
	HWND hCheckReverse  = GetDlgItem( hDlg, IDC_CHECK_REVERSE );
	HWND hCheckIgnoreFF = GetDlgItem( hDlg, IDC_CHECK_IGNOREFF );
	HWND hCheckWriteInterpolation = GetDlgItem( hDlg, IDC_CHECK_WRITELINEAR );

	SendMessage( hCheckReverse,  BM_SETCHECK, lReversedata ? TRUE : FALSE, 0 );
	SendMessage( hCheckIgnoreFF, BM_SETCHECK, lIgnoreff ? TRUE : FALSE, 0 );
	SendMessage( hCheckWriteInterpolation, BM_SETCHECK, lWriteInterpolation ? TRUE : FALSE, 0 );
	return;
}

VOID GetCheckValue( HWND hDlg, DWORD *lReversedata, DWORD *lIgnoreff, DWORD *lWriteInterpolation )
{
	HWND hCheckReverse = GetDlgItem( hDlg, IDC_CHECK_REVERSE );
	HWND hCheckIgnoreFF = GetDlgItem( hDlg, IDC_CHECK_IGNOREFF );
	HWND hCheckWriteInterpolation = GetDlgItem( hDlg, IDC_CHECK_WRITELINEAR );

	*lReversedata = SendMessage( hCheckReverse,  BM_GETCHECK, 0, 0 );
	*lIgnoreff    = SendMessage( hCheckIgnoreFF, BM_GETCHECK, 0, 0 );
	*lWriteInterpolation = SendMessage( hCheckWriteInterpolation, BM_GETCHECK, 0, 0 );
	return;
}

VOID OnInitDialog( HWND hDlg, DWORD pich, DWORD threshold,
	DWORD writeAmplitude, DWORD writeCenter,
	DWORD checkreverse, DWORD checkignoreff, DWORD checkinterpolation )
{
	/* get the handles from dialog items */
	HWND hPitchSlider       = GetDlgItem( hDlg, IDC_PITCH_SLIDER );
	HWND hThresholdSlider   = GetDlgItem( hDlg, IDC_THRESHOLD_SLIDER );
	HWND hAmpRangeSlider    = GetDlgItem( hDlg, IDC_AMPLITUDERANGE_SLIDER );
	HWND hWriteCenterSlider = GetDlgItem( hDlg, IDC_WCENTER_SLIDER );

	/* set to the ranges of the pitch sliders */
	PostMessage( hPitchSlider, TBM_SETRANGEMAX, TRUE, 110);
	PostMessage( hPitchSlider, TBM_SETRANGEMIN, TRUE, 10 );

	/* set to the ranges of the read threshold sliders */
	PostMessage( hThresholdSlider, TBM_SETRANGEMAX, TRUE, 200 );
	PostMessage( hThresholdSlider, TBM_SETRANGEMIN, TRUE, 40 );

	/* set to the ranges of the write amplitude sliders */
	PostMessage( hAmpRangeSlider, TBM_SETRANGEMAX, TRUE, 127 );
	PostMessage( hAmpRangeSlider, TBM_SETRANGEMIN, TRUE, 1 );

	/* set to the ranges of the write center sliders */
	PostMessage( hWriteCenterSlider, TBM_SETRANGEMAX, TRUE, 200 );
	PostMessage( hWriteCenterSlider, TBM_SETRANGEMIN, TRUE, 40 );

	/* set to the positions of the sliders */
	SetSlidersPos( hDlg, pich, threshold, writeAmplitude, writeCenter );

	/* set to the states of the check boxes */
	SetCheckValue( hDlg, checkreverse, checkignoreff, checkinterpolation );
	return;
}

BOOL WINAPI DlgProcTape( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	int t1, t2, t3;

	switch (msg) {
	case WM_INITDIALOG :
		/* set the window attributes */
		DlgCenterWindow( hDlg, NULL );
		/* set the parameters */
		OnInitDialog( hDlg,
			mz2000_global -> tapePitch, mz2000_global -> tapeThreshold,
				mz2000_global -> amplitudeRange, mz2000_global -> writeThreshold,
				mz2000_global -> tapemode_reverse,
				mz2000_global -> tapeff_ignore,
				mz2000_global -> tapewrite_interpolation );
		return TRUE;
	case WM_NOTIFY :
		OnSliderChanged( hDlg );
		return TRUE;
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
			GetSlidersPos( hDlg, (void *)&mz2000_global -> tapePitch,
				(void *)&mz2000_global -> tapeThreshold,
				(void *)&mz2000_global -> amplitudeRange,
				(void *)&mz2000_global -> writeThreshold );
			GetCheckValue( hDlg, &t1, &t2, &t3 );
			mz2000_global -> tapemode_reverse = t1;
			mz2000_global -> tapeff_ignore = t2;
			mz2000_global -> tapewrite_interpolation = t3;
			EndDialog( hDlg, TRUE );
			return TRUE;
		case IDCANCEL :
			EndDialog( hDlg, FALSE );
			return TRUE;
		case IDC_BUTTON_DEFAULT :
			SetSlidersPos( hDlg, DEFAULT_TAPE_PITCH, DEFAULT_TAPE_THRESHOLD,
				DEFAULT_TAPE_AMPLITUDERANGE, DEFAULT_TAPE_WRITETHRESHOLD );
			SetCheckValue( hDlg, FALSE, FALSE, FALSE );
			return TRUE;
		}
		break;
	default :
		break;
	}
	return FALSE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
