/* File: util.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Utilities Subroutines

	Created by FUKUI, Toshio and TSUNEOKA, Shinji.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef WINDOWS
#include <limits.h>
#endif

#include "util.h"

int StrICmp(const char *lpcszDest, const char *lpcszSrc)
{
	int iDestChar, iSrcChar;

	do{
		iDestChar = (unsigned char)(*(lpcszDest++));
		if((iDestChar >= 'A') && (iDestChar <= 'Z')){
			iDestChar -= ('A' - 'a');
		}
		iSrcChar = (unsigned char)(*(lpcszSrc++));
		if((iSrcChar >= 'A') && (iSrcChar <= 'Z')){
			iSrcChar -= ('A' - 'a');
		}
	}while(iDestChar && (iDestChar == iSrcChar));

	return (iDestChar - iSrcChar);
}

char *StrIStr(const char *lpcszStr1, const char *lpcszStr2)
{
	char *lpszCmp = (char *)lpcszStr1;
	char *lpszTemp1, *lpszTemp2;

	if(*lpcszStr2 == '\0'){
		return (char *)lpcszStr1;
	}

	while(*lpszCmp){
		lpszTemp1 = lpszCmp;
		lpszTemp2 = (char *)lpcszStr2;

		while((*lpszTemp1 != '\0')&&(*lpszTemp2 != '\0')
		 &&((tolower(*lpszTemp1) == tolower(*lpszTemp2)))){
			lpszTemp1++;
			lpszTemp2++;
		}
		if(*lpszTemp2 == '\0'){
			return lpszCmp;
		}
		lpszCmp++;
	}

	return NULL;
}

int CreateSnapshot(const char *lpcszFileName, void **lplpvBuff, unsigned int *lpuSize)
#ifdef WIN32
{
	HANDLE	hFile = NULL;
	DWORD	dwBuffSize, dwTotalReaded = 0, dwReaded = 0;
	LPSTR	lpszBuff = NULL, lpsz = NULL;
	int 	iResult = 0;

	*lpuSize = 0L;

	hFile = CreateFile(lpcszFileName, GENERIC_READ, FILE_SHARE_READ,
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile == INVALID_HANDLE_VALUE){
		return GetLastError();
	}

	__try{
		if((dwBuffSize = GetFileSize(hFile, NULL)) == -1){
			iResult = GetLastError();
			__leave;
		}

		if((lpszBuff = malloc(dwBuffSize + 1)) == NULL){
			iResult = errno;
			__leave;
		}

		for(lpsz = lpszBuff; dwTotalReaded < dwBuffSize; lpsz += dwReaded){
			if(ReadFile(hFile, lpsz, dwBuffSize, &dwReaded, NULL) == FALSE){
				iResult = GetLastError();
				free(lpszBuff);
				lpszBuff = NULL;
				__leave;
			}
			if(dwReaded == 0){
				break;
			}
			dwTotalReaded += dwReaded;
		}

		*(lpszBuff + dwTotalReaded) = '\0';
		*lpuSize   = dwTotalReaded;
		*lplpvBuff = lpszBuff;
	}
	__finally{
		CloseHandle(hFile);
		if(iResult != 0){
			free(lpszBuff);
		}
	}
	return iResult;
}
#else
{
	struct stat 	stat_buff;
	int 			fd;
	int 			iReaded = 0;
	unsigned int	uBuffSize, uTotalReaded = 0;
	char			*lpszBuff = NULL, *lpsz = NULL;
	int 			iResult = 0;

	*lpuSize = 0L;

	if((fd = open(lpcszFileName, O_RDONLY)) < 0){
		return errno;
	}
	if(fstat(fd, &stat_buff) == -1){
		iResult = errno;
		goto finish;
	}
	uBuffSize = stat_buff.st_size;

	if((lpszBuff = malloc(uBuffSize + 1)) == NULL){
		iResult = errno;
		goto finish;
	}

	for(lpsz = lpszBuff; uTotalReaded < uBuffSize; lpsz += iReaded){
		if((iReaded = read(fd, lpsz, (uBuffSize - uTotalReaded))) <= 0){
			if(iReaded < 0){
				iResult = errno;
				free(lpszBuff);
				lpszBuff = NULL;
				goto finish;
			}
			break;
		}
		uTotalReaded += (unsigned int)iReaded;
	}

	*(lpszBuff + uTotalReaded) = '\0';
	*lpuSize   = uTotalReaded;
	*lplpvBuff = lpszBuff;

finish:
	close(fd);
	if(iResult != 0){
		free(lpszBuff);
	}
	return iResult;
}
#endif

int EnumUserProfileSection(char *lpszBuff, unsigned int uBuffSize, int *lpiCount, const char *lpcszIniFile)
{
	FILE			*fp;
	char			szLineBuff[MAX_LINEBUFF];
	char			*lpszNext, *lpszTop, *lpszBottom;
	unsigned int	uSectSize, uSize;
	int 			iSections = 0;

	if((lpszBuff == NULL) || (uBuffSize == 0) || (lpcszIniFile == NULL)){
		return -1;
	}

	lpszNext  = lpszBuff;
	uSize = uBuffSize - 1;

	if((fp = fopen(lpcszIniFile, "r")) == NULL){
		return errno;
	}

	*lpszNext = '\0';
	while(fgets(szLineBuff, sizeof(szLineBuff), fp) != NULL){
		lpszTop = szLineBuff;
		if(*lpszTop != '['){
			continue;
		}
		lpszTop++;
		if((lpszBottom = strchr(lpszTop, ']')) != NULL){
			*lpszBottom = '\0';
			uSectSize = strlen(lpszTop);
			if(uSize < (uSectSize + 2)){
				break;
			}
			*lpszNext = '\0';	/* '\n\n''\n'ɂ */
			strcat(lpszNext, lpszTop);
			strcat(lpszNext, "\n\n");
			lpszNext  += (uSectSize + 1);
			uSize -= (uSectSize + 1);
			iSections++;
		}
	}
	fclose(fp);

	if(lpiCount){
		*lpiCount = iSections;
	}
	return 0;
}


unsigned int GetUserProfileString(const char *lpcszSection, const char *lpcszKey, const char *lpcszDefault,
char *lpszBuff, unsigned int uBuffSize, const char *lpcszIniFile)
{
	FILE			*fp;
	char			*lpszTop, *lpszBottom, *lpszValue;
	char			szLineBuff[MAX_LINEBUFF];
	int 			fInSection = FALSE;
	unsigned int	uTemp, uSize = 0;

	strcpy(lpszBuff, lpcszDefault);
	uSize = strlen(lpcszDefault);

	if((fp = fopen(lpcszIniFile, "r")) == NULL){
		return uSize;
	}

	while(fgets(szLineBuff, sizeof(szLineBuff), fp) != NULL){
		lpszTop = szLineBuff;
		if(*lpszTop == '#'){
			continue;	/* Rgs */
		}
		if(fInSection == FALSE){
			if(*lpszTop != '['){
				continue;
			}
			lpszTop++;
			if((lpszBottom = strchr(lpszTop, ']')) == NULL){
				continue;
			}
			*lpszBottom = '\0';
			if(strcmp(lpcszSection, lpszTop) == 0){
				fInSection = TRUE;
			}
		}
		else{
			if((lpszValue = strchr(szLineBuff, '=')) == NULL){
				if(*lpszTop == '['){
					break;		/* ̃ZNVFlȂ */
				}
				continue;
			}
			*lpszValue = '\0';
			lpszValue++;
			if(strcmp(lpszTop, lpcszKey) != 0){
				continue;	/* KeyvȂ */
			}
			if((lpszTop = strchr(lpszValue, '\n')) != NULL){
				*lpszTop = '\0';	/* I[̉sR[h폜 */
			}
			uTemp = strlen(lpszValue);
			if((uBuffSize <= uTemp) || (uTemp == 0)){
				break;	/* ̈s܂͒lȂ */
			}
			strcpy(lpszBuff, lpszValue);
			uSize = strlen(lpszValue);
			break;
		}
	}

	fclose(fp);
	return uSize;
}

int WriteUserProfileString(const char *lpcszSection, const char *lpcszKey,
const char *lpcszValue, const char *lpcszIniFile)
{
	FILE			*fp = NULL;
	char			*lpszBuff = NULL;
	char			*lpszSectionTop, *lpszSectionBottom;
	char			*lpszKeyTop, *lpszKeyBottom;
	char			szSearchKey[MAX_LINEBUFF];
	char			szTempFile[MAX_PATH];
	unsigned int	uSize;
	const char		*lpcszCRLF = CRLF_CODE;
	int 			iResult = 0;

	iResult = CreateSnapshot(lpcszIniFile, (void**)&lpszBuff, &uSize);
	if((iResult != 0) && (iResult != ENOENT)){
		goto finish;
	}

	iResult = 0;
	/* e|t@CJ */
	GetTempFileName(".", "Ini", 0, szTempFile);
	if((fp = fopen(szTempFile, "wb")) == NULL){
		iResult = errno;
		goto finish;
	}

	if(lpszBuff == NULL){
		/* VK쐬 */
		fprintf(fp, "[%s]%s%s=%s%s", lpcszSection, lpcszCRLF,
				lpcszKey, lpcszValue, lpcszCRLF);
		goto finish;
	}

	/* ZNV */
	sprintf(szSearchKey, "[%s]", lpcszSection);
	if((lpszSectionTop = strstr(lpszBuff, szSearchKey)) == NULL){
		/* ZNVǉ */
		fwrite(lpszBuff, strlen(lpszBuff), 1, fp);
		fprintf(fp, "%s[%s]%s%s=%s%s", lpcszCRLF, lpcszSection,
				lpcszCRLF, lpcszKey, lpcszValue, lpcszCRLF);
		goto finish;
	}
	strcpy(szSearchKey, "\n[");
	if((lpszSectionBottom = strstr(lpszSectionTop, szSearchKey)) != NULL){
		*lpszSectionBottom = '\0';
		if(*(lpszSectionBottom - 1) == '\r'){
			*(lpszSectionBottom - 1) = '\0';
		}
	}

	/* wZNVÕZNV */
	if(lpszBuff < lpszSectionTop){
		*(lpszSectionTop - 1) = '\0';
		fwrite(lpszBuff, strlen(lpszBuff), 1, fp);
		fputc('\n', fp);
	}

	/* L[ */
	sprintf(szSearchKey, "\n%s=", lpcszKey);
	if((lpszKeyTop = strstr(lpszSectionTop, szSearchKey)) != NULL){
		/* L[㏑ */
		*lpszKeyTop = '\0';
		if(*(lpszKeyTop - 1) == '\r'){
			*(lpszKeyTop - 1) = '\0';
		}
		fwrite(lpszSectionTop, strlen(lpszSectionTop), 1, fp);
		fprintf(fp, "%s%s=%s%s", lpcszCRLF, lpcszKey, lpcszValue, lpcszCRLF);
		lpszKeyTop++;
		if((lpszKeyBottom = strchr(lpszKeyTop, '\n')) != NULL){
			lpszKeyBottom++;
			fwrite(lpszKeyBottom, strlen(lpszKeyBottom), 1, fp);
		}
	}
	else{
		/* VKL[ǉ */
		fprintf(fp, "[%s]%s%s=%s%s", lpcszSection, lpcszCRLF,
				lpcszKey, lpcszValue, lpcszCRLF);
		if((lpszKeyBottom = strchr(lpszSectionTop, '\n')) != NULL){
			lpszKeyBottom++;
			fwrite(lpszKeyBottom, strlen(lpszKeyBottom), 1, fp);
		}
	}

	/* wZNVȍ~̃ZNV */
	if(lpszSectionBottom){
		fprintf(fp, "%s", lpcszCRLF);
		lpszSectionBottom++;
		fwrite(lpszSectionBottom, strlen(lpszSectionBottom), 1, fp);
	}

finish:
	if(fp){
		if(fclose(fp) == -1){
			iResult = errno;
		}
		if(iResult == 0){
			/* t@Cւ */
			unlink(lpcszIniFile);
			if(rename(szTempFile, lpcszIniFile) == -1){
				iResult = errno;
			}
		}
		else{
			unlink(szTempFile);
		}
	}
	if(lpszBuff){
		free(lpszBuff);
	}
	return iResult;
}

#ifdef WIN32
LRESULT SetRegistory(HKEY root, const char *path, const char *key, const char *value)
{
	HKEY hKey = NULL;
	DWORD disp = 0;
	DWORD len = strlen(value);
	LRESULT result = FALSE;

	result = RegCreateKeyEx(root, path, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &disp);
	if (result != ERROR_SUCCESS){
		return result;
	}
	result = RegSetValueEx(hKey, key, 0, REG_SZ, (LPBYTE)value, len);
	RegCloseKey(hKey);

    return result;
}
#else
unsigned int GetTempFileName(const char *lpcszPath, const char *lpcszPrefix, unsigned int uUnique, char *lpszTempFile)
{
	struct stat 	statbuff;
	pid_t			pid = 0;
	time_t			tm;
	unsigned int	uRand;
	char			szDir[MAX_PATH];
	char			*lpsz;

	strcpy(szDir, lpcszPath);
	lpsz = szDir + strlen(szDir) - 1;
	if(*lpsz == '/'){
		*lpsz = '\0';
	}
	pid   = getpid();
	uRand = uUnique;

	while(1){
		if(uUnique == 0){
			tm = time(NULL);
			uRand = (unsigned int)rand_r((unsigned int *)&tm);
		}
		sprintf(lpszTempFile, "%s/%s%x%x.tmp",
				szDir, lpcszPrefix, (unsigned int)pid, uRand);
		if(stat(lpszTempFile, &statbuff) < 0){
			int fd = open(lpszTempFile, O_CREAT | O_RDWR);
			if(fd == -1){
				return 0;
			}
			close(fd);
			chmod(lpszTempFile, 0644);
			break;
		}
		else if(uUnique != 0){
			return 0;
		}
	}

	return uRand;
}
#endif

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
