/* File: wavedata.h

	SHARP MZ-2000/2200/80B/B2 Emulator "emz2000 / EmuZ-2000"
		Wave Data Accesses Headers

	Copyright (C) 2001-2019 FUKUI, Toshio.
	This file is part of the emz2000 / EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __WAVEDATA_H_INCLUDED
#define __WAVEDATA_H_INCLUDED

#ifndef WIN32
#include "wave_def.h"
#endif

typedef struct {
	int f;				/* frequency */
	int ch;				/* mono=1 / stereo=2 */
	int bytes;			/* one data bytes (8bit=1/16bit=2) */
	unsigned long len;		/* all data length */

	/* for function wavefile_* */
	int fd;
	unsigned int attr;
	unsigned int dcpos;
	unsigned long filelen;
} WAVEDATA_STRUCT;

#define wavedata_getlenbytes(_X) ((_X) -> ch * (_X) -> bytes * (_X) -> len)

/* for function wavefile_* */
#define wavedata_getfd(_X) ((_X) -> fd)

extern int wavedata_initstruct( WAVEDATA_STRUCT *p );

#endif /* __WAVEDATA_H_INCLUDED */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
