/* File: wavefile.h

	SHARP MZ-2000/2200/80B/B2 Emulator "emz2000 / EmuZ-2000"
		Wave Files Accesses Headers

	Copyright (C) 2001-2019 FUKUI, Toshio.
	This file is part of the emz2000 / EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __WAVEFILE_H_INCLUDED
#define __WAVEFILE_H_INCLUDED

#ifndef WIN32
#include "wave_def.h"
#endif
#include "wavedata.h"

#define WAVEFILE_ATTR_NONE	0U
#define WAVEFILE_ATTR_DEFAULT	WAVEFILE_ATTR_NONE

#define WAVEFILE_RESULT_NOERROR			0
#define WAVEFILE_RESULT_OPENFAIL		-1
#define WAVEFILE_RESULT_IOERROR			-2
#define WAVEFILE_RESULT_HEADERR_1		-10
#define WAVEFILE_RESULT_HEADERR_2		-11
#define WAVEFILE_RESULT_HEADERR_3		-12
#define WAVEFILE_RESULT_HEADERR_4		-13
#define WAVEFILE_RESULT_HEADERR_5		-14
#define WAVEFILE_RESULT_HEADERR_6		-15
#define WAVEFILE_RESULT_UNSUPPORTEDFMT		-20
#define WAVEFILE_RESULT_UNSUPPORTEDFMT_1	-21	/* No PCM */
#define WAVEFILE_RESULT_UNSUPPORTEDFMT_2	-21	/* Channels != 1 or 2 */
#define WAVEFILE_RESULT_UNSUPPORTEDFMT_3	-21	/* BitsPerSample != 8 or 16 */
#define WAVEFILE_RESULT_UNSUPPORTEDFMT_4	-21
#define WAVEFILE_RESULT_DATALENERR		-30	/* data length error */

extern int wavefile_ropen( unsigned int attr, WAVEDATA_STRUCT *p, const char *fn );
extern int wavefile_rclose( WAVEDATA_STRUCT *p );

#endif /* __WAVEFILE_H_INCLUDED */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
