#include <stdio.h>
#include "z80.h"
#include "z80operand.h"


u16 wr;

int exec_dd00()
{
	NOP();
	return 4;
}
int exec_dd01()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(BC,f2);
	return 10;
}
int exec_dd02()
{
	LD_RM_R8(BC,A);
	return 7;
}
int exec_dd03()
{
	INC_R16(BC);
	return 6;
}
int exec_dd04()
{
	INC_R8(B);
	return 4;
}
int exec_dd05()
{
	DEC_R8(B);
	return 4;
}
int exec_dd06()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(B,f2);
	return 7;
}
int exec_dd07()
{
	RLCA();
	return 4;
}
int exec_dd08()
{
	EX_R16_R16(AF,AF2);
	return 4;
}
int exec_dd09()
{
	ADD_R16_R16(IX,BC);
	return 11;
}
int exec_dd0a()
{
	LD_R8_RM(A,BC);
	return 0;
}
int exec_dd0b()
{
	DEC_R16(BC);
	return 6;
}
int exec_dd0c()
{
	INC_R8(C);
	return 4;
}
int exec_dd0d()
{
	DEC_R8(C);
	return 4;
}
int exec_dd0e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(C,f2);
	return 7;
}
int exec_dd0f()
{
	RRCA();
	return 4;
}
int exec_dd10()
{
	int f1;
	fetchPC(f1);
	DJNZ_N(f1);
	return (readReg(B)!=0)? 13 : 8;
}
int exec_dd11()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(DE,f2);
	return 10;
}
int exec_dd12()
{
	LD_RM_R8(DE,A);
	return 7;
}
int exec_dd13()
{
	INC_R16(DE);
	return 6;
}
int exec_dd14()
{
	INC_R8(D);
	return 4;
}
int exec_dd15()
{
	DEC_R8(D);
	return 4;
}
int exec_dd16()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(D,f2);
	return 7;
}
int exec_dd17()
{
	RLA();
	return 4;
}
int exec_dd18()
{
	int f1;
	fetchPC(f1);
	JR_N(f1);
	return 12;
}
int exec_dd19()
{
	ADD_R16_R16(IX,DE);
	return 11;
}
int exec_dd1a()
{
	LD_R8_RM(A,DE);
	return 0;
}
int exec_dd1b()
{
	DEC_R16(DE);
	return 6;
}
int exec_dd1c()
{
	INC_R8(E);
	return 4;
}
int exec_dd1d()
{
	DEC_R8(E);
	return 4;
}
int exec_dd1e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(E,f2);
	return 7;
}
int exec_dd1f()
{
	RRA();
	return 4;
}
int exec_dd20()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(NZ,f2);
	return (!bitFlg(Z))? 12 : 7;
}
int exec_dd21()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(IX,f2);
	return 10;
}
int exec_dd22()
{
	int f1;
	fetch2PC(f1);
	LD_M_R16(f1,IX);
	return 16;
}
int exec_dd23()
{
	INC_R16(IX);
	return 6;
}
int exec_dd24()
{
	INC_R8(IXH);
	return 4;
}
int exec_dd25()
{
	DEC_R8(IXH);
	return 4;
}
int exec_dd26()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(IXH,f2);
	return 7;
}
int exec_dd27()
{
	DAA();
	return 4;
}
int exec_dd28()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(Z,f2);
	return (bitFlg(Z))? 12 : 7;
}
int exec_dd29()
{
	ADD_R16_R16(IX,IX);
	return 11;
}
int exec_dd2a()
{
	int f2;
	fetch2PC(f2);
	LD_R16_M(IX,f2);
	return 16;
}
int exec_dd2b()
{
	DEC_R16(IX);
	return 6;
}
int exec_dd2c()
{
	INC_R8IL(IXL);
	return 4;
}
int exec_dd2d()
{
	DEC_R8IL(IXL);
	return 4;
}
int exec_dd2e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(IXL,f2);
	return 7;
}
int exec_dd2f()
{
	CPL();
	return 4;
}
int exec_dd30()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(NC,f2);
	return (!bitFlg(C))? 12 : 7;
}
int exec_dd31()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(SP,f2);
	return 10;
}
int exec_dd32()
{
	int f1;
	fetch2PC(f1);
	LD_M_R8(f1,A);
	return 13;
}
int exec_dd33()
{
	INC_R16(SP);
	return 6;
}
int exec_dd34()
{
	int f1;
	fetchPC(f1);
	INC_IDX(IX,f1);
	return 19;
}
int exec_dd35()
{
	int f1;
	fetchPC(f1);
	DEC_IDX(IX,f1);
	return 19;
}
int exec_dd36()
{
	int f1;
	int f2;
	fetchPC(f1);
	fetchPC(f2);
	LD_IDX_N(IX,f1,f2);
	return 15;
}
int exec_dd37()
{
	SCF();
	return 4;
}
int exec_dd38()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(C,f2);
	return (bitFlg(C))? 12 : 7;
}
int exec_dd39()
{
	ADD_R16_R16(IX,SP);
	return 11;
}
int exec_dd3a()
{
	int f2;
	fetch2PC(f2);
	LD_R8_M(A,f2);
	return 13;
}
int exec_dd3b()
{
	DEC_R16(SP);
	return 6;
}
int exec_dd3c()
{
	INC_R8(A);
	return 4;
}
int exec_dd3d()
{
	DEC_R8(A);
	return 4;
}
int exec_dd3e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(A,f2);
	return 7;
}
int exec_dd3f()
{
	CCF();
	return 4;
}
int exec_dd40()
{
	LD_R8_R8(B,B);
	return 4;
}
int exec_dd41()
{
	LD_R8_R8(B,C);
	return 4;
}
int exec_dd42()
{
	LD_R8_R8(B,D);
	return 4;
}
int exec_dd43()
{
	LD_R8_R8(B,E);
	return 4;
}
int exec_dd44()
{
	LD_R8_R8(B,IXH);
	return 4;
}
int exec_dd45()
{
	LD_R8_R8(B,IXL);
	return 4;
}
int exec_dd46()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(B,IX,f2);
	return 15;
}
int exec_dd47()
{
	LD_R8_R8(B,A);
	return 4;
}
int exec_dd48()
{
	LD_R8_R8(C,B);
	return 4;
}
int exec_dd49()
{
	LD_R8_R8(C,C);
	return 4;
}
int exec_dd4a()
{
	LD_R8_R8(C,D);
	return 4;
}
int exec_dd4b()
{
	LD_R8_R8(C,E);
	return 4;
}
int exec_dd4c()
{
	LD_R8_R8(C,IXH);
	return 4;
}
int exec_dd4d()
{
	LD_R8_R8(C,IXL);
	return 4;
}
int exec_dd4e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(C,IX,f2);
	return 15;
}
int exec_dd4f()
{
	LD_R8_R8(C,A);
	return 4;
}
int exec_dd50()
{
	LD_R8_R8(D,B);
	return 4;
}
int exec_dd51()
{
	LD_R8_R8(D,C);
	return 4;
}
int exec_dd52()
{
	LD_R8_R8(D,D);
	return 4;
}
int exec_dd53()
{
	LD_R8_R8(D,E);
	return 4;
}
int exec_dd54()
{
	LD_R8_R8(D,IXH);
	return 4;
}
int exec_dd55()
{
	LD_R8_R8(D,IXL);
	return 4;
}
int exec_dd56()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(D,IX,f2);
	return 15;
}
int exec_dd57()
{
	LD_R8_R8(D,A);
	return 4;
}
int exec_dd58()
{
	LD_R8_R8(E,B);
	return 4;
}
int exec_dd59()
{
	LD_R8_R8(E,C);
	return 4;
}
int exec_dd5a()
{
	LD_R8_R8(E,D);
	return 4;
}
int exec_dd5b()
{
	LD_R8_R8(E,E);
	return 4;
}
int exec_dd5c()
{
	LD_R8_R8(E,IXH);
	return 4;
}
int exec_dd5d()
{
	LD_R8_R8(E,IXL);
	return 4;
}
int exec_dd5e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(E,IX,f2);
	return 15;
}
int exec_dd5f()
{
	LD_R8_R8(E,A);
	return 4;
}
int exec_dd60()
{
	LD_R8_R8(IXH,B);
	return 4;
}
int exec_dd61()
{
	LD_R8_R8(IXH,C);
	return 4;
}
int exec_dd62()
{
	LD_R8_R8(IXH,D);
	return 4;
}
int exec_dd63()
{
	LD_R8_R8(IXH,E);
	return 4;
}
int exec_dd64()
{
	LD_R8_R8(IXH,IXH);
	return 4;
}
int exec_dd65()
{
	LD_R8_R8(IXH,IXL);
	return 4;
}
int exec_dd66()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(H,IX,f2);
	return 15;
}
int exec_dd67()
{
	LD_R8_R8(IXH,A);
	return 4;
}
int exec_dd68()
{
	LD_R8_R8(IXL,B);
	return 4;
}
int exec_dd69()
{
	LD_R8_R8(IXL,C);
	return 4;
}
int exec_dd6a()
{
	LD_R8_R8(IXL,D);
	return 4;
}
int exec_dd6b()
{
	LD_R8_R8(IXL,E);
	return 4;
}
int exec_dd6c()
{
	LD_R8_R8(IXL,IXH);
	return 4;
}
int exec_dd6d()
{
	LD_R8_R8(IXL,IXL);
	return 4;
}
int exec_dd6e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(L,IX,f2);
	return 15;
}
int exec_dd6f()
{
	LD_R8_R8(IXL,A);
	return 4;
}
int exec_dd70()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IX,f1,B);
	return 15;
}
int exec_dd71()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IX,f1,C);
	return 15;
}
int exec_dd72()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IX,f1,D);
	return 15;
}
int exec_dd73()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IX,f1,E);
	return 15;
}
int exec_dd74()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IX,f1,H);
	return 15;
}
int exec_dd75()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IX,f1,L);
	return 15;
}
int exec_dd76()
{
	HALT();
	return 4;
}
int exec_dd77()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IX,f1,A);
	return 15;
}
int exec_dd78()
{
	LD_R8_R8(A,B);
	return 4;
}
int exec_dd79()
{
	LD_R8_R8(A,C);
	return 4;
}
int exec_dd7a()
{
	LD_R8_R8(A,D);
	return 4;
}
int exec_dd7b()
{
	LD_R8_R8(A,E);
	return 4;
}
int exec_dd7c()
{
	LD_R8_R8(A,IXH);
	return 4;
}
int exec_dd7d()
{
	LD_R8_R8(A,IXL);
	return 4;
}
int exec_dd7e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(A,IX,f2);
	return 15;
}
int exec_dd7f()
{
	LD_R8_R8(A,A);
	return 4;
}
int exec_dd80()
{
	ADD_R8_R8(A,B);
	return 4;
}
int exec_dd81()
{
	ADD_R8_R8(A,C);
	return 4;
}
int exec_dd82()
{
	ADD_R8_R8(A,D);
	return 4;
}
int exec_dd83()
{
	ADD_R8_R8(A,E);
	return 4;
}
int exec_dd84()
{
	ADD_R8_R8(A,IXH);
	return 4;
}
int exec_dd85()
{
	ADD_R8_R8(A,IXL);
	return 4;
}
int exec_dd86()
{
	int f2;
	fetchPC(f2);
	ADD_R8_IDX(A,IX,f2);
	return 15;
}
int exec_dd87()
{
	ADD_R8_R8(A,A);
	return 4;
}
int exec_dd88()
{
	ADC_R8_R8(A,B);
	return 4;
}
int exec_dd89()
{
	ADC_R8_R8(A,C);
	return 4;
}
int exec_dd8a()
{
	ADC_R8_R8(A,D);
	return 4;
}
int exec_dd8b()
{
	ADC_R8_R8(A,E);
	return 4;
}
int exec_dd8c()
{
	ADC_R8_R8(A,IXH);
	return 4;
}
int exec_dd8d()
{
	ADC_R8_R8(A,IXL);
	return 4;
}
int exec_dd8e()
{
	int f2;
	fetchPC(f2);
	ADC_R8_IDX(A,IX,f2);
	return 15;
}
int exec_dd8f()
{
	ADC_R8_R8(A,A);
	return 4;
}
int exec_dd90()
{
	SUB_R8(B);
	return 4;
}
int exec_dd91()
{
	SUB_R8(C);
	return 4;
}
int exec_dd92()
{
	SUB_R8(D);
	return 4;
}
int exec_dd93()
{
	SUB_R8(E);
	return 4;
}
int exec_dd94()
{
	SUB_R8(IXH);
	return 4;
}
int exec_dd95()
{
	SUB_R8(IXL);
	return 4;
}
int exec_dd96()
{
	int f1;
	fetchPC(f1);
	SUB_IDX(IX,f1);
	return 15;
}
int exec_dd97()
{
	SUB_R8(A);
	return 4;
}
int exec_dd98()
{
	SBC_R8_R8(A,B);
	return 4;
}
int exec_dd99()
{
	SBC_R8_R8(A,C);
	return 4;
}
int exec_dd9a()
{
	SBC_R8_R8(A,D);
	return 4;
}
int exec_dd9b()
{
	SBC_R8_R8(A,E);
	return 4;
}
int exec_dd9c()
{
	SBC_R8_R8(A,IXH);
	return 4;
}
int exec_dd9d()
{
	SBC_R8_R8(A,IXL);
	return 4;
}
int exec_dd9e()
{
	int f2;
	fetchPC(f2);
	SBC_R8_IDX(A,IX,f2);
	return 15;
}
int exec_dd9f()
{
	SBC_R8_R8(A,A);
	return 4;
}
int exec_dda0()
{
	AND_R8(B);
	return 4;
}
int exec_dda1()
{
	AND_R8(C);
	return 4;
}
int exec_dda2()
{
	AND_R8(D);
	return 4;
}
int exec_dda3()
{
	AND_R8(E);
	return 4;
}
int exec_dda4()
{
	AND_R8(IXH);
	return 4;
}
int exec_dda5()
{
	AND_R8(IXL);
	return 4;
}
int exec_dda6()
{
	int f1;
	fetchPC(f1);
	AND_IDX(IX,f1);
	return 15;
}
int exec_dda7()
{
	AND_R8(A);
	return 4;
}
int exec_dda8()
{
	XOR_R8(B);
	return 4;
}
int exec_dda9()
{
	XOR_R8(C);
	return 4;
}
int exec_ddaa()
{
	XOR_R8(D);
	return 4;
}
int exec_ddab()
{
	XOR_R8(E);
	return 4;
}
int exec_ddac()
{
	XOR_R8(IXH);
	return 4;
}
int exec_ddad()
{
	XOR_R8(IXL);
	return 4;
}
int exec_ddae()
{
	int f1;
	fetchPC(f1);
	XOR_IDX(IX,f1);
	return 15;
}
int exec_ddaf()
{
	XOR_R8(A);
	return 4;
}
int exec_ddb0()
{
	OR_R8(B);
	return 4;
}
int exec_ddb1()
{
	OR_R8(C);
	return 4;
}
int exec_ddb2()
{
	OR_R8(D);
	return 4;
}
int exec_ddb3()
{
	OR_R8(E);
	return 4;
}
int exec_ddb4()
{
	OR_R8(IXH);
	return 4;
}
int exec_ddb5()
{
	OR_R8(IXL);
	return 4;
}
int exec_ddb6()
{
	int f1;
	fetchPC(f1);
	OR_IDX(IX,f1);
	return 15;
}
int exec_ddb7()
{
	OR_R8(A);
	return 4;
}
int exec_ddb8()
{
	CP_R8(B);
	return 4;
}
int exec_ddb9()
{
	CP_R8(C);
	return 4;
}
int exec_ddba()
{
	CP_R8(D);
	return 4;
}
int exec_ddbb()
{
	CP_R8(E);
	return 4;
}
int exec_ddbc()
{
	CP_R8(IXH);
	return 4;
}
int exec_ddbd()
{
	CP_R8(IXL);
	return 4;
}
int exec_ddbe()
{
	int f1;
	fetchPC(f1);
	CP_IDX(IX,f1);
	return 15;
}
int exec_ddbf()
{
	CP_R8(A);
	return 4;
}
int exec_ddc0()
{
	RET_FLG(NZ);
	return (!bitFlg(Z))? 11 : 5;
}
int exec_ddc1()
{
	POP_R16(BC);
	return 10;
}
int exec_ddc2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(NZ,f2);
	return 10;
}
int exec_ddc3()
{
	int f1;
	fetch2PC(f1);
	JP_N(f1);
	return 10;
}
int exec_ddc4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(NZ,f2);
	return (!bitFlg(Z))? 17 : 10;
}
int exec_ddc5()
{
	PUSH_R16(BC);
	return 10;
}
int exec_ddc6()
{
	int f2;
	fetchPC(f2);
	ADD_R8_N(A,f2);
	return 7;
}
int exec_ddc7()
{
	RST_N(0);
	return 11;
}
int exec_ddc8()
{
	RET_FLG(Z);
	return (bitFlg(Z))? 11 : 5;
}
int exec_ddc9()
{
	RET();
	return 10;
}
int exec_ddca()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(Z,f2);
	return 10;
}
int exec_ddcb()
{
	return exec_instruction2(GROUP_DDCB)-4;
}
int exec_ddcc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(Z,f2);
	return (bitFlg(Z))? 17 : 10;
}
int exec_ddcd()
{
	int f1;
	fetch2PC(f1);
	CALL_N(f1);
	return 17;
}
int exec_ddce()
{
	int f2;
	fetchPC(f2);
	ADC_R8_N(A,f2);
	return 7;
}
int exec_ddcf()
{
	RST_N(8);
	return 11;
}
int exec_ddd0()
{
	RET_FLG(NC);
	return (!bitFlg(C))? 11 : 5;
}
int exec_ddd1()
{
	POP_R16(DE);
	return 10;
}
int exec_ddd2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(NC,f2);
	return 10;
}
int exec_ddd3()
{
	int f1;
	fetchPC(f1);
	OUT_M_R8(f1,A);
	return 11;
}
int exec_ddd4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(NC,f2);
	return (!bitFlg(C))? 17 : 10;
}
int exec_ddd5()
{
	PUSH_R16(DE);
	return 10;
}
int exec_ddd6()
{
	int f1;
	fetchPC(f1);
	SUB_N(f1);
	return 7;
}
int exec_ddd7()
{
	RST_N(16);
	return 11;
}
int exec_ddd8()
{
	RET_FLG(C);
	return (bitFlg(C))? 11 : 5;
}
int exec_ddd9()
{
	EXX();
	return 4;
}
int exec_ddda()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(C,f2);
	return 10;
}
int exec_dddb()
{
	int f2;
	fetchPC(f2);
	IN_R8_M(A,f2);
	return 11;
}
int exec_dddc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(C,f2);
	return (bitFlg(C))? 17 : 10;
}
int exec_dddd()
{
	decReg(PC);	return 0;
}
int exec_ddde()
{
	int f2;
	fetchPC(f2);
	SBC_R8_N(A,f2);
	return 7;
}
int exec_dddf()
{
	RST_N(24);
	return 11;
}
int exec_dde0()
{
	RET_FLG(PO);
	return (!bitFlg(PV))? 11 : 5;
}
int exec_dde1()
{
	POP_R16(IX);
	return 10;
}
int exec_dde2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(PO,f2);
	return 10;
}
int exec_dde3()
{
	EX_RM_R16(SP,IX);
	return 19;
}
int exec_dde4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(PO,f2);
	return (!bitFlg(PV))? 17 : 10;
}
int exec_dde5()
{
	PUSH_R16(IX);
	return 10;
}
int exec_dde6()
{
	int f1;
	fetchPC(f1);
	AND_N(f1);
	return 7;
}
int exec_dde7()
{
	RST_N(32);
	return 11;
}
int exec_dde8()
{
	RET_FLG(PE);
	return (bitFlg(PV))? 11 : 5;
}
int exec_dde9()
{
	JP_R16(IX);
	return 4;
}
int exec_ddea()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(PE,f2);
	return 10;
}
int exec_ddeb()
{
	EX_R16_R16(DE,IX);
	return 4;
}
int exec_ddec()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(PE,f2);
	return (bitFlg(PV))? 17 : 10;
}
int exec_dded()
{
	decReg(PC);	return 0;
}
int exec_ddee()
{
	int f1;
	fetchPC(f1);
	XOR_N(f1);
	return 7;
}
int exec_ddef()
{
	RST_N(40);
	return 11;
}
int exec_ddf0()
{
	RET_FLG(P);
	return (!bitFlg(S))? 11 : 5;
}
int exec_ddf1()
{
	POP_R16(AF);
	return 10;
}
int exec_ddf2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(P,f2);
	return 10;
}
int exec_ddf3()
{
	DI();
	return 4;
}
int exec_ddf4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(P,f2);
	return (!bitFlg(S))? 17 : 10;
}
int exec_ddf5()
{
	PUSH_R16(AF);
	return 10;
}
int exec_ddf6()
{
	int f1;
	fetchPC(f1);
	OR_N(f1);
	return 7;
}
int exec_ddf7()
{
	RST_N(48);
	return 11;
}
int exec_ddf8()
{
	RET_FLG(M);
	return (bitFlg(S))? 11 : 5;
}
int exec_ddf9()
{
	LD_R16_R16(SP,IX);
	return 6;
}
int exec_ddfa()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(M,f2);
	return 10;
}
int exec_ddfb()
{
	EI();
	return 4;
}
int exec_ddfc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(M,f2);
	return (bitFlg(S))? 17 : 10;
}
int exec_ddfd()
{
	decReg(PC);	return 0;
}
int exec_ddfe()
{
	int f1;
	fetchPC(f1);
	CP_N(f1);
	return 7;
}
int exec_ddff()
{
	RST_N(56);
	return 11;
}

int (*(instr_dd[]))() = {
	exec_dd00,
	exec_dd01,
	exec_dd02,
	exec_dd03,
	exec_dd04,
	exec_dd05,
	exec_dd06,
	exec_dd07,
	exec_dd08,
	exec_dd09,
	exec_dd0a,
	exec_dd0b,
	exec_dd0c,
	exec_dd0d,
	exec_dd0e,
	exec_dd0f,
	exec_dd10,
	exec_dd11,
	exec_dd12,
	exec_dd13,
	exec_dd14,
	exec_dd15,
	exec_dd16,
	exec_dd17,
	exec_dd18,
	exec_dd19,
	exec_dd1a,
	exec_dd1b,
	exec_dd1c,
	exec_dd1d,
	exec_dd1e,
	exec_dd1f,
	exec_dd20,
	exec_dd21,
	exec_dd22,
	exec_dd23,
	exec_dd24,
	exec_dd25,
	exec_dd26,
	exec_dd27,
	exec_dd28,
	exec_dd29,
	exec_dd2a,
	exec_dd2b,
	exec_dd2c,
	exec_dd2d,
	exec_dd2e,
	exec_dd2f,
	exec_dd30,
	exec_dd31,
	exec_dd32,
	exec_dd33,
	exec_dd34,
	exec_dd35,
	exec_dd36,
	exec_dd37,
	exec_dd38,
	exec_dd39,
	exec_dd3a,
	exec_dd3b,
	exec_dd3c,
	exec_dd3d,
	exec_dd3e,
	exec_dd3f,
	exec_dd40,
	exec_dd41,
	exec_dd42,
	exec_dd43,
	exec_dd44,
	exec_dd45,
	exec_dd46,
	exec_dd47,
	exec_dd48,
	exec_dd49,
	exec_dd4a,
	exec_dd4b,
	exec_dd4c,
	exec_dd4d,
	exec_dd4e,
	exec_dd4f,
	exec_dd50,
	exec_dd51,
	exec_dd52,
	exec_dd53,
	exec_dd54,
	exec_dd55,
	exec_dd56,
	exec_dd57,
	exec_dd58,
	exec_dd59,
	exec_dd5a,
	exec_dd5b,
	exec_dd5c,
	exec_dd5d,
	exec_dd5e,
	exec_dd5f,
	exec_dd60,
	exec_dd61,
	exec_dd62,
	exec_dd63,
	exec_dd64,
	exec_dd65,
	exec_dd66,
	exec_dd67,
	exec_dd68,
	exec_dd69,
	exec_dd6a,
	exec_dd6b,
	exec_dd6c,
	exec_dd6d,
	exec_dd6e,
	exec_dd6f,
	exec_dd70,
	exec_dd71,
	exec_dd72,
	exec_dd73,
	exec_dd74,
	exec_dd75,
	exec_dd76,
	exec_dd77,
	exec_dd78,
	exec_dd79,
	exec_dd7a,
	exec_dd7b,
	exec_dd7c,
	exec_dd7d,
	exec_dd7e,
	exec_dd7f,
	exec_dd80,
	exec_dd81,
	exec_dd82,
	exec_dd83,
	exec_dd84,
	exec_dd85,
	exec_dd86,
	exec_dd87,
	exec_dd88,
	exec_dd89,
	exec_dd8a,
	exec_dd8b,
	exec_dd8c,
	exec_dd8d,
	exec_dd8e,
	exec_dd8f,
	exec_dd90,
	exec_dd91,
	exec_dd92,
	exec_dd93,
	exec_dd94,
	exec_dd95,
	exec_dd96,
	exec_dd97,
	exec_dd98,
	exec_dd99,
	exec_dd9a,
	exec_dd9b,
	exec_dd9c,
	exec_dd9d,
	exec_dd9e,
	exec_dd9f,
	exec_dda0,
	exec_dda1,
	exec_dda2,
	exec_dda3,
	exec_dda4,
	exec_dda5,
	exec_dda6,
	exec_dda7,
	exec_dda8,
	exec_dda9,
	exec_ddaa,
	exec_ddab,
	exec_ddac,
	exec_ddad,
	exec_ddae,
	exec_ddaf,
	exec_ddb0,
	exec_ddb1,
	exec_ddb2,
	exec_ddb3,
	exec_ddb4,
	exec_ddb5,
	exec_ddb6,
	exec_ddb7,
	exec_ddb8,
	exec_ddb9,
	exec_ddba,
	exec_ddbb,
	exec_ddbc,
	exec_ddbd,
	exec_ddbe,
	exec_ddbf,
	exec_ddc0,
	exec_ddc1,
	exec_ddc2,
	exec_ddc3,
	exec_ddc4,
	exec_ddc5,
	exec_ddc6,
	exec_ddc7,
	exec_ddc8,
	exec_ddc9,
	exec_ddca,
	exec_ddcb,
	exec_ddcc,
	exec_ddcd,
	exec_ddce,
	exec_ddcf,
	exec_ddd0,
	exec_ddd1,
	exec_ddd2,
	exec_ddd3,
	exec_ddd4,
	exec_ddd5,
	exec_ddd6,
	exec_ddd7,
	exec_ddd8,
	exec_ddd9,
	exec_ddda,
	exec_dddb,
	exec_dddc,
	exec_dddd,
	exec_ddde,
	exec_dddf,
	exec_dde0,
	exec_dde1,
	exec_dde2,
	exec_dde3,
	exec_dde4,
	exec_dde5,
	exec_dde6,
	exec_dde7,
	exec_dde8,
	exec_dde9,
	exec_ddea,
	exec_ddeb,
	exec_ddec,
	exec_dded,
	exec_ddee,
	exec_ddef,
	exec_ddf0,
	exec_ddf1,
	exec_ddf2,
	exec_ddf3,
	exec_ddf4,
	exec_ddf5,
	exec_ddf6,
	exec_ddf7,
	exec_ddf8,
	exec_ddf9,
	exec_ddfa,
	exec_ddfb,
	exec_ddfc,
	exec_ddfd,
	exec_ddfe,
	exec_ddff,
};
