#include <stdio.h>
#include "z80.h"
#include "z80operand.h"


u16 wr;

int exec_fd00()
{
	NOP();
	return 4;
}
int exec_fd01()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(BC,f2);
	return 10;
}
int exec_fd02()
{
	LD_RM_R8(BC,A);
	return 7;
}
int exec_fd03()
{
	INC_R16(BC);
	return 6;
}
int exec_fd04()
{
	INC_R8(B);
	return 4;
}
int exec_fd05()
{
	DEC_R8(B);
	return 4;
}
int exec_fd06()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(B,f2);
	return 7;
}
int exec_fd07()
{
	RLCA();
	return 4;
}
int exec_fd08()
{
	EX_R16_R16(AF,AF2);
	return 4;
}
int exec_fd09()
{
	ADD_R16_R16(IY,BC);
	return 11;
}
int exec_fd0a()
{
	LD_R8_RM(A,BC);
	return 0;
}
int exec_fd0b()
{
	DEC_R16(BC);
	return 6;
}
int exec_fd0c()
{
	INC_R8(C);
	return 4;
}
int exec_fd0d()
{
	DEC_R8(C);
	return 4;
}
int exec_fd0e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(C,f2);
	return 7;
}
int exec_fd0f()
{
	RRCA();
	return 4;
}
int exec_fd10()
{
	int f1;
	fetchPC(f1);
	DJNZ_N(f1);
	return (readReg(B)!=0)? 13 : 8;
}
int exec_fd11()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(DE,f2);
	return 10;
}
int exec_fd12()
{
	LD_RM_R8(DE,A);
	return 7;
}
int exec_fd13()
{
	INC_R16(DE);
	return 6;
}
int exec_fd14()
{
	INC_R8(D);
	return 4;
}
int exec_fd15()
{
	DEC_R8(D);
	return 4;
}
int exec_fd16()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(D,f2);
	return 7;
}
int exec_fd17()
{
	RLA();
	return 4;
}
int exec_fd18()
{
	int f1;
	fetchPC(f1);
	JR_N(f1);
	return 12;
}
int exec_fd19()
{
	ADD_R16_R16(IY,DE);
	return 11;
}
int exec_fd1a()
{
	LD_R8_RM(A,DE);
	return 0;
}
int exec_fd1b()
{
	DEC_R16(DE);
	return 6;
}
int exec_fd1c()
{
	INC_R8(E);
	return 4;
}
int exec_fd1d()
{
	DEC_R8(E);
	return 4;
}
int exec_fd1e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(E,f2);
	return 7;
}
int exec_fd1f()
{
	RRA();
	return 4;
}
int exec_fd20()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(NZ,f2);
	return (!bitFlg(Z))? 12 : 7;
}
int exec_fd21()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(IY,f2);
	return 10;
}
int exec_fd22()
{
	int f1;
	fetch2PC(f1);
	LD_M_R16(f1,IY);
	return 16;
}
int exec_fd23()
{
	INC_R16(IY);
	return 6;
}
int exec_fd24()
{
	INC_R8(IYH);
	return 4;
}
int exec_fd25()
{
	DEC_R8(IYH);
	return 4;
}
int exec_fd26()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(IYH,f2);
	return 7;
}
int exec_fd27()
{
	DAA();
	return 4;
}
int exec_fd28()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(Z,f2);
	return (bitFlg(Z))? 12 : 7;
}
int exec_fd29()
{
	ADD_R16_R16(IY,IY);
	return 11;
}
int exec_fd2a()
{
	int f2;
	fetch2PC(f2);
	LD_R16_M(IY,f2);
	return 16;
}
int exec_fd2b()
{
	DEC_R16(IY);
	return 6;
}
int exec_fd2c()
{
	INC_R8IL(IYL);
	return 4;
}
int exec_fd2d()
{
	DEC_R8IL(IYL);
	return 4;
}
int exec_fd2e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(IYL,f2);
	return 7;
}
int exec_fd2f()
{
	CPL();
	return 4;
}
int exec_fd30()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(NC,f2);
	return (!bitFlg(C))? 12 : 7;
}
int exec_fd31()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(SP,f2);
	return 10;
}
int exec_fd32()
{
	int f1;
	fetch2PC(f1);
	LD_M_R8(f1,A);
	return 13;
}
int exec_fd33()
{
	INC_R16(SP);
	return 6;
}
int exec_fd34()
{
	int f1;
	fetchPC(f1);
	INC_IDX(IY,f1);
	return 19;
}
int exec_fd35()
{
	int f1;
	fetchPC(f1);
	DEC_IDX(IY,f1);
	return 19;
}
int exec_fd36()
{
	int f1;
	int f2;
	fetchPC(f1);
	fetchPC(f2);
	LD_IDX_N(IY,f1,f2);
	return 15;
}
int exec_fd37()
{
	SCF();
	return 4;
}
int exec_fd38()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(C,f2);
	return (bitFlg(C))? 12 : 7;
}
int exec_fd39()
{
	ADD_R16_R16(IY,SP);
	return 11;
}
int exec_fd3a()
{
	int f2;
	fetch2PC(f2);
	LD_R8_M(A,f2);
	return 13;
}
int exec_fd3b()
{
	DEC_R16(SP);
	return 6;
}
int exec_fd3c()
{
	INC_R8(A);
	return 4;
}
int exec_fd3d()
{
	DEC_R8(A);
	return 4;
}
int exec_fd3e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(A,f2);
	return 7;
}
int exec_fd3f()
{
	CCF();
	return 4;
}
int exec_fd40()
{
	LD_R8_R8(B,B);
	return 4;
}
int exec_fd41()
{
	LD_R8_R8(B,C);
	return 4;
}
int exec_fd42()
{
	LD_R8_R8(B,D);
	return 4;
}
int exec_fd43()
{
	LD_R8_R8(B,E);
	return 4;
}
int exec_fd44()
{
	LD_R8_R8(B,IYH);
	return 4;
}
int exec_fd45()
{
	LD_R8_R8(B,IYL);
	return 4;
}
int exec_fd46()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(B,IY,f2);
	return 15;
}
int exec_fd47()
{
	LD_R8_R8(B,A);
	return 4;
}
int exec_fd48()
{
	LD_R8_R8(C,B);
	return 4;
}
int exec_fd49()
{
	LD_R8_R8(C,C);
	return 4;
}
int exec_fd4a()
{
	LD_R8_R8(C,D);
	return 4;
}
int exec_fd4b()
{
	LD_R8_R8(C,E);
	return 4;
}
int exec_fd4c()
{
	LD_R8_R8(C,IYH);
	return 4;
}
int exec_fd4d()
{
	LD_R8_R8(C,IYL);
	return 4;
}
int exec_fd4e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(C,IY,f2);
	return 15;
}
int exec_fd4f()
{
	LD_R8_R8(C,A);
	return 4;
}
int exec_fd50()
{
	LD_R8_R8(D,B);
	return 4;
}
int exec_fd51()
{
	LD_R8_R8(D,C);
	return 4;
}
int exec_fd52()
{
	LD_R8_R8(D,D);
	return 4;
}
int exec_fd53()
{
	LD_R8_R8(D,E);
	return 4;
}
int exec_fd54()
{
	LD_R8_R8(D,IYH);
	return 4;
}
int exec_fd55()
{
	LD_R8_R8(D,IYL);
	return 4;
}
int exec_fd56()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(D,IY,f2);
	return 15;
}
int exec_fd57()
{
	LD_R8_R8(D,A);
	return 4;
}
int exec_fd58()
{
	LD_R8_R8(E,B);
	return 4;
}
int exec_fd59()
{
	LD_R8_R8(E,C);
	return 4;
}
int exec_fd5a()
{
	LD_R8_R8(E,D);
	return 4;
}
int exec_fd5b()
{
	LD_R8_R8(E,E);
	return 4;
}
int exec_fd5c()
{
	LD_R8_R8(E,IYH);
	return 4;
}
int exec_fd5d()
{
	LD_R8_R8(E,IYL);
	return 4;
}
int exec_fd5e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(E,IY,f2);
	return 15;
}
int exec_fd5f()
{
	LD_R8_R8(E,A);
	return 4;
}
int exec_fd60()
{
	LD_R8_R8(IYH,B);
	return 4;
}
int exec_fd61()
{
	LD_R8_R8(IYH,C);
	return 4;
}
int exec_fd62()
{
	LD_R8_R8(IYH,D);
	return 4;
}
int exec_fd63()
{
	LD_R8_R8(IYH,E);
	return 4;
}
int exec_fd64()
{
	LD_R8_R8(IYH,IYH);
	return 4;
}
int exec_fd65()
{
	LD_R8_R8(IYH,IYL);
	return 4;
}
int exec_fd66()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(H,IY,f2);
	return 15;
}
int exec_fd67()
{
	LD_R8_R8(IYH,A);
	return 4;
}
int exec_fd68()
{
	LD_R8_R8(IYL,B);
	return 4;
}
int exec_fd69()
{
	LD_R8_R8(IYL,C);
	return 4;
}
int exec_fd6a()
{
	LD_R8_R8(IYL,D);
	return 4;
}
int exec_fd6b()
{
	LD_R8_R8(IYL,E);
	return 4;
}
int exec_fd6c()
{
	LD_R8_R8(IYL,IYH);
	return 4;
}
int exec_fd6d()
{
	LD_R8_R8(IYL,IYL);
	return 4;
}
int exec_fd6e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(L,IY,f2);
	return 15;
}
int exec_fd6f()
{
	LD_R8_R8(IYL,A);
	return 4;
}
int exec_fd70()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IY,f1,B);
	return 15;
}
int exec_fd71()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IY,f1,C);
	return 15;
}
int exec_fd72()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IY,f1,D);
	return 15;
}
int exec_fd73()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IY,f1,E);
	return 15;
}
int exec_fd74()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IY,f1,H);
	return 15;
}
int exec_fd75()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IY,f1,L);
	return 15;
}
int exec_fd76()
{
	HALT();
	return 4;
}
int exec_fd77()
{
	int f1;
	fetchPC(f1);
	LD_IDX_R8(IY,f1,A);
	return 15;
}
int exec_fd78()
{
	LD_R8_R8(A,B);
	return 4;
}
int exec_fd79()
{
	LD_R8_R8(A,C);
	return 4;
}
int exec_fd7a()
{
	LD_R8_R8(A,D);
	return 4;
}
int exec_fd7b()
{
	LD_R8_R8(A,E);
	return 4;
}
int exec_fd7c()
{
	LD_R8_R8(A,IYH);
	return 4;
}
int exec_fd7d()
{
	LD_R8_R8(A,IYL);
	return 4;
}
int exec_fd7e()
{
	int f2;
	fetchPC(f2);
	LD_R8_IDX(A,IY,f2);
	return 15;
}
int exec_fd7f()
{
	LD_R8_R8(A,A);
	return 4;
}
int exec_fd80()
{
	ADD_R8_R8(A,B);
	return 4;
}
int exec_fd81()
{
	ADD_R8_R8(A,C);
	return 4;
}
int exec_fd82()
{
	ADD_R8_R8(A,D);
	return 4;
}
int exec_fd83()
{
	ADD_R8_R8(A,E);
	return 4;
}
int exec_fd84()
{
	ADD_R8_R8(A,IYH);
	return 4;
}
int exec_fd85()
{
	ADD_R8_R8(A,IYL);
	return 4;
}
int exec_fd86()
{
	int f2;
	fetchPC(f2);
	ADD_R8_IDX(A,IY,f2);
	return 15;
}
int exec_fd87()
{
	ADD_R8_R8(A,A);
	return 4;
}
int exec_fd88()
{
	ADC_R8_R8(A,B);
	return 4;
}
int exec_fd89()
{
	ADC_R8_R8(A,C);
	return 4;
}
int exec_fd8a()
{
	ADC_R8_R8(A,D);
	return 4;
}
int exec_fd8b()
{
	ADC_R8_R8(A,E);
	return 4;
}
int exec_fd8c()
{
	ADC_R8_R8(A,IYH);
	return 4;
}
int exec_fd8d()
{
	ADC_R8_R8(A,IYL);
	return 4;
}
int exec_fd8e()
{
	int f2;
	fetchPC(f2);
	ADC_R8_IDX(A,IY,f2);
	return 15;
}
int exec_fd8f()
{
	ADC_R8_R8(A,A);
	return 4;
}
int exec_fd90()
{
	SUB_R8(B);
	return 4;
}
int exec_fd91()
{
	SUB_R8(C);
	return 4;
}
int exec_fd92()
{
	SUB_R8(D);
	return 4;
}
int exec_fd93()
{
	SUB_R8(E);
	return 4;
}
int exec_fd94()
{
	SUB_R8(IYH);
	return 4;
}
int exec_fd95()
{
	SUB_R8(IYL);
	return 4;
}
int exec_fd96()
{
	int f1;
	fetchPC(f1);
	SUB_IDX(IY,f1);
	return 15;
}
int exec_fd97()
{
	SUB_R8(A);
	return 4;
}
int exec_fd98()
{
	SBC_R8_R8(A,B);
	return 4;
}
int exec_fd99()
{
	SBC_R8_R8(A,C);
	return 4;
}
int exec_fd9a()
{
	SBC_R8_R8(A,D);
	return 4;
}
int exec_fd9b()
{
	SBC_R8_R8(A,E);
	return 4;
}
int exec_fd9c()
{
	SBC_R8_R8(A,IYH);
	return 4;
}
int exec_fd9d()
{
	SBC_R8_R8(A,IYL);
	return 4;
}
int exec_fd9e()
{
	int f2;
	fetchPC(f2);
	SBC_R8_IDX(A,IY,f2);
	return 15;
}
int exec_fd9f()
{
	SBC_R8_R8(A,A);
	return 4;
}
int exec_fda0()
{
	AND_R8(B);
	return 4;
}
int exec_fda1()
{
	AND_R8(C);
	return 4;
}
int exec_fda2()
{
	AND_R8(D);
	return 4;
}
int exec_fda3()
{
	AND_R8(E);
	return 4;
}
int exec_fda4()
{
	AND_R8(IYH);
	return 4;
}
int exec_fda5()
{
	AND_R8(IYL);
	return 4;
}
int exec_fda6()
{
	int f1;
	fetchPC(f1);
	AND_IDX(IY,f1);
	return 15;
}
int exec_fda7()
{
	AND_R8(A);
	return 4;
}
int exec_fda8()
{
	XOR_R8(B);
	return 4;
}
int exec_fda9()
{
	XOR_R8(C);
	return 4;
}
int exec_fdaa()
{
	XOR_R8(D);
	return 4;
}
int exec_fdab()
{
	XOR_R8(E);
	return 4;
}
int exec_fdac()
{
	XOR_R8(IYH);
	return 4;
}
int exec_fdad()
{
	XOR_R8(IYL);
	return 4;
}
int exec_fdae()
{
	int f1;
	fetchPC(f1);
	XOR_IDX(IY,f1);
	return 15;
}
int exec_fdaf()
{
	XOR_R8(A);
	return 4;
}
int exec_fdb0()
{
	OR_R8(B);
	return 4;
}
int exec_fdb1()
{
	OR_R8(C);
	return 4;
}
int exec_fdb2()
{
	OR_R8(D);
	return 4;
}
int exec_fdb3()
{
	OR_R8(E);
	return 4;
}
int exec_fdb4()
{
	OR_R8(IYH);
	return 4;
}
int exec_fdb5()
{
	OR_R8(IYL);
	return 4;
}
int exec_fdb6()
{
	int f1;
	fetchPC(f1);
	OR_IDX(IY,f1);
	return 15;
}
int exec_fdb7()
{
	OR_R8(A);
	return 4;
}
int exec_fdb8()
{
	CP_R8(B);
	return 4;
}
int exec_fdb9()
{
	CP_R8(C);
	return 4;
}
int exec_fdba()
{
	CP_R8(D);
	return 4;
}
int exec_fdbb()
{
	CP_R8(E);
	return 4;
}
int exec_fdbc()
{
	CP_R8(IYH);
	return 4;
}
int exec_fdbd()
{
	CP_R8(IYL);
	return 4;
}
int exec_fdbe()
{
	int f1;
	fetchPC(f1);
	CP_IDX(IY,f1);
	return 15;
}
int exec_fdbf()
{
	CP_R8(A);
	return 4;
}
int exec_fdc0()
{
	RET_FLG(NZ);
	return (!bitFlg(Z))? 11 : 5;
}
int exec_fdc1()
{
	POP_R16(BC);
	return 10;
}
int exec_fdc2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(NZ,f2);
	return 10;
}
int exec_fdc3()
{
	int f1;
	fetch2PC(f1);
	JP_N(f1);
	return 10;
}
int exec_fdc4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(NZ,f2);
	return (!bitFlg(Z))? 17 : 10;
}
int exec_fdc5()
{
	PUSH_R16(BC);
	return 10;
}
int exec_fdc6()
{
	int f2;
	fetchPC(f2);
	ADD_R8_N(A,f2);
	return 7;
}
int exec_fdc7()
{
	RST_N(0);
	return 11;
}
int exec_fdc8()
{
	RET_FLG(Z);
	return (bitFlg(Z))? 11 : 5;
}
int exec_fdc9()
{
	RET();
	return 10;
}
int exec_fdca()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(Z,f2);
	return 10;
}
int exec_fdcb()
{
	return exec_instruction2(GROUP_FDCB)-4;
}
int exec_fdcc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(Z,f2);
	return (bitFlg(Z))? 17 : 10;
}
int exec_fdcd()
{
	int f1;
	fetch2PC(f1);
	CALL_N(f1);
	return 17;
}
int exec_fdce()
{
	int f2;
	fetchPC(f2);
	ADC_R8_N(A,f2);
	return 7;
}
int exec_fdcf()
{
	RST_N(8);
	return 11;
}
int exec_fdd0()
{
	RET_FLG(NC);
	return (!bitFlg(C))? 11 : 5;
}
int exec_fdd1()
{
	POP_R16(DE);
	return 10;
}
int exec_fdd2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(NC,f2);
	return 10;
}
int exec_fdd3()
{
	int f1;
	fetchPC(f1);
	OUT_M_R8(f1,A);
	return 11;
}
int exec_fdd4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(NC,f2);
	return (!bitFlg(C))? 17 : 10;
}
int exec_fdd5()
{
	PUSH_R16(DE);
	return 10;
}
int exec_fdd6()
{
	int f1;
	fetchPC(f1);
	SUB_N(f1);
	return 7;
}
int exec_fdd7()
{
	RST_N(16);
	return 11;
}
int exec_fdd8()
{
	RET_FLG(C);
	return (bitFlg(C))? 11 : 5;
}
int exec_fdd9()
{
	EXX();
	return 4;
}
int exec_fdda()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(C,f2);
	return 10;
}
int exec_fddb()
{
	int f2;
	fetchPC(f2);
	IN_R8_M(A,f2);
	return 11;
}
int exec_fddc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(C,f2);
	return (bitFlg(C))? 17 : 10;
}
int exec_fddd()
{
	decReg(PC);	return 0;
}
int exec_fdde()
{
	int f2;
	fetchPC(f2);
	SBC_R8_N(A,f2);
	return 7;
}
int exec_fddf()
{
	RST_N(24);
	return 11;
}
int exec_fde0()
{
	RET_FLG(PO);
	return (!bitFlg(PV))? 11 : 5;
}
int exec_fde1()
{
	POP_R16(IY);
	return 10;
}
int exec_fde2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(PO,f2);
	return 10;
}
int exec_fde3()
{
	EX_RM_R16(SP,IY);
	return 19;
}
int exec_fde4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(PO,f2);
	return (!bitFlg(PV))? 17 : 10;
}
int exec_fde5()
{
	PUSH_R16(IY);
	return 10;
}
int exec_fde6()
{
	int f1;
	fetchPC(f1);
	AND_N(f1);
	return 7;
}
int exec_fde7()
{
	RST_N(32);
	return 11;
}
int exec_fde8()
{
	RET_FLG(PE);
	return (bitFlg(PV))? 11 : 5;
}
int exec_fde9()
{
	JP_R16(IY);
	return 4;
}
int exec_fdea()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(PE,f2);
	return 10;
}
int exec_fdeb()
{
	EX_R16_R16(DE,IY);
	return 4;
}
int exec_fdec()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(PE,f2);
	return (bitFlg(PV))? 17 : 10;
}
int exec_fded()
{
	decReg(PC);	return 0;
}
int exec_fdee()
{
	int f1;
	fetchPC(f1);
	XOR_N(f1);
	return 7;
}
int exec_fdef()
{
	RST_N(40);
	return 11;
}
int exec_fdf0()
{
	RET_FLG(P);
	return (!bitFlg(S))? 11 : 5;
}
int exec_fdf1()
{
	POP_R16(AF);
	return 10;
}
int exec_fdf2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(P,f2);
	return 10;
}
int exec_fdf3()
{
	DI();
	return 4;
}
int exec_fdf4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(P,f2);
	return (!bitFlg(S))? 17 : 10;
}
int exec_fdf5()
{
	PUSH_R16(AF);
	return 10;
}
int exec_fdf6()
{
	int f1;
	fetchPC(f1);
	OR_N(f1);
	return 7;
}
int exec_fdf7()
{
	RST_N(48);
	return 11;
}
int exec_fdf8()
{
	RET_FLG(M);
	return (bitFlg(S))? 11 : 5;
}
int exec_fdf9()
{
	LD_R16_R16(SP,IY);
	return 6;
}
int exec_fdfa()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(M,f2);
	return 10;
}
int exec_fdfb()
{
	EI();
	return 4;
}
int exec_fdfc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(M,f2);
	return (bitFlg(S))? 17 : 10;
}
int exec_fdfd()
{
	decReg(PC);	return 0;
}
int exec_fdfe()
{
	int f1;
	fetchPC(f1);
	CP_N(f1);
	return 7;
}
int exec_fdff()
{
	RST_N(56);
	return 11;
}

int (*(instr_fd[]))() = {
	exec_fd00,
	exec_fd01,
	exec_fd02,
	exec_fd03,
	exec_fd04,
	exec_fd05,
	exec_fd06,
	exec_fd07,
	exec_fd08,
	exec_fd09,
	exec_fd0a,
	exec_fd0b,
	exec_fd0c,
	exec_fd0d,
	exec_fd0e,
	exec_fd0f,
	exec_fd10,
	exec_fd11,
	exec_fd12,
	exec_fd13,
	exec_fd14,
	exec_fd15,
	exec_fd16,
	exec_fd17,
	exec_fd18,
	exec_fd19,
	exec_fd1a,
	exec_fd1b,
	exec_fd1c,
	exec_fd1d,
	exec_fd1e,
	exec_fd1f,
	exec_fd20,
	exec_fd21,
	exec_fd22,
	exec_fd23,
	exec_fd24,
	exec_fd25,
	exec_fd26,
	exec_fd27,
	exec_fd28,
	exec_fd29,
	exec_fd2a,
	exec_fd2b,
	exec_fd2c,
	exec_fd2d,
	exec_fd2e,
	exec_fd2f,
	exec_fd30,
	exec_fd31,
	exec_fd32,
	exec_fd33,
	exec_fd34,
	exec_fd35,
	exec_fd36,
	exec_fd37,
	exec_fd38,
	exec_fd39,
	exec_fd3a,
	exec_fd3b,
	exec_fd3c,
	exec_fd3d,
	exec_fd3e,
	exec_fd3f,
	exec_fd40,
	exec_fd41,
	exec_fd42,
	exec_fd43,
	exec_fd44,
	exec_fd45,
	exec_fd46,
	exec_fd47,
	exec_fd48,
	exec_fd49,
	exec_fd4a,
	exec_fd4b,
	exec_fd4c,
	exec_fd4d,
	exec_fd4e,
	exec_fd4f,
	exec_fd50,
	exec_fd51,
	exec_fd52,
	exec_fd53,
	exec_fd54,
	exec_fd55,
	exec_fd56,
	exec_fd57,
	exec_fd58,
	exec_fd59,
	exec_fd5a,
	exec_fd5b,
	exec_fd5c,
	exec_fd5d,
	exec_fd5e,
	exec_fd5f,
	exec_fd60,
	exec_fd61,
	exec_fd62,
	exec_fd63,
	exec_fd64,
	exec_fd65,
	exec_fd66,
	exec_fd67,
	exec_fd68,
	exec_fd69,
	exec_fd6a,
	exec_fd6b,
	exec_fd6c,
	exec_fd6d,
	exec_fd6e,
	exec_fd6f,
	exec_fd70,
	exec_fd71,
	exec_fd72,
	exec_fd73,
	exec_fd74,
	exec_fd75,
	exec_fd76,
	exec_fd77,
	exec_fd78,
	exec_fd79,
	exec_fd7a,
	exec_fd7b,
	exec_fd7c,
	exec_fd7d,
	exec_fd7e,
	exec_fd7f,
	exec_fd80,
	exec_fd81,
	exec_fd82,
	exec_fd83,
	exec_fd84,
	exec_fd85,
	exec_fd86,
	exec_fd87,
	exec_fd88,
	exec_fd89,
	exec_fd8a,
	exec_fd8b,
	exec_fd8c,
	exec_fd8d,
	exec_fd8e,
	exec_fd8f,
	exec_fd90,
	exec_fd91,
	exec_fd92,
	exec_fd93,
	exec_fd94,
	exec_fd95,
	exec_fd96,
	exec_fd97,
	exec_fd98,
	exec_fd99,
	exec_fd9a,
	exec_fd9b,
	exec_fd9c,
	exec_fd9d,
	exec_fd9e,
	exec_fd9f,
	exec_fda0,
	exec_fda1,
	exec_fda2,
	exec_fda3,
	exec_fda4,
	exec_fda5,
	exec_fda6,
	exec_fda7,
	exec_fda8,
	exec_fda9,
	exec_fdaa,
	exec_fdab,
	exec_fdac,
	exec_fdad,
	exec_fdae,
	exec_fdaf,
	exec_fdb0,
	exec_fdb1,
	exec_fdb2,
	exec_fdb3,
	exec_fdb4,
	exec_fdb5,
	exec_fdb6,
	exec_fdb7,
	exec_fdb8,
	exec_fdb9,
	exec_fdba,
	exec_fdbb,
	exec_fdbc,
	exec_fdbd,
	exec_fdbe,
	exec_fdbf,
	exec_fdc0,
	exec_fdc1,
	exec_fdc2,
	exec_fdc3,
	exec_fdc4,
	exec_fdc5,
	exec_fdc6,
	exec_fdc7,
	exec_fdc8,
	exec_fdc9,
	exec_fdca,
	exec_fdcb,
	exec_fdcc,
	exec_fdcd,
	exec_fdce,
	exec_fdcf,
	exec_fdd0,
	exec_fdd1,
	exec_fdd2,
	exec_fdd3,
	exec_fdd4,
	exec_fdd5,
	exec_fdd6,
	exec_fdd7,
	exec_fdd8,
	exec_fdd9,
	exec_fdda,
	exec_fddb,
	exec_fddc,
	exec_fddd,
	exec_fdde,
	exec_fddf,
	exec_fde0,
	exec_fde1,
	exec_fde2,
	exec_fde3,
	exec_fde4,
	exec_fde5,
	exec_fde6,
	exec_fde7,
	exec_fde8,
	exec_fde9,
	exec_fdea,
	exec_fdeb,
	exec_fdec,
	exec_fded,
	exec_fdee,
	exec_fdef,
	exec_fdf0,
	exec_fdf1,
	exec_fdf2,
	exec_fdf3,
	exec_fdf4,
	exec_fdf5,
	exec_fdf6,
	exec_fdf7,
	exec_fdf8,
	exec_fdf9,
	exec_fdfa,
	exec_fdfb,
	exec_fdfc,
	exec_fdfd,
	exec_fdfe,
	exec_fdff,
};
