:menu
@echo off
:menup
cls

echo #####################################################
echo #                      Main Menu                    #
echo #####################################################

echo Type :
echo 0 Quit
echo 1 For TI-nSpire CAS
echo 2 For TI-nSpire
echo 3 For *.bin files (confirmed only)
echo 4 To display help

set /p me= Chose : 
IF %me% == 0 goto quitter
IF %me% == 1 goto cas
IF %me% == 2 goto noncas
IF %me% == 3 goto binrun
IF %me% == 4 goto help
goto quitter

:binrun
cls
echo #####################################################
echo #                 Run a *.bin file                  #
echo #####################################################
set binfile=demo
set /p binfile= Type the *.bin file name to use (without extension) : 
nspire_emu.exe /B=%binfile%.bin
pause
goto menup


:cas
cls

echo #####################################################
echo #                TI-nSpire CAS Menu                 #
echo #####################################################

echo Type :
echo 0 Return
echo 1 Extract boot2 file
echo 2 Create a ROM file
echo 3 Launch a ROM file with boot1
echo 4 Launch a ROM file with boot2

set /p mecas= Chose : 
IF %mecas% == 0 goto menup
IF %mecas% == 1 goto extboot2
IF %mecas% == 2 goto romcas
IF %mecas% == 3 goto runcasb1
IF %mecas% == 4 goto runcasb2
goto menup

:noncas
cls

echo #####################################################
echo #                  TI-nSpire Menu                   #
echo #####################################################

echo Type :
echo 0 Return 
echo 1 pour Extract boot2 file
echo 2 Create a ROM file
echo 3 Launch a ROM file with boot1
echo 4 Launch a ROM file in 84+ mode with boot1
echo 5 Launch a ROM file with boot2
echo 6 Launch a ROM file in 84+ mode with boot2


set /p mebas= Chose  
IF %mebas% == 0 goto menup
IF %mebas% == 1 goto extboot2
IF %mebas% == 2 goto romnoncas
IF %mebas% == 3 goto runnoncasb1
IF %mebas% == 4 goto runnoncas84b1
IF %mebas% == 5 goto runnoncasb2
IF %mebas% == 6 goto runnoncas84b2
goto menup

:extboot2
cls

echo #####################################################
echo #       Extract the Boot2 file from boot2.img       #
echo #####################################################

imgdump boot2.img
pause
goto menup

:romnoncas
cls

echo #####################################################
echo #          Create a ROM file for TI-nSpire          #
echo ##################################################### 
set /p rom= Type the *.rom file name to create (without extension) : 
set /p os= Type the *.tno file name to use (without extension) : 
nspire_emu.exe /F=%rom%.rom /N /PB=boot2.img /PO=%os%.tno

pause
goto noncas

:romcas
cls

echo #####################################################
echo #            Create une ROM TI-nSpire CAS           #
echo #####################################################
set /p rom= Type the *.rom file name to create (without extension) : 
set /p os= Type the *.tnc file name to use (without extension) : 
nspire_emu.exe /F=%rom%.rom /N /PB=boot2.img /PO=%os%.tnc /C

pause
goto cas

:runnoncasb1
cls

echo #####################################################
echo #    Launch a ROM file for TI-nSpire with boot1     #
echo #####################################################
set /p rom= Type the *.rom file name to use (without extension) : 
set /p boot1= Type the entire boot1 file name to use : 
nspire_emu.exe /F=%rom%.rom /1=%boot1%
pause
goto noncas

:runnoncas84b1
cls

echo #####################################################
echo #     Launch a ROM file in 84+ mode with boot1      #
echo #####################################################
set /p rom= Type the *.rom file name to use (without extension) : 
set /p boot1= Type the entire boot1 file name to use : 
nspire_emu.exe /F=%rom%.rom /1=%boot1%.img /K
pause
goto noncas

:runcasb1
cls

echo #####################################################
echo #     Launch a ROM file TI-nSpire CAS with boot1    #
echo #####################################################
set /p rom= Type the *.rom file name to use (without extension) : 
set /p boot1= Type the entire boot1 file name to use : 
nspire_emu.exe /F=%rom%.rom /1=%boot1% /C
pause
goto cas

:runnoncasb2
cls

echo #####################################################
echo #     Launch a ROM file for TI-nSpire with boot2    #
echo #####################################################
set /p rom= Type the *.rom file name to use (without extension) : 
nspire_emu.exe /F=%rom%.rom /B=boot2.img.raw
pause
goto noncas

:runnoncas84b2
cls

echo #####################################################
echo #      Launch a ROM file in 84+ mode with boot2     #
echo #####################################################
set /p rom= Type the *.rom file name to use (without extension) : 
nspire_emu.exe /F=%rom%.rom /B=boot2.img.raw /K
pause
goto noncas

:runcasb2
cls

echo #####################################################
echo #   Launch a ROM file for TI-nSpire CAS with boot2  #
echo #####################################################
set /p rom= Type the *.rom file name to use (without extension) : 
nspire_emu.exe /F=%rom%.rom /B=boot2.img.raw /C
pause
goto cas

:help
cls
echo #####################################################
echo #                      Help                         #
echo #                   ----------                     ##
echo ##         On the usage with boot2 start up        ##
echo #####################################################
echo - Get the Upgrade TI files (*.tnc/*.tno) by downloading it on
echo   TI website, or on TI-bank, where you can find most of the 
echo   files that have existed.
echo - Copy the file into the emulator root folder.
echo - Rename it by an explicit name (eg. : 17.tnc) !
echo - Change the extension into *.zip format
echo - Open the archive an simply extract the 'boot2.img' file into 
echo   the emulator root folder
echo - Restore the update TI file extension (*.tnc / *.tno).
echo - Thanks to the batch file, decrypt the "boot2.img" file.
echo - Thanks to the batch file, launch the emulator.
echo ### Look up the below video tutorial : http://vimeo.com/8884626
pause
goto menup

:quitter
cls
echo Thanks for using this Bash shell made by Levak
echo A BIG Thanks to Goplat for its emulator and to xspire for its skin !
pause
exit
