/* 
 * ASCD : copyright (c) Aley Keprt 1998-2012
 * SimCoupe : Copyright (c) Allan Skillman 1996
 *
 * Emulations of the Z80 CPU instruction set - part of xz80.
 * Copyright (C) 1994 Ian Collier.
 *
    This file is part of Z80 CPU emulation library used in ASCD emulator.

    This library is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*/


#define instr(opcode,cycles) case opcode: {tstates=cycles

#define HLinstr(opcode,cycles,morecycles) \
  case opcode: { \
    WORD addr; \
    tstates=cycles; \
    if(ixoriy==0)addr=hl; \
    else tstates+=morecycles, addr = (ixoriy==1?ix:iy) + (sgn8)read_byte(pc), pc++

#define endinstr }; break

#define cy (f&1)

#define xh (ixoriy==0?h:ixoriy==1?(ix>>8):(iy>>8))
#define xl (ixoriy==0?l:ixoriy==1?(ix&0xff):(iy&0xff))

#define setxh(x) (ixoriy==0?(h=(x)):ixoriy==1?(ix=(ix&0xff)|((x)<<8)):\
                  (iy=(iy&0xff)|((x)<<8)))

#define setxl(x) (ixoriy==0?(l=(x)):ixoriy==1?(ix=(ix&0xff00)|(x)):\
                  (iy=(iy&0xff00)|(x)))

#define inc(var) /* 8-bit increment */ ( var++,\
                                         f=(f&1)|(var&0xa8)|\
                                           ((!(var&15))<<4)|((!var)<<6)|\
                                           ((var==128)<<2)\
                                       )

#define dec(var) /* 8-bit decrement */ ( f=(f&1)|((!(var&15))<<4)|2, --var,\
                                         f |= (var&0xa8) | ((var==127)<<2) | ((!var)<<6) )

#define swap(x,y) {BYTE t=x; x=y; y=t;}

#define addhl(hi,lo) /* 16-bit add */ if(!ixoriy) {\
                      WORD t;\
                      l=t=l+(lo);\
                      f = (f&0xc4) | (((t>>=8)+(h&0x0f)+((hi)&0x0f)>15)<<4);\
                      h = t += h + (hi); \
                      f |= (h&0x28) | (t>>8); \
                   } else do { DWORD t = (ixoriy==1 ? ix : iy); \
                      f = (f&0xc4) | (((t&0xfff)+((hi<<8)|lo)>0xfff)<<4); \
                      t += (hi<<8) | lo; \
                      if(ixoriy==1) ix=t; else iy=t; \
                      f |= ((t>>8)&0x28) | (t>>16); \
                   } while(0)

#define adda1(x,c) /* 8-bit add */ do{WORD y;\
                      BYTE z=(x);\
                      y=a+z+(c);\
                      f=(y&0xa8)|(y>>8)|(((a&0x0f)+(z&0x0f)+(c)>15)<<4)|\
                        (((~a^z)&0x80&(y^a))>>5);\
                      f|=(!(a=y))<<6;\
                   } while(0)

#define adda(x)		adda1((x),0)
#define adca(x)		adda1((x),cy)

#define suba1(x,c) /* 8-bit subtract */ do{WORD y;\
                      BYTE z=(x);\
                      y=(a-z-(c))&0x1ff;\
                      f=(y&0xa8)|(y>>8)|(((a&0x0f)<(z&0x0f)+(c))<<4)|\
                        (((a^z)&0x80&(y^a))>>5)|2;\
                      f|=(!(a=y))<<6;\
                   } while(0)

#define suba(x)		suba1((x),0)
#define sbca(x)		suba1((x),cy)

#define cpa(x) /* 8-bit compare */ do{WORD y;\
                      BYTE z=(x);\
                      y=(a-z)&0x1ff;\
                      f=(y&0xa8)|(y>>8)|(((a&0x0f)<(z&0x0f))<<4)|\
                        (((a^z)&0x80&(y^a))>>5)|2|((!y)<<6);\
                   } while(0)

#define anda(x) /* logical and */ do{\
                      a&=(x);\
                      f=(a&0xa8)|((!a)<<6)|0x10|parity(a);\
                   } while(0)

#define xora(x) /* logical xor */ do{\
                      a^=(x);\
                      f=(a&0xa8)|((!a)<<6)|parity(a);\
                   } while(0)

#define ora(x) /* logical or */ do{\
                      a|=(x);\
                      f=(a&0xa8)|((!a)<<6)|parity(a);\
                   } while(0)

#define jr /* execute relative jump */ do { int j=(sgn8)read_byte(pc); pc+=j+1; tstates+=4; } while(0)

#define jp /* execute jump */ (pc=read_word(pc))

#define call /* execute call */ do{ tstates+=8; push2(pc+2); jp; } while(0)

#define ret /* execute return */ do{ tstates+=4; pop2(pc); } while(0)

#define pop2(var) /* pop 16-bit register */ (var=read_word(sp), sp+=2)
#define pop1(v1,v2) /* pop register pair */ (v2=read_byte(sp), v1=read_byte(sp+1), sp+=2)
#define push2(val) /* push 16-bit register */ do{ sp-=2; write_word(sp,(val)); } while(0)
#define push1(v1,v2) /* push register pair */ do{ sp-=2; write_word(sp,(v1)<<8|(v2)); } while(0)

//tohle je prevzato ze SimCoupe 1.0
#define PORT_ACCESS(port) if(zxmode==EM_Sam) (LineCycleCounter += 4) |= ((port) >= 0xF8) ? 7 : 0; else {}

instr(0,4);
   //nop
endinstr;

instr(1,12);
   c=read_byte(pc),pc++;
   b=read_byte(pc),pc++;
endinstr;

instr(2,8);
   write_byte(bc,a);
endinstr;

instr(3,8);
   if(!++c)b++;
endinstr;

instr(4,4);
   inc(b);
endinstr;

instr(5,4);
   dec(b);
endinstr;

instr(6,8);
   b=read_byte(pc),pc++;
endinstr;

instr(7,4);
   a=(a<<1)|(a>>7);
   f=(f&0xc4)|(a&0x29);
endinstr;

instr(8,4);
   swap(a,a1);
   swap(f,f1);
endinstr;

instr(9,12);
   addhl(b,c);
endinstr;

instr(10,8);
   a=read_byte(bc);
endinstr;

instr(11,8);
   if(!c--)b--;
endinstr;

instr(12,4);
   inc(c);
endinstr;

instr(13,4);
   dec(c);
endinstr;

instr(14,8);
   c=read_byte(pc),pc++;
endinstr;

instr(15,4);
   f=(f&0xc4)|(a&1);
   a=(a>>1)|(a<<7);
   f|=a&0x28;
endinstr;

instr(16,13); //djnz
   if(!--b)pc++;
   else { tstates-=5; jr; }
endinstr;

instr(17,12);
   e=read_byte(pc),pc++;
   d=read_byte(pc),pc++;
endinstr;

instr(18,8);
   write_byte(de,a);
endinstr;

instr(19,8);
   if(!++e)d++;
endinstr;

instr(20,4);
   inc(d);
endinstr;

instr(21,4);
   dec(d);
endinstr;

instr(22,8);
   d=read_byte(pc),pc++;
endinstr;

instr(23,4);
  {int t=a>>7;
   a=(a<<1)|(f&1);
   f=(f&0xc4)|(a&0x28)|t;
  }
endinstr;

instr(24,8);
   jr;
endinstr;

instr(25,12);
   addhl(d,e);
endinstr;

instr(26,8);
   a=read_byte(de);
endinstr;

instr(27,8);
   if(!e--)d--;
endinstr;

instr(28,4);
   inc(e);
endinstr;

instr(29,4);
   dec(e);
endinstr;

instr(30,8);
   e=read_byte(pc),pc++;
endinstr;

instr(31,4);
  {int t=a&1;
   a=(a>>1)|(f<<7);
   f=(f&0xc4)|(a&0x28)|t;
  }
endinstr;

instr(32,8);
  if(f&0x40)pc++;
  else jr;
endinstr;

instr(33,12);
   if(!ixoriy){
      l=read_byte(pc),pc++;
      h=read_byte(pc),pc++;
   } else {
      if(ixoriy==1)ix=read_word(pc);
      else iy=read_word(pc);
      pc+=2;
   }
endinstr;

instr(34,16); //ld (nn),hl
   {WORD addr=read_word(pc);
    pc+=2;
    if(!ixoriy)write_word(addr,hl);
    else if(ixoriy==1)write_word(addr,ix);
    else write_word(addr,iy);
   }
endinstr;

instr(35,8);
   if(!ixoriy){if(!++l)h++;}
   else if(ixoriy==1)ix++;
   else iy++;
endinstr;

instr(36,4);
   if(ixoriy==0)inc(h);
   else{BYTE t;
      t=(ixoriy==1?ix:iy)>>8;
      inc(t);
      if(ixoriy==1)ix=(ix&0xff)|(t<<8);
      else iy=(iy&0xff)|(t<<8);
   }
endinstr;

instr(37,4);
   if(ixoriy==0)dec(h);
   else{BYTE t;
      t=(ixoriy==1?ix:iy)>>8;
      dec(t);
      if(ixoriy==1)ix=(ix&0xff)|(t<<8);
      else iy=(iy&0xff)|(t<<8);
   }
endinstr;

instr(38,8);
   setxh(read_byte(pc));
   pc++;
endinstr;

instr(39,4);
   {
      BYTE incr=0, carry=cy;
      if((f&0x10) || (a&0x0f)>9) incr=6;
      if((f&1) || (a>>4)>9) incr|=0x60;
      if(f&2)suba(incr);
      else {
         if(a>0x90 && (a&15)>9)incr|=0x60;
         adda(incr);
      }
      f=((f|carry)&0xfb)|parity(a);
   }

endinstr;

instr(40,8);
   if(f&0x40)jr;
   else pc++;
endinstr;

instr(41,12);
   if(!ixoriy)addhl(h,l);
   else if(ixoriy==1)addhl((ix>>8),(ix&0xff));
   else addhl((iy>>8),(iy&0xff));
endinstr;

instr(42,16); //ld hl,(nn)
  {WORD addr=read_word(pc);
   pc+=2;
   if(!ixoriy){
      l=read_byte(addr);
      h=read_byte(addr+1);
   }
   else if(ixoriy==1)ix=read_word(addr);
   else iy=read_word(addr);
  }
endinstr;

instr(43,8);
   if(!ixoriy){if(!l--)h--;}
   else if(ixoriy==1)ix--;
   else iy--;
endinstr;

instr(44,4);
   if(!ixoriy)inc(l);
   else {BYTE t;
      t=(ixoriy==1?ix:iy);
      inc(t);
      if(ixoriy==1)ix=(ix&0xff00)|t;
      else iy=(iy&0xff00)|t;
   }
endinstr;

instr(45,4);
   if(!ixoriy)dec(l);
   else {BYTE t;
      t=(ixoriy==1?ix:iy);
      dec(t);
      if(ixoriy==1)ix=(ix&0xff00)|t;
      else iy=(iy&0xff00)|t;
   }
endinstr;

instr(46,8);
   setxl(read_byte(pc));
   pc++;
endinstr;

instr(47,4);
   a=~a;
   f=(f&0xc5)|(a&0x28)|0x12;
endinstr;

instr(48,8);
   if(f&1)pc++;
   else jr;
endinstr;

instr(49,12);
   sp=read_word(pc);
   pc+=2;
endinstr;

instr(50,16);
  {WORD addr=read_word(pc);
   pc+=2;
   write_byte(addr,a);
  }
endinstr;

instr(51,8);
   sp++;
endinstr;

HLinstr(52,12,8);
  {BYTE t=read_byte(addr);
   inc(t);
   write_byte(addr,t);
  }
endinstr;

HLinstr(53,12,8);
  {BYTE t=read_byte(addr);
   dec(t);
   write_byte(addr,t);
  }
endinstr;

HLinstr(54,12,8);
   write_byte(addr,read_byte(pc));
   pc++;
endinstr;

instr(55,4);
   f=(f&0xc4)|1|(a&0x28);
endinstr;

instr(56,8);
   if(f&1)jr;
   else pc++;
endinstr;

instr(57,12);
   addhl((sp>>8),(sp&0xff));
endinstr;

instr(58,16);
  {WORD addr=read_word(pc);
   pc+=2;
   a=read_byte(addr);
  }
endinstr;

instr(59,8);
   sp--;
endinstr;

instr(60,4);
   inc(a);
endinstr;

instr(61,4);
   dec(a);
endinstr;

instr(62,8);
   a=read_byte(pc),pc++;
endinstr;

instr(63,4);
   f=(f&0xc4)|(cy^1)|(cy<<4)|(a&0x28);
endinstr;

instr(0x40,4);
   //ld b,b
endinstr;

instr(0x41,4);
   b=c;
endinstr;

instr(0x42,4);
   b=d;
endinstr;

instr(0x43,4);
   b=e;
endinstr;

instr(0x44,4);
   b=xh;
endinstr;

instr(0x45,4);
   b=xl;
endinstr;

HLinstr(0x46,8,12);
   b=read_byte(addr);
endinstr;

instr(0x47,4);
   b=a;
endinstr;

instr(0x48,4);
   c=b;
endinstr;

instr(0x49,4);
   //ld c,c
endinstr;

instr(0x4a,4);
   c=d;
endinstr;

instr(0x4b,4);
   c=e;
endinstr;

instr(0x4c,4);
   c=xh;
endinstr;

instr(0x4d,4);
   c=xl;
endinstr;

HLinstr(0x4e,8,12);
   c=read_byte(addr);
endinstr;

instr(0x4f,4);
   c=a;
endinstr;

instr(0x50,4);
   d=b;
endinstr;

instr(0x51,4);
   d=c;
endinstr;

instr(0x52,4);
   //ld d,d
endinstr;

instr(0x53,4);
   d=e;
endinstr;

instr(0x54,4);
   d=xh;
endinstr;

instr(0x55,4);
   d=xl;
endinstr;

HLinstr(0x56,8,12);
   d=read_byte(addr);
endinstr;

instr(0x57,4);
   d=a;
endinstr;

instr(0x58,4);
   e=b;
endinstr;

instr(0x59,4);
   e=c;
endinstr;

instr(0x5a,4);
   e=d;
endinstr;

instr(0x5b,4);
   //ld e,e
endinstr;

instr(0x5c,4);
   e=xh;
endinstr;

instr(0x5d,4);
   e=xl;
endinstr;

HLinstr(0x5e,8,12);
   e=read_byte(addr);
endinstr;

instr(0x5f,4);
   e=a;
endinstr;

instr(0x60,4);
   setxh(b);
endinstr;

instr(0x61,4);
   setxh(c);
endinstr;

instr(0x62,4);
   setxh(d);
endinstr;

instr(0x63,4);
   setxh(e);
endinstr;

instr(0x64,4);
   //ld h,h
endinstr;

instr(0x65,4);
   setxh(xl);
endinstr;

HLinstr(0x66,8,12);
   h=read_byte(addr);
endinstr;

instr(0x67,4);
   setxh(a);
endinstr;

instr(0x68,4);
   setxl(b);
endinstr;

instr(0x69,4);
   setxl(c);
endinstr;

instr(0x6a,4);
   setxl(d);
endinstr;

instr(0x6b,4);
   setxl(e);
endinstr;

instr(0x6c,4);
   setxl(xh);
endinstr;

instr(0x6d,4);
   //ld l,l
endinstr;

HLinstr(0x6e,8,12);
   l=read_byte(addr);
endinstr;

instr(0x6f,4);
   setxl(a);
endinstr;

HLinstr(0x70,8,8);
   write_byte(addr,b);
endinstr;

HLinstr(0x71,8,8);
   write_byte(addr,c);
endinstr;

HLinstr(0x72,8,8);
   write_byte(addr,d);
endinstr;

HLinstr(0x73,8,8);
   write_byte(addr,e);
endinstr;

HLinstr(0x74,8,8);
   write_byte(addr,h);
endinstr;

HLinstr(0x75,8,8);
   write_byte(addr,l);
endinstr;

instr(0x76,4);
   //HALT executes NOP instructions until the next frame, so the number of cycles used is a multiple of 4
   //if(tstates<int_cycles) tstates += (int_cycles - tstates + 3)&~3;
   pc--; //HALT will be repeated until an interrupt occurs
endinstr;

HLinstr(0x77,8,8);
   write_byte(addr,a);
endinstr;

instr(0x78,4);
   a=b;
endinstr;

instr(0x79,4);
   a=c;
endinstr;

instr(0x7a,4);
   a=d;
endinstr;

instr(0x7b,4);
   a=e;
endinstr;

instr(0x7c,4);
   a=xh;
endinstr;

instr(0x7d,4);
   a=xl;
endinstr;

HLinstr(0x7e,8,8);
   a=read_byte(addr);
endinstr;

instr(0x7f,4);
   //ld a,a
endinstr;

instr(0x80,4);
   adda(b);
endinstr;

instr(0x81,4);
   adda(c);
endinstr;

instr(0x82,4);
   adda(d);
endinstr;

instr(0x83,4);
   adda(e);
endinstr;

instr(0x84,4);
   adda(xh);
endinstr;

instr(0x85,4);
   adda(xl);
endinstr;

HLinstr(0x86,8,8);
   adda(read_byte(addr));
endinstr;

instr(0x87,4);
   adda(a);
endinstr;

instr(0x88,4);
   adca(b);
endinstr;

instr(0x89,4);
   adca(c);
endinstr;

instr(0x8a,4);
   adca(d);
endinstr;

instr(0x8b,4);
   adca(e);
endinstr;

instr(0x8c,4);
   adca(xh);
endinstr;

instr(0x8d,4);
   adca(xl);
endinstr;

HLinstr(0x8e,8,8);
   adca(read_byte(addr));
endinstr;

instr(0x8f,4);
   adca(a);
endinstr;

instr(0x90,4);
   suba(b);
endinstr;

instr(0x91,4);
   suba(c);
endinstr;

instr(0x92,4);
   suba(d);
endinstr;

instr(0x93,4);
   suba(e);
endinstr;

instr(0x94,4);
   suba(xh);
endinstr;

instr(0x95,4);
   suba(xl);
endinstr;

HLinstr(0x96,8,8);
   suba(read_byte(addr));
endinstr;

instr(0x97,4);
   suba(a);
endinstr;

instr(0x98,4);
   sbca(b);
endinstr;

instr(0x99,4);
   sbca(c);
endinstr;

instr(0x9a,4);
   sbca(d);
endinstr;

instr(0x9b,4);
   sbca(e);
endinstr;

instr(0x9c,4);
   sbca(xh);
endinstr;

instr(0x9d,4);
   sbca(xl);
endinstr;

HLinstr(0x9e,8,8);
   sbca(read_byte(addr));
endinstr;

instr(0x9f,4);
   sbca(a);
endinstr;

instr(0xa0,4);
   anda(b);
endinstr;

instr(0xa1,4);
   anda(c);
endinstr;

instr(0xa2,4);
   anda(d);
endinstr;

instr(0xa3,4);
   anda(e);
endinstr;

instr(0xa4,4);
   anda(xh);
endinstr;

instr(0xa5,4);
   anda(xl);
endinstr;

HLinstr(0xa6,8,8);
   anda(read_byte(addr));
endinstr;

instr(0xa7,4);
   anda(a);
endinstr;

instr(0xa8,4);
   xora(b);
endinstr;

instr(0xa9,4);
   xora(c);
endinstr;

instr(0xaa,4);
   xora(d);
endinstr;

instr(0xab,4);
   xora(e);
endinstr;

instr(0xac,4);
   xora(xh);
endinstr;

instr(0xad,4);
   xora(xl);
endinstr;

HLinstr(0xae,8,8);
   xora(read_byte(addr));
endinstr;

instr(0xaf,4);
   xora(a);
endinstr;

instr(0xb0,4);
   ora(b);
endinstr;

instr(0xb1,4);
   ora(c);
endinstr;

instr(0xb2,4);
   ora(d);
endinstr;

instr(0xb3,4);
   ora(e);
endinstr;

instr(0xb4,4);
   ora(xh);
endinstr;

instr(0xb5,4);
   ora(xl);
endinstr;

HLinstr(0xb6,8,8);
   ora(read_byte(addr));
endinstr;

instr(0xb7,4);
   ora(a);
endinstr;

instr(0xb8,4);
   cpa(b);
endinstr;

instr(0xb9,4);
   cpa(c);
endinstr;

instr(0xba,4);
   cpa(d);
endinstr;

instr(0xbb,4);
   cpa(e);
endinstr;

instr(0xbc,4);
   cpa(xh);
endinstr;

instr(0xbd,4);
   cpa(xl);
endinstr;

HLinstr(0xbe,8,8);
   cpa(read_byte(addr));
endinstr;

instr(0xbf,4);
   cpa(a);
endinstr;

instr(0xc0,8);
   if(!(f&0x40))ret;
endinstr;

instr(0xc1,12);
   pop1(b,c);
endinstr;

instr(0xc2,12);
   if(!(f&0x40))jp;
   else pc+=2;
endinstr;

instr(0xc3,12);
   jp;
endinstr;

instr(0xc4,12);
   if(!(f&0x40))call;
   else pc+=2;
endinstr;

instr(0xc5,12);
   push1(b,c);
endinstr;

instr(0xc6,8);
   adda(read_byte(pc));
   pc++;
endinstr;

instr(0xc7,12);
   push2(pc);
   pc=0;
endinstr;

instr(0xc8,8);
   if(f&0x40)ret;
endinstr;

instr(0xc9,8);
   ret;
endinstr;

instr(0xca,12);
   if(f&0x40)jp;
   else pc+=2;
endinstr;

instr(0xcb,4);
#include "cbops.h"
endinstr;

instr(0xcc,12);
   if(f&0x40)call;
   else pc+=2;
endinstr;

instr(0xcd,12);
   call;
endinstr;

instr(0xce,8);
   adca(read_byte(pc));
   pc++;
endinstr;

instr(0xcf,12);
   push2(pc);
   pc=8;
endinstr;

instr(0xd0,8);
   if(!cy)ret;
endinstr;

instr(0xd1,12);
   pop1(d,e);
endinstr;

instr(0xd2,12);
   if(!cy)jp;
   else pc+=2;
endinstr;

instr(0xd3,12);
{  
  BYTE port = read_byte(pc);
  PORT_ACCESS(port);
  out_byte((a<<8)+port,a);
  pc++;
}
endinstr;

instr(0xd4,12);
   if(!cy)call;
   else pc+=2;
endinstr;

instr(0xd5,12);
   push1(d,e);
endinstr;

instr(0xd6,8);
   suba(read_byte(pc));
   pc++;
endinstr;

instr(0xd7,12);
   push2(pc);
   pc=16;
endinstr;

instr(0xd8,8);
   if(cy)ret;
endinstr;

instr(0xd9,4);
   swap(b,b1);
   swap(c,c1);
   swap(d,d1);
   swap(e,e1);
   swap(h,h1);
   swap(l,l1);
endinstr;

instr(0xda,12);
   if(cy)jp;
   else pc+=2;
endinstr;

instr(0xdb,12);
  {
   if(zxmode==EM_Sam && LineCycleCounter%8) tstates+=4;
   BYTE port = read_byte(pc);
   PORT_ACCESS(port);
   a = in_byte((a<<8)+port);
   pc++;
  }
endinstr;

instr(0xdc,12);
   if(cy)call;
   else pc+=2;
endinstr;

instr(0xdd,4);
   new_ixoriy=1;
   DelayedEI=1;
endinstr;

instr(0xde,8);
   sbca(read_byte(pc));
   pc++;
endinstr;

instr(0xdf,12);
   push2(pc);
   pc=24;
endinstr;

instr(0xe0,8);
   if(!(f&4))ret;
endinstr;

instr(0xe1,12);
   if(!ixoriy)pop1(h,l);
   else if(ixoriy==1)pop2(ix);
   else pop2(iy);
endinstr;

instr(0xe2,12);
   if(!(f&4))jp;
   else pc+=2;
endinstr;

instr(0xe3,20);
   if(!ixoriy){
      WORD t=read_word(sp);
      write_word(sp,hl);
      l=t;
      h=t>>8;
   }
   else if(ixoriy==1){
      WORD t=read_word(sp);
      write_word(sp,ix);
      ix=t;
   }
   else{
      WORD t=read_word(sp);
      write_word(sp,iy);
      iy=t;
   }
endinstr;

instr(0xe4,12);
   if(!(f&4))call;
   else pc+=2;
endinstr;

instr(0xe5,12);
   if(!ixoriy)push1(h,l);
   else if(ixoriy==1)push2(ix);
   else push2(iy);
endinstr;

instr(0xe6,8);
   anda(read_byte(pc));
   pc++;
endinstr;

instr(0xe7,12);
   push2(pc);
   pc=32;
endinstr;

instr(0xe8,8);
   if(f&4)ret;
endinstr;

instr(0xe9,4);
   pc=!ixoriy?hl:ixoriy==1?ix:iy;
endinstr;

instr(0xea,12);
   if(f&4)jp;
   else pc+=2;
endinstr;

instr(0xeb,4);
   swap(h,d);
   swap(e,l);
endinstr;

instr(0xec,12);
   if(f&4)call;
   else pc+=2;
endinstr;

instr(0xed,4);
#include "edops.h"
endinstr;

instr(0xee,8);
   xora(read_byte(pc));
   pc++;
endinstr;

instr(0xef,12);
   push2(pc);
   pc=40;
endinstr;

instr(0xf0,8);
   if(!(f&0x80))ret;
endinstr;

instr(0xf1,12);
   pop1(a,f);
endinstr;

instr(0xf2,12);
   if(!(f&0x80))jp;
   else pc+=2;
endinstr;

instr(0xf3,4);
   iff1=iff2=0;
   DelayedEI=1;
endinstr;

instr(0xf4,12);
   if(!(f&0x80))call;
   else pc+=2;
endinstr;

instr(0xf5,12);
   push1(a,f);
endinstr;

instr(0xf6,8);
   ora(read_byte(pc));
   pc++;
endinstr;

instr(0xf7,12);
   push2(pc);
   pc=48;
endinstr;

instr(0xf8,8);
   if(f&0x80)ret;
endinstr;

instr(0xf9,8);
   sp=!ixoriy?hl:ixoriy==1?ix:iy;
endinstr;

instr(0xfa,12);
   if(f&0x80)jp;
   else pc+=2;
endinstr;

instr(0xfb,4);
	//according to Z80 specs, interrupts are not enabled until AFTER the instruction following the EI
	iff1=iff2=1;
	DelayedEI=1;
endinstr;

instr(0xfc,12);
   if(f&0x80)call;
   else pc+=2;
endinstr;

instr(0xfd,4);
   new_ixoriy=2;
   DelayedEI=1;
endinstr;

instr(0xfe,8);
   cpa(read_byte(pc));
   pc++;
endinstr;

instr(0xff,12);
   push2(pc);
   pc=56;
endinstr;

