/*
 * Decompiled with CFR 0.152.
 */
public class PgbCachedVideo
extends PgbBasicVideo {
    byte[][][][] tiles = new byte[2][384][8][8];
    byte[][][] map = new byte[4][256][256];
    byte[][][] sprites = new byte[40][16][8];
    int lastTile;

    void checkTile(int n) {
        int n2 = (n - 32768) / 16;
        if ((n & 0xF) == 15) {
            this.doTile(n2, this.gbcVram & 1);
        } else if (n2 != this.lastTile) {
            this.doTile(this.lastTile, this.gbcVram & 1);
        }
        this.lastTile = n2;
    }

    void scanUpdateTile(int n) {
        byte by = (byte)n;
        int n2 = 6144;
        do {
            if (this.vram[n2] != by) continue;
            if (n > 127) {
                this.updateMap(0, n2 - 6144 & 0x1F, n2 - 6144 >> 5, n);
            }
            if (n >= 256) continue;
            this.updateMap(1, n2 - 6144 & 0x1F, n2 - 6144 >> 5, n);
        } while (++n2 < 7168);
        n2 = 7168;
        do {
            if (this.vram[n2] != by) continue;
            if (n > 127) {
                this.updateMap(2, n2 - 7168 & 0x1F, n2 - 7168 >> 5, n);
            }
            if (n >= 256) continue;
            this.updateMap(3, n2 - 7168 & 0x1F, n2 - 7168 >> 5, n);
        } while (++n2 < 8192);
    }

    public void updateObj(int n) {
        byte by;
        int n2;
        int n3 = this.oam[(n << 2) + 2] & (this.obj_mode ? 254 : 255);
        byte by2 = this.oam[(n << 2) + 3];
        if (PgbSettings.system == 11) {
            n2 = by2 >> 3 & 1;
            by = (byte)(by2 << 3 & 0x38 | 4);
        } else {
            n2 = 0;
            by = (byte)(by2 >> 1 & 8 | 4);
        }
        boolean bl = (by2 & 0x40) == 64;
        boolean bl2 = (by2 & 0x20) == 32;
        int n4 = n3 * 16 + 8192 * n2;
        int n5 = 0;
        while (n5 < this.obj_siz) {
            int n6 = bl ? this.obj_siz - n5 - 1 : n5;
            this.copyTileLineArray(n4 + n6 * 2, bl2, by, this.sprites[n][n5], 0);
            ++n5;
        }
    }

    public void write(int n, byte by) {
        super.write(n, by);
        if (n >= 32768 && n < 38912) {
            this.checkTile(n);
        }
        if (n >= 38912 && n < 39936) {
            this.updateMap(0, n - 38912 & 0x1F, n - 38912 >> 5, this.vram[n - 32768] + 256);
            this.updateMap(1, n - 38912 & 0x1F, n - 38912 >> 5, this.vram[n - 32768] & 0xFF);
            return;
        }
        if (n >= 39936 && n < 40960) {
            this.updateMap(2, n - 39936 & 0x1F, n - 39936 >> 5, this.vram[n - 32768] + 256);
            this.updateMap(3, n - 39936 & 0x1F, n - 39936 >> 5, this.vram[n - 32768] & 0xFF);
            return;
        }
        if (n >= 65024 && n < 65184) {
            if ((n & 2) == 2) {
                this.updateObj(n - 65024 >> 2);
            }
            return;
        }
    }

    void doBgLine(int n) {
        int n2 = n + this.scy & 0xFF;
        byte[] byArray = this.map[(this.chr_mode ? 1 : 0) + (this.bg_mode ? 2 : 0)][n2];
        if (this.scx < 97) {
            System.arraycopy(byArray, this.scx, this.screenMemory, n * 160, 160);
            return;
        }
        int n3 = 256 - this.scx;
        System.arraycopy(byArray, this.scx, this.screenMemory, n * 160, n3);
        System.arraycopy(byArray, 0, this.screenMemory, n * 160 + n3, 160 - n3);
    }

    void updateMap(int n, int n2, int n3, int n4) {
        if (PgbSettings.system == 11) {
            byte by = this.getAttr(n2, n3, (n & 2) == 2);
            byte by2 = (byte)((by & 7) << 3);
            int n5 = (by & 8) == 8 ? 1 : 0;
            int n6 = 0;
            do {
                int n7;
                int n8 = n3 * 8 + n6;
                int n9 = n2 * 8;
                int n10 = n7 = (by & 0x40) == 64 ? 7 - n6 : n6;
                if ((by & 0x20) == 32) {
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][7]);
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][6]);
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][5]);
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][4]);
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][3]);
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][2]);
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][1]);
                    this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][0]);
                    continue;
                }
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][0]);
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][1]);
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][2]);
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][3]);
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][4]);
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][5]);
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][6]);
                this.map[n][n8][n9++] = (byte)(by2 | this.tiles[n5][n4][n7][7]);
            } while (++n6 < 8);
            return;
        }
        int n11 = n2 * 8;
        int n12 = n3 * 8;
        System.arraycopy(this.tiles[0][n4][0], 0, this.map[n][n12++], n11, 8);
        System.arraycopy(this.tiles[0][n4][1], 0, this.map[n][n12++], n11, 8);
        System.arraycopy(this.tiles[0][n4][2], 0, this.map[n][n12++], n11, 8);
        System.arraycopy(this.tiles[0][n4][3], 0, this.map[n][n12++], n11, 8);
        System.arraycopy(this.tiles[0][n4][4], 0, this.map[n][n12++], n11, 8);
        System.arraycopy(this.tiles[0][n4][5], 0, this.map[n][n12++], n11, 8);
        System.arraycopy(this.tiles[0][n4][6], 0, this.map[n][n12++], n11, 8);
        System.arraycopy(this.tiles[0][n4][7], 0, this.map[n][n12++], n11, 8);
    }

    void doWinLine(int n) {
        int n2;
        int n3;
        int n4;
        if (this.wy > n || this.wx > 166) {
            return;
        }
        byte[] byArray = this.map[(this.chr_mode ? 1 : 0) + (this.win_mode ? 2 : 0)][n - this.wy];
        if (this.wx < 7) {
            n4 = 7 - this.wx;
            n3 = 0;
            n2 = 160 - n4;
        } else {
            n4 = 0;
            n3 = this.wx - 7;
            n2 = 160 - n3;
        }
        System.arraycopy(byArray, n4, this.screenMemory, n * 160 + n3, n2);
    }

    void doObjLine(int n) {
        int n2 = 39;
        do {
            int n3 = n2 * 4;
            int n4 = this.oam[n3 + 1] & 0xFF;
            int n5 = this.oam[n3] & 0xFF;
            if (n4 <= 0 || n5 <= 0 || n5 > n + 16 || n5 <= n + (16 - this.obj_siz)) continue;
            boolean bl = (this.oam[n3 + 3] & 0x80) == 128;
            byte[] byArray = this.sprites[n2][n - n5 + 16];
            int n6 = 0;
            do {
                int n7 = n4 - 8 + n6;
                byte by = byArray[n6];
                if ((by & 3) <= 0 || n7 >= 160 || n7 < 0 || (bl || (this.getBackgroundAttr(n7, n) & 0x80) == 128) && (this.screenMemory[n * 160 + n7] & 3) != 0) continue;
                this.screenMemory[n * 160 + n7] = by;
            } while (++n6 < 8);
        } while (--n2 >= 0);
    }

    void doTile(int n, int n2) {
        int n3 = n * 16 + 8192 * n2;
        this.copyTileLineArray(n3, this.tiles[n2][n][0], 0);
        this.copyTileLineArray(n3 + 2, this.tiles[n2][n][1], 0);
        this.copyTileLineArray(n3 + 4, this.tiles[n2][n][2], 0);
        this.copyTileLineArray(n3 + 6, this.tiles[n2][n][3], 0);
        this.copyTileLineArray(n3 + 8, this.tiles[n2][n][4], 0);
        this.copyTileLineArray(n3 + 10, this.tiles[n2][n][5], 0);
        this.copyTileLineArray(n3 + 12, this.tiles[n2][n][6], 0);
        this.copyTileLineArray(n3 + 14, this.tiles[n2][n][7], 0);
        this.scanUpdateTile(n);
    }
}

