/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class PgbCart
implements FilenameFilter {
    private static final int C_NONE = 0;
    private static final int C_MBC1 = 1;
    private static final int C_MBC2 = 6;
    private static final int C_MMM01 = 11;
    private static final int C_MBC3 = 15;
    private static final int C_MBC5 = 25;
    private static final int CLOCK_REL = 0;
    private static final int CLOCK_LATCH = 1;
    private static final int CLOCK_SEC = 8;
    private static final int CLOCK_MIN = 9;
    private static final int CLOCK_HRS = 10;
    private static final int CLOCK_DAYL = 11;
    private static final int CLOCK_DAYH = 12;
    public byte[] romdata;
    public byte[] ramdata;
    public int romoffset;
    public int ramoffset;
    public boolean mbc1mode;
    public boolean mbc1ramenabled;
    public boolean mbc3clockenabled;
    public long mbc3time;
    public int mbc3reg;

    public void loadGB(File file, String string) {
        FileInputStream fileInputStream;
        File file2 = new File(file, string);
        this.romdata = new byte[(int)file2.length()];
        System.out.println("\nLoading cart '" + file2.getName() + "', size:" + file2.length() + "...");
        try {
            fileInputStream = new FileInputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found!");
            System.out.println(fileNotFoundException.getMessage());
            this.romdata = new byte[32768];
            return;
        }
        this.loadCart(fileInputStream, (int)file2.length());
    }

    public void reset() {
        this.setRomBank(1);
        this.setRamBank(0);
        this.mbc1mode = true;
        this.mbc1ramenabled = false;
        this.mbc3clockenabled = false;
    }

    public void setRomBank(int n) {
        this.romoffset = (n - 1) * 16384;
    }

    public final byte read(int n) {
        if (n < 16384) {
            return this.romdata[n];
        }
        if (n < 32768) {
            return this.romdata[n + this.romoffset];
        }
        if (n < 49152) {
            if (!this.mbc3clockenabled) {
                return this.ramdata[n + this.ramoffset];
            }
            Calendar calendar = Calendar.getInstance();
            switch (this.mbc3reg) {
                case 8: {
                    return (byte)calendar.get(13);
                }
                case 9: {
                    return (byte)calendar.get(12);
                }
                case 10: {
                    return (byte)calendar.get(10);
                }
                case 11: {
                    return (byte)calendar.get(6);
                }
                case 12: {
                    return (byte)(calendar.get(6) >> 8);
                }
            }
            return 0;
        }
        System.out.println("Read from unmapped cart memory:" + Integer.toHexString(n));
        return 0;
    }

    public boolean loaded() {
        return this.romdata != null && this.romdata.length > 0;
    }

    public void loadCart(InputStream inputStream, int n) {
        try {
            int n2;
            this.romdata = new byte[n];
            int n3 = 0;
            while (n > 0 && (n2 = inputStream.read(this.romdata, n3, n)) != -1) {
                n3 += n2;
                n -= n2;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("File read error:");
            System.out.println(exception.getMessage());
        }
        System.out.println("rom byte: " + Integer.toHexString(this.romdata[328]) + ", banks: " + this.getRomBanks());
        System.out.println("ram byte: " + Integer.toHexString(this.romdata[329]) + ", banks: " + this.getRamBanks());
        System.out.println("type byte: " + Integer.toHexString(this.romdata[327]) + " (" + this.getTypeString() + ")" + ", SGB features: " + Integer.toHexString(this.romdata[326] & 0xFF) + " (" + this.getSgb() + "), GBC features: " + Integer.toHexString(this.romdata[323] & 0xFF) + " (" + this.getGbc() + ")");
    }

    public int getRamBanks() {
        switch (this.romdata[329]) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
        }
        return 0;
    }

    public boolean accept(File file, String string) {
        return string.toLowerCase().endsWith(".gb") || string.toLowerCase().endsWith(".gbc") || string.toLowerCase().endsWith(".cgb");
    }

    public final void write(int n, int n2) {
        if (n < 8192 && n >= 0) {
            this.mbc1ramenabled = (n2 & 0xF) == 10;
            return;
        }
        if (n < 12288 && n >= 8192) {
            if (this.getType() != 25 && n2 == 0) {
                this.setRomBank(1);
                return;
            }
            this.setRomBank(n2 & 0xFF);
            return;
        }
        if (n < 16384 && n >= 12288) {
            if (this.getType() != 25) {
                this.setRomBank(n2);
            }
            return;
        }
        if (n < 24576 && n >= 16384) {
            if (n2 < 4) {
                this.setRamBank(n2 & 0xFF);
                this.mbc3clockenabled = false;
                return;
            }
            this.mbc3reg = n2;
            this.mbc3clockenabled = true;
            return;
        }
        if (n < 32768 && n >= 24576 && this.getType() == 1) {
            this.mbc1mode = (n2 & 1) == 0;
            return;
        }
        if (n < 32768 && n >= 24576) {
            this.mbc3time = System.currentTimeMillis();
            return;
        }
        if (n < 49152 && n >= 40960) {
            if (this.mbc1ramenabled) {
                this.ramdata[n + this.ramoffset] = (byte)n2;
                return;
            }
            return;
        }
        System.out.println("Write to unmapped cart memory:" + Integer.toHexString(n) + ", " + Integer.toHexString(n2));
    }

    public void load(String string, String string2) {
        this.load(new File(string), string2);
    }

    public void load(File file, String string) {
        if (string.length() < 1) {
            return;
        }
        if (this.accept(file, string)) {
            this.loadGB(file, string);
            this.loadBattery(PgbSettings.savepath, string.substring(0, string.lastIndexOf(46)) + ".sav");
            System.out.println("");
            return;
        }
        if (string.endsWith(".zip")) {
            this.loadZip(file, string);
            this.loadBattery(PgbSettings.savepath, string.substring(0, string.lastIndexOf(46)) + ".sav");
            System.out.println("");
            return;
        }
        System.out.println("File format not recognized.");
        System.out.println("");
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 1: {
                return "MBC1";
            }
            case 6: {
                return "MBC2";
            }
            case 11: {
                return "MMM01";
            }
            case 15: {
                return "MBC3";
            }
            case 25: {
                return "MBC5";
            }
        }
        return "NONE";
    }

    public int getRomBanks() {
        switch (this.romdata[328]) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 256;
            }
        }
        return 2;
    }

    public String getName() {
        return new String(this.romdata, 134, 11);
    }

    public int getType() {
        int n = this.romdata[327] & 0xFF;
        if (n >= 1 && n <= 3) {
            return 1;
        }
        if (n == 6) {
            return 6;
        }
        if (n >= 11 && n <= 13) {
            return 11;
        }
        if (n >= 15 && n <= 19) {
            return 15;
        }
        if (n >= 25 && n <= 30) {
            return 25;
        }
        return 0;
    }

    public boolean getSgb() {
        if (this.loaded()) {
            return this.romdata[326] == 3;
        }
        return false;
    }

    public void loadZip(File file, String string) {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream;
        File file2 = new File(file, string);
        System.out.println("\nLoading zip file '" + file2.getName() + "'...");
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file2));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!this.accept(file, zipEntry.getName())) continue;
                System.out.println("Loading entry '" + zipEntry.getName() + "', size : " + zipEntry.getSize() + "...");
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("File not found!");
            System.out.println(exception.getMessage());
            this.romdata = new byte[32768];
            return;
        }
        this.loadCart(zipInputStream, (int)zipEntry.getSize());
    }

    public void loadBattery(File file, String string) {
        if (this.getRamBanks() > 0) {
            this.ramdata = new byte[8192 * this.getRamBanks()];
            File file2 = new File(file, string);
            String string2 = "Looking for battery save... ";
            try {
                if (file2.exists()) {
                    string2 = string2 + "loading... ";
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    this.loadBattery(fileInputStream);
                    string2 = string2 + "done.";
                } else {
                    string2 = string2 + "not found.";
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            System.out.println(string2);
            return;
        }
        this.ramdata = new byte[8192];
    }

    public void loadBattery(InputStream inputStream) {
        try {
            inputStream.read(this.ramdata);
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            System.out.println("File read error:");
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void setRamBank(int n) {
        this.ramoffset = -40960 + n * 8192;
    }

    public void saveBattery(File file, String string) {
        if (!this.loaded() || this.getRamBanks() == 0) {
            return;
        }
        File file2 = new File(file, string.substring(0, string.lastIndexOf(46)) + ".sav");
        try {
            file.mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            ((OutputStream)fileOutputStream).write(this.ramdata);
            ((OutputStream)fileOutputStream).close();
            System.out.println("Saving ram to file... done.");
            return;
        }
        catch (Exception exception) {
            System.out.println("Saving ram to file... error!");
            System.out.println(exception.getMessage());
            return;
        }
    }

    public boolean getGbc() {
        if (this.loaded()) {
            return (this.romdata[323] & 0xFF) == 128 || (this.romdata[323] & 0xFF) == 192;
        }
        return false;
    }
}

