/*
 * Decompiled with CFR 0.152.
 */
import com.ms.directX.DDPixelFormat;
import com.ms.directX.DDSurfaceDesc;
import com.ms.directX.DirectDraw;
import com.ms.directX.DirectDrawClipper;
import com.ms.directX.DirectDrawSurface;
import com.ms.directX.Rect;
import java.awt.Component;

public final class PgbDirectDrawVideoOutput
extends PgbVideoOutput {
    DirectDraw dd;
    DirectDrawSurface ddsPrimary;
    DirectDrawSurface ddsOffscreen;
    DirectDrawClipper ddClipper;
    Rect dest;
    byte[] onPixels = new byte[23040 * this.rgbByteCount];
    byte[] offPixels = new byte[23040 * this.rgbByteCount];
    int rgbByteCount = 1;

    public void reset() {
    }

    void doLine(byte[] byArray, int n) {
        int n2 = n * 160;
        if (this.rgbByteCount == 4) {
            int n3 = 0;
            do {
                this.doPixelA8R8G8B8(byArray, (n2 + n3) * this.rgbByteCount, this.video.getScreenMemory(n2 + n3));
            } while (++n3 < 160);
            return;
        }
        if (this.rgbByteCount == 2) {
            int n4 = 0;
            do {
                this.doPixelR5G6B5(byArray, (n2 + n4) * this.rgbByteCount, this.video.getScreenMemory(n2 + n4));
            } while (++n4 < 160);
            return;
        }
    }

    public PgbDirectDrawVideoOutput(PgbVideo pgbVideo) {
        super(pgbVideo);
    }

    public void acquire() {
        try {
            this.dd = new DirectDraw();
            this.dd.setCooperativeLevel((Component)this, 8);
            DDSurfaceDesc dDSurfaceDesc = new DDSurfaceDesc();
            dDSurfaceDesc.flags = 1;
            dDSurfaceDesc.ddsCaps = 512;
            this.ddsPrimary = this.dd.createSurface(dDSurfaceDesc);
            this.ddClipper = this.dd.createClipper(0);
            this.ddClipper.setComponent((Component)this);
            this.ddsPrimary.setClipper(this.ddClipper);
            dDSurfaceDesc = new DDSurfaceDesc();
            dDSurfaceDesc.flags = 7;
            dDSurfaceDesc.ddsCaps = 64;
            dDSurfaceDesc.width = 160;
            dDSurfaceDesc.height = 144;
            this.ddsOffscreen = this.dd.createSurface(dDSurfaceDesc);
            this.dest = new Rect();
            this.dest.left = 0;
            this.dest.top = 0;
            this.dest.right = 160;
            this.dest.bottom = 144;
            DDPixelFormat dDPixelFormat = new DDPixelFormat();
            this.ddsOffscreen.getPixelFormat(dDPixelFormat);
            this.rgbByteCount = dDPixelFormat.rgbBitCount / 8;
            this.onPixels = new byte[23040 * this.rgbByteCount];
            this.offPixels = new byte[23040 * this.rgbByteCount];
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void doPixelR5G6B5(byte[] byArray, int n, byte by) {
        byArray[n + 1] = (byte)(this.video.getScreenRed(by) & 0xF8 | (this.video.getScreenGreen(by) & 0xE0) >> 5);
        byArray[n] = (byte)((this.video.getScreenGreen(by) & 0xE) << 4 | (this.video.getScreenBlue(by) & 0xF8) >> 3);
    }

    public void hblank(int n) {
        this.doLine(this.offPixels, n);
    }

    void doPixelA8R8G8B8(byte[] byArray, int n, byte by) {
        byArray[n + 3] = -1;
        byArray[n + 2] = this.video.getScreenRed(by);
        byArray[n + 1] = this.video.getScreenGreen(by);
        byArray[n] = this.video.getScreenBlue(by);
    }

    public void vblank() {
        try {
            DDSurfaceDesc dDSurfaceDesc = new DDSurfaceDesc();
            this.ddsOffscreen.lock(new Rect(), dDSurfaceDesc, 0, 0, this.onPixels);
            this.ddsOffscreen.unlock(this.dest, dDSurfaceDesc, this.offPixels);
            Rect rect = new Rect();
            rect.left = 0;
            rect.top = 0;
            rect.right = this.getSize().width;
            rect.bottom = this.getSize().height;
            this.ddsPrimary.blt(rect, this.ddsOffscreen, this.dest, 0);
            return;
        }
        catch (Exception exception) {
            this.acquire();
            return;
        }
    }
}

