/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public final class PgbIndexedVideoOutput
extends PgbVideoOutput {
    MemoryImageSource mISrc;
    Image mImg;
    byte[] packedScreenPalette = new byte[192];
    MemoryImageSource borderMISrc;
    Image borderMImg;
    ColorModel borderColorModel;
    byte[] packedBorderPalette;

    public void reset() {
    }

    public PgbIndexedVideoOutput(PgbVideo pgbVideo) {
        super(pgbVideo);
        this.mISrc = new MemoryImageSource(160, 144, (ColorModel)new IndexColorModel(6, 64, this.packedScreenPalette, 0, false), pgbVideo.getScreenMemory(), 0, 160);
        this.mISrc.setAnimated(true);
        this.mImg = this.createImage(this.mISrc);
        this.packedBorderPalette = new byte[768];
        this.borderColorModel = new IndexColorModel(8, 256, this.packedBorderPalette, 0, false);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (PgbSettings.sgbborder) {
            graphics.drawImage(this.mImg, 48 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 160 * PgbSettings.lcdsize, 144 * PgbSettings.lcdsize, this);
            graphics.drawImage(this.borderMImg, 0, 0, 256 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 0, 0, 256, 40, this);
            graphics.drawImage(this.borderMImg, 0, 40 * PgbSettings.lcdsize, 48 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 0, 40, 48, 184, this);
            graphics.drawImage(this.borderMImg, 208 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 208, 40, 256, 184, this);
            graphics.drawImage(this.borderMImg, 0, 184 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 224 * PgbSettings.lcdsize, 0, 184, 256, 224, this);
            return;
        }
        graphics.drawImage(this.mImg, 0, 0, 160 * PgbSettings.lcdsize, 144 * PgbSettings.lcdsize, this);
    }

    public ColorModel getScreenColorModel() {
        if (PgbSettings.system == 11) {
            byte by = 0;
            while (by < 64) {
                this.packedScreenPalette[by * 3] = this.video.getScreenRed(by);
                this.packedScreenPalette[by * 3 + 1] = this.video.getScreenGreen(by);
                this.packedScreenPalette[by * 3 + 2] = this.video.getScreenBlue(by);
                by = (byte)(by + 1);
            }
            return new IndexColorModel(6, 64, this.packedScreenPalette, 0, false);
        }
        byte by = 0;
        while (by < 12) {
            this.packedScreenPalette[by * 3] = this.video.getScreenRed(by);
            this.packedScreenPalette[by * 3 + 1] = this.video.getScreenGreen(by);
            this.packedScreenPalette[by * 3 + 2] = this.video.getScreenBlue(by);
            by = (byte)(by + 1);
        }
        return new IndexColorModel(4, 12, this.packedScreenPalette, 0, false);
    }

    public void hblank(int n) {
    }

    public void vblank() {
        this.mISrc.newPixels(this.video.getScreenMemory(), this.getScreenColorModel(), 0, 160);
    }
}

