/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

class PgbNetDialog
extends Dialog
implements ActionListener {
    Frame frame;
    TextField status;
    Button listen;
    Button connect;
    Button cancel;
    public Socket socket;

    public PgbNetDialog(Frame frame) {
        super(frame, "Pgb Netplay", true);
        this.frame = frame;
        ((Component)this).setSize(250, 90);
        this.setResizable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.status = new TextField("", 30);
        this.status.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.status, gridBagConstraints);
        this.add(this.status);
        this.listen = new Button("Listen");
        this.listen.setActionCommand("listen");
        this.listen.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.listen, gridBagConstraints);
        this.add(this.listen);
        this.connect = new Button("Connect...");
        this.connect.setActionCommand("connect");
        this.connect.addActionListener(this);
        gridBagLayout.setConstraints(this.connect, gridBagConstraints);
        this.add(this.connect);
        this.cancel = new Button("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cancel, gridBagConstraints);
        this.add(this.cancel);
    }

    public void listen() {
        ((TextComponent)this.status).setText("Listening...");
        try {
            ServerSocket serverSocket = new ServerSocket(PgbSettings.netport);
            serverSocket.setSoTimeout(PgbSettings.netlistentimeout);
            this.socket = serverSocket.accept();
            ((TextComponent)this.status).setText("Listening... connected to " + this.socket.getInetAddress().getHostName());
            this.hide();
            return;
        }
        catch (Exception exception) {
            ((TextComponent)this.status).setText("Listening... timed out");
            this.socket = null;
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("listen")) {
            this.listen();
        }
        if (actionEvent.getActionCommand().equals("connect")) {
            this.connect();
        }
        if (actionEvent.getActionCommand().equals("cancel")) {
            this.hide();
        }
    }

    public void connect() {
        InetAddress inetAddress;
        PgbConnectDialog pgbConnectDialog = new PgbConnectDialog(this.frame);
        ((Component)pgbConnectDialog).setLocation(this.getLocation().x + 30, this.getLocation().y + 30);
        pgbConnectDialog.show();
        String string = pgbConnectDialog.address;
        if (string.length() < 1) {
            return;
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            ((TextComponent)this.status).setText("Could not resolve connection address.");
            return;
        }
        ((TextComponent)this.status).setText("Connecting to " + string + "...");
        try {
            this.socket = new Socket(inetAddress, PgbSettings.netport);
            ((TextComponent)this.status).setText("Connected to " + string + ".");
            this.hide();
        }
        catch (Exception exception) {
            ((TextComponent)this.status).setText("Connecting to " + string + "... timed out.");
            this.socket = null;
            return;
        }
        PgbSettings.lastnetaddress = string;
    }
}

