/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class PgbNetplay
implements ActionListener {
    boolean connected;
    Socket socket;
    PgbConnectionStatus pcs;
    byte serialData;
    byte serialControl;
    byte lastSerialData;
    boolean newSerialData;
    boolean waitingOnSerial;
    int serialCount;
    int serialRetryCount;
    boolean irTransmit;
    boolean irReceive;
    boolean irReadOn;

    public void setSerialData(byte by) {
        this.serialData = by;
    }

    public byte getSerialData() {
        return this.serialData;
    }

    public void setIR(byte by) {
        this.irTransmit = (by & 1) == 1;
        boolean bl = this.irReadOn = (by & 0xC0) == 192;
        if (this.connected) {
            try {
                this.socket.setTcpNoDelay(true);
                OutputStream outputStream = this.socket.getOutputStream();
                outputStream.write(2);
                outputStream.write(this.irTransmit ? 1 : 0);
                this.pcs.setStatus("wrote I/R: " + this.irTransmit);
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public byte getIR() {
        if (this.irReadOn) {
            this.doInput();
        }
        if (this.irReceive) {
            return -62;
        }
        return -64;
    }

    public void disconnect() {
        if (this.connected) {
            this.connected = false;
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
            this.pcs.hide();
            this.pcs.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("disconnect")) {
            this.disconnect();
        }
        if (actionEvent.getActionCommand().equals("close")) {
            this.pcs.hide();
            this.pcs.dispose();
        }
    }

    public void sendInfo() {
        if (this.connected) {
            try {
                this.socket.setTcpNoDelay(true);
                OutputStream outputStream = this.socket.getOutputStream();
                outputStream.write(16);
                outputStream.write(PgbSettings.gamestring.length());
                outputStream.write(PgbSettings.gamestring.getBytes());
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public int cyclesLeft() {
        if (!this.waitingOnSerial) {
            return Integer.MAX_VALUE;
        }
        return this.serialCount;
    }

    public void setSerialControl(byte by) {
        this.serialControl = by;
        if ((this.serialControl & 0x80) == 128) {
            if ((this.serialControl & 1) == 1 || this.connected) {
                this.waitingOnSerial = true;
                this.serialCount = 3904;
                this.serialRetryCount = 2;
            } else {
                this.waitingOnSerial = false;
            }
            if (this.connected) {
                try {
                    this.socket.setTcpNoDelay(true);
                    OutputStream outputStream = this.socket.getOutputStream();
                    outputStream.write(3);
                    outputStream.write(this.serialData & 0xFF);
                    this.pcs.setStatus("wrote serial: " + this.serialData);
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        } else {
            this.waitingOnSerial = false;
        }
    }

    public byte getSerialControl() {
        return this.serialControl;
    }

    public void PgbNetPlay() {
        this.socket = null;
        this.connected = false;
        this.serialCount = 0;
        this.serialControl = 0;
        this.irReadOn = false;
    }

    public void popNetDialog(Frame frame) {
        PgbNetDialog pgbNetDialog = new PgbNetDialog(frame);
        ((Component)pgbNetDialog).setLocation(frame.getLocation().x - 60, frame.getLocation().y + 80);
        pgbNetDialog.show();
        if (pgbNetDialog.socket == null) {
            this.connected = false;
            return;
        }
        this.socket = pgbNetDialog.socket;
        this.connected = true;
        this.pcs = new PgbConnectionStatus(frame, this, this.socket);
        ((Component)this.pcs).setLocation(frame.getLocation().x - 310, frame.getLocation().y);
        this.pcs.show();
    }

    public void doInput() {
        if (this.connected) {
            try {
                this.socket.setTcpNoDelay(true);
                this.socket.setSoTimeout(1);
                InputStream inputStream = this.socket.getInputStream();
                block9: while (true) {
                    int n = inputStream.read();
                    switch (n) {
                        default: {
                            continue block9;
                        }
                        case 16: {
                            int n2 = inputStream.read();
                            byte[] byArray = new byte[n2];
                            inputStream.read(byArray);
                            this.pcs.setGame(new String(byArray));
                            continue block9;
                        }
                        case 17: {
                            int n2 = inputStream.read();
                            byte[] byArray = new byte[n2];
                            inputStream.read(byArray);
                            this.pcs.setGame(new String(byArray));
                            continue block9;
                        }
                        case 18: {
                            int n2 = inputStream.read();
                            byte[] byArray = new byte[n2];
                            inputStream.read(byArray);
                            this.pcs.setGame(new String(byArray));
                            continue block9;
                        }
                        case 2: {
                            this.irReceive = inputStream.read() != 0;
                            this.pcs.setStatus("read I/R: " + this.irReceive);
                            continue block9;
                        }
                        case 3: 
                    }
                    this.lastSerialData = (byte)inputStream.read();
                    this.newSerialData = true;
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
        this.lastSerialData = (byte)-1;
        this.newSerialData = true;
    }

    public byte cycle(int n) {
        if (this.waitingOnSerial) {
            this.serialCount -= n;
            if (this.serialCount <= 0) {
                this.doInput();
                if (this.newSerialData) {
                    this.serialData = this.lastSerialData;
                    this.newSerialData = false;
                    this.serialControl = 0;
                    this.waitingOnSerial = false;
                    if (this.connected) {
                        this.pcs.setStatus("read serial: " + this.serialData);
                    }
                    return 8;
                }
                int n2 = this.serialRetryCount;
                this.serialRetryCount = n2 + -1;
                if (n2 > 0) {
                    this.serialCount = 19520;
                } else {
                    this.serialData = this.lastSerialData;
                    this.newSerialData = false;
                    this.serialControl = 0;
                    this.waitingOnSerial = false;
                    if (this.connected) {
                        this.pcs.setStatus("read serial: " + this.serialData);
                    }
                    return 8;
                }
            }
        }
        return 0;
    }
}

