/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;

public class PgbSettings {
    public static final boolean DEBUG = false;
    public static final String emulator = "Pgb";
    public static final String version = "0.8x";
    public static final int SYS_GB = 0;
    public static final int SYS_GBP = 1;
    public static final int SYS_SGB = 10;
    public static final int SYS_GBC = 11;
    public static final int VIDOUT_DEFAULT = 0;
    public static final int VIDOUT_DIRECTX = 1;
    public static final int VIDOUT_INDEXED = 2;
    public static final int VIDOUT_DIRECT = 3;
    public static volatile boolean paused = false;
    public static volatile boolean active = false;
    public static int priority = 5;
    public static boolean usedirectx = false;
    public static int debuglevel = 0;
    public static int debugstop = -1;
    public static int videooutput = 0;
    public static int desiredsystem = 11;
    public static int system;
    public static int lcdsize;
    public static boolean autowait;
    public static int frameskip;
    public static double clockspeed;
    public static int key_up;
    public static int key_down;
    public static int key_left;
    public static int key_right;
    public static int key_a;
    public static int key_b;
    public static int key_select;
    public static int key_start;
    public static int[] bgcolors;
    public static int[] obj0colors;
    public static int[] obj1colors;
    public static boolean sgbborder;
    public static boolean colormute;
    public static String gamestring;
    public static String lastnetaddress;
    public static int netlistentimeout;
    public static int netport;
    public static File savepath;
    public static Point winloc;

    public static void popSavePathDialog(Frame frame) {
        FileDialog fileDialog = new FileDialog(frame, "Please choose a save directory.", 1);
        fileDialog.show();
        savepath = new File(fileDialog.getDirectory());
    }

    public static void popKeysDialog(Frame frame) {
        PgbKeyDialog pgbKeyDialog = new PgbKeyDialog(frame);
        pgbKeyDialog.show();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load() {
        StreamTokenizer streamTokenizer;
        FileReader fileReader;
        try {
            File file = new File("Pgb.cfg");
            if (!file.exists()) {
                return;
            }
            fileReader = new FileReader(file);
            streamTokenizer = new StreamTokenizer(fileReader);
            streamTokenizer.lowerCaseMode(true);
            streamTokenizer.quoteChar(34);
            streamTokenizer.commentChar(35);
        }
        catch (Exception exception) {
            System.err.println("error reading settings file:");
            System.err.println(exception.getClass());
            System.err.println(exception.getMessage());
            return;
        }
        block6: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -3: {
                    String string = streamTokenizer.sval;
                    if (string.equals("winloc")) {
                        winloc = new Point();
                        streamTokenizer.nextToken();
                        PgbSettings.winloc.x = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        PgbSettings.winloc.y = (int)streamTokenizer.nval;
                    }
                    if (string.equals("lcdsize")) {
                        streamTokenizer.nextToken();
                        lcdsize = (int)streamTokenizer.nval;
                    }
                    if (string.equals("frameskip")) {
                        streamTokenizer.nextToken();
                        frameskip = (int)streamTokenizer.nval;
                    }
                    if (string.equals("colormute")) {
                        streamTokenizer.nextToken();
                        colormute = streamTokenizer.sval.equalsIgnoreCase("true");
                    }
                    if (string.equals("sgbborder")) {
                        streamTokenizer.nextToken();
                        sgbborder = streamTokenizer.sval.equalsIgnoreCase("true");
                    }
                    if (string.equals("debuglevel")) {
                        streamTokenizer.nextToken();
                        debuglevel = (int)streamTokenizer.nval;
                    }
                    if (string.equals("keys")) {
                        streamTokenizer.nextToken();
                        key_up = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        key_down = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        key_left = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        key_right = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        key_a = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        key_b = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        key_select = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        key_start = (int)streamTokenizer.nval;
                    }
                    if (string.equals("savepath")) {
                        streamTokenizer.nextToken();
                        savepath = new File(streamTokenizer.sval);
                    }
                    if (string.equals("lastnetaddress")) {
                        streamTokenizer.nextToken();
                        lastnetaddress = streamTokenizer.sval;
                    }
                    if (string.equals("netlistentimeout")) {
                        streamTokenizer.nextToken();
                        netlistentimeout = (int)streamTokenizer.nval;
                    }
                    if (string.equals("netport")) {
                        streamTokenizer.nextToken();
                        netport = (int)streamTokenizer.nval;
                    }
                    if (string.equals("lastnetaddress")) {
                        streamTokenizer.nextToken();
                        lastnetaddress = streamTokenizer.sval;
                    }
                    if (string.equals("systemtype")) {
                        streamTokenizer.nextToken();
                        desiredsystem = (int)streamTokenizer.nval;
                    }
                    if (string.equals("cpupriority")) {
                        streamTokenizer.nextToken();
                        priority = (int)streamTokenizer.nval;
                    }
                    if (string.equals("videooutput")) {
                        streamTokenizer.nextToken();
                        videooutput = (int)streamTokenizer.nval;
                    }
                    if (string.equals("autowait")) {
                        streamTokenizer.nextToken();
                        autowait = streamTokenizer.sval.equalsIgnoreCase("true");
                    }
                }
                default: {
                    continue block6;
                }
                case -1: 
                case 10: 
            }
            break;
        }
        ((Reader)fileReader).close();
    }

    static {
        lcdsize = 1;
        autowait = true;
        frameskip = 0;
        clockspeed = 4.194304;
        key_up = 38;
        key_down = 40;
        key_left = 37;
        key_right = 39;
        key_a = 88;
        key_b = 90;
        key_select = 65;
        key_start = 83;
        bgcolors = new int[]{-1, -2447954, -6143919, -16777216};
        obj0colors = new int[]{-1, -6957660, -11037143, -16777216};
        obj1colors = new int[]{-1, -7159577, -13664560, -16777216};
        sgbborder = false;
        colormute = false;
        gamestring = "NONE            ";
        lastnetaddress = "";
        netlistentimeout = 10000;
        netport = 2907;
        savepath = new File("sav");
        winloc = new Point();
    }

    public static void save(Frame frame) {
        winloc = frame.getLocation();
        try {
            File file = new File("Pgb.cfg");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("# Pgb config file\r\n");
            fileWriter.write("# Edit at your own risk\r\n");
            fileWriter.write("\r\n");
            fileWriter.write("debuglevel " + debuglevel + "\r\n");
            fileWriter.write("frameskip " + frameskip + "\r\n");
            fileWriter.write("keys " + key_up + " " + key_down + " " + key_left + " " + key_right + " " + key_a + " " + key_b + " " + key_select + " " + key_start + "\r\n");
            fileWriter.write("winloc " + PgbSettings.winloc.x + " " + PgbSettings.winloc.y + "\r\n");
            fileWriter.write("lcdsize " + lcdsize + "\r\n");
            fileWriter.write("colormute " + colormute + "\r\n");
            fileWriter.write("sgbborder " + sgbborder + "\r\n");
            fileWriter.write("savepath " + '\"' + savepath.getPath() + '\"' + "\r\n");
            fileWriter.write("lastnetaddress " + '\"' + lastnetaddress + '\"' + "\r\n");
            fileWriter.write("netlistentimeout " + netlistentimeout + "\r\n");
            fileWriter.write("netport " + netport + "\r\n");
            fileWriter.write("systemtype " + desiredsystem + "\r\n");
            fileWriter.write("cpupriority " + priority + "\r\n");
            fileWriter.write("videooutput " + videooutput + "\r\n");
            fileWriter.write("autowait " + autowait + "\r\n");
            ((Writer)fileWriter).close();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return;
        }
    }
}

