/*
 * Decompiled with CFR 0.152.
 */
public class PgbBasicVideo
extends PgbVideo {
    byte[] screenMemory = new byte[23040];
    byte[] borderPixels = new byte[57344];
    byte[] screenRPal = new byte[64];
    byte[] screenGPal = new byte[64];
    byte[] screenBPal = new byte[64];
    int[] screenPalette = new int[64];
    int[] borderPalette = new int[128];

    void setBorderPalette(int n, int n2) {
        this.borderPalette[n] = n2;
    }

    void doSgbBorder() {
        int n = 0;
        do {
            int n2 = 0;
            do {
                byte by;
                boolean bl = ((by = this.sgbPicture[n2 * 2 + n * 64 + 1]) & 0x80) == 128;
                boolean bl2 = (by & 0x40) == 64;
                byte by2 = (byte)((by & 0x1C) << 2);
                System.arraycopy(this.getSgbBorderArray(n2, n, 0, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + n * 8 * 256, 8);
                System.arraycopy(this.getSgbBorderArray(n2, n, 1, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + (n * 8 + 1) * 256, 8);
                System.arraycopy(this.getSgbBorderArray(n2, n, 2, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + (n * 8 + 2) * 256, 8);
                System.arraycopy(this.getSgbBorderArray(n2, n, 3, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + (n * 8 + 3) * 256, 8);
                System.arraycopy(this.getSgbBorderArray(n2, n, 4, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + (n * 8 + 4) * 256, 8);
                System.arraycopy(this.getSgbBorderArray(n2, n, 5, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + (n * 8 + 5) * 256, 8);
                System.arraycopy(this.getSgbBorderArray(n2, n, 6, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + (n * 8 + 6) * 256, 8);
                System.arraycopy(this.getSgbBorderArray(n2, n, 7, bl, bl2, by2), 0, this.borderPixels, n2 * 8 + (n * 8 + 7) * 256, 8);
            } while (++n2 < 32);
        } while (++n < 28);
    }

    public void sgbSetPaletteIndirect(int n, int n2, int n3, int n4, int n5) {
        super.sgbSetPaletteIndirect(n, n2, n3, n4, n5);
        this.setBgPal(this.bgpal);
        this.setObjPal0(this.objpal0);
        this.setObjPal1(this.objpal1);
    }

    public byte getScreenBlue(byte by) {
        return this.screenBPal[by & 0x3F];
    }

    public byte getScreenGreen(byte by) {
        return this.screenGPal[by & 0x3F];
    }

    void doBgLine(int n) {
        int n2 = this.scx & 7;
        int n3 = 8 - (this.scx & 7);
        int n4 = n * 160;
        int n5 = this.scx / 8 + 1;
        int n6 = n + this.scy >> 3 & 0x1F;
        int n7 = n + this.scy & 7;
        System.arraycopy(this.getTileLineArray(n5 - 1, n6, n7, this.bg_mode), n2, this.screenMemory, n4, n3);
        int n8 = 0;
        do {
            this.copyTileLineArray(n5 + n8 & 0x1F, n6, n7, this.bg_mode, this.screenMemory, n4 + n8 * 8 + n3);
        } while (++n8 < 19);
        System.arraycopy(this.getTileLineArray(n5 + 19 & 0x1F, n6, n7, this.bg_mode), 0, this.screenMemory, n4 + 152 + n3, n2);
    }

    void setScreenPalette(boolean bl, int n, int n2, int n3, byte by, byte by2) {
        int n4 = (n2 & 3) << 4 | (bl ? 4 : 0) | (n & 7) << 3 | n3 & 3;
        this.setScreenPalette(n4, this.getColor32(by, by2));
    }

    void setScreenPalette(int n, int n2) {
        int n3;
        this.screenPalette[n] = n3 = this.colorAdjust(n2);
        this.screenRPal[n] = (byte)(n3 >> 16);
        this.screenGPal[n] = (byte)(n3 >> 8);
        this.screenBPal[n] = (byte)n3;
    }

    void tileLineOr(byte[] byArray, int n, byte by) {
        int n2 = n++;
        byArray[n2] = (byte)(byArray[n2] | by);
        int n3 = n++;
        byArray[n3] = (byte)(byArray[n3] | by);
        int n4 = n++;
        byArray[n4] = (byte)(byArray[n4] | by);
        int n5 = n++;
        byArray[n5] = (byte)(byArray[n5] | by);
        int n6 = n++;
        byArray[n6] = (byte)(byArray[n6] | by);
        int n7 = n++;
        byArray[n7] = (byte)(byArray[n7] | by);
        int n8 = n++;
        byArray[n8] = (byte)(byArray[n8] | by);
        int n9 = n++;
        byArray[n9] = (byte)(byArray[n9] | by);
    }

    public void setObjPal0(int n) {
        super.setObjPal0(n);
        this.objpal0 = n;
        if (PgbSettings.system == 10) {
            int n2 = 0;
            do {
                int n3 = 0;
                do {
                    this.setScreenPalette(true, 0, n2, n3, this.sgbPalette[n2 * 8 + (n >> n3 * 2 & 3) * 2 + 1], this.sgbPalette[n2 * 8 + (n >> n3 * 2 & 3) * 2]);
                } while (++n3 < 4);
            } while (++n2 < 4);
            return;
        }
        if (PgbSettings.system == 0 || PgbSettings.system == 1) {
            int n4 = 0;
            do {
                this.setScreenPalette(4 | n4, PgbSettings.obj0colors[n >> n4 * 2 & 3]);
            } while (++n4 < 4);
        }
    }

    public void gbcSetBgpd(byte by) {
        int n = this.bgpi >> 3 & 7;
        int n2 = this.bgpi >> 1 & 3;
        super.gbcSetBgpd(by);
        this.setScreenPalette(false, n, 0, n2, this.gbcPalette[n * 8 + n2 * 2 + 1], this.gbcPalette[n * 8 + n2 * 2]);
    }

    byte getBackgroundAttr(int n, int n2) {
        return this.getAttr(n + this.scx >> 3 & 0x1F, n2 + this.scy >> 3 & 0x1F, this.bg_mode);
    }

    int colorAdjust(int n) {
        if (PgbSettings.colormute) {
            int n2 = n >> 16 & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n & 0xFF;
            n2 = (int)((double)(n2 - 128) * 0.75 + 144.0);
            n3 = (int)((double)(n3 - 128) * 0.75 + 144.0);
            n4 = (int)((double)(n4 - 128) * 0.75 + 144.0);
            return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
        }
        return n;
    }

    int getColor32(byte by, byte by2) {
        int n = by << 8 | by2 & 0xFF;
        int n2 = 0xFF000000 | (n & 0x1F) << 19 | (n & 0x3E0) << 6 | (n & 0x7C00) >> 7;
        return n2;
    }

    public void setBgPal(int n) {
        super.setBgPal(n);
        if (PgbSettings.system == 10) {
            int n2 = 0;
            do {
                int n3 = 0;
                do {
                    this.setScreenPalette(false, 0, n2, n3, this.sgbPalette[n2 * 8 + (n >> n3 * 2 & 3) * 2 + 1], this.sgbPalette[n2 * 8 + (n >> n3 * 2 & 3) * 2]);
                } while (++n3 < 4);
            } while (++n2 < 4);
            return;
        }
        if (PgbSettings.system == 0 || PgbSettings.system == 1) {
            int n4 = 0;
            do {
                this.setScreenPalette(n4, PgbSettings.bgcolors[n >> n4 * 2 & 3]);
            } while (++n4 < 4);
        }
    }

    public byte[] getScreenMemory() {
        return this.screenMemory;
    }

    public byte getScreenMemory(int n) {
        return this.screenMemory[n];
    }

    public void hblank() {
        super.hblank();
        if (this.lcd_on && this.curframe == 0) {
            if (this.bg_on) {
                this.doBgLine(this.ly);
            }
            if (this.win_on) {
                this.doWinLine(this.ly);
            }
            if (this.obj_on) {
                this.doObjLine(this.ly);
            }
            if (PgbSettings.system == 10) {
                this.doSgbPalette(this.ly);
            }
        }
    }

    int getTile(int n, int n2, boolean bl) {
        if (this.chr_mode) {
            return this.vram[(bl ? 7168 : 6144) + n2 * 32 + n] & 0xFF;
        }
        return this.vram[(bl ? 7168 : 6144) + n2 * 32 + n] + 256;
    }

    public byte getScreenRed(byte by) {
        return this.screenRPal[by & 0x3F];
    }

    public void sgbPictureTransfer() {
        super.sgbPictureTransfer();
        int n = 0;
        do {
            this.setBorderPalette(n + 64, this.getColor32(this.sgbPicture[2048 + n * 2 + 1], this.sgbPicture[2048 + n * 2]));
        } while (++n < 64);
        this.doSgbBorder();
    }

    public void gbcSetObpd(byte by) {
        int n = this.obpi >> 3 & 7;
        int n2 = this.obpi >> 1 & 3;
        super.gbcSetObpd(by);
        this.setScreenPalette(true, n, 0, n2, this.gbcPalette[64 + n * 8 + n2 * 2 + 1], this.gbcPalette[64 + n * 8 + n2 * 2]);
    }

    byte getAttr(int n, int n2, boolean bl) {
        return this.vram[(bl ? 15360 : 14336) + n2 * 32 + n];
    }

    byte[] getSgbBorderArray(int n, int n2, int n3, boolean bl, boolean bl2, byte by) {
        byte[] byArray = new byte[8];
        if (bl) {
            n3 = 7 - n3;
        }
        int n4 = (this.sgbPicture[n * 2 + n2 * 64] & 0xFF) * 32 + n3 * 2;
        byte by2 = this.sgbCharset[n4];
        byte by3 = this.sgbCharset[n4 + 1];
        byte by4 = this.sgbCharset[n4 + 16];
        byte by5 = this.sgbCharset[n4 + 17];
        if (bl2) {
            byArray[7] = (byte)(by | by4 >> 5 & 4 | by5 >> 4 & 8 | by2 >> 7 & 1 | by3 >> 6 & 2);
            byArray[6] = (byte)(by | by4 >> 4 & 4 | by5 >> 3 & 8 | by2 >> 6 & 1 | by3 >> 5 & 2);
            byArray[5] = (byte)(by | by4 >> 3 & 4 | by5 >> 2 & 8 | by2 >> 5 & 1 | by3 >> 4 & 2);
            byArray[4] = (byte)(by | by4 >> 2 & 4 | by5 >> 1 & 8 | by2 >> 4 & 1 | by3 >> 3 & 2);
            byArray[3] = (byte)(by | by4 >> 1 & 4 | by5 & 8 | by2 >> 3 & 1 | by3 >> 2 & 2);
            byArray[2] = (byte)(by | by4 & 4 | by5 << 1 & 8 | by2 >> 2 & 1 | by3 >> 1 & 2);
            byArray[1] = (byte)(by | by4 << 1 & 4 | by5 << 2 & 8 | by2 >> 1 & 1 | by3 & 2);
            byArray[0] = (byte)(by | by4 << 2 & 4 | by5 << 3 & 8 | by2 & 1 | by3 << 1 & 2);
        } else {
            byArray[0] = (byte)(by | by4 >> 5 & 4 | by5 >> 4 & 8 | by2 >> 7 & 1 | by3 >> 6 & 2);
            byArray[1] = (byte)(by | by4 >> 4 & 4 | by5 >> 3 & 8 | by2 >> 6 & 1 | by3 >> 5 & 2);
            byArray[2] = (byte)(by | by4 >> 3 & 4 | by5 >> 2 & 8 | by2 >> 5 & 1 | by3 >> 4 & 2);
            byArray[3] = (byte)(by | by4 >> 2 & 4 | by5 >> 1 & 8 | by2 >> 4 & 1 | by3 >> 3 & 2);
            byArray[4] = (byte)(by | by4 >> 1 & 4 | by5 & 8 | by2 >> 3 & 1 | by3 >> 2 & 2);
            byArray[5] = (byte)(by | by4 & 4 | by5 << 1 & 8 | by2 >> 2 & 1 | by3 >> 1 & 2);
            byArray[6] = (byte)(by | by4 << 1 & 4 | by5 << 2 & 8 | by2 >> 1 & 1 | by3 & 2);
            byArray[7] = (byte)(by | by4 << 2 & 4 | by5 << 3 & 8 | by2 & 1 | by3 << 1 & 2);
        }
        return byArray;
    }

    byte[] getTileLineArray(int n, int n2, int n3, boolean bl) {
        int n4 = this.getTile(n, n2, bl);
        if (PgbSettings.system == 11) {
            byte by;
            return this.getTileLineArray((by & 8) >> 3, n4, ((by = this.getAttr(n, n2, bl)) & 0x40) == 64 ? 7 - n3 : n3, (by & 0x20) == 32, (byte)((by & 7) << 3));
        }
        return this.getTileLineArray(0, n4, n3);
    }

    byte[] getTileLineArray(int n, int n2, int n3) {
        byte[] byArray = new byte[8];
        this.copyTileLineArray(n * 8192 + n2 * 16 + n3 * 2, byArray, 0);
        return byArray;
    }

    byte[] getTileLineArray(int n, int n2, int n3, boolean bl, byte by) {
        byte[] byArray = new byte[8];
        this.copyTileLineArray(n * 8192 + n2 * 16 + n3 * 2, bl, by, byArray, 0);
        return byArray;
    }

    void copyTileLineArray(int n, int n2, int n3, boolean bl, byte[] byArray, int n4) {
        int n5 = this.getTile(n, n2, bl);
        if (PgbSettings.system == 11) {
            byte by;
            this.copyTileLineArray(((by & 8) >> 3) * 8192 + n5 * 16 + (((by = this.getAttr(n, n2, bl)) & 0x40) == 64 ? 7 - n3 : n3) * 2, (by & 0x20) == 32, (byte)((by & 7) << 3), byArray, n4);
            return;
        }
        this.copyTileLineArray(n5 * 16 + n3 * 2, byArray, n4);
    }

    void doWinLine(int n) {
        if (this.wx < 0 || this.wx > 166 || this.wy > n) {
            return;
        }
        int n2 = n * 160;
        int n3 = n - this.wy >> 3 & 0x1F;
        int n4 = n - this.wy & 7;
        System.arraycopy(this.getTileLineArray(0, n3, n4, this.win_mode), 0, this.screenMemory, n2, 8);
        int n5 = 0;
        do {
            System.arraycopy(this.getTileLineArray(n5 + 1, n3, n4, this.win_mode), 0, this.screenMemory, n2 + n5 * 8 + 8, 8);
        } while (++n5 < 19);
    }

    void doObjLine(int n) {
        int n2 = 39;
        do {
            int n3 = n2 * 4;
            int n4 = this.oam[n3 + 1] & 0xFF;
            int n5 = this.oam[n3] & 0xFF;
            if (n4 == 0 || n5 == 0 || n5 > n + 16 || n5 <= n + (16 - this.obj_siz)) continue;
            boolean bl = (this.oam[n3 + 3] & 0x20) == 32;
            boolean bl2 = (this.oam[n3 + 3] & 0x40) == 64;
            boolean bl3 = ((this.oam[n3 + 3] | this.getBackgroundAttr(n4 - 8, n)) & 0x80) == 128;
            byte by = PgbSettings.system == 11 ? (byte)(4 | (this.oam[n3 + 3] & 7) << 3) : (byte)(4 | (this.oam[n3 + 3] & 0x10) >> 1);
            byte[] byArray = this.getTileLineArray((this.oam[n3 + 3] & 8) >> 3, this.oam[n3 + 2] & (this.obj_mode ? 254 : 255), bl2 ? this.obj_siz - (n - n5 + 17) : n - n5 + 16, bl, by);
            int n6 = 0;
            do {
                int n7 = n4 - 8 + n6;
                byte by2 = byArray[n6];
                if ((by2 & 3) == 0 || n7 >= 160 || n7 < 0 || bl3 && (this.screenMemory[n * 160 + n7] & 3) != 0) continue;
                this.screenMemory[n * 160 + n7] = by2;
            } while (++n6 < 8);
        } while (--n2 >= 0);
    }

    void copyTileLineArray(int n, byte[] byArray, int n2) {
        byte by = this.vram[n];
        byte by2 = this.vram[n + 1];
        byArray[n2++] = (byte)(by >> 7 & 1 | by2 >> 6 & 2);
        byArray[n2++] = (byte)(by >> 6 & 1 | by2 >> 5 & 2);
        byArray[n2++] = (byte)(by >> 5 & 1 | by2 >> 4 & 2);
        byArray[n2++] = (byte)(by >> 4 & 1 | by2 >> 3 & 2);
        byArray[n2++] = (byte)(by >> 3 & 1 | by2 >> 2 & 2);
        byArray[n2++] = (byte)(by >> 2 & 1 | by2 >> 1 & 2);
        byArray[n2++] = (byte)(by >> 1 & 1 | by2 & 2);
        byArray[n2++] = (byte)(by & 1 | by2 << 1 & 2);
    }

    public void setObjPal1(int n) {
        super.setObjPal1(n);
        if (PgbSettings.system == 10) {
            int n2 = 0;
            do {
                int n3 = 0;
                do {
                    this.setScreenPalette(true, 1, n2, n3, this.sgbPalette[n2 * 8 + (n >> n3 * 2 & 3) * 2 + 1], this.sgbPalette[n2 * 8 + (n >> n3 * 2 & 3) * 2]);
                } while (++n3 < 4);
            } while (++n2 < 4);
            return;
        }
        if (PgbSettings.system == 0 || PgbSettings.system == 1) {
            int n4 = 0;
            do {
                this.setScreenPalette(0xD | n4, PgbSettings.obj1colors[n >> n4 * 2 & 3]);
            } while (++n4 < 4);
        }
    }

    void copyTileLineArray(int n, boolean bl, byte by, byte[] byArray, int n2) {
        byte by2 = this.vram[n];
        byte by3 = this.vram[n + 1];
        if (bl) {
            n2 += 7;
            byArray[n2--] = (byte)(by | by2 >> 7 & 1 | by3 >> 6 & 2);
            byArray[n2--] = (byte)(by | by2 >> 6 & 1 | by3 >> 5 & 2);
            byArray[n2--] = (byte)(by | by2 >> 5 & 1 | by3 >> 4 & 2);
            byArray[n2--] = (byte)(by | by2 >> 4 & 1 | by3 >> 3 & 2);
            byArray[n2--] = (byte)(by | by2 >> 3 & 1 | by3 >> 2 & 2);
            byArray[n2--] = (byte)(by | by2 >> 2 & 1 | by3 >> 1 & 2);
            byArray[n2--] = (byte)(by | by2 >> 1 & 1 | by3 & 2);
            byArray[n2--] = (byte)(by | by2 & 1 | by3 << 1 & 2);
            return;
        }
        byArray[n2++] = (byte)(by | by2 >> 7 & 1 | by3 >> 6 & 2);
        byArray[n2++] = (byte)(by | by2 >> 6 & 1 | by3 >> 5 & 2);
        byArray[n2++] = (byte)(by | by2 >> 5 & 1 | by3 >> 4 & 2);
        byArray[n2++] = (byte)(by | by2 >> 4 & 1 | by3 >> 3 & 2);
        byArray[n2++] = (byte)(by | by2 >> 3 & 1 | by3 >> 2 & 2);
        byArray[n2++] = (byte)(by | by2 >> 2 & 1 | by3 >> 1 & 2);
        byArray[n2++] = (byte)(by | by2 >> 1 & 1 | by3 & 2);
        byArray[n2++] = (byte)(by | by2 & 1 | by3 << 1 & 2);
    }

    public void doSgbPalette(int n) {
        int n2 = 0;
        do {
            byte by = this.sgbPaletteOverlay[n / 8 * 5 + n2];
            int n3 = n * 160 + n2 * 32;
            this.tileLineOr(this.screenMemory, n3, (byte)((by & 0xC0) >> 2));
            this.tileLineOr(this.screenMemory, n3 + 8, (byte)(by & 0x30));
            this.tileLineOr(this.screenMemory, n3 + 16, (byte)((by & 0xC) << 2));
            this.tileLineOr(this.screenMemory, n3 + 24, (byte)((by & 3) << 4));
        } while (++n2 < 5);
    }

    public void sgbSetPalette(int n, int n2, byte by, byte by2) {
        super.sgbSetPalette(n, n2, by, by2);
        this.setBgPal(this.bgpal);
        this.setObjPal0(this.objpal0);
        this.setObjPal1(this.objpal1);
    }

    public int getScreenColor(byte by) {
        return this.screenPalette[by & 0x3F];
    }
}

