/*
 * Decompiled with CFR 0.152.
 */
public final class PgbCpu {
    private final int HALTON = -1;
    static final int Z_FLAG = 128;
    static final int N_FLAG = 64;
    static final int H_FLAG = 32;
    static final int C_FLAG = 16;
    PgbMemory mem;
    PgbRegisterB AF;
    PgbRegister BC;
    PgbRegister DE;
    PgbRegister HL;
    PgbRegisterW SP;
    private PgbRegisterW PC;
    boolean ime;
    private Opcode[] opcodes;
    Opcode[] cbcodes;

    final void slaI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 *= 2) != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    final int readByte() {
        return this.unsign(this.mem.read(this.PC.data++));
    }

    final void sbc(int n) {
        int n2 = this.AF.getH() - n - (this.getC() ? 1 : 0);
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(true);
        this.AF.setH(n2);
    }

    final void incH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() + 1;
        this.setZ(n &= 0xFF);
        this.setN(false);
        pgbRegister.setH(n);
    }

    final void rlcL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n = n << 1 | n >> 7) != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final void rlcI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 = n2 << 1 | n2 >> 7) != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    final void setH(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getH() | (int)Math.pow(2.0, n);
        pgbRegister.setH(n2);
    }

    private final void setH(boolean bl) {
        this.AF.lo &= 0xFFFFFFDF;
        if (bl) {
            this.AF.lo |= 0x20;
        }
    }

    private final boolean getH() {
        return (this.AF.getL() & 0x20) == 32;
    }

    final void decH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() - 1;
        this.setZ(n &= 0xFF);
        this.setN(true);
        pgbRegister.setH(n);
    }

    final void xor(int n) {
        int n2 = this.AF.getH() ^ n;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    final void slaH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() << 1;
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    final void rst(int n) {
        this.push(this.PC);
        this.PC.setR(n);
    }

    private final int unsign(byte by) {
        return by & 0xFF;
    }

    final void rlcH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n = n << 1 | n >> 7) != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    final void sraL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n & 1) == 1);
        n = n >> 1 | n & 0x80;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final void sraI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 & 1) == 1);
        n2 = n2 >> 1 | n2 & 0x80;
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    final void swapL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() << 4 & 0xF0 | pgbRegister.getL() >> 4;
        this.setC(false);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final void swapI(int n) {
        int n2 = this.unsign(this.mem.read(n)) << 4 & 0xF0 | this.unsign(this.mem.read(n)) >> 4;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    final void sub(int n) {
        int n2 = this.AF.getH() - n;
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(true);
        this.AF.setH(n2);
    }

    final void rrcL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n & 1) == 1);
        n = n >> 1 | (n & 1) << 7;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final void or(int n) {
        int n2 = this.AF.getH() | n;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    final void rrcI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 & 1) == 1);
        n2 = n2 >> 1 | (n2 & 1) << 7;
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    final void call(int n) {
        this.push(this.PC);
        this.PC.setR(n);
    }

    final void sraH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n & 1) == 1);
        n = n >> 1 | n & 0x80;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private void initOpcodes() {
        this.opcodes = new Opcode[256];
        this.opcodes[0] = new Op0x00();
        this.opcodes[1] = new Op0x01();
        this.opcodes[2] = new Op0x02();
        this.opcodes[3] = new Op0x03();
        this.opcodes[4] = new Op0x04();
        this.opcodes[5] = new Op0x05();
        this.opcodes[6] = new Op0x06();
        this.opcodes[7] = new Op0x07();
        this.opcodes[8] = new Op0x08();
        this.opcodes[9] = new Op0x09();
        this.opcodes[10] = new Op0x0A();
        this.opcodes[11] = new Op0x0B();
        this.opcodes[12] = new Op0x0C();
        this.opcodes[13] = new Op0x0D();
        this.opcodes[14] = new Op0x0E();
        this.opcodes[15] = new Op0x0F();
        this.opcodes[16] = new Op0x10();
        this.opcodes[17] = new Op0x11();
        this.opcodes[18] = new Op0x12();
        this.opcodes[19] = new Op0x13();
        this.opcodes[20] = new Op0x14();
        this.opcodes[21] = new Op0x15();
        this.opcodes[22] = new Op0x16();
        this.opcodes[23] = new Op0x17();
        this.opcodes[24] = new Op0x18();
        this.opcodes[25] = new Op0x19();
        this.opcodes[26] = new Op0x1A();
        this.opcodes[27] = new Op0x1B();
        this.opcodes[28] = new Op0x1C();
        this.opcodes[29] = new Op0x1D();
        this.opcodes[30] = new Op0x1E();
        this.opcodes[31] = new Op0x1F();
        this.opcodes[32] = new Op0x20();
        this.opcodes[33] = new Op0x21();
        this.opcodes[34] = new Op0x22();
        this.opcodes[35] = new Op0x23();
        this.opcodes[36] = new Op0x24();
        this.opcodes[37] = new Op0x25();
        this.opcodes[38] = new Op0x26();
        this.opcodes[39] = new Op0x27();
        this.opcodes[40] = new Op0x28();
        this.opcodes[41] = new Op0x29();
        this.opcodes[42] = new Op0x2A();
        this.opcodes[43] = new Op0x2B();
        this.opcodes[44] = new Op0x2C();
        this.opcodes[45] = new Op0x2D();
        this.opcodes[46] = new Op0x2E();
        this.opcodes[47] = new Op0x2F();
        this.opcodes[48] = new Op0x30();
        this.opcodes[49] = new Op0x31();
        this.opcodes[50] = new Op0x32();
        this.opcodes[51] = new Op0x33();
        this.opcodes[52] = new Op0x34();
        this.opcodes[53] = new Op0x35();
        this.opcodes[54] = new Op0x36();
        this.opcodes[55] = new Op0x37();
        this.opcodes[56] = new Op0x38();
        this.opcodes[57] = new Op0x39();
        this.opcodes[58] = new Op0x3A();
        this.opcodes[59] = new Op0x3B();
        this.opcodes[60] = new Op0x3C();
        this.opcodes[61] = new Op0x3D();
        this.opcodes[62] = new Op0x3E();
        this.opcodes[63] = new Op0x3F();
        this.opcodes[64] = new Op0x40();
        this.opcodes[65] = new Op0x41();
        this.opcodes[66] = new Op0x42();
        this.opcodes[67] = new Op0x43();
        this.opcodes[68] = new Op0x44();
        this.opcodes[69] = new Op0x45();
        this.opcodes[70] = new Op0x46();
        this.opcodes[71] = new Op0x47();
        this.opcodes[72] = new Op0x48();
        this.opcodes[73] = new Op0x49();
        this.opcodes[74] = new Op0x4A();
        this.opcodes[75] = new Op0x4B();
        this.opcodes[76] = new Op0x4C();
        this.opcodes[77] = new Op0x4D();
        this.opcodes[78] = new Op0x4E();
        this.opcodes[79] = new Op0x4F();
        this.opcodes[80] = new Op0x50();
        this.opcodes[81] = new Op0x51();
        this.opcodes[82] = new Op0x52();
        this.opcodes[83] = new Op0x53();
        this.opcodes[84] = new Op0x54();
        this.opcodes[85] = new Op0x55();
        this.opcodes[86] = new Op0x56();
        this.opcodes[87] = new Op0x57();
        this.opcodes[88] = new Op0x58();
        this.opcodes[89] = new Op0x59();
        this.opcodes[90] = new Op0x5A();
        this.opcodes[91] = new Op0x5B();
        this.opcodes[92] = new Op0x5C();
        this.opcodes[93] = new Op0x5D();
        this.opcodes[94] = new Op0x5E();
        this.opcodes[95] = new Op0x5F();
        this.opcodes[96] = new Op0x60();
        this.opcodes[97] = new Op0x61();
        this.opcodes[98] = new Op0x62();
        this.opcodes[99] = new Op0x63();
        this.opcodes[100] = new Op0x64();
        this.opcodes[101] = new Op0x65();
        this.opcodes[102] = new Op0x66();
        this.opcodes[103] = new Op0x67();
        this.opcodes[104] = new Op0x68();
        this.opcodes[105] = new Op0x69();
        this.opcodes[106] = new Op0x6A();
        this.opcodes[107] = new Op0x6B();
        this.opcodes[108] = new Op0x6C();
        this.opcodes[109] = new Op0x6D();
        this.opcodes[110] = new Op0x6E();
        this.opcodes[111] = new Op0x6F();
        this.opcodes[112] = new Op0x70();
        this.opcodes[113] = new Op0x71();
        this.opcodes[114] = new Op0x72();
        this.opcodes[115] = new Op0x73();
        this.opcodes[116] = new Op0x74();
        this.opcodes[117] = new Op0x75();
        this.opcodes[118] = new Op0x76();
        this.opcodes[119] = new Op0x77();
        this.opcodes[120] = new Op0x78();
        this.opcodes[121] = new Op0x79();
        this.opcodes[122] = new Op0x7A();
        this.opcodes[123] = new Op0x7B();
        this.opcodes[124] = new Op0x7C();
        this.opcodes[125] = new Op0x7D();
        this.opcodes[126] = new Op0x7E();
        this.opcodes[127] = new Op0x7F();
        this.opcodes[128] = new Op0x80();
        this.opcodes[129] = new Op0x81();
        this.opcodes[130] = new Op0x82();
        this.opcodes[131] = new Op0x83();
        this.opcodes[132] = new Op0x84();
        this.opcodes[133] = new Op0x85();
        this.opcodes[134] = new Op0x86();
        this.opcodes[135] = new Op0x87();
        this.opcodes[136] = new Op0x88();
        this.opcodes[137] = new Op0x89();
        this.opcodes[138] = new Op0x8A();
        this.opcodes[139] = new Op0x8B();
        this.opcodes[140] = new Op0x8C();
        this.opcodes[141] = new Op0x8D();
        this.opcodes[142] = new Op0x8E();
        this.opcodes[143] = new Op0x8F();
        this.opcodes[144] = new Op0x90();
        this.opcodes[145] = new Op0x91();
        this.opcodes[146] = new Op0x92();
        this.opcodes[147] = new Op0x93();
        this.opcodes[148] = new Op0x94();
        this.opcodes[149] = new Op0x95();
        this.opcodes[150] = new Op0x96();
        this.opcodes[151] = new Op0x97();
        this.opcodes[152] = new Op0x98();
        this.opcodes[153] = new Op0x99();
        this.opcodes[154] = new Op0x9A();
        this.opcodes[155] = new Op0x9B();
        this.opcodes[156] = new Op0x9C();
        this.opcodes[157] = new Op0x9D();
        this.opcodes[158] = new Op0x9E();
        this.opcodes[159] = new Op0x9F();
        this.opcodes[160] = new Op0xA0();
        this.opcodes[161] = new Op0xA1();
        this.opcodes[162] = new Op0xA2();
        this.opcodes[163] = new Op0xA3();
        this.opcodes[164] = new Op0xA4();
        this.opcodes[165] = new Op0xA5();
        this.opcodes[166] = new Op0xA6();
        this.opcodes[167] = new Op0xA7();
        this.opcodes[168] = new Op0xA8();
        this.opcodes[169] = new Op0xA9();
        this.opcodes[170] = new Op0xAA();
        this.opcodes[171] = new Op0xAB();
        this.opcodes[172] = new Op0xAC();
        this.opcodes[173] = new Op0xAD();
        this.opcodes[174] = new Op0xAE();
        this.opcodes[175] = new Op0xAF();
        this.opcodes[176] = new Op0xB0();
        this.opcodes[177] = new Op0xB1();
        this.opcodes[178] = new Op0xB2();
        this.opcodes[179] = new Op0xB3();
        this.opcodes[180] = new Op0xB4();
        this.opcodes[181] = new Op0xB5();
        this.opcodes[182] = new Op0xB6();
        this.opcodes[183] = new Op0xB7();
        this.opcodes[184] = new Op0xB8();
        this.opcodes[185] = new Op0xB9();
        this.opcodes[186] = new Op0xBA();
        this.opcodes[187] = new Op0xBB();
        this.opcodes[188] = new Op0xBC();
        this.opcodes[189] = new Op0xBD();
        this.opcodes[190] = new Op0xBE();
        this.opcodes[191] = new Op0xBF();
        this.opcodes[192] = new Op0xC0();
        this.opcodes[193] = new Op0xC1();
        this.opcodes[194] = new Op0xC2();
        this.opcodes[195] = new Op0xC3();
        this.opcodes[196] = new Op0xC4();
        this.opcodes[197] = new Op0xC5();
        this.opcodes[198] = new Op0xC6();
        this.opcodes[199] = new Op0xC7();
        this.opcodes[200] = new Op0xC8();
        this.opcodes[201] = new Op0xC9();
        this.opcodes[202] = new Op0xCA();
        this.opcodes[203] = new Op0xCB();
        this.opcodes[204] = new Op0xCC();
        this.opcodes[205] = new Op0xCD();
        this.opcodes[206] = new Op0xCE();
        this.opcodes[207] = new Op0xCF();
        this.opcodes[208] = new Op0xD0();
        this.opcodes[209] = new Op0xD1();
        this.opcodes[210] = new Op0xD2();
        this.opcodes[211] = new Op0xD3();
        this.opcodes[212] = new Op0xD4();
        this.opcodes[213] = new Op0xD5();
        this.opcodes[214] = new Op0xD6();
        this.opcodes[215] = new Op0xD7();
        this.opcodes[216] = new Op0xD8();
        this.opcodes[217] = new Op0xD9();
        this.opcodes[218] = new Op0xDA();
        this.opcodes[219] = new Op0xDB();
        this.opcodes[220] = new Op0xDC();
        this.opcodes[221] = new Op0xDD();
        this.opcodes[222] = new Op0xDE();
        this.opcodes[223] = new Op0xDF();
        this.opcodes[224] = new Op0xE0();
        this.opcodes[225] = new Op0xE1();
        this.opcodes[226] = new Op0xE2();
        this.opcodes[227] = new Op0xE3();
        this.opcodes[228] = new Op0xE4();
        this.opcodes[229] = new Op0xE5();
        this.opcodes[230] = new Op0xE6();
        this.opcodes[231] = new Op0xE7();
        this.opcodes[232] = new Op0xE8();
        this.opcodes[233] = new Op0xE9();
        this.opcodes[234] = new Op0xEA();
        this.opcodes[235] = new Op0xEB();
        this.opcodes[236] = new Op0xEC();
        this.opcodes[237] = new Op0xED();
        this.opcodes[238] = new Op0xEE();
        this.opcodes[239] = new Op0xEF();
        this.opcodes[240] = new Op0xF0();
        this.opcodes[241] = new Op0xF1();
        this.opcodes[242] = new Op0xF2();
        this.opcodes[243] = new Op0xF3();
        this.opcodes[244] = new Op0xF4();
        this.opcodes[245] = new Op0xF5();
        this.opcodes[246] = new Op0xF6();
        this.opcodes[247] = new Op0xF7();
        this.opcodes[248] = new Op0xF8();
        this.opcodes[249] = new Op0xF9();
        this.opcodes[250] = new Op0xFA();
        this.opcodes[251] = new Op0xFB();
        this.opcodes[252] = new Op0xFC();
        this.opcodes[253] = new Op0xFD();
        this.opcodes[254] = new Op0xFE();
        this.opcodes[255] = new Op0xFF();
        this.cbcodes = new Opcode[256];
        this.cbcodes[0] = new OpCB0x00();
        this.cbcodes[1] = new OpCB0x01();
        this.cbcodes[2] = new OpCB0x02();
        this.cbcodes[3] = new OpCB0x03();
        this.cbcodes[4] = new OpCB0x04();
        this.cbcodes[5] = new OpCB0x05();
        this.cbcodes[6] = new OpCB0x06();
        this.cbcodes[7] = new OpCB0x07();
        this.cbcodes[8] = new OpCB0x08();
        this.cbcodes[9] = new OpCB0x09();
        this.cbcodes[10] = new OpCB0x0A();
        this.cbcodes[11] = new OpCB0x0B();
        this.cbcodes[12] = new OpCB0x0C();
        this.cbcodes[13] = new OpCB0x0D();
        this.cbcodes[14] = new OpCB0x0E();
        this.cbcodes[15] = new OpCB0x0F();
        this.cbcodes[16] = new OpCB0x10();
        this.cbcodes[17] = new OpCB0x11();
        this.cbcodes[18] = new OpCB0x12();
        this.cbcodes[19] = new OpCB0x13();
        this.cbcodes[20] = new OpCB0x14();
        this.cbcodes[21] = new OpCB0x15();
        this.cbcodes[22] = new OpCB0x16();
        this.cbcodes[23] = new OpCB0x17();
        this.cbcodes[24] = new OpCB0x18();
        this.cbcodes[25] = new OpCB0x19();
        this.cbcodes[26] = new OpCB0x1A();
        this.cbcodes[27] = new OpCB0x1B();
        this.cbcodes[28] = new OpCB0x1C();
        this.cbcodes[29] = new OpCB0x1D();
        this.cbcodes[30] = new OpCB0x1E();
        this.cbcodes[31] = new OpCB0x1F();
        this.cbcodes[32] = new OpCB0x20();
        this.cbcodes[33] = new OpCB0x21();
        this.cbcodes[34] = new OpCB0x22();
        this.cbcodes[35] = new OpCB0x23();
        this.cbcodes[36] = new OpCB0x24();
        this.cbcodes[37] = new OpCB0x25();
        this.cbcodes[38] = new OpCB0x26();
        this.cbcodes[39] = new OpCB0x27();
        this.cbcodes[40] = new OpCB0x28();
        this.cbcodes[41] = new OpCB0x29();
        this.cbcodes[42] = new OpCB0x2A();
        this.cbcodes[43] = new OpCB0x2B();
        this.cbcodes[44] = new OpCB0x2C();
        this.cbcodes[45] = new OpCB0x2D();
        this.cbcodes[46] = new OpCB0x2E();
        this.cbcodes[47] = new OpCB0x2F();
        this.cbcodes[48] = new OpCB0x30();
        this.cbcodes[49] = new OpCB0x31();
        this.cbcodes[50] = new OpCB0x32();
        this.cbcodes[51] = new OpCB0x33();
        this.cbcodes[52] = new OpCB0x34();
        this.cbcodes[53] = new OpCB0x35();
        this.cbcodes[54] = new OpCB0x36();
        this.cbcodes[55] = new OpCB0x37();
        this.cbcodes[56] = new OpCB0x38();
        this.cbcodes[57] = new OpCB0x39();
        this.cbcodes[58] = new OpCB0x3A();
        this.cbcodes[59] = new OpCB0x3B();
        this.cbcodes[60] = new OpCB0x3C();
        this.cbcodes[61] = new OpCB0x3D();
        this.cbcodes[62] = new OpCB0x3E();
        this.cbcodes[63] = new OpCB0x3F();
        this.cbcodes[64] = new OpCB0x40();
        this.cbcodes[65] = new OpCB0x41();
        this.cbcodes[66] = new OpCB0x42();
        this.cbcodes[67] = new OpCB0x43();
        this.cbcodes[68] = new OpCB0x44();
        this.cbcodes[69] = new OpCB0x45();
        this.cbcodes[70] = new OpCB0x46();
        this.cbcodes[71] = new OpCB0x47();
        this.cbcodes[72] = new OpCB0x48();
        this.cbcodes[73] = new OpCB0x49();
        this.cbcodes[74] = new OpCB0x4A();
        this.cbcodes[75] = new OpCB0x4B();
        this.cbcodes[76] = new OpCB0x4C();
        this.cbcodes[77] = new OpCB0x4D();
        this.cbcodes[78] = new OpCB0x4E();
        this.cbcodes[79] = new OpCB0x4F();
        this.cbcodes[80] = new OpCB0x50();
        this.cbcodes[81] = new OpCB0x51();
        this.cbcodes[82] = new OpCB0x52();
        this.cbcodes[83] = new OpCB0x53();
        this.cbcodes[84] = new OpCB0x54();
        this.cbcodes[85] = new OpCB0x55();
        this.cbcodes[86] = new OpCB0x56();
        this.cbcodes[87] = new OpCB0x57();
        this.cbcodes[88] = new OpCB0x58();
        this.cbcodes[89] = new OpCB0x59();
        this.cbcodes[90] = new OpCB0x5A();
        this.cbcodes[91] = new OpCB0x5B();
        this.cbcodes[92] = new OpCB0x5C();
        this.cbcodes[93] = new OpCB0x5D();
        this.cbcodes[94] = new OpCB0x5E();
        this.cbcodes[95] = new OpCB0x5F();
        this.cbcodes[96] = new OpCB0x60();
        this.cbcodes[97] = new OpCB0x61();
        this.cbcodes[98] = new OpCB0x62();
        this.cbcodes[99] = new OpCB0x63();
        this.cbcodes[100] = new OpCB0x64();
        this.cbcodes[101] = new OpCB0x65();
        this.cbcodes[102] = new OpCB0x66();
        this.cbcodes[103] = new OpCB0x67();
        this.cbcodes[104] = new OpCB0x68();
        this.cbcodes[105] = new OpCB0x69();
        this.cbcodes[106] = new OpCB0x6A();
        this.cbcodes[107] = new OpCB0x6B();
        this.cbcodes[108] = new OpCB0x6C();
        this.cbcodes[109] = new OpCB0x6D();
        this.cbcodes[110] = new OpCB0x6E();
        this.cbcodes[111] = new OpCB0x6F();
        this.cbcodes[112] = new OpCB0x70();
        this.cbcodes[113] = new OpCB0x71();
        this.cbcodes[114] = new OpCB0x72();
        this.cbcodes[115] = new OpCB0x73();
        this.cbcodes[116] = new OpCB0x74();
        this.cbcodes[117] = new OpCB0x75();
        this.cbcodes[118] = new OpCB0x76();
        this.cbcodes[119] = new OpCB0x77();
        this.cbcodes[120] = new OpCB0x78();
        this.cbcodes[121] = new OpCB0x79();
        this.cbcodes[122] = new OpCB0x7A();
        this.cbcodes[123] = new OpCB0x7B();
        this.cbcodes[124] = new OpCB0x7C();
        this.cbcodes[125] = new OpCB0x7D();
        this.cbcodes[126] = new OpCB0x7E();
        this.cbcodes[127] = new OpCB0x7F();
        this.cbcodes[128] = new OpCB0x80();
        this.cbcodes[129] = new OpCB0x81();
        this.cbcodes[130] = new OpCB0x82();
        this.cbcodes[131] = new OpCB0x83();
        this.cbcodes[132] = new OpCB0x84();
        this.cbcodes[133] = new OpCB0x85();
        this.cbcodes[134] = new OpCB0x86();
        this.cbcodes[135] = new OpCB0x87();
        this.cbcodes[136] = new OpCB0x88();
        this.cbcodes[137] = new OpCB0x89();
        this.cbcodes[138] = new OpCB0x8A();
        this.cbcodes[139] = new OpCB0x8B();
        this.cbcodes[140] = new OpCB0x8C();
        this.cbcodes[141] = new OpCB0x8D();
        this.cbcodes[142] = new OpCB0x8E();
        this.cbcodes[143] = new OpCB0x8F();
        this.cbcodes[144] = new OpCB0x90();
        this.cbcodes[145] = new OpCB0x91();
        this.cbcodes[146] = new OpCB0x92();
        this.cbcodes[147] = new OpCB0x93();
        this.cbcodes[148] = new OpCB0x94();
        this.cbcodes[149] = new OpCB0x95();
        this.cbcodes[150] = new OpCB0x96();
        this.cbcodes[151] = new OpCB0x97();
        this.cbcodes[152] = new OpCB0x98();
        this.cbcodes[153] = new OpCB0x99();
        this.cbcodes[154] = new OpCB0x9A();
        this.cbcodes[155] = new OpCB0x9B();
        this.cbcodes[156] = new OpCB0x9C();
        this.cbcodes[157] = new OpCB0x9D();
        this.cbcodes[158] = new OpCB0x9E();
        this.cbcodes[159] = new OpCB0x9F();
        this.cbcodes[160] = new OpCB0xA0();
        this.cbcodes[161] = new OpCB0xA1();
        this.cbcodes[162] = new OpCB0xA2();
        this.cbcodes[163] = new OpCB0xA3();
        this.cbcodes[164] = new OpCB0xA4();
        this.cbcodes[165] = new OpCB0xA5();
        this.cbcodes[166] = new OpCB0xA6();
        this.cbcodes[167] = new OpCB0xA7();
        this.cbcodes[168] = new OpCB0xA8();
        this.cbcodes[169] = new OpCB0xA9();
        this.cbcodes[170] = new OpCB0xAA();
        this.cbcodes[171] = new OpCB0xAB();
        this.cbcodes[172] = new OpCB0xAC();
        this.cbcodes[173] = new OpCB0xAD();
        this.cbcodes[174] = new OpCB0xAE();
        this.cbcodes[175] = new OpCB0xAF();
        this.cbcodes[176] = new OpCB0xB0();
        this.cbcodes[177] = new OpCB0xB1();
        this.cbcodes[178] = new OpCB0xB2();
        this.cbcodes[179] = new OpCB0xB3();
        this.cbcodes[180] = new OpCB0xB4();
        this.cbcodes[181] = new OpCB0xB5();
        this.cbcodes[182] = new OpCB0xB6();
        this.cbcodes[183] = new OpCB0xB7();
        this.cbcodes[184] = new OpCB0xB8();
        this.cbcodes[185] = new OpCB0xB9();
        this.cbcodes[186] = new OpCB0xBA();
        this.cbcodes[187] = new OpCB0xBB();
        this.cbcodes[188] = new OpCB0xBC();
        this.cbcodes[189] = new OpCB0xBD();
        this.cbcodes[190] = new OpCB0xBE();
        this.cbcodes[191] = new OpCB0xBF();
        this.cbcodes[192] = new OpCB0xC0();
        this.cbcodes[193] = new OpCB0xC1();
        this.cbcodes[194] = new OpCB0xC2();
        this.cbcodes[195] = new OpCB0xC3();
        this.cbcodes[196] = new OpCB0xC4();
        this.cbcodes[197] = new OpCB0xC5();
        this.cbcodes[198] = new OpCB0xC6();
        this.cbcodes[199] = new OpCB0xC7();
        this.cbcodes[200] = new OpCB0xC8();
        this.cbcodes[201] = new OpCB0xC9();
        this.cbcodes[202] = new OpCB0xCA();
        this.cbcodes[203] = new OpCB0xCB();
        this.cbcodes[204] = new OpCB0xCC();
        this.cbcodes[205] = new OpCB0xCD();
        this.cbcodes[206] = new OpCB0xCE();
        this.cbcodes[207] = new OpCB0xCF();
        this.cbcodes[208] = new OpCB0xD0();
        this.cbcodes[209] = new OpCB0xD1();
        this.cbcodes[210] = new OpCB0xD2();
        this.cbcodes[211] = new OpCB0xD3();
        this.cbcodes[212] = new OpCB0xD4();
        this.cbcodes[213] = new OpCB0xD5();
        this.cbcodes[214] = new OpCB0xD6();
        this.cbcodes[215] = new OpCB0xD7();
        this.cbcodes[216] = new OpCB0xD8();
        this.cbcodes[217] = new OpCB0xD9();
        this.cbcodes[218] = new OpCB0xDA();
        this.cbcodes[219] = new OpCB0xDB();
        this.cbcodes[220] = new OpCB0xDC();
        this.cbcodes[221] = new OpCB0xDD();
        this.cbcodes[222] = new OpCB0xDE();
        this.cbcodes[223] = new OpCB0xDF();
        this.cbcodes[224] = new OpCB0xE0();
        this.cbcodes[225] = new OpCB0xE1();
        this.cbcodes[226] = new OpCB0xE2();
        this.cbcodes[227] = new OpCB0xE3();
        this.cbcodes[228] = new OpCB0xE4();
        this.cbcodes[229] = new OpCB0xE5();
        this.cbcodes[230] = new OpCB0xE6();
        this.cbcodes[231] = new OpCB0xE7();
        this.cbcodes[232] = new OpCB0xE8();
        this.cbcodes[233] = new OpCB0xE9();
        this.cbcodes[234] = new OpCB0xEA();
        this.cbcodes[235] = new OpCB0xEB();
        this.cbcodes[236] = new OpCB0xEC();
        this.cbcodes[237] = new OpCB0xED();
        this.cbcodes[238] = new OpCB0xEE();
        this.cbcodes[239] = new OpCB0xEF();
        this.cbcodes[240] = new OpCB0xF0();
        this.cbcodes[241] = new OpCB0xF1();
        this.cbcodes[242] = new OpCB0xF2();
        this.cbcodes[243] = new OpCB0xF3();
        this.cbcodes[244] = new OpCB0xF4();
        this.cbcodes[245] = new OpCB0xF5();
        this.cbcodes[246] = new OpCB0xF6();
        this.cbcodes[247] = new OpCB0xF7();
        this.cbcodes[248] = new OpCB0xF8();
        this.cbcodes[249] = new OpCB0xF9();
        this.cbcodes[250] = new OpCB0xFA();
        this.cbcodes[251] = new OpCB0xFB();
        this.cbcodes[252] = new OpCB0xFC();
        this.cbcodes[253] = new OpCB0xFD();
        this.cbcodes[254] = new OpCB0xFE();
        this.cbcodes[255] = new OpCB0xFF();
    }

    final void swapH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() << 4 & 0xF0 | pgbRegister.getH() >> 4;
        this.setC(false);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    public final void exec(int n) {
        while (n > 0) {
            if (this.ime && (this.mem.IF & this.mem.IE) != 0) {
                this.interrupt(this.mem.IF & this.mem.IE);
            }
            int n2 = this.opcodes[this.mem.read(this.PC.data++) & 0xFF].exec();
            this.mem.cycle(n2);
            n -= n2;
        }
    }

    final void and(int n) {
        int n2 = this.AF.getH() & n;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    final void jr(int n) {
        this.PC.setR(this.PC.getR() + (byte)n);
    }

    void unsupported(int n) {
        System.out.println(Integer.toHexString(this.PC.data - 1) + " unsupported opcode: " + Integer.toHexString(n));
    }

    final void rrcH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n & 1) == 1);
        n = n >> 1 | (n & 1) << 7;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    final void ei() {
        this.ime = true;
    }

    final void di() {
        this.ime = false;
    }

    final void add(int n) {
        int n2 = this.AF.getH() + n;
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    final void cp(int n) {
        this.setC(this.AF.getH() < n);
        this.setZ(this.AF.getH() == n);
        this.setN(true);
    }

    final void cpl() {
        int n = ~this.AF.getH() & 0xFF;
        this.setN(true);
        this.AF.setH(n);
    }

    final void rrL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        n = n >> 1 | (this.getC() ? 128 : 0);
        this.setC((pgbRegister.getL() & 1) == 1);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final void daa() {
        int n = this.AF.getH();
        if (this.getN()) {
            if (n / 16 > 9) {
                n -= 96;
            }
            if (n % 16 > 9) {
                n -= 6;
            }
        } else {
            if (n / 16 > 9) {
                n += 96;
            }
            if (n % 16 > 9) {
                n += 6;
            }
        }
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.AF.setH(n);
    }

    final void ret() {
        this.pop(this.PC);
    }

    final void bit(int n, int n2) {
        int n3 = n2 & (int)Math.pow(2.0, n);
        this.setZ(n3);
        this.setN(false);
    }

    final void rrI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        n2 = n2 >> 1 | (this.getC() ? 128 : 0);
        this.setC((this.unsign(this.mem.read(n)) & 1) == 1);
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void setN(boolean bl) {
        this.AF.lo &= 0xFFFFFFBF;
        if (bl) {
            this.AF.lo |= 0x40;
        }
    }

    private final boolean getN() {
        return (this.AF.getL() & 0x40) == 64;
    }

    final void srlL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n & 1) == 1);
        this.setZ(n >>= 1);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final void srlI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 & 1) == 1);
        this.setZ(n2 >>= 1);
        this.setN(false);
        this.mem.write(n, n2);
    }

    final void incR(PgbRegister pgbRegister) {
        pgbRegister.setR(pgbRegister.getR() + 1 & 0xFFFF);
    }

    final void jp(int n) {
        this.PC.setR(n);
    }

    private final void interrupt(int n) {
        if ((n & 1) == 1) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFFE);
            this.di();
            this.rst(64);
            return;
        }
        if ((n & 2) == 2) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFFD);
            this.di();
            this.rst(72);
            return;
        }
        if ((n & 4) == 4) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFFB);
            this.di();
            this.rst(80);
            return;
        }
        if ((n & 8) == 8) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFF7);
            this.di();
            this.rst(88);
            return;
        }
        if ((n & 0x10) == 16) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFEF);
            this.di();
            this.rst(96);
            return;
        }
    }

    final void pop(PgbRegister pgbRegister) {
        pgbRegister.setL(this.mem.read(this.SP.data++));
        pgbRegister.setH(this.mem.read(this.SP.data++));
    }

    final void setZ(boolean bl) {
        this.AF.lo &= 0xFFFFFF7F;
        if (bl) {
            this.AF.lo |= 0x80;
        }
    }

    private final void setZ(int n) {
        this.AF.lo &= 0xFFFFFF7F;
        if (n == 0) {
            this.AF.lo |= 0x80;
        }
    }

    final boolean getZ() {
        return (this.AF.getL() & 0x80) == 128;
    }

    final void rrH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        n = n >> 1 | (this.getC() ? 128 : 0);
        this.setC((pgbRegister.getH() & 1) == 1);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    public void reset() {
        this.AF = new PgbRegisterB(384);
        if (PgbSettings.system == 1) {
            this.AF = new PgbRegisterB(65408);
        }
        if (PgbSettings.system == 11) {
            this.AF = new PgbRegisterB(4480);
        }
        this.BC = new PgbRegisterB(19);
        this.DE = new PgbRegisterB(216);
        this.HL = new PgbRegisterW(333);
        this.SP = new PgbRegisterW(65534);
        this.PC = new PgbRegisterW(256);
        this.ime = false;
        PgbSettings.clockspeed = 4.194304;
    }

    final void rlL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() << 1 | (this.getC() ? 1 : 0);
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final void decR(PgbRegister pgbRegister) {
        pgbRegister.setR(pgbRegister.getR() - 1 & 0xFFFF);
    }

    final void adc(int n) {
        int n2 = this.AF.getH() + n + (this.getC() ? 1 : 0);
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    final void rlI(int n) {
        int n2 = this.unsign(this.mem.read(n)) << 1 | (this.getC() ? 1 : 0);
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    public PgbCpu(PgbMemory pgbMemory) {
        this.mem = pgbMemory;
        this.initOpcodes();
    }

    final void resL(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getL() & ~((int)Math.pow(2.0, n));
        pgbRegister.setL(n2);
    }

    final void resI(int n, int n2) {
        int n3 = this.unsign(this.mem.read(n2)) & ~((int)Math.pow(2.0, n));
        this.mem.write(n2, n3);
    }

    final void addR(PgbRegister pgbRegister, PgbRegister pgbRegister2) {
        int n = pgbRegister.getR() + pgbRegister2.getR();
        this.setC(n != (n &= 0xFFFF));
        pgbRegister.setR(n);
    }

    final void push(PgbRegister pgbRegister) {
        this.mem.write((this.SP.data += -1) & 0xFFFF, pgbRegister.getH());
        this.SP.data &= 0xFFFF;
        this.mem.write(this.SP.data += -1, pgbRegister.getL());
    }

    final void srlH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n & 1) == 1);
        this.setZ(n >>= 1);
        this.setN(false);
        pgbRegister.setH(n);
    }

    final void setC(boolean bl) {
        this.AF.lo &= 0xFFFFFFEF;
        if (bl) {
            this.AF.lo |= 0x10;
        }
    }

    final void incL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() + 1;
        this.setZ(n &= 0xFF);
        this.setN(false);
        pgbRegister.setL(n);
    }

    final boolean getC() {
        return (this.AF.getL() & 0x10) == 16;
    }

    final void incI(PgbRegister pgbRegister) {
        int n = pgbRegister.getI(this.mem) + 1;
        this.setZ(n &= 0xFF);
        this.setN(false);
        pgbRegister.setI(n, this.mem);
    }

    final void setL(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getL() | (int)Math.pow(2.0, n);
        pgbRegister.setL(n2);
    }

    final int readWord() {
        return this.unsign(this.mem.read(this.PC.data++)) | this.unsign(this.mem.read(this.PC.data++)) << 8;
    }

    final void setI(int n, int n2) {
        int n3 = this.unsign(this.mem.read(n2)) | (int)Math.pow(2.0, n);
        this.mem.write(n2, n3);
    }

    final void decL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() - 1;
        this.setZ(n &= 0xFF);
        this.setN(true);
        pgbRegister.setL(n);
    }

    final void rlH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() << 1 | (this.getC() ? 1 : 0);
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    final void decI(PgbRegister pgbRegister) {
        int n = pgbRegister.getI(this.mem) - 1;
        this.setZ(n &= 0xFF);
        this.setN(true);
        pgbRegister.setI(n, this.mem);
    }

    final void resH(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getH() & ~((int)Math.pow(2.0, n));
        pgbRegister.setH(n2);
    }

    final void slaL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() << 1;
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private void unsupportedCB(int n) {
        System.out.println("unsupported CB code: " + Integer.toHexString(n));
    }

    private abstract class Opcode {
        public abstract int exec();

        Opcode() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x00
    extends Opcode {
        public final int exec() {
            return 4;
        }

        Op0x00() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x01
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setR(PgbCpu.this.readWord());
            return 20;
        }

        Op0x01() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x02
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.BC.getR(), PgbCpu.this.AF.getH());
            return 8;
        }

        Op0x02() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x03
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incR(PgbCpu.this.BC);
            return 8;
        }

        Op0x03() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x04
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incH(PgbCpu.this.BC);
            return 4;
        }

        Op0x04() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x05
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decH(PgbCpu.this.BC);
            return 4;
        }

        Op0x05() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x06
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.readByte());
            return 8;
        }

        Op0x06() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x07
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcH(PgbCpu.this.AF);
            PgbCpu.this.setZ(false);
            return 4;
        }

        Op0x07() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x08
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.writeWord(PgbCpu.this.readWord(), PgbCpu.this.SP.getR());
            return 20;
        }

        Op0x08() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x09
    extends Opcode {
        public final int exec() {
            PgbCpu.this.addR(PgbCpu.this.HL, PgbCpu.this.BC);
            return 12;
        }

        Op0x09() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x0A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.BC.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x0A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x0B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decR(PgbCpu.this.BC);
            return 8;
        }

        Op0x0B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x0C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incL(PgbCpu.this.BC);
            return 4;
        }

        Op0x0C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x0D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decL(PgbCpu.this.BC);
            return 4;
        }

        Op0x0D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x0E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.readByte());
            return 8;
        }

        Op0x0E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x0F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcH(PgbCpu.this.AF);
            PgbCpu.this.setZ(false);
            return 4;
        }

        Op0x0F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x10
    extends Opcode {
        public final int exec() {
            PgbCpu.this.readByte();
            if (PgbSettings.system == 11) {
                if ((PgbCpu.this.mem.gbcGetSpeed() & 1) == 1) {
                    PgbSettings.clockspeed = 8.388;
                    PgbCpu.this.mem.gbcSetSpeed((byte)-128);
                } else {
                    PgbSettings.clockspeed = 4.194;
                    PgbCpu.this.mem.gbcSetSpeed((byte)0);
                }
            } else {
                PgbCpu.this.unsupported(16);
            }
            return 4;
        }

        Op0x10() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x11
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setR(PgbCpu.this.readWord());
            return 12;
        }

        Op0x11() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x12
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setI(PgbCpu.this.AF.getH(), PgbCpu.this.mem);
            return 8;
        }

        Op0x12() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x13
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incR(PgbCpu.this.DE);
            return 8;
        }

        Op0x13() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x14
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incH(PgbCpu.this.DE);
            return 4;
        }

        Op0x14() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x15
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decH(PgbCpu.this.DE);
            return 4;
        }

        Op0x15() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x16
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.readByte());
            return 8;
        }

        Op0x16() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x17
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlH(PgbCpu.this.AF);
            PgbCpu.this.setZ(false);
            return 4;
        }

        Op0x17() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x18
    extends Opcode {
        public final int exec() {
            PgbCpu.this.jr(PgbCpu.this.readByte());
            return 12;
        }

        Op0x18() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x19
    extends Opcode {
        public final int exec() {
            PgbCpu.this.addR(PgbCpu.this.HL, PgbCpu.this.DE);
            return 16;
        }

        Op0x19() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x1A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.DE.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x1A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x1B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decR(PgbCpu.this.DE);
            return 4;
        }

        Op0x1B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x1C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incL(PgbCpu.this.DE);
            return 4;
        }

        Op0x1C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x1D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decL(PgbCpu.this.DE);
            return 4;
        }

        Op0x1D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x1E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.readByte());
            return 8;
        }

        Op0x1E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x1F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrH(PgbCpu.this.AF);
            PgbCpu.this.setZ(false);
            return 4;
        }

        Op0x1F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x20
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getZ()) {
                PgbCpu.this.jr(PgbCpu.this.readByte());
                return 12;
            }
            PgbCpu.this.readByte();
            return 8;
        }

        Op0x20() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x21
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setR(PgbCpu.this.readWord());
            return 12;
        }

        Op0x21() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x22
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setI(PgbCpu.this.AF.getH(), PgbCpu.this.mem);
            PgbCpu.this.incR(PgbCpu.this.HL);
            return 16;
        }

        Op0x22() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x23
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incR(PgbCpu.this.HL);
            return 8;
        }

        Op0x23() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x24
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incH(PgbCpu.this.HL);
            return 4;
        }

        Op0x24() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x25
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decH(PgbCpu.this.HL);
            return 4;
        }

        Op0x25() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x26
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.readByte());
            return 8;
        }

        Op0x26() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x27
    extends Opcode {
        public final int exec() {
            PgbCpu.this.daa();
            return 4;
        }

        Op0x27() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x28
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getZ()) {
                PgbCpu.this.jr(PgbCpu.this.readByte());
                return 12;
            }
            PgbCpu.this.readByte();
            return 8;
        }

        Op0x28() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x29
    extends Opcode {
        public final int exec() {
            PgbCpu.this.addR(PgbCpu.this.HL, PgbCpu.this.HL);
            return 12;
        }

        Op0x29() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x2A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            PgbCpu.this.incR(PgbCpu.this.HL);
            return 16;
        }

        Op0x2A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x2B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decR(PgbCpu.this.HL);
            return 8;
        }

        Op0x2B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x2C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incL(PgbCpu.this.HL);
            return 4;
        }

        Op0x2C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x2D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decL(PgbCpu.this.HL);
            return 4;
        }

        Op0x2D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x2E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.readByte());
            return 8;
        }

        Op0x2E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x2F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cpl();
            return 4;
        }

        Op0x2F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x30
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getC()) {
                PgbCpu.this.jr(PgbCpu.this.readByte());
                return 12;
            }
            PgbCpu.this.readByte();
            return 8;
        }

        Op0x30() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x31
    extends Opcode {
        public final int exec() {
            PgbCpu.this.SP.setR(PgbCpu.this.readWord());
            return 12;
        }

        Op0x31() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x32
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setI(PgbCpu.this.AF.getH(), PgbCpu.this.mem);
            PgbCpu.this.decR(PgbCpu.this.HL);
            return 16;
        }

        Op0x32() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x33
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incR(PgbCpu.this.SP);
            return 8;
        }

        Op0x33() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x34
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incI(PgbCpu.this.HL);
            return 12;
        }

        Op0x34() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x35
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decI(PgbCpu.this.HL);
            return 12;
        }

        Op0x35() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x36
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setI(PgbCpu.this.readByte(), PgbCpu.this.mem);
            return 12;
        }

        Op0x36() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x37
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setC(true);
            return 4;
        }

        Op0x37() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x38
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getC()) {
                PgbCpu.this.jr(PgbCpu.this.readByte());
                return 12;
            }
            PgbCpu.this.readByte();
            return 8;
        }

        Op0x38() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x39
    extends Opcode {
        public final int exec() {
            PgbCpu.this.addR(PgbCpu.this.HL, PgbCpu.this.SP);
            return 12;
        }

        Op0x39() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x3A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            PgbCpu.this.decR(PgbCpu.this.HL);
            return 16;
        }

        Op0x3A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x3B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decR(PgbCpu.this.SP);
            return 8;
        }

        Op0x3B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x3C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.incH(PgbCpu.this.AF);
            return 4;
        }

        Op0x3C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x3D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.decH(PgbCpu.this.AF);
            return 4;
        }

        Op0x3D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x3E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.readByte());
            return 8;
        }

        Op0x3E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x3F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setC(!PgbCpu.this.getC());
            return 4;
        }

        Op0x3F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x40
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x40() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x41
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x41() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x42
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x42() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x43
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x43() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x44
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x44() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x45
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x45() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x46
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x46() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x47
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setH(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x47() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x48
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x48() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x49
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x49() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x4A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x4A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x4B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x4B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x4C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x4C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x4D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x4D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x4E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x4E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x4F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.BC.setL(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x4F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x50
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x50() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x51
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x51() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x52
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x52() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x53
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x53() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x54
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x54() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x55
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x55() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x56
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x56() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x57
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setH(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x57() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x58
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x58() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x59
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x59() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x5A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x5A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x5B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x5B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x5C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x5C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x5D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x5D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x5E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x5E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x5F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.DE.setL(PgbCpu.this.AF.getH());
            return 8;
        }

        Op0x5F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x60
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x60() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x61
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x61() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x62
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x62() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x63
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x63() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x64
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x64() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x65
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x65() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x66
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x66() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x67
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setH(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x67() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x68
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x68() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x69
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x69() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x6A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x6A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x6B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x6B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x6C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x6C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x6D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x6D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x6E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x6E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x6F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setL(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x6F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x70
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.HL.getR(), PgbCpu.this.BC.getH());
            return 8;
        }

        Op0x70() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x71
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.HL.getR(), PgbCpu.this.BC.getL());
            return 8;
        }

        Op0x71() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x72
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.HL.getR(), PgbCpu.this.DE.getH());
            return 8;
        }

        Op0x72() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x73
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.HL.getR(), PgbCpu.this.DE.getL());
            return 8;
        }

        Op0x73() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x74
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.HL.getR(), PgbCpu.this.HL.getH());
            return 8;
        }

        Op0x74() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x75
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.HL.getR(), PgbCpu.this.HL.getL());
            return 8;
        }

        Op0x75() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x76
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.ime) {
                PgbCpu.this.mem.recalcCyclesLeft();
                return PgbCpu.this.mem.cyclesLeft;
            }
            return 4;
        }

        Op0x76() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x77
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.HL.getR(), PgbCpu.this.AF.getH());
            return 8;
        }

        Op0x77() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x78
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x78() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x79
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x79() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x7A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x7A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x7B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x7B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x7C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x7C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x7D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x7D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x7E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x7E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x7F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x7F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x80
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x80() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x81
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x81() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x82
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x82() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x83
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x83() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x84
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x84() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x85
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x85() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x86
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        Op0x86() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x87
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x87() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x88
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x88() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x89
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x89() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x8A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x8A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x8B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x8B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x8C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x8C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x8D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x8D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x8E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        Op0x8E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x8F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x8F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x90
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x90() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x91
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x91() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x92
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x92() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x93
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x93() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x94
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x94() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x95
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x95() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x96
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x96() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x97
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x97() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x98
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0x98() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x99
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0x99() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x9A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0x9A() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x9B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0x9B() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x9C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0x9C() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x9D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0x9D() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x9E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0x9E() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0x9F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0x9F() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0xA0() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0xA1() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0xA2() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0xA3() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0xA4() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0xA5() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0xA6() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0xA7() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0xA8() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xA9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0xA9() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xAA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0xAA() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xAB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0xAB() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xAC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0xAC() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xAD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0xAD() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xAE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0xAE() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xAF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0xAF() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0xB0() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0xB1() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0xB2() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0xB3() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0xB4() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0xB5() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0xB6() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0xB7() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.BC.getH());
            return 4;
        }

        Op0xB8() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xB9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.BC.getL());
            return 4;
        }

        Op0xB9() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xBA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.DE.getH());
            return 4;
        }

        Op0xBA() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xBB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.DE.getL());
            return 4;
        }

        Op0xBB() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xBC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.HL.getH());
            return 4;
        }

        Op0xBC() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xBD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.HL.getL());
            return 4;
        }

        Op0xBD() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xBE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 8;
        }

        Op0xBE() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xBF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.AF.getH());
            return 4;
        }

        Op0xBF() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC0
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getZ()) {
                PgbCpu.this.ret();
                return 20;
            }
            return 8;
        }

        Op0xC0() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.pop(PgbCpu.this.BC);
            return 12;
        }

        Op0xC1() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC2
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getZ()) {
                PgbCpu.this.jp(PgbCpu.this.readWord());
                return 16;
            }
            PgbCpu.this.readWord();
            return 12;
        }

        Op0xC2() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.jp(PgbCpu.this.readWord());
            return 16;
        }

        Op0xC3() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC4
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getZ()) {
                PgbCpu.this.call(PgbCpu.this.readWord());
                return 24;
            }
            PgbCpu.this.readWord();
            return 12;
        }

        Op0xC4() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.push(PgbCpu.this.BC);
            return 16;
        }

        Op0xC5() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.add(PgbCpu.this.readByte());
            return 8;
        }

        Op0xC6() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(0);
            return 16;
        }

        Op0xC7() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC8
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getZ()) {
                PgbCpu.this.ret();
                return 20;
            }
            return 8;
        }

        Op0xC8() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xC9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.ret();
            return 16;
        }

        Op0xC9() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xCA
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getZ()) {
                PgbCpu.this.jp(PgbCpu.this.readWord());
                return 16;
            }
            PgbCpu.this.readWord();
            return 12;
        }

        Op0xCA() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xCB
    extends Opcode {
        public final int exec() {
            return PgbCpu.this.cbcodes[PgbCpu.this.readByte()].exec();
        }

        Op0xCB() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xCC
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getZ()) {
                PgbCpu.this.call(PgbCpu.this.readWord());
                return 24;
            }
            PgbCpu.this.readWord();
            return 12;
        }

        Op0xCC() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xCD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.call(PgbCpu.this.readWord());
            return 24;
        }

        Op0xCD() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xCE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.adc(PgbCpu.this.readByte());
            return 8;
        }

        Op0xCE() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xCF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(8);
            return 16;
        }

        Op0xCF() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD0
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getC()) {
                PgbCpu.this.ret();
                return 20;
            }
            return 8;
        }

        Op0xD0() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.pop(PgbCpu.this.DE);
            return 10;
        }

        Op0xD1() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD2
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getC()) {
                PgbCpu.this.jp(PgbCpu.this.readWord());
                return 20;
            }
            PgbCpu.this.readWord();
            return 8;
        }

        Op0xD2() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(211);
            return 4;
        }

        Op0xD3() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD4
    extends Opcode {
        public final int exec() {
            if (!PgbCpu.this.getC()) {
                PgbCpu.this.call(PgbCpu.this.readWord());
                return 24;
            }
            PgbCpu.this.readWord();
            return 12;
        }

        Op0xD4() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.push(PgbCpu.this.DE);
            return 16;
        }

        Op0xD5() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sub(PgbCpu.this.readByte());
            return 8;
        }

        Op0xD6() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(16);
            return 16;
        }

        Op0xD7() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD8
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getC()) {
                PgbCpu.this.ret();
                return 20;
            }
            return 8;
        }

        Op0xD8() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xD9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.ret();
            PgbCpu.this.ei();
            return 16;
        }

        Op0xD9() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xDA
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getC()) {
                PgbCpu.this.jp(PgbCpu.this.readWord());
                return 16;
            }
            PgbCpu.this.readWord();
            return 12;
        }

        Op0xDA() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xDB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(219);
            return 4;
        }

        Op0xDB() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xDC
    extends Opcode {
        public final int exec() {
            if (PgbCpu.this.getC()) {
                PgbCpu.this.call(PgbCpu.this.readWord());
                return 24;
            }
            PgbCpu.this.readWord();
            return 12;
        }

        Op0xDC() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xDD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(221);
            return 4;
        }

        Op0xDD() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xDE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sbc(PgbCpu.this.readByte());
            return 8;
        }

        Op0xDE() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xDF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(24);
            return 16;
        }

        Op0xDF() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(65280 + PgbCpu.this.readByte(), PgbCpu.this.AF.getH());
            return 12;
        }

        Op0xE0() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.pop(PgbCpu.this.HL);
            return 12;
        }

        Op0xE1() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(65280 + PgbCpu.this.BC.getL(), PgbCpu.this.AF.getH());
            return 8;
        }

        Op0xE2() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(227);
            return 4;
        }

        Op0xE3() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(228);
            return 4;
        }

        Op0xE4() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.push(PgbCpu.this.HL);
            return 16;
        }

        Op0xE5() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.and(PgbCpu.this.readByte());
            return 8;
        }

        Op0xE6() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(32);
            return 16;
        }

        Op0xE7() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.SP.setR(PgbCpu.this.SP.getR() + (byte)PgbCpu.this.readByte());
            PgbCpu.this.setZ(false);
            return 16;
        }

        Op0xE8() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xE9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.jp(PgbCpu.this.HL.getR());
            return 4;
        }

        Op0xE9() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xEA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.mem.write(PgbCpu.this.readWord(), PgbCpu.this.AF.getH());
            return 16;
        }

        Op0xEA() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xEB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(235);
            return 4;
        }

        Op0xEB() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xEC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(236);
            return 4;
        }

        Op0xEC() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xED
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(237);
            return 4;
        }

        Op0xED() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xEE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.xor(PgbCpu.this.readByte());
            return 8;
        }

        Op0xEE() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xEF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(40);
            return 16;
        }

        Op0xEF() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.mem.read(65280 + PgbCpu.this.readByte()));
            return 8;
        }

        Op0xF0() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.pop(PgbCpu.this.AF);
            return 12;
        }

        Op0xF1() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.mem.read(65280 + PgbCpu.this.BC.getL()));
            return 8;
        }

        Op0xF2() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.di();
            return 4;
        }

        Op0xF3() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(244);
            return 4;
        }

        Op0xF4() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.push(PgbCpu.this.AF);
            return 16;
        }

        Op0xF5() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.or(PgbCpu.this.readByte());
            return 8;
        }

        Op0xF6() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(48);
            return 16;
        }

        Op0xF7() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.HL.setR(PgbCpu.this.SP.getR() + (byte)PgbCpu.this.readByte());
            return 12;
        }

        Op0xF8() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xF9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.SP.setR(PgbCpu.this.HL.getR());
            return 8;
        }

        Op0xF9() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xFA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.AF.setH(PgbCpu.this.mem.read(PgbCpu.this.readWord()));
            return 16;
        }

        Op0xFA() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xFB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.ei();
            return 4;
        }

        Op0xFB() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xFC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.unsupported(252);
            return 4;
        }

        Op0xFC() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xFD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.ei();
            return 4;
        }

        Op0xFD() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xFE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.cp(PgbCpu.this.readByte());
            return 8;
        }

        Op0xFE() {
            PgbCpu.this.getClass();
        }
    }

    private final class Op0xFF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rst(56);
            return 16;
        }

        Op0xFF() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x00
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x00() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x01
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x01() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x02
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x02() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x03
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x03() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x04
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x04() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x05
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x05() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x06
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x06() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x07
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlcH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x07() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x08
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x08() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x09
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x09() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x0A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x0A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x0B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x0B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x0C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x0C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x0D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x0D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x0E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x0E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x0F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrcH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x0F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x10
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x10() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x11
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x11() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x12
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x12() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x13
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x13() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x14
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x14() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x15
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x15() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x16
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x16() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x17
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rlH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x17() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x18
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x18() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x19
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x19() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x1A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x1A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x1B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x1B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x1C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x1C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x1D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x1D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x1E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x1E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x1F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.rrH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x1F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x20
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x20() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x21
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x21() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x22
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x22() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x23
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x23() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x24
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x24() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x25
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x25() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x26
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x26() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x27
    extends Opcode {
        public final int exec() {
            PgbCpu.this.slaH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x27() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x28
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x28() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x29
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x29() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x2A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x2A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x2B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x2B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x2C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x2C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x2D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x2D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x2E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x2E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x2F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.sraH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x2F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x30
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x30() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x31
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x31() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x32
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x32() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x33
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x33() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x34
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x34() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x35
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x35() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x36
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x36() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x37
    extends Opcode {
        public final int exec() {
            PgbCpu.this.swapH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x37() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x38
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlH(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x38() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x39
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlL(PgbCpu.this.BC);
            return 4;
        }

        OpCB0x39() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x3A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlH(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x3A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x3B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlL(PgbCpu.this.DE);
            return 4;
        }

        OpCB0x3B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x3C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlH(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x3C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x3D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlL(PgbCpu.this.HL);
            return 4;
        }

        OpCB0x3D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x3E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlI(PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x3E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x3F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.srlH(PgbCpu.this.AF);
            return 4;
        }

        OpCB0x3F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x40
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x40() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x41
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x41() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x42
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x42() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x43
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x43() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x44
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x44() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x45
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x45() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x46
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x46() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x47
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(0, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x47() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x48
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x48() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x49
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x49() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x4A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x4A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x4B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x4B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x4C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x4C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x4D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x4D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x4E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x4E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x4F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(1, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x4F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x50
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x50() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x51
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x51() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x52
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x52() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x53
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x53() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x54
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x54() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x55
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x55() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x56
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x56() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x57
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(2, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x57() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x58
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x58() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x59
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x59() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x5A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x5A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x5B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x5B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x5C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x5C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x5D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x5D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x5E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x5E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x5F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(3, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x5F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x60
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x60() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x61
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x61() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x62
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x62() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x63
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x63() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x64
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x64() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x65
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x65() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x66
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x66() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x67
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(4, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x67() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x68
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x68() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x69
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x69() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x6A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x6A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x6B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x6B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x6C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x6C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x6D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x6D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x6E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x6E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x6F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(5, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x6F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x70
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x70() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x71
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x71() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x72
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x72() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x73
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x73() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x74
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x74() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x75
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x75() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x76
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x76() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x77
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(6, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x77() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x78
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.BC.getH());
            return 4;
        }

        OpCB0x78() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x79
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.BC.getL());
            return 4;
        }

        OpCB0x79() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x7A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.DE.getH());
            return 4;
        }

        OpCB0x7A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x7B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.DE.getL());
            return 4;
        }

        OpCB0x7B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x7C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.HL.getH());
            return 4;
        }

        OpCB0x7C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x7D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.HL.getL());
            return 4;
        }

        OpCB0x7D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x7E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.HL.getI(PgbCpu.this.mem));
            return 4;
        }

        OpCB0x7E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x7F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.bit(7, PgbCpu.this.AF.getH());
            return 4;
        }

        OpCB0x7F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x80
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(0, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x80() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x81
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(0, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x81() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x82
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(0, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x82() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x83
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(0, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x83() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x84
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(0, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x84() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x85
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(0, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x85() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x86
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(0, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x86() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x87
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(0, PgbCpu.this.AF);
            return 4;
        }

        OpCB0x87() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x88
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(1, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x88() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x89
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(1, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x89() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x8A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(1, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x8A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x8B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(1, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x8B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x8C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(1, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x8C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x8D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(1, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x8D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x8E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(1, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x8E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x8F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(1, PgbCpu.this.AF);
            return 4;
        }

        OpCB0x8F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x90
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(2, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x90() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x91
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(2, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x91() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x92
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(2, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x92() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x93
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(2, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x93() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x94
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(2, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x94() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x95
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(2, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x95() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x96
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(2, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x96() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x97
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(2, PgbCpu.this.AF);
            return 4;
        }

        OpCB0x97() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x98
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(3, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x98() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x99
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(3, PgbCpu.this.BC);
            return 4;
        }

        OpCB0x99() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x9A
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(3, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x9A() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x9B
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(3, PgbCpu.this.DE);
            return 4;
        }

        OpCB0x9B() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x9C
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(3, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x9C() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x9D
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(3, PgbCpu.this.HL);
            return 4;
        }

        OpCB0x9D() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x9E
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(3, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0x9E() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0x9F
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(3, PgbCpu.this.AF);
            return 4;
        }

        OpCB0x9F() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(4, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xA0() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(4, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xA1() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(4, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xA2() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(4, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xA3() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(4, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xA4() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(4, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xA5() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(4, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xA6() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(4, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xA7() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(5, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xA8() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xA9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(5, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xA9() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xAA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(5, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xAA() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xAB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(5, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xAB() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xAC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(5, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xAC() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xAD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(5, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xAD() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xAE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(5, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xAE() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xAF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(5, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xAF() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(6, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xB0() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(6, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xB1() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(6, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xB2() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(6, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xB3() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(6, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xB4() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(6, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xB5() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(6, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xB6() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(6, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xB7() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(7, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xB8() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xB9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(7, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xB9() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xBA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(7, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xBA() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xBB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(7, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xBB() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xBC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(7, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xBC() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xBD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resL(7, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xBD() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xBE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resI(7, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xBE() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xBF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.resH(7, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xBF() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(0, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xC0() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(0, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xC1() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(0, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xC2() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(0, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xC3() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(0, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xC4() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(0, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xC5() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(0, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xC6() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(0, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xC7() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(1, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xC8() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xC9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(1, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xC9() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xCA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(1, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xCA() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xCB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(1, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xCB() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xCC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(1, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xCC() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xCD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(1, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xCD() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xCE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(1, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xCE() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xCF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(1, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xCF() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(2, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xD0() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(2, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xD1() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(2, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xD2() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(2, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xD3() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(2, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xD4() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(2, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xD5() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(2, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xD6() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(2, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xD7() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(3, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xD8() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xD9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(3, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xD9() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xDA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(3, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xDA() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xDB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(3, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xDB() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xDC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(3, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xDC() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xDD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(3, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xDD() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xDE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(3, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xDE() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xDF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(3, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xDF() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(4, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xE0() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(4, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xE1() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(4, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xE2() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(4, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xE3() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(4, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xE4() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(4, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xE5() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(4, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xE6() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(4, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xE7() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(5, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xE8() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xE9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(5, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xE9() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xEA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(5, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xEA() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xEB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(5, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xEB() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xEC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(5, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xEC() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xED
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(5, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xED() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xEE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(5, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xEE() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xEF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(5, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xEF() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF0
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(6, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xF0() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF1
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(6, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xF1() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF2
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(6, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xF2() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF3
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(6, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xF3() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF4
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(6, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xF4() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF5
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(6, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xF5() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF6
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(6, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xF6() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF7
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(6, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xF7() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF8
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(7, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xF8() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xF9
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(7, PgbCpu.this.BC);
            return 4;
        }

        OpCB0xF9() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xFA
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(7, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xFA() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xFB
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(7, PgbCpu.this.DE);
            return 4;
        }

        OpCB0xFB() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xFC
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(7, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xFC() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xFD
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setL(7, PgbCpu.this.HL);
            return 4;
        }

        OpCB0xFD() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xFE
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setI(7, PgbCpu.this.HL.getR());
            return 4;
        }

        OpCB0xFE() {
            PgbCpu.this.getClass();
        }
    }

    private final class OpCB0xFF
    extends Opcode {
        public final int exec() {
            PgbCpu.this.setH(7, PgbCpu.this.AF);
            return 4;
        }

        OpCB0xFF() {
            PgbCpu.this.getClass();
        }
    }
}

