/*
 * Decompiled with CFR 0.152.
 */
public final class PgbMemory {
    public PgbCart cart;
    public PgbVideo video;
    public PgbJoypad joy;
    public PgbNetplay net;
    public static final byte INT_JOYPAD = 16;
    public static final byte INT_SERIAL = 8;
    public static final byte INT_TIMER = 4;
    public static final byte INT_LCD = 2;
    public static final byte INT_VBLANK = 1;
    protected byte[] hiRAM;
    protected byte[] loRAM;
    public byte IF;
    public byte IE;
    public int tima;
    public int tma;
    public byte tac;
    protected boolean timerOn;
    protected int timeCounter;
    protected int timeLimit;
    public int div;
    public int cycles;
    public int cyclesLeft;
    public int cyclesSkipped;
    protected int sgbBitCounter;
    protected int sgbPacketCounter;
    protected byte[] sgbBuffer;
    protected boolean sgbListening;
    protected int sgbCommand;
    protected int sgbPackets;
    byte gbcRAM;
    int loRAMOffset;
    byte gbcSpeed;
    byte rHDMA1;
    byte rHDMA2;
    byte rHDMA3;
    byte rHDMA4;
    int hdmaSrc;
    int hdmaDst;
    boolean hdmaDone;
    byte hdmaLastMode;
    int hdmaStop;

    public void reset() {
        this.tima = 0;
        this.tma = 0;
        this.tac = 0;
        this.timerOn = false;
        this.timeCounter = 0;
        this.timeLimit = 0;
        this.div = 44800;
        this.IF = 1;
        this.IE = 0;
        this.sgbBitCounter = 0;
        this.sgbPacketCounter = 0;
        this.sgbListening = false;
        this.sgbPackets = 1;
        this.gbcRAM = 0;
        this.loRAMOffset = 49152;
        this.gbcSpeed = (byte)126;
        this.cycles = 0;
        this.cyclesLeft = Integer.MAX_VALUE;
        this.recalcCyclesLeft();
        this.hdmaDone = true;
        this.hdmaLastMode = 0;
    }

    public void setTac(byte by) {
        this.timerOn = (by & 4) == 4;
        this.timeCounter = 0;
        switch (by & 3) {
            case 0: {
                this.timeLimit = 1024;
                return;
            }
            case 1: {
                this.timeLimit = 16;
                return;
            }
            case 2: {
                this.timeLimit = 64;
                return;
            }
            case 3: {
                this.timeLimit = 256;
                return;
            }
        }
    }

    public void sgbCommandExec() {
        switch (this.sgbCommand) {
            case 0: {
                String string = "Download color palettes 0 & 1";
                this.video.sgbSetPalette(0, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(0, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(0, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(0, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(1, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(1, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(1, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(1, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                return;
            }
            case 1: {
                String string = "Download color palettes 2 & 3";
                this.video.sgbSetPalette(2, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(2, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(2, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(2, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(3, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(3, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(3, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(3, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                return;
            }
            case 2: {
                String string = "Download color palettes 0 & 3";
                this.video.sgbSetPalette(0, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(0, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(0, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(0, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(3, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(3, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(3, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(3, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                return;
            }
            case 3: {
                String string = "Download color palettes 1 & 2";
                this.video.sgbSetPalette(1, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(1, 1, this.sgbBuffer[4], this.sgbBuffer[3]);
                this.video.sgbSetPalette(1, 2, this.sgbBuffer[6], this.sgbBuffer[5]);
                this.video.sgbSetPalette(1, 3, this.sgbBuffer[8], this.sgbBuffer[7]);
                this.video.sgbSetPalette(2, 0, this.sgbBuffer[2], this.sgbBuffer[1]);
                this.video.sgbSetPalette(2, 1, this.sgbBuffer[10], this.sgbBuffer[9]);
                this.video.sgbSetPalette(2, 2, this.sgbBuffer[12], this.sgbBuffer[11]);
                this.video.sgbSetPalette(2, 3, this.sgbBuffer[14], this.sgbBuffer[13]);
                return;
            }
            case 4: {
                String string = "'Block' Area Designation Mode";
                int n = 0;
                while (n < this.sgbBuffer[1]) {
                    this.video.sgbBlockDesignate(this.sgbBuffer[n * 6 + 2], this.sgbBuffer[n * 6 + 3], this.sgbBuffer[n * 6 + 4], this.sgbBuffer[n * 6 + 5], this.sgbBuffer[n * 6 + 6], this.sgbBuffer[n * 6 + 7]);
                    ++n;
                }
                return;
            }
            case 5: {
                String string = "'Line' Area Designation Mode";
                int n = 0;
                while (n < this.sgbBuffer[1]) {
                    this.video.sgbLineDesignate(this.sgbBuffer[n + 2]);
                    ++n;
                }
                return;
            }
            case 6: {
                String string = "'Divide' Area Designation Mode";
                this.video.sgbDivideDesignate(this.sgbBuffer[1], this.sgbBuffer[2]);
                return;
            }
            case 7: {
                String string = "'1CHR' Area Designation Mode";
                int n = 0;
                do {
                    this.video.sgbSetPaletteOverlay(n * 4, this.sgbBuffer[n + 6] & 3);
                    this.video.sgbSetPaletteOverlay(n * 4 + 1, this.sgbBuffer[n + 6] & 3);
                    this.video.sgbSetPaletteOverlay(n * 4 + 2, this.sgbBuffer[n + 6] & 3);
                    this.video.sgbSetPaletteOverlay(n * 4 + 3, this.sgbBuffer[n + 6] & 3);
                } while (++n < 90);
                return;
            }
            case 8: {
                String string = "Sound On/Off (unprogrammed)";
                return;
            }
            case 10: {
                String string = "Set SGB Palette Indirect";
                this.video.sgbSetPaletteIndirect((this.sgbBuffer[2] & 1) << 8 | this.sgbBuffer[1] & 0xFF, (this.sgbBuffer[4] & 1) << 8 | this.sgbBuffer[3] & 0xFF, (this.sgbBuffer[6] & 1) << 8 | this.sgbBuffer[5] & 0xFF, (this.sgbBuffer[8] & 1) << 8 | this.sgbBuffer[7] & 0xFF, (this.sgbBuffer[10] & 1) << 8 | this.sgbBuffer[9] & 0xFF);
                return;
            }
            case 11: {
                String string = "Set System Color Palette Data";
                this.video.sgbPaletteTransfer();
                return;
            }
            case 15: {
                String string = "Super NES WRAM Transfer 1";
                return;
            }
            case 17: {
                String string = "Controller 2 Request";
                this.joy.setSgbPlayer(this.sgbBuffer[1]);
                return;
            }
            case 19: {
                String string = "CharSet Transfer";
                this.video.sgbCharsetTransfer((this.sgbBuffer[1] & 4) == 4, (this.sgbBuffer[1] & 1) == 1);
                return;
            }
            case 20: {
                String string = "Picture Transfer";
                this.video.sgbPictureTransfer();
                return;
            }
            case 21: {
                String string = "Set Attribute from ATF";
                this.video.sgbAtfTransfer();
                return;
            }
            case 22: {
                String string = "Set Data from ATF";
                this.video.sgbSetOverlayFromAtf(this.sgbBuffer[1]);
                return;
            }
            case 23: {
                String string = "GameBoy Window Mask";
                if (this.sgbBuffer[1] == 0) {
                    this.video.sgbvramon = false;
                }
                if (this.sgbBuffer[1] != 1 && this.sgbBuffer[1] != 3) break;
                this.video.sgbvramon = true;
                return;
            }
            default: {
                String string = "Unprogrammed";
                return;
            }
        }
    }

    public PgbMemory(PgbCart pgbCart, PgbVideo pgbVideo, PgbJoypad pgbJoypad, PgbNetplay pgbNetplay) {
        this.cart = pgbCart;
        this.video = pgbVideo;
        this.joy = pgbJoypad;
        this.net = pgbNetplay;
        this.hiRAM = new byte[128];
        this.loRAM = new byte[32768];
        this.sgbBuffer = new byte[128];
        this.reset();
    }

    public final byte read(int n) {
        if (n < 32768) {
            return this.cart.read(n);
        }
        if (n < 40960) {
            return this.video.read(n);
        }
        if (n < 49152) {
            return this.cart.read(n);
        }
        if (n < 53248) {
            return this.loRAM[n - 49152];
        }
        if (n < 57344) {
            return this.loRAM[n - this.loRAMOffset];
        }
        if (n < 65024) {
            return this.loRAM[n - 57344];
        }
        if (n < 65184) {
            return this.video.read(n);
        }
        if (n < 65280) {
            return 0;
        }
        if (n == 65280) {
            return this.joy.read();
        }
        if (n == 65281) {
            return this.net.getSerialData();
        }
        if (n == 65282) {
            return this.net.getSerialControl();
        }
        if (n == 65283) {
            return 0;
        }
        if (n == 65284) {
            return (byte)(this.div / 256);
        }
        if (n == 65285) {
            return (byte)this.tima;
        }
        if (n == 65286) {
            return (byte)this.tma;
        }
        if (n == 65287) {
            return this.tac;
        }
        if (n < 65295) {
            return 0;
        }
        if (n == 65295) {
            return this.IF;
        }
        if (n < 65344) {
            return 0;
        }
        if (n == 65344) {
            return this.video.getLcdc();
        }
        if (n == 65345) {
            return this.video.getStat();
        }
        if (n == 65346) {
            return (byte)this.video.scy;
        }
        if (n == 65347) {
            return (byte)this.video.scx;
        }
        if (n == 65348) {
            return (byte)this.video.ly;
        }
        if (n == 65349) {
            return (byte)this.video.lyc;
        }
        if (n == 65351) {
            return (byte)this.video.bgpal;
        }
        if (n == 65352) {
            return (byte)this.video.objpal0;
        }
        if (n == 65353) {
            return (byte)this.video.objpal1;
        }
        if (n == 65354) {
            return (byte)this.video.wy;
        }
        if (n == 65355) {
            return (byte)this.video.wx;
        }
        if (n == 65357) {
            return this.gbcGetSpeed();
        }
        if (n == 65359) {
            return this.video.gbcGetVram();
        }
        if (n < 65365) {
            System.out.println("read GBC register:" + Integer.toHexString(n));
            return 0;
        }
        if (n == 65365) {
            return this.getHDMAControl();
        }
        if (n == 65366) {
            return this.net.getIR();
        }
        if (n == 65384) {
            return this.video.gbcGetBgpi();
        }
        if (n == 65385) {
            return this.video.gbcGetBgpd();
        }
        if (n == 65386) {
            return this.video.gbcGetObpi();
        }
        if (n == 65387) {
            return this.video.gbcGetObpd();
        }
        if (n < 65392) {
            System.out.println("read GBC register:" + Integer.toHexString(n));
            return 0;
        }
        if (n == 65392) {
            return this.gbcGetRamBank();
        }
        if (n < 65407) {
            System.out.println("read GBC register:" + Integer.toHexString(n));
            return 0;
        }
        if (n == 65407) {
            System.out.println("Read from 0xFF7F");
            return 0;
        }
        if (n < 65535) {
            return this.hiRAM[n - 65408];
        }
        if (n == 65535) {
            return this.IE;
        }
        System.out.println("Read from unmapped memory:" + Integer.toHexString(n));
        return 0;
    }

    public void gbcSetRamBank(byte by) {
        if (PgbSettings.system == 11) {
            this.gbcRAM = by;
            int n = (this.gbcRAM & 7) == 0 ? 0 : (this.gbcRAM & 7) - 1;
            this.loRAMOffset = 49152 - n * 4096;
        }
    }

    public void gbcSetSpeed(byte by) {
        this.gbcSpeed = by;
    }

    public final void write(int n, byte by) {
        if (n < 32768 && n >= 0) {
            this.cart.write(n, by);
            return;
        }
        if (n < 40960 && n >= 32768) {
            this.video.write(n, by);
            return;
        }
        if (n < 49152 && n >= 40960) {
            this.cart.write(n, by);
            return;
        }
        if (n < 53248 && n >= 49152) {
            this.loRAM[n - 49152] = by;
            return;
        }
        if (n < 57344 && n >= 53248) {
            this.loRAM[n - this.loRAMOffset] = by;
            return;
        }
        if (n >= 57344 && n < 65024) {
            this.loRAM[n - 57344] = by;
            return;
        }
        if (n < 65184 && n >= 65024) {
            this.video.write(n, by);
            return;
        }
        if (n < 65280 && n >= 65184) {
            return;
        }
        if (n == 65280) {
            if (by == 48 && PgbSettings.system == 10) {
                this.sgbCommandBit(this.joy.selected);
            }
            this.joy.write(by);
            return;
        }
        if (n == 65281) {
            this.net.setSerialData(by);
            return;
        }
        if (n == 65282) {
            this.net.setSerialControl(by);
            this.recalcCyclesLeft();
            return;
        }
        if (n == 65284) {
            this.div = 0;
            return;
        }
        if (n == 65285) {
            this.tima = by;
            return;
        }
        if (n == 65286) {
            this.tma = by;
            return;
        }
        if (n == 65287) {
            this.setTac(by);
            this.recalcCyclesLeft();
            return;
        }
        if (n < 65344 && n >= 65296) {
            return;
        }
        if (n == 65295) {
            this.IF = by;
            return;
        }
        if (n == 65344) {
            this.video.setLcdc(by);
            this.recalcCyclesLeft();
            return;
        }
        if (n == 65345) {
            this.video.setStat(by);
            this.recalcCyclesLeft();
            return;
        }
        if (n == 65346) {
            this.video.scy = by & 0xFF;
            return;
        }
        if (n == 65347) {
            this.video.scx = by & 0xFF;
            return;
        }
        if (n == 65348) {
            this.video.ly = 0;
            this.recalcCyclesLeft();
            return;
        }
        if (n == 65349) {
            this.video.lyc = by & 0xFF;
            return;
        }
        if (n == 65350) {
            this.oamDMA(by);
            return;
        }
        if (n == 65351) {
            this.video.setBgPal(by & 0xFF);
            return;
        }
        if (n == 65352) {
            this.video.setObjPal0(by & 0xFF);
            return;
        }
        if (n == 65353) {
            this.video.setObjPal1(by & 0xFF);
            return;
        }
        if (n == 65354) {
            this.video.wy = by & 0xFF;
            return;
        }
        if (n == 65355) {
            this.video.wx = by & 0xFF;
            return;
        }
        if (n == 65357) {
            this.gbcSetSpeed(by);
            return;
        }
        if (n == 65359) {
            this.video.gbcSetVram(by);
            return;
        }
        if (n == 65361) {
            this.rHDMA1 = by;
            return;
        }
        if (n == 65362) {
            this.rHDMA2 = by;
            return;
        }
        if (n == 65363) {
            this.rHDMA3 = by;
            return;
        }
        if (n == 65364) {
            this.rHDMA4 = by;
            return;
        }
        if (n == 65365) {
            this.setHDMAControl(by);
            return;
        }
        if (n == 65366) {
            this.net.setIR(by);
            return;
        }
        if (n == 65384) {
            if (PgbSettings.system == 11) {
                this.video.gbcSetBgpi(by);
            }
            return;
        }
        if (n == 65385) {
            if (PgbSettings.system == 11) {
                this.video.gbcSetBgpd(by);
            }
            return;
        }
        if (n == 65386) {
            if (PgbSettings.system == 11) {
                this.video.gbcSetObpi(by);
            }
            return;
        }
        if (n == 65387) {
            if (PgbSettings.system == 11) {
                this.video.gbcSetObpd(by);
            }
            return;
        }
        if (n == 65392) {
            this.gbcSetRamBank(by);
            return;
        }
        if (n == 65407) {
            System.out.println("write to GBC mystery register:" + (by & 0xFF));
            return;
        }
        if (n < 65535 && n >= 65408) {
            this.hiRAM[n - 65408] = by;
            return;
        }
        if (n == 65535) {
            this.IE = by;
            this.recalcCyclesLeft();
            return;
        }
        System.out.println("Write to unmapped memory:" + Integer.toHexString(n) + ", " + Integer.toHexString(by));
    }

    public final void write(int n, int n2) {
        this.write(n, (byte)n2);
    }

    public byte gbcGetSpeed() {
        if (PgbSettings.system == 11) {
            return this.gbcSpeed;
        }
        return 0;
    }

    public void oamDMA(byte by) {
        int n = (by & 0xFF) * 256;
        int n2 = 0;
        do {
            this.video.write(65024 + n2, this.read(n + n2));
        } while (++n2 < 160);
    }

    public byte gbcGetRamBank() {
        return this.gbcRAM;
    }

    public void sgbCommandBit(byte by) {
        if (this.sgbPacketCounter == 0 && this.sgbBitCounter == 8) {
            this.sgbCheckCommand();
        }
        if (this.sgbBitCounter == 128) {
            if (++this.sgbPacketCounter == this.sgbPackets) {
                this.sgbCommandExec();
                this.sgbPacketCounter = 0;
            }
            this.sgbBitCounter = 0;
            this.sgbListening = false;
            return;
        }
        if (by == 0) {
            this.sgbListening = true;
            return;
        }
        if (this.sgbListening && by == 16) {
            int n = this.sgbPacketCounter * 16 + this.sgbBitCounter / 8;
            this.sgbBuffer[n] = (byte)(this.sgbBuffer[n] | (byte)Math.pow(2.0, this.sgbBitCounter % 8));
            ++this.sgbBitCounter;
            return;
        }
        if (this.sgbListening && by == 32) {
            int n = this.sgbPacketCounter * 16 + this.sgbBitCounter / 8;
            this.sgbBuffer[n] = (byte)(this.sgbBuffer[n] & ~((byte)Math.pow(2.0, this.sgbBitCounter % 8)));
            ++this.sgbBitCounter;
            return;
        }
    }

    public void sgbCheckCommand() {
        this.sgbCommand = (this.sgbBuffer[0] & 0xF8) >> 3;
        this.sgbPackets = this.sgbBuffer[0] & 7;
    }

    public void recalcCyclesLeft() {
        this.cyclesLeft = Integer.MAX_VALUE;
        if (this.timerOn && this.timeLimit - this.timeCounter < this.cyclesLeft) {
            this.cyclesLeft = this.timeLimit - this.timeCounter;
        }
        if (this.video.lcd_on && this.video.cyclesLeft() < this.cyclesLeft) {
            this.cyclesLeft = this.video.cyclesLeft();
        }
        if (this.net.cyclesLeft() < this.cyclesLeft) {
            this.cyclesLeft = this.net.cyclesLeft();
        }
    }

    public void writeWord(int n, int n2) {
        this.write(n, n2 & 0xFF);
        this.write(n + 1, n2 >> 8);
    }

    public void setHDMAControl(byte by) {
        boolean bl = (by & 0x80) == 128;
        int n = ((by & 0x7F) + 1) * 16;
        this.hdmaSrc = (this.rHDMA1 & 0xFF) << 8 | this.rHDMA2 & 0xF0;
        this.hdmaDst = (this.rHDMA3 & 0x1F) << 8 | (this.rHDMA4 & 0xF0) + 32768;
        if (bl) {
            this.hdmaDone = false;
            this.hdmaStop = this.hdmaDst + n;
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
            ++n2;
        }
    }

    public byte getHDMAControl() {
        if (this.hdmaDone) {
            return 1;
        }
        return 0;
    }

    public final void cycle(int n) {
        this.cycles += n;
        if (this.cycles > this.cyclesLeft) {
            this.div -= this.cyclesLeft;
            if (this.div < 0) {
                this.div = 65280;
            }
            if (this.timerOn) {
                this.timeCounter += this.cyclesLeft;
                if (this.timeCounter >= this.timeLimit) {
                    this.timeCounter = 0;
                    ++this.tima;
                }
                if (this.tima > 255) {
                    this.tima = this.tma;
                    this.IF = (byte)(this.IF | 4);
                }
            }
            this.IF = (byte)(this.IF | this.net.cycle(this.cyclesLeft));
            if (this.video.lcd_on) {
                this.IF = (byte)(this.IF | this.video.cycle(this.cyclesLeft));
            }
            if (!this.hdmaDone) {
                if (this.hdmaLastMode != 0 && (byte)(this.video.getStat() & 3) == 0) {
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    this.write(this.hdmaDst++, this.read(this.hdmaSrc++));
                    if (this.hdmaDst >= this.hdmaStop) {
                        this.hdmaDone = true;
                    }
                }
                this.hdmaLastMode = (byte)(this.video.getStat() & 3);
            }
            this.cycles -= this.cyclesLeft;
            this.recalcCyclesLeft();
        }
    }
}

