﻿/* 
 *  Copyright 2008-2018 Alex Makeev
 * 
 *  This file is part of ZXMAK2 (ZX Spectrum virtual machine).
 *
 *  ZXMAK2 is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  ZXMAK2 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with ZXMAK2.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  Description: DirectX native wrapper
 *  Date: 15.07.2018
 */
using System;
using System.Runtime.InteropServices;


namespace ZXMAK2.DirectX.DirectInput
{
    // x64 sizeof = 24
    // x86 sizeof = 16
    [StructLayout(LayoutKind.Sequential)]
    public struct DIOBJECTDATAFORMAT
    {
        public readonly IntPtr pguid;       // const GUID *
        public readonly int dwOfs;          // DWORD
        public readonly int dwType;         // DWORD
        public readonly DIDOI dwFlags;      // DWORD

        
        public DIOBJECTDATAFORMAT(Guid guid, int offset, int type, DIDOI flags)
        {
            pguid = guid == Guid.Empty ? IntPtr.Zero :
                GCHandle.Alloc(guid, GCHandleType.Pinned).AddrOfPinnedObject();
            dwOfs = offset;
            dwType = type;
            dwFlags = flags;
        }

        // http://xaos.sourceforge.net/dxguid.c
        public static readonly DIOBJECTDATAFORMAT[] rgodf_c_dfDIMouse = new[] {
            new DIOBJECTDATAFORMAT(SysGuid.GUID_XAxis, 0, 16776963, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_YAxis, 4, 16776963, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_ZAxis, 8, -2130706685, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 12, 16776972, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 13, 16776972, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 14, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 15, -2130706676, 0),

            new DIOBJECTDATAFORMAT(Guid.Empty, 16, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 17, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 18, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 19, -2130706676, 0),
        };
        
        public static readonly DIOBJECTDATAFORMAT[] rgodf_c_dfDIKeyboard = {
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 0, -2147483636, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 1, -2147483380, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 2, -2147483124, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 3, -2147482868, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 4, -2147482612, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 5, -2147482356, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 6, -2147482100, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 7, -2147481844, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 8, -2147481588, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 9, -2147481332, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 10, -2147481076, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 11, -2147480820, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 12, -2147480564, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 13, -2147480308, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 14, -2147480052, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 15, -2147479796, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 16, -2147479540, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 17, -2147479284, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 18, -2147479028, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 19, -2147478772, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 20, -2147478516, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 21, -2147478260, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 22, -2147478004, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 23, -2147477748, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 24, -2147477492, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 25, -2147477236, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 26, -2147476980, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 27, -2147476724, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 28, -2147476468, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 29, -2147476212, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 30, -2147475956, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 31, -2147475700, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 32, -2147475444, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 33, -2147475188, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 34, -2147474932, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 35, -2147474676, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 36, -2147474420, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 37, -2147474164, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 38, -2147473908, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 39, -2147473652, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 40, -2147473396, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 41, -2147473140, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 42, -2147472884, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 43, -2147472628, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 44, -2147472372, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 45, -2147472116, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 46, -2147471860, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 47, -2147471604, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 48, -2147471348, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 49, -2147471092, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 50, -2147470836, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 51, -2147470580, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 52, -2147470324, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 53, -2147470068, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 54, -2147469812, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 55, -2147469556, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 56, -2147469300, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 57, -2147469044, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 58, -2147468788, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 59, -2147468532, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 60, -2147468276, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 61, -2147468020, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 62, -2147467764, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 63, -2147467508, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 64, -2147467252, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 65, -2147466996, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 66, -2147466740, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 67, -2147466484, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 68, -2147466228, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 69, -2147465972, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 70, -2147465716, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 71, -2147465460, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 72, -2147465204, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 73, -2147464948, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 74, -2147464692, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 75, -2147464436, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 76, -2147464180, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 77, -2147463924, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 78, -2147463668, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 79, -2147463412, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 80, -2147463156, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 81, -2147462900, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 82, -2147462644, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 83, -2147462388, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 84, -2147462132, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 85, -2147461876, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 86, -2147461620, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 87, -2147461364, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 88, -2147461108, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 89, -2147460852, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 90, -2147460596, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 91, -2147460340, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 92, -2147460084, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 93, -2147459828, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 94, -2147459572, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 95, -2147459316, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 96, -2147459060, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 97, -2147458804, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 98, -2147458548, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 99, -2147458292, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 100, -2147458036, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 101, -2147457780, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 102, -2147457524, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 103, -2147457268, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 104, -2147457012, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 105, -2147456756, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 106, -2147456500, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 107, -2147456244, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 108, -2147455988, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 109, -2147455732, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 110, -2147455476, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 111, -2147455220, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 112, -2147454964, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 113, -2147454708, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 114, -2147454452, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 115, -2147454196, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 116, -2147453940, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 117, -2147453684, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 118, -2147453428, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 119, -2147453172, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 120, -2147452916, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 121, -2147452660, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 122, -2147452404, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 123, -2147452148, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 124, -2147451892, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 125, -2147451636, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 126, -2147451380, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 127, -2147451124, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 128, -2147450868, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 129, -2147450612, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 130, -2147450356, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 131, -2147450100, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 132, -2147449844, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 133, -2147449588, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 134, -2147449332, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 135, -2147449076, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 136, -2147448820, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 137, -2147448564, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 138, -2147448308, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 139, -2147448052, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 140, -2147447796, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 141, -2147447540, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 142, -2147447284, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 143, -2147447028, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 144, -2147446772, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 145, -2147446516, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 146, -2147446260, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 147, -2147446004, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 148, -2147445748, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 149, -2147445492, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 150, -2147445236, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 151, -2147444980, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 152, -2147444724, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 153, -2147444468, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 154, -2147444212, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 155, -2147443956, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 156, -2147443700, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 157, -2147443444, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 158, -2147443188, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 159, -2147442932, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 160, -2147442676, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 161, -2147442420, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 162, -2147442164, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 163, -2147441908, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 164, -2147441652, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 165, -2147441396, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 166, -2147441140, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 167, -2147440884, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 168, -2147440628, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 169, -2147440372, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 170, -2147440116, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 171, -2147439860, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 172, -2147439604, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 173, -2147439348, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 174, -2147439092, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 175, -2147438836, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 176, -2147438580, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 177, -2147438324, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 178, -2147438068, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 179, -2147437812, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 180, -2147437556, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 181, -2147437300, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 182, -2147437044, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 183, -2147436788, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 184, -2147436532, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 185, -2147436276, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 186, -2147436020, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 187, -2147435764, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 188, -2147435508, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 189, -2147435252, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 190, -2147434996, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 191, -2147434740, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 192, -2147434484, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 193, -2147434228, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 194, -2147433972, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 195, -2147433716, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 196, -2147433460, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 197, -2147433204, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 198, -2147432948, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 199, -2147432692, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 200, -2147432436, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 201, -2147432180, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 202, -2147431924, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 203, -2147431668, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 204, -2147431412, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 205, -2147431156, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 206, -2147430900, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 207, -2147430644, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 208, -2147430388, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 209, -2147430132, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 210, -2147429876, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 211, -2147429620, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 212, -2147429364, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 213, -2147429108, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 214, -2147428852, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 215, -2147428596, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 216, -2147428340, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 217, -2147428084, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 218, -2147427828, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 219, -2147427572, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 220, -2147427316, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 221, -2147427060, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 222, -2147426804, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 223, -2147426548, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 224, -2147426292, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 225, -2147426036, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 226, -2147425780, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 227, -2147425524, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 228, -2147425268, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 229, -2147425012, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 230, -2147424756, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 231, -2147424500, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 232, -2147424244, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 233, -2147423988, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 234, -2147423732, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 235, -2147423476, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 236, -2147423220, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 237, -2147422964, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 238, -2147422708, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 239, -2147422452, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 240, -2147422196, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 241, -2147421940, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 242, -2147421684, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 243, -2147421428, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 244, -2147421172, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 245, -2147420916, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 246, -2147420660, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 247, -2147420404, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 248, -2147420148, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 249, -2147419892, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 250, -2147419636, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 251, -2147419380, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 252, -2147419124, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 253, -2147418868, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 254, -2147418612, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Key, 255, -2147418356, 0),
        };

        public static readonly DIOBJECTDATAFORMAT[] rgodf_c_dfDIJoystick = new[] {
            new DIOBJECTDATAFORMAT(SysGuid.GUID_XAxis, 0, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_YAxis, 4, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_ZAxis, 8, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_RxAxis, 12, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_RyAxis, 16, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_RzAxis, 20, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Slider, 24, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_Slider, 28, -2130706685, (DIDOI)256),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_POV, 32, -2130706672, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_POV, 36, -2130706672, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_POV, 40, -2130706672, 0),
            new DIOBJECTDATAFORMAT(SysGuid.GUID_POV, 44, -2130706672, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 48, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 49, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 50, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 51, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 52, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 53, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 54, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 55, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 56, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 57, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 58, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 59, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 60, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 61, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 62, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 63, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 64, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 65, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 66, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 67, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 68, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 69, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 70, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 71, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 72, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 73, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 74, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 75, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 76, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 77, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 78, -2130706676, 0),
            new DIOBJECTDATAFORMAT(Guid.Empty, 79, -2130706676, 0),
        };

        //public static readonly DIOBJECTDATAFORMAT[] rgodf_c_dfDIJoystick2 = {
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_XAxis, 0, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_YAxis, 4, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_ZAxis, 8, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RxAxis, 12, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RyAxis, 16, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RzAxis, 20, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 24, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 28, -2130706685, (DIDOI)256),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_POV, 32, -2130706672, 0),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_POV, 36, -2130706672, 0),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_POV, 40, -2130706672, 0),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_POV, 44, -2130706672, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 48, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 49, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 50, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 51, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 52, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 53, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 54, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 55, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 56, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 57, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 58, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 59, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 60, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 61, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 62, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 63, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 64, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 65, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 66, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 67, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 68, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 69, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 70, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 71, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 72, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 73, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 74, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 75, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 76, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 77, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 78, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 79, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 80, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 81, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 82, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 83, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 84, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 85, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 86, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 87, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 88, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 89, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 90, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 91, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 92, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 93, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 94, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 95, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 96, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 97, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 98, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 99, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 100, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 101, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 102, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 103, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 104, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 105, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 106, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 107, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 108, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 109, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 110, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 111, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 112, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 113, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 114, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 115, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 116, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 117, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 118, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 119, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 120, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 121, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 122, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 123, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 124, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 125, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 126, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 127, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 128, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 129, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 130, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 131, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 132, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 133, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 134, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 135, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 136, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 137, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 138, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 139, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 140, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 141, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 142, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 143, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 144, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 145, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 146, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 147, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 148, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 149, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 150, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 151, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 152, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 153, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 154, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 155, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 156, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 157, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 158, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 159, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 160, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 161, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 162, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 163, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 164, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 165, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 166, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 167, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 168, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 169, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 170, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 171, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 172, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 173, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 174, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(Guid.Empty, 175, -2130706676, 0),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_XAxis, 176, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_YAxis, 180, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_ZAxis, 184, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RxAxis, 188, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RyAxis, 192, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RzAxis, 196, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 24, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 28, -2130706685, (DIDOI)512),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_XAxis, 208, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_YAxis, 212, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_ZAxis, 216, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RxAxis, 220, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RyAxis, 224, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RzAxis, 228, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 24, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 28, -2130706685, (DIDOI)768),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_XAxis, 240, -2130706685, (DIDOI)1024),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_YAxis, 244, -2130706685, (DIDOI)1024),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_ZAxis, 248, -2130706685, (DIDOI)1024),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RxAxis, 252, -2130706685, (DIDOI)1024),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RyAxis, 256, -2130706685, (DIDOI)1024),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_RzAxis, 260, -2130706685, (DIDOI)1024),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 24, -2130706685, (DIDOI)1024),
        //    new DIOBJECTDATAFORMAT(SystemGuid.GUID_Slider, 28, -2130706685, (DIDOI)1024),
        //};
    }
}
