﻿/* 
 *  Copyright 2008-2018 Alex Makeev
 * 
 *  This file is part of ZXMAK2 (ZX Spectrum virtual machine).
 *
 *  ZXMAK2 is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  ZXMAK2 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with ZXMAK2.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  Description: DirectX native wrapper
 *  Date: 15.07.2018
 */

namespace ZXMAK2.DirectX.DirectInput
{
    public enum Key
    {
        Escape = 1,
        D1 = 2,
        D2 = 3,
        D3 = 4,
        D4 = 5,
        D5 = 6,
        D6 = 7,
        D7 = 8,
        D8 = 9,
        D9 = 10,
        D0 = 11,
        Minus = 12,
        Equals = 13,
        BackSpace = 14,
        Back = 14,
        Tab = 15,
        Q = 16,
        W = 17,
        E = 18,
        R = 19,
        T = 20,
        Y = 21,
        U = 22,
        I = 23,
        O = 24,
        P = 25,
        LeftBracket = 26,
        RightBracket = 27,
        Return = 28,
        LeftControl = 29,
        A = 30,
        S = 31,
        D = 32,
        F = 33,
        G = 34,
        H = 35,
        J = 36,
        K = 37,
        L = 38,
        SemiColon = 39,
        Apostrophe = 40,
        Grave = 41,
        LeftShift = 42,
        BackSlash = 43,
        Z = 44,
        X = 45,
        C = 46,
        V = 47,
        B = 48,
        N = 49,
        M = 50,
        Comma = 51,
        Period = 52,
        Slash = 53,
        RightShift = 54,
        NumPadStar = 55,
        Multiply = 55,
        LeftMenu = 56,
        LeftAlt = 56,
        Space = 57,
        Capital = 58,
        CapsLock = 58,
        F1 = 59,
        F2 = 60,
        F3 = 61,
        F4 = 62,
        F5 = 63,
        F6 = 64,
        F7 = 65,
        F8 = 66,
        F9 = 67,
        F10 = 68,
        Numlock = 69,
        Scroll = 70,
        NumPad7 = 71,
        NumPad8 = 72,
        NumPad9 = 73,
        NumPadMinus = 74,
        Subtract = 74,
        NumPad4 = 75,
        NumPad5 = 76,
        NumPad6 = 77,
        NumPadPlus = 78,
        Add = 78,
        NumPad1 = 79,
        NumPad2 = 80,
        NumPad3 = 81,
        NumPad0 = 82,
        NumPadPeriod = 83,
        Decimal = 83,
        OEM102 = 86,
        F11 = 87,
        F12 = 88,
        F13 = 100,
        F14 = 101,
        F15 = 102,
        Kana = 112,
        AbntC1 = 115,
        Convert = 121,
        NoConvert = 123,
        Yen = 125,
        AbntC2 = 126,
        NumPadEquals = 141,
        Circumflex = 144,
        PrevTrack = 144,
        At = 145,
        Colon = 146,
        Underline = 147,
        Kanji = 148,
        Stop = 149,
        AX = 150,
        Unlabeled = 151,
        NextTrack = 153,
        NumPadEnter = 156,
        RightControl = 157,
        Mute = 160,
        Calculator = 161,
        PlayPause = 162,
        MediaStop = 164,
        VolumeDown = 174,
        VolumeUp = 176,
        WebHome = 178,
        NumPadComma = 179,
        Divide = 181,
        NumPadSlash = 181,
        SysRq = 183,
        RightMenu = 184,
        RightAlt = 184,
        Pause = 197,
        Home = 199,
        UpArrow = 200,
        Up = 200,
        Prior = 201,
        PageUp = 201,
        Left = 203,
        LeftArrow = 203,
        Right = 205,
        RightArrow = 205,
        End = 207,
        DownArrow = 208,
        Down = 208,
        Next = 209,
        PageDown = 209,
        Insert = 210,
        Delete = 211,
        LeftWindows = 219,
        RightWindows = 220,
        Apps = 221,
        Power = 222,
        Sleep = 223,
        Wake = 227,
        WebSearch = 229,
        WebFavorites = 230,
        WebRefresh = 231,
        WebStop = 232,
        WebForward = 233,
        WebBack = 234,
        MyComputer = 235,
        Mail = 236,
        MediaSelect = 237,
    }
}
