/*
 * Decompiled with CFR 0.152.
 */
package elliott803.telecode;

import elliott803.telecode.CharToTelecode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class TelecodeInputStream
extends InputStream {
    BufferedReader inputReader;
    CharToTelecode converter;
    byte[] bb = new byte[2];
    char[] cc = new char[1];
    int bbLen;
    int bbPos;
    boolean skipLF;

    public TelecodeInputStream(Reader in) {
        this(new BufferedReader(in));
    }

    public TelecodeInputStream(BufferedReader in) {
        this.inputReader = in;
        this.converter = new CharToTelecode();
    }

    public int read() throws IOException {
        int tc = -1;
        while (this.bbLen == 0) {
            if (this.inputReader.read(this.cc) <= 0) break;
            if (this.cc[0] == '\r' || this.cc[0] == '\n') {
                if (this.cc[0] == '\r' || !this.skipLF) {
                    this.bb[0] = 29;
                    this.bb[1] = 30;
                    this.bbLen = 2;
                    this.bbPos = 0;
                }
                this.skipLF = this.cc[0] == '\r';
                continue;
            }
            this.bbLen = this.converter.convert(this.cc, 1, this.bb);
            this.bbPos = 0;
            this.skipLF = false;
        }
        if (this.bbLen > 0) {
            tc = this.bb[this.bbPos++];
            --this.bbLen;
        }
        return tc;
    }

    public void close() throws IOException {
        this.inputReader.close();
    }

    public void write(OutputStream output) throws IOException {
        int ch = this.read();
        while (ch != -1) {
            output.write(ch);
            ch = this.read();
        }
        this.close();
    }
}

