/*
 * Decompiled with CFR 0.152.
 */
package elliott803.utils;

import elliott803.machine.Dump;
import elliott803.machine.Instruction;
import elliott803.machine.Word;
import elliott803.telecode.Telecode;
import elliott803.utils.Args;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;

public class PrintCore {
    PrintStream output;

    public static void main(String[] args) throws Exception {
        Args parms = new Args("PrintCore", "corefile [outputfile]", args, null);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile(2);
        if (inputFile == null) {
            parms.usage();
        }
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        Dump dump = Dump.readDump(inputFile);
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        if (dump != null) {
            output.println("Elliott 803B Core Dump");
            output.println("created: " + df.format(dump.timestamp));
            output.println();
            PrintCore formatter = new PrintCore(output);
            output.println("CPU registers:");
            formatter.printCpu(dump);
            output.println("Core store:");
            formatter.printStore(dump.core, 0, 8192);
        } else {
            System.out.println("No core dump found");
        }
    }

    PrintCore(PrintStream out) {
        this.output = out;
    }

    void printCpu(Dump dump) {
        this.output.println("  ACC: " + Word.toBinaryString(dump.acc));
        this.output.println("   AR: " + Word.toBin38String(dump.ar));
        this.output.println("  SCR: " + Instruction.toAddrString(dump.scr) + "." + dump.scr2);
        this.output.println("   IR: " + Word.toInstrString(dump.ir));
        this.output.println();
        this.output.println("  Overflow:   " + dump.overflow);
        this.output.println("  FP Overflow: " + dump.fpOverflow);
        this.output.println();
    }

    void printStore(long[] store, int addr, int length) {
        long lastWord = 0L;
        int duplicates = 0;
        int i = addr;
        while (i < addr + length) {
            long word = store[i];
            if (i == addr + length - 1 || word != lastWord) {
                if (duplicates > 0) {
                    if (duplicates < 5 || lastWord != 0L && duplicates < 8) {
                        while (duplicates-- > 0) {
                            this.printLine(i - duplicates, lastWord);
                        }
                    } else {
                        this.output.println("         ...");
                    }
                    duplicates = 0;
                }
                this.printLine(i, word);
                lastWord = word;
            } else {
                ++duplicates;
            }
            ++i;
        }
        this.output.println();
    }

    private void printLine(int addr, long word) {
        if (word == 0L) {
            this.output.println(String.valueOf(Instruction.toAddrString(addr)) + ":    0");
        } else {
            String text = String.valueOf(Instruction.toAddrString(addr)) + ":   ";
            if (addr < 4) {
                text = String.valueOf(text) + "(" + Word.toInstrString(word) + ")";
            } else {
                text = String.valueOf(text) + " " + Word.toInstrString(word) + "   ";
                text = String.valueOf(text) + "[" + Word.toOctalString(word) + "]   ";
                text = String.valueOf(text) + "(" + Word.toIntegerString(word) + ")";
                if (word > 1L && word < 32L) {
                    int ch = (int)word;
                    if (ch < 10) {
                        text = String.valueOf(text) + " ";
                    }
                    switch (ch) {
                        case 27: {
                            text = String.valueOf(text) + "    FS";
                            break;
                        }
                        case 28: {
                            text = String.valueOf(text) + "   SPC";
                            break;
                        }
                        case 29: {
                            text = String.valueOf(text) + "   CR";
                            break;
                        }
                        case 30: {
                            text = String.valueOf(text) + "   LF";
                            break;
                        }
                        case 31: {
                            text = String.valueOf(text) + "   LS";
                            break;
                        }
                        default: {
                            text = String.valueOf(text) + "  '" + Telecode.asLetter(ch) + " " + Telecode.asFigure(ch) + "'";
                            break;
                        }
                    }
                } else if (word > 63L) {
                    char[] pt = new char[6];
                    int i = 5;
                    while (i >= 0) {
                        int ch = (int)word & 0x1F;
                        int sh = (int)word & 0x20;
                        pt[i] = ch > 0 && (ch < 27 || ch == 28) ? (sh != 0 ? Telecode.asLetter(ch) : Telecode.asFigure(ch)) : (char)46;
                        word >>= 6;
                        --i;
                    }
                    i = text.length();
                    while (i < 65) {
                        text = String.valueOf(text) + " ";
                        ++i;
                    }
                    text = String.valueOf(text) + "\"" + new String(pt) + "\"";
                }
            }
            this.output.println(text);
        }
    }
}

