/*
 * Decompiled with CFR 0.152.
 */
package elliott803.utils;

import elliott803.machine.Instruction;
import elliott803.machine.Word;
import elliott803.utils.Args;
import elliott803.utils.PrintCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class PrintT1 {
    public static void main(String[] args) throws Exception {
        long word;
        Args parms = new Args("PrintT1", "tapefile [outputfile]", args, null);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile(2);
        if (inputFile == null) {
            parms.usage();
        }
        FileInputStream input = new FileInputStream(inputFile);
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        if ((word = PrintT1.readWord(input)) == -1L) {
            PrintT1.error("Unable to read program load address");
        }
        int loadAddress = (int)word + 4;
        long[] store = new long[8192];
        int addr = 0;
        addr = loadAddress;
        while (addr < store.length) {
            word = PrintT1.readWord(input);
            if (word == -1L) break;
            store[addr] = word;
            ++addr;
        }
        int size = addr - loadAddress;
        int triggerInstruction = -1;
        if (word != -1L) {
            int i = 0;
            while (i < 5) {
                word = PrintT1.readWord(input);
                if (word == -1L) break;
                ++i;
            }
            if (word == -1L) {
                PrintT1.error("Unable to read program trigger address");
            }
            if (input.read() == -1) {
                PrintT1.error("Tape is missing final character to activate trigger");
            }
            triggerInstruction = Instruction.asInstr(14, 4) + Word.getInstr2(word);
        }
        output.println("Elliott 803B Binary Tape");
        output.println();
        output.println("Load address: " + Instruction.toAddrString(loadAddress));
        if (triggerInstruction != -1) {
            output.println("Trigger:   " + Instruction.toInstrString(triggerInstruction));
        }
        output.println();
        PrintCore formatter = new PrintCore(output);
        formatter.printStore(store, loadAddress, size);
    }

    private static long readWord(InputStream in) throws IOException {
        long word = 0L;
        while (Long.numberOfLeadingZeros(word) > 25) {
            int ch = in.read();
            word = ch != -1 ? (word << 5) + ((long)ch & 0x1FL) : -1L;
        }
        return word == -1L ? word : Word.asWord(word);
    }

    private static void error(String msg) {
        System.out.println("ERROR: " + msg);
        System.exit(1);
    }
}

