/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.machine.Computer;
import elliott803.view.ConsoleView;
import elliott803.view.ControlView;
import elliott803.view.CpuView;
import elliott803.view.MachineImage;
import elliott803.view.PlotterView;
import elliott803.view.PtsView;
import elliott803.view.StoreView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ComputerView
extends JDesktopPane
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final String IMAGE_LOAD = "Load...";
    static final String IMAGE_SAVE = "Save...";
    public ControlView control;
    public ConsoleView console;
    public CpuView cpu;
    public StoreView store;
    public PtsView pts;
    public PlotterView plotter;
    Computer computer;
    JFileChooser imageSelect;

    public ComputerView(Computer computer) {
        this.setLayout(null);
        this.computer = computer;
        this.control = new ControlView(computer, this);
        this.console = new ConsoleView(computer.console);
        this.cpu = new CpuView(computer.cpu);
        this.store = new StoreView(computer.core);
        this.pts = new PtsView(computer.pts);
        this.plotter = new PlotterView(computer.plotter);
        this.add(this.control);
        this.add(this.console);
        this.add(this.cpu);
        this.add(this.store);
        this.add(this.pts.reader[0]);
        this.add(this.pts.reader[1]);
        this.add(this.pts.punch[0]);
        this.add(this.pts.punch[1]);
        this.add(this.pts.teletype);
        this.add(this.plotter);
        this.imageSelect = new JFileChooser(new File("."));
        this.imageSelect.setDialogTitle("Elliott 803 Machine Image");
        this.imageSelect.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".803");
            }

            public String getDescription() {
                return "Elliott 803 Machine Images";
            }
        });
    }

    public boolean defaultLayout() {
        int extraY = 0;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (this.getLayer(c) > DEFAULT_LAYER && c.getY() < 0) {
                extraY = Math.max(extraY, c.getHeight() - 1);
            }
            ++n2;
        }
        int plotterX = this.pts.teletype.getWidth() - this.pts.teletype.getRootPane().getPreferredSize().width;
        int plotterY = this.pts.teletype.getHeight() - this.pts.teletype.getRootPane().getPreferredSize().height;
        int max1X = this.control.getWidth();
        int max2X = this.cpu.getWidth() + this.store.getWidth();
        int maxCX = Math.max(max1X, max2X);
        int max3X = this.console.getWidth() + maxCX + 10;
        int max4X = this.pts.teletype.getWidth() + plotterX + this.pts.punch[0].getWidth() + this.pts.reader[0].getWidth() + 10;
        int maxX = Math.max(max3X, max4X);
        int max1Y = this.console.getHeight() + this.pts.teletype.getHeight() + plotterY + 10;
        int max2Y = this.control.getHeight() + this.cpu.getHeight() + 2 * this.pts.punch[0].getHeight() + 10;
        int max3Y = this.control.getHeight() + this.store.getHeight() + 2 * this.pts.reader[0].getHeight() + 10;
        int maxY = Math.max(Math.max(max1Y, max2Y), max3Y);
        int consoleX = 0;
        int consoleY = 0;
        int controlX = maxX - maxCX;
        int controlY = 0;
        int storeX = maxX - this.store.getWidth();
        int storeY = this.control.getHeight();
        int cpuX = storeX - this.cpu.getWidth();
        int cpuY = this.control.getHeight();
        int teletypeX = 0;
        int teletypeY = maxY - this.pts.teletype.getHeight();
        int punch2X = maxX - this.pts.punch[1].getWidth();
        int punch2Y = maxY - this.pts.punch[1].getHeight();
        int reader2X = punch2X - this.pts.reader[1].getWidth();
        int reader2Y = punch2Y;
        int punch1X = punch2X;
        int punch1Y = punch2Y - this.pts.punch[0].getHeight();
        int reader1X = reader2X;
        int reader1Y = reader2Y - this.pts.reader[0].getHeight();
        this.control.setSize(maxCX, this.control.getHeight());
        this.control.setLocation(controlX, controlY);
        this.console.setLocation(consoleX, consoleY);
        this.cpu.setLocation(cpuX, cpuY);
        this.store.setLocation(storeX, storeY);
        this.plotter.setSize(this.pts.teletype.getWidth(), this.pts.teletype.getHeight());
        this.plotter.setLocation(teletypeX + plotterX, teletypeY - plotterY);
        this.pts.teletype.setLocation(teletypeX, teletypeY);
        this.pts.punch[0].setLocation(punch1X, punch1Y);
        this.pts.punch[1].setLocation(punch2X, punch2Y);
        this.pts.reader[0].setLocation(reader1X, reader1Y);
        this.pts.reader[1].setLocation(reader2X, reader2Y);
        Dimension size = new Dimension(maxX, maxY + extraY);
        this.setPreferredSize(size);
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(IMAGE_LOAD)) {
            if (this.imageSelect.showOpenDialog(this) == 0) {
                File file = this.imageSelect.getSelectedFile();
                MachineImage image = MachineImage.readImage(file);
                image.apply(this.computer, this);
            }
        } else if (e.getActionCommand().equals(IMAGE_SAVE) && this.imageSelect.showSaveDialog(this) == 0) {
            File file = this.imageSelect.getSelectedFile();
            if (!file.getName().contains(".")) {
                file = new File(String.valueOf(file.getPath()) + ".803");
            }
            MachineImage image = new MachineImage(this.computer, this);
            image.write(file);
        }
    }
}

