/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.machine.Computer;
import elliott803.view.ComputerView;
import elliott803.view.component.DisplaySpeed;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ControlView
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Computer computer;
    Timer speedTimer;
    DisplaySpeed speed;
    JCheckBox realTime;

    public ControlView(Computer computer, ComputerView computerView) {
        super("Simulation Control", false, false, false, true);
        this.computer = computer;
        JPanel ip = new JPanel();
        ip.setLayout(new BoxLayout(ip, 0));
        ip.setBorder(BorderFactory.createTitledBorder("Machine Image"));
        JButton lb = new JButton("Load...");
        lb.addActionListener(computerView);
        JButton sb = new JButton("Save...");
        sb.addActionListener(computerView);
        ip.add(Box.createHorizontalStrut(5));
        ip.add(lb);
        ip.add(Box.createHorizontalStrut(10));
        ip.add(sb);
        ip.add(Box.createHorizontalStrut(5));
        JPanel sp = new JPanel();
        sp.setLayout(new BoxLayout(sp, 0));
        sp.setBorder(BorderFactory.createTitledBorder("CPU Speed"));
        this.speed = new DisplaySpeed(1.0f);
        this.realTime = new JCheckBox("Real time", true);
        this.realTime.addActionListener(this);
        sp.add(Box.createHorizontalStrut(5));
        sp.add(this.speed);
        sp.add(Box.createHorizontalStrut(10));
        sp.add(Box.createHorizontalGlue());
        sp.add(this.realTime);
        this.speedTimer = new Timer(2500, this);
        this.speedTimer.setInitialDelay(5000);
        this.speedTimer.setRepeats(true);
        this.speedTimer.start();
        Container content = this.getContentPane();
        content.add((Component)ip, "East");
        content.add((Component)sp, "West");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.speedTimer) {
            float sp = this.computer.cpu.getSpeed();
            if ((double)sp > 0.1) {
                this.speed.setValue(sp);
            }
        } else if (e.getSource() == this.realTime) {
            this.computer.setRealTime(this.realTime.isSelected());
        }
    }
}

