/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class DisplayCore
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final int STORESIZE = 8192;
    static final int ROWSIZE = 64;
    static final int ROWCOUNT = 128;
    static final int BLOCKSIZE = 2;
    static final int ROUNDING = 1;
    byte[][] store = new byte[128][64];

    public DisplayCore() {
        this.setPreferredSize(new Dimension(128, 256));
    }

    public void setValue(int addr, long value) {
        byte b;
        int i = addr % 64;
        int j = addr / 64;
        this.store[j][i] = b = (byte)(value == 0L ? 0 : this.store[j][i] + 1);
        this.repaint(2 * i, 2 * j, 2, 2);
    }

    public void setValues(long[] core) {
        int addr = 4;
        while (addr < core.length) {
            int i = addr % 64;
            int j = addr / 64;
            this.store[j][i] = (byte)(core[addr] != 0L ? 1 : 0);
            ++addr;
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int minI = 0;
        int maxI = 64;
        int minJ = 0;
        int maxJ = 128;
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            minI = clip.x / 2;
            maxI = minI + (clip.width + 1) / 2;
            minJ = clip.y / 2;
            maxJ = minJ + (clip.height + 1) / 2;
        }
        int startX = minI * 2;
        int startY = minJ * 2;
        int j = minJ;
        int y = startY;
        while (j < maxJ) {
            int i = minI;
            int x = startX;
            while (i < maxI) {
                byte b = this.store[j][i];
                g.setColor(b == 0 ? Color.WHITE : ((b & 1) == 0 ? Color.DARK_GRAY : Color.LIGHT_GRAY));
                g.fillRect(x, y, 2, 2);
                x += 2;
                ++i;
            }
            y += 2;
            ++j;
        }
    }
}

