/*
 * Decompiled with CFR 0.152.
 */
package elliott803;

import elliott803.hardware.TapeDevice;
import elliott803.machine.Computer;
import elliott803.machine.Word;
import elliott803.telecode.Telecode;
import elliott803.telecode.TelecodeInputStream;
import elliott803.telecode.TelecodeOutputStream;
import elliott803.utils.Args;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;

public class Run {
    public static void main(String[] args) throws Exception {
        TapeDevice device;
        Args.Map options = Args.optionMap();
        options.put("reader1", "inputtape");
        options.put("reader2", "inputtape");
        options.put("punch1", "outputtape");
        options.put("punch2", "outputtape");
        options.put("teletype", "outputfile");
        options.put("wordgen", "+\"instruction\"");
        options.put("press", "button");
        options.put("ascii");
        options.put("dump");
        options.put("trace");
        Args parms = new Args("elliott803.Run", "programtape [entryaddress]", args, options);
        File inputFile1 = parms.getInputFile("reader1");
        File inputFile2 = parms.getInputFile("reader2");
        File outputFile1 = parms.getOutputFile("punch1");
        File outputFile2 = parms.getOutputFile("punch2");
        File outputFile3 = parms.getOutputFile("teletype");
        String wgInstruction = parms.getOption("wordgen");
        int button = parms.getInteger("press");
        boolean instrTrace = parms.getFlag("trace");
        boolean dumpOnExit = parms.getFlag("dump");
        boolean useASCII = parms.getFlag("ascii");
        File programFile = parms.getInputFile(1);
        int entryAddr = parms.getInteger(2);
        if (programFile == null) {
            parms.usage();
        }
        FileInputStream programTape = new FileInputStream(programFile);
        InputStream inputTape1 = null;
        InputStream inputTape2 = null;
        if (inputFile1 != null) {
            inputTape1 = Telecode.isTelecode(inputFile1) ? new FileInputStream(inputFile1) : new TelecodeInputStream(new FileReader(inputFile1));
        }
        if (inputFile2 != null) {
            inputTape2 = Telecode.isTelecode(inputFile2) ? new FileInputStream(inputFile2) : new TelecodeInputStream(new FileReader(inputFile2));
        }
        FileOutputStream outputTape1 = null;
        FileOutputStream outputTape2 = null;
        TelecodeOutputStream outputTeletype = null;
        if (outputFile1 != null) {
            outputTape1 = new FileOutputStream(outputFile1);
        }
        if (outputFile2 != null) {
            outputTape2 = new FileOutputStream(outputFile2);
        }
        outputTeletype = outputFile3 != null ? new TelecodeOutputStream(new FileWriter(outputFile3), useASCII) : new TelecodeOutputStream(System.out, useASCII);
        long wordgen = 0L;
        if (wgInstruction != null) {
            wordgen = Word.parseInstr(wgInstruction);
        }
        Computer computer = new Computer();
        computer.setRealTime(false);
        computer.pts.setReaderTape(0, programTape);
        computer.pts.setPunchTape(0, outputTape1);
        computer.pts.setPunchTape(1, outputTape2);
        computer.pts.setPunchTape(2, outputTeletype);
        computer.console.setWordGen(wordgen);
        computer.console.setManualData(button > 0);
        computer.runInstructions(0);
        boolean rdr1Wait = computer.pts.readers[0].deviceBusy();
        boolean rdr2Wait = computer.pts.readers[1].deviceBusy();
        computer.pts.setReaderTape(0, inputTape1);
        computer.pts.setReaderTape(1, inputTape2);
        if (instrTrace) {
            computer.traceStart();
        }
        if (entryAddr != -1) {
            computer.runInstructions(entryAddr);
        } else if (rdr1Wait || rdr2Wait) {
            computer.runInstructions();
        }
        if (computer.console.deviceBusy()) {
            computer.console.setManualDataDelay();
            computer.runInstructions();
            computer.console.toggleWordGenBit(40 - button);
            computer.console.setManualData(false);
            computer.runInstructions();
        }
        if (instrTrace) {
            computer.traceStop();
        }
        TapeDevice[] tapeDeviceArray = computer.pts.readers;
        int n = computer.pts.readers.length;
        int n2 = 0;
        while (n2 < n) {
            device = tapeDeviceArray[n2];
            if (device.deviceBusy()) {
                System.out.println("*** Waiting for input: READER " + device.id);
            }
            ++n2;
        }
        tapeDeviceArray = computer.pts.punches;
        n = computer.pts.punches.length;
        n2 = 0;
        while (n2 < n) {
            device = tapeDeviceArray[n2];
            if (device.deviceBusy()) {
                System.out.println("*** Waiting for output: PUNCH " + device.id);
            }
            ++n2;
        }
        if (dumpOnExit) {
            computer.dump();
        }
    }
}

